
/*
	Initialisierung
		=> Aufruf durch onload im <prefwindow>
*/
function aios_initPrefs() {
	// Fenster wenig vergrssern, da es im "Windows Classic Theme" manchmal zu klein ist
	//window.setTimeout("window.resizeTo(window.outerWidth, window.outerHeight + 3)", 0);

	// Apply-Button deaktivieren
	aios_disableApplyButton(true);

	// Settings-Button
	if(document.documentElement.getButton('extra2')) {
		var extra2 = document.documentElement.getButton('extra2');
		extra2.setAttribute('id', 'aios-settings-button');
		extra2.setAttribute('popup', 'aios-settings-popup');
		extra2.setAttribute('dir', 'reverse');
	}

	// abhngige Elemente aktivieren oder deaktivieren
	aios_checkDependent();

	// v. Benutzer konfigurierte Links
	aios_customLinks();

	// Advanced Mode aktivieren/deaktivieren
	aios_advancedMode();

	// Maeinheiten zur Sidebarbreite auf nderungen berwachen
	document.getElementById('obj-minWidthUnit').addEventListener("ValueChange", function(e) {
		aios_changeWidthUnit('min');
	}, false);

	document.getElementById('obj-defWidthUnit').addEventListener("ValueChange", function(e) {
		aios_changeWidthUnit('def');
	}, false);

	document.getElementById('obj-maxWidthUnit').addEventListener("ValueChange", function(e) {
		aios_changeWidthUnit('max');
	}, false);
	
	
	// DOM-Inspector-Optionen ausblenden, wenn er nicht installiert ist
	if(!aios_WIN.document.getElementById('Tasks:InspectPage'))
		document.getElementById('domi-prefs').setAttribute('hidden', true);

	// Prefs merken, wird fr den Apply-Button bentigt => aios_checkApply()
	aios_rememberOldPrefs();

	// alte Prefs lschen
	aios_deleteOldPrefs();

	// Option fr Sidebar Collapsing ggfs. deaktivieren
	if(aios_WIN.aios_allowCollapseSidebar && !aios_WIN.aios_allowCollapseSidebar())
	  document.getElementById('obj-SBCollapsing').setAttribute('disabled', true);
	  
	// Option fr Page-Info-Layout ggfs. deaktivieren
	if(aios_appVersion.indexOf('3.0') != 0) document.getElementById('obj-PILayout').setAttribute('hidden', true);
	
	// Optionen fr Slim-Download-List und Tools-Button ggfs. deaktivieren
	if(aios_appVersion.indexOf('3.0') == 0) {
	    document.getElementById('obj-DMSort').setAttribute('hidden', true);
	    document.getElementById('obj-DMTools').setAttribute('hidden', true);
	}
}


function aios_initPane(mode) {
	// zuletzt gewhlten Tab wieder selektieren
	var tabbox = null;
	switch(mode) {
		case "general": 	tabbox = document.getElementById('aiosTabboxGeneral'); break;
		case "panels": 		tabbox = document.getElementById('aiosTabboxPanels'); break;
		case "menus": 		tabbox = document.getElementById('aiosTabboxMenus'); break;
	}

	var seltab = tabbox.parentNode.getAttribute('seltab');
	if(tabbox.childNodes[0].tagName == "tabs") tabbox.childNodes[0].selectedIndex = seltab;
	if(tabbox.childNodes[1].tagName == "tabs") tabbox.childNodes[1].selectedIndex = seltab;

	// Liste der zur Verfgung stehenden Sidebars erstellen
	if(mode == "general") aios_genSidebarList();
}


/*
	Standardeinstellungen zuruecksetzen
		=> Aufruf durch <menuitem> in prefs.xul
*/
function aios_defaultSettings() {
	var strings = document.getElementById("aiosStrings");
	if(!confirm(strings.getString('prefs.confirm'))) return false;

	var count = { value : 0 };
	var childList = aios_gPrefBranch.getChildList("", count);

	for(var i = 0; i < count.value; i++) {
		if(aios_gPrefBranch.prefHasUserValue(childList[i]) && childList[i] != "changelog") {
			aios_gPrefBranch.clearUserPref(childList[i]);
		}
	}

	// GUI-Elemente zurcksetzen
	aios_synchElements();

	// abhngige Elemente aktivieren oder deaktivieren
	aios_checkDependent();

	// v. Benutzer konfigurierte Links
	aios_customLinks(true);

	return true;
}


/*
	Einstellungen in Textdatei exportieren
		=> Aufruf durch <menuitem> in prefs.xul
*/
function aios_exportSettings() {
	var now = new Date();
	var sDate = aios_extendInt(now.getMonth() + 1) + "/" + aios_extendInt(now.getDate()) + "/" + now.getFullYear();
	var sTtime = aios_extendInt(now.getHours()) + ":" + aios_extendInt(now.getMinutes()) + ":" + aios_extendInt(now.getSeconds());
	var sGMT = now.toGMTString();

	var aiosExport = new Array;
	aiosExport[0] = "-----------------------------------------------------------------------\n";
	aiosExport[0]+= "                     All-In-One Sidebar - Settings\n";
	aiosExport[0]+= "          " + sDate + ", " + sTtime + " (" + sGMT + ")\n";
	aiosExport[0]+= "-----------------------------------------------------------------------\n";
	aiosExport[0]+= "                         DO NOT EDIT THIS FILE\n";
	aiosExport[0]+= "-----------------------------------------------------------------------";

	var count = { value : 0 };
	var childList = aios_gPrefBranch.getChildList("", count);

	for(var i = 0; i < count.value; i++) {
		try {
			switch(aios_gPrefBranch.getPrefType(childList[i])) {
				case 	aios_pBranch.PREF_BOOL:
							aiosExport[i+1] = childList[i] + '=' + aios_gPrefBranch.getBoolPref(childList[i]);
							break;

				case 	aios_pBranch.PREF_INT:
							aiosExport[i+1] = childList[i] + '=' + aios_gPrefBranch.getIntPref(childList[i]);
							break;

				case 	aios_pBranch.PREF_STRING:
							aiosExport[i+1] = childList[i] + '=' + aios_gPrefBranch.getCharPref(childList[i]);
							break;
			}
		}
		catch(e) { }
	}

	aiosExport.sort();
	aios_saveToFile(aiosExport);
}


/*
	Einstellungen aus Textdatei importieren
		=> Aufruf durch <menuitem> in prefs.xul
*/
function aios_importSettings() {
	var strings = document.getElementById("aiosStrings");

	var pattern = aios_loadFromFile();
  if(!pattern) return false;

  var i;
  var aiosImport = new Array;
  var appendFilters = null;

  if(pattern[1].indexOf("All-In-One Sidebar - Settings") < 0) {
  	alert(strings.getString('prefs.invalid'));
  	return false;
  }

  if(!confirm(strings.getString('prefs.import'))) return false;

  for(i = 6; i < pattern.length; i++) {
  	var index = pattern[i].indexOf("=");

  	if(index > 0) {
  		aiosImport[i] = [];
      aiosImport[i].push(pattern[i].substring(0, index));
      aiosImport[i].push(pattern[i].substring(index + 1, pattern[i].length));
		}
	}

	if(pattern[1].indexOf("All-In-One Sidebar - Settings") >= 0) {
	for(i = 6; i < aiosImport.length; i++) {
			try {
				switch(aios_gPrefBranch.getPrefType(aiosImport[i][0])) {
					case aios_pBranch.PREF_BOOL:
							 aios_gPrefBranch.setBoolPref(aiosImport[i][0],/true/i.test(aiosImport[i][1]));
               break;

          case aios_pBranch.PREF_INT:
               aios_gPrefBranch.setIntPref(aiosImport[i][0], aiosImport[i][1]);
               break;

          case aios_pBranch.PREF_STRING:
               var pref = aiosImport[i][1];
               if(pref.indexOf('"') == 0) // in prev version we use " " for string
							 		pref = pref.substring(1,pref.length - 1);
               aios_gPrefBranch.setCharPref(aiosImport[i][0], pref);
               break;
				}
			}
			catch(e) { }
		}

		// GUI-Elemente zurcksetzen
		aios_synchElements();

		// abhngige Elemente aktivieren oder deaktivieren
		aios_checkDependent();

		return true;
	}

	alert(strings.getString('prefs.failed'));
	return false;
}


/*
	Array in einer Textdatei speichern (thanks to adblock & Tab Mix Plus :-))
		=> Aufruf durch aios_exportSettings()
*/
function aios_saveToFile(patterns) {
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

	var strings = document.getElementById("aiosStrings");

  fp.init(window, strings.getString('prefs.save'), fp.modeSave);
  fp.defaultExtension = 'txt';
  fp.defaultString = 'AIOS-Settings';
  fp.appendFilters(fp.filterText);

  if(fp.show() != fp.returnCancel) {

    if(fp.file.exists()) fp.file.remove(true);
    fp.file.create(fp.file.NORMAL_FILE_TYPE, 0666);
    stream.init(fp.file, 0x02, 0x200, null);

    for(var i = 0; i < patterns.length; i++) {
      patterns[i] = patterns[i] + "\n";
      stream.write(patterns[i], patterns[i].length);
    }

    stream.close();
  }
}


/*
	Textdatei in ein Array einlesen (thanks to adblock & Tab Mix Plus :-))
		=> Aufruf durch aios_importSettings()
*/
function aios_loadFromFile() {
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  var stream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
  var streamIO = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

	var strings = document.getElementById("aiosStrings");

  fp.init(window, strings.getString('prefs.open'), fp.modeOpen);
  fp.defaultExtension = 'txt';
  fp.appendFilters(fp.filterText);

  if(fp.show() != fp.returnCancel) {

  	stream.init(fp.file, 0x01, 0444, null);
    streamIO.init(stream);

    var input = streamIO.read(stream.available());
    streamIO.close();
    stream.close();

    var linebreak = input.match(/(((\n+)|(\r+))+)/m)[1]; // first: whole match -- second: backref-1 -- etc..
    return input.split(linebreak);
  }

  return null;
}


/*
	auf abhngige Elemente prfen
		=> Aufruf durch aios_initPrefs(), aios_defaultPrefs() und aios_importSettings()
*/
function aios_checkDependent() {
	var childObserver = document.getElementsByAttribute('oncommand', 'aios_checkboxObserver(this);');

	for(var i = 0; i < childObserver.length; i++) {
		aios_checkboxObserver(childObserver[i]);
	}
}


/*
	abhngige Checkboxen aktivieren oder deaktivieren
		Aufruf durch die Eltern-Checkbox und aios_checkDependent()
*/
function aios_checkboxObserver(which) {
	var observe = which.getAttribute('aiosChilds');
	var allChilds = observe.split(",");

	for(var i = 0; i < allChilds.length; i++) {
		var childPref = allChilds[i].replace(/ /, "");

		var child = document.getElementsByAttribute('preference', childPref);
		if(child.length == 0) child = document.getElementsByAttribute('id', childPref);

		//if(child[0]) child[0].setAttribute('disabled', !aios_getBoolean(which, 'checked') || aios_getBoolean(which, 'disabled'));

		if(child[0]) {
			if(!aios_getBoolean(which, 'checked') || aios_getBoolean(which, 'disabled')) child[0].setAttribute('disabled', true);
			else child[0].removeAttribute('disabled');
		}
	}
}


/*
	Feld fr Link-Konfiguration mit Standard-Einstellung vorbelegen oder zurcksetzen
	 => Aufruf durch aios_initPrefs() und aios_defaultSettings()
*/
function aios_customLinks(reset) {
	var strings = document.getElementById("aiosStrings");
	var emDefLinks = strings.getString('addons.def.links');

	var emTextbox = document.getElementById('emCustLinks');
	
	if(emTextbox.value == "" || reset) emTextbox.value = emDefLinks;
}


/*
	Advanced-Mode aktivieren/deaktivieren und Elemente und ein-/ausblenden
		=> Aufruf durch aios_initPrefs() und das <menuitem> des Setting buttons
*/
function aios_advancedMode(trigger) {

	/*if(trigger) {
		var heightBefore = aios_getSizeBoxHeight();
	}*/

	var advanced = aios_getBoolean('aios-advanced', 'checked');

	// Advanced-Elemente durchlaufen und ein-/ausblenden
	var advElems = document.getElementsByAttribute('aiosAdvanced', 'true');
	for(var i = 0; i < advElems.length; i++) {

		// wenn das Element ein Tab-Container ist
		if(advElems[i].localName == "tabs") {

			var tabChild = advElems[i].selectedIndex;
			var tabChildClass = advElems[i].childNodes[tabChild].getAttribute('class');

			// vorherigen Tab aktivieren, wenn ein advanced Tab gewhlt ist und der Advanced Mode deaktiviert wird
			if(!advanced && tabChildClass == "aiosAdvanced") {
				advElems[i].parentNode.childNodes[0].selectedIndex = advElems[i].selectedIndex - 1;
				advElems[i].parentNode.childNodes[1].selectedIndex = advElems[i].selectedIndex - 1;

				// noch einmal vorherigen Tab aktivieren, wenn der neue Tab auch ein advanced Tab ist
				tabChild = advElems[i].selectedIndex;
				tabChildClass = advElems[i].childNodes[tabChild].getAttribute('class');
				if(tabChildClass == "aiosAdvanced") {
					advElems[i].parentNode.childNodes[0].selectedIndex = advElems[i].selectedIndex - 1;
					advElems[i].parentNode.childNodes[1].selectedIndex = advElems[i].selectedIndex - 1;
				}

				// selektierten Tab merken (in prefpane)
				advElems[i].parentNode.parentNode.setAttribute('seltab', advElems[i].selectedIndex);
			}

			// welcher Tab-Container ist sichtbar?
			advElems[i].parentNode.childNodes[0].setAttribute('hidden', advanced);
			advElems[i].parentNode.childNodes[1].setAttribute('hidden', !advanced);
			if(advanced) advElems[i].parentNode.childNodes[1].style.visibility = 'visible';
		}
		// andere Elemente
		else {
			advElems[i].setAttribute('hidden', !advanced);
			if(advanced) advElems[i].style.visibility = 'visible';
		}
	}

	// variierende Style-Angaben im normalen und erweiterten Modus
	var advStyleElems = document.getElementsByAttribute('aiosAdvancedStyle', 'true');
	for(var s = 0; s < advStyleElems.length; s++) {

		var sStyle = advStyleElems[s].getAttribute('aiosNorStyle');
		if(advanced) sStyle = advStyleElems[s].getAttribute('aiosAdvStyle');

		advStyleElems[s].setAttribute('style', sStyle);
	}

  /*// Fenster vergern/verkleinern bei Mode-Umschaltung
	if(trigger) {
		var heightAfter = aios_getSizeBoxHeight();

		//alert("heightBefore: " + heightBefore + " heightAfter: " + heightAfter);

		var diff = heightBefore - heightAfter;
		if(heightAfter > heightBefore) diff = diff - 10;
		window.resizeTo(window.outerWidth, window.outerHeight - diff);
	}*/
	window.sizeToContent();
}


/*
	Hhe der Boxen zum Aktivieren/Deaktivieren des Advanced-Modes ermitteln
		=> Aufruf durch aios_advancedMode()
*/
function aios_getSizeBoxHeight() {
	var theHeight = 0;
	var sizeBoxen = document.getElementsByAttribute('class', 'aiosSizeBox');

	for(var i = 0; i < sizeBoxen.length; i++) {
		var h = sizeBoxen[i].boxObject.height;

		if(sizeBoxen[i].getAttribute('restart')) h = h + 30;

		if(h > theHeight) theHeight = h;
	}

	return theHeight;
}


/*
	Zahlen mit fhrender Null zurckgeben
		=> Aufruf durch aios_exportSettings()
*/
function aios_extendInt(aInput) {
	if(aInput < 10) return "0" + aInput.toString();
	else return aInput;
}


/*
	synchronisiert jeweils die beiden Tab-Container, die abwechselnd angezeigt werden (normal und advanced)
		=> Aufruf durch die beiden Tab-Container (General und Misc)
*/
function aios_synchTabs(which) {
	var tabs0 = which.parentNode.childNodes[0];
	var tabs1 = which.parentNode.childNodes[1];

	if(tabs0.tagName == "tabs") tabs0.selectedIndex = which.selectedIndex;
	if(tabs1.tagName == "tabs") tabs1.selectedIndex = which.selectedIndex;

	// selektierten Tab merken (in prefpane)
	which.parentNode.parentNode.setAttribute('seltab', which.selectedIndex);
}


/*
	GUI-Elemente zurcksetzen
		=> Aufruf durch aios_defaultSettings() und aios_importSettings()
*/
function aios_synchElements() {
	var val;
	var prefs = document.getElementsByTagName('preference');

	for(var i = 0; i < prefs.length; i++) {

		var prefID = prefs[i].getAttribute('id');
		var prefType = prefs[i].getAttribute('type');
		var prefName = prefs[i].getAttribute('name').replace(/extensions.aios./, "");

		var elem = document.getElementsByAttribute('preference', prefID)[0];

		switch(prefType) {
			case "int":			val = aios_gPrefBranch.getIntPref(prefName); break;
			case "string":	val = aios_gPrefBranch.getCharPref(prefName); break;
			case "bool":		val = aios_gPrefBranch.getBoolPref(prefName); break;
		}

		if(elem) {
			switch(elem.tagName) {
				case "checkbox":	elem.checked = val; break;
				case "textbox":		elem.value = val; break;
				case "menulist":	elem.value = val; break;
			}
		}
	}
}


/*
	Einstellungen einiger Optionen direkt bernehmen
		=> Aufruf durch button "accept" und aios_applyPrefs()
*/

function aios_savePrefs() {
	aios_setConfSidebarWidth();

	// Tooltip fr PanelTab-Button festlegen
	if(aios_WIN.document.getElementById('paneltab-button')) {
		var ptReverse = aios_gPrefBranch.getBoolPref("paneltab.reverse");
		var ptTooltip = (ptReverse) ? 'paneltab-tooltip-reverse' : 'paneltab-tooltip';
		aios_WIN.document.getElementById('paneltab-button').setAttribute('tooltip', ptTooltip);
	}

	if(aios_WIN.aios_setTargets) aios_WIN.aios_setTargets();
	if(aios_WIN.aios_modKeys) aios_WIN.aios_modKeys();
	if(aios_WIN.aiostbx_checkSpecialToolbars) aios_WIN.aiostbx_checkSpecialToolbars();
	if(aios_WIN.aios_checkThinSwitch) aios_WIN.aios_checkThinSwitch();
	if(aios_WIN.aios_setSidebarOrient) aios_WIN.aios_setSidebarOrient();
	if(aios_WIN.aios_modFFToolsMenu) aios_WIN.aios_modFFToolsMenu();
	if(aios_WIN.aios_initAutohide) aios_WIN.aios_initAutohide();

	// Bugfix...
	// sonst wird das Kontextmen der Erweiterung angezeigt,
	// wenn die Optionen ber Rechtsklick geffnet wurden und der Apply-Button geklickt wird
	if(opener.document.getElementById('extensionContextMenu'))
	  opener.document.getElementById('extensionContextMenu').hidePopup();
}


/*
	Einstellungen uebernehmen ohne den Dialog zu schliessen
		=> Aufruf durch button "extra1"
*/
function aios_applyPrefs() {
	var pID, pType, pName, pValue;

	// Prefs direkt speichern
	var allPrefs = document.getElementsByTagName('preference');
	for(var i = 0; i < allPrefs.length; i++) {
		pID = allPrefs[i].getAttribute('id');
		pType = allPrefs[i].getAttribute('type');
		pName = allPrefs[i].getAttribute('name');
		pValue = allPrefs[i].value;

		switch(pType) {
			case "string": 	aios_gPref.setCharPref(pName, pValue); break;
			case "bool": 		aios_gPref.setBoolPref(pName, pValue); break;
			case "int": 		aios_gPref.setIntPref(pName, pValue); break;
		}
	}

	// zustzliche Optionen
	aios_savePrefs();

	// Apply-Button deaktivieren
	aios_disableApplyButton(true);

	// Prefs merken, wird fr den Apply-Button bentigt => aios_checkApply()
	aios_rememberOldPrefs();

	// Prefs direkt in Datei speichern
	aios_gPref.savePrefFile(null);
}


/*
	Apply-Button aktivieren/deaktivieren
		=> Aufruf durch aios_initPrefs(), aios_applyPrefs() und aios_checkApply()
*/
function aios_disableApplyButton(aDis) {

	if(document.documentElement.getButton('extra1')) {
		document.documentElement.getButton('extra1').setAttribute('disabled', aDis);
	}

	if(aDis) couldApply = "";
}


/*
	Prefs merken, bevor sie verndert werden => wird fr den Apply-Button bentigt
		=> Aufruf durch aios_initPrefs() und aios_applyPrefs()
*/
function aios_rememberOldPrefs() {
	var allPrefs = document.getElementsByTagName('preference');
	for(var i = 0; i < allPrefs.length; i++) {
		allPrefs[i].setAttribute('oldValue', allPrefs[i].value);

		// onchange-Handler hinzufgen
		if(!allPrefs[i].getAttribute('onchange')) allPrefs[i].setAttribute('onchange', "aios_checkApply(this);");
	}
}


/*
	berprfung auf zu speichernde Optionen
		Aufruf durch alle Checkboxen, Selcts, Textboxen usw durch onchange-Handler - gesetzt durch aios_rememberOldPrefs()
*/
var couldApply = "";
function aios_checkApply(aPref) {
	if(typeof aPref == "object") {

		var oldPref, newPref;
		var pID = aPref.id;

		// gemerkte und neue Einstellungen in richtiges Format konvertieren
		switch(aPref.getAttribute('type')) {
			case "string": 	oldPref = aPref.getAttribute('oldValue');
											newPref = aPref.value;
											break;

			case "bool": 		oldPref = aios_getBoolean(aPref, 'oldValue');
											newPref = aPref.value;
											break;

			case "int": 		oldPref = aPref.getAttribute('oldValue') * 1;
											newPref = aPref.value * 1;
											break;
		}

		// wenn die nderung der alten Einstellung entspricht,...
		if(oldPref === newPref) {

			// enspr. String lschen
			if(couldApply.indexOf(pID) >= 0) {
				var t1 = couldApply.substr(0, couldApply.indexOf(pID));
				if(t1.indexOf(",") == 0) t1 = t1.substr(1, t1.length);												// Komma am Anfang lschen
				if(t1.lastIndexOf(",") == t1.length - 1) t1 = t1.substr(0, t1.length - 1);		// Komma am Ende lschen

				var t2 = couldApply.substr(couldApply.indexOf(pID) + pID.length, couldApply.length);
				if(t2.indexOf(",") == 0) t2 = t2.substr(1, t2.length);												// Komma am Anfang lschen
				if(t2.lastIndexOf(",") == t2.length - 1) t2 = t2.substr(0, t2.length - 1);		// Komma am Ende lschen

				if(t2.length > 0) t1+= ",";																										// mit Komma verbinden
				couldApply = t1 + t2;
			}
			//alert("keine Aenderung: " + couldApply);
		}
		// wenn die nderung _nicht_ der alten Einstellung entspricht,...
		else {
			// enspr. String erweitern
			if(couldApply.length > 0) couldApply+= ",";																			// mit Komma verbinden
			couldApply+= pID;
			//alert("Aenderung: " + couldApply);
		}

		// Apply-Button deaktivieren/aktivieren
		if(couldApply.length == 0) aios_disableApplyButton(true);
		else aios_disableApplyButton(false);
	}
}


/*
	Optionen aus lteren Versionen lschen
		=> Aufruf durch aios_initPrefs()
*/
function aios_deleteOldPrefs() {

	var oldPrefs = new Array('stop_reload', 'toggle_findbar', 'sort_extensions', 'count_extensions', 'sidebar_extensions', 'sort_themes', 'count_themes', 'sidebar_themes', 'sort_downloads', 'count_downloads', 'sidebar_downloads', 'webpanel.remembersite', 'webpanel.rememberSite', 'lastBookmarkFolder', 'lastHistoryFolder', 'scrollToLastFolder', 'reselectLastFolder', 'showToolbar', 'jsconsolefilter', 'acbh.enable', 'acbh.rememberFolder', 'acbh.scrollToFolder', 'acbh.showButtons', 'em.link.cs-CZ', 'em.link.de-DE', 'em.link.en-US1', 'em.link.en-US2', 'em.link.en-US3', 'em.link.es-ES', 'em.link.fr-FR', 'em.link.hu-HU', 'em.link.it-IT', 'em.link.ja-JP', 'em.link.ko-KR', 'em.link.nl-NL', 'em.link.pl-PL', 'em.link.pt-BR', 'em.link.ru-RU', 'em.link.sv-SE', 'em.link.tr-TR', 'em.link.zh-CN', 'tm.link.en-US1', 'tm.link.en-US2', 'bookmarks.shift', 'em.link.moz', 'em.link.extroom', 'em.link.extmirror', 'em.link.brazil', 'em.link.chinese', 'em.link.czech', 'em.link.dutch', 'em.link.french', 'em.link.german', 'em.link.hungarian', 'em.link.italian', 'em.link.japanese', 'em.link.korean', 'em.link.polish', 'em.link.russian', 'em.link.spanish', 'em.link.swedish', 'tm.link.moz', 'tm.link.extmirror', 'menus.tools.options', 'scrollToLastFolder', 'jscon.filter', 'jscon.categories', 'spec.toggleFindbar', 'spec.stopReload', 'changelog.show', 'menus.context.gotop', 'menus.context.gobottom', 'menus.context.urltools', 'menus.context.dlembed', 'menus.context.gcache', 'menus.context.wayback', 'menus.context.whois', 'gen.switch.athin', 'menus.context.source', 'menus.context.submenu', 'menus.context.webpanel', 'menus.context.pageinfo', 'menus.sidebar.paneltab', 'bookmarks.paneltab', 'em.sort', 'tm.sidebar', 'tm.sort', 'tm.layout', 'tm.slim', 'tm.count', 'tm.colors', 'tm.tools', 'tm.link', 'tm.custom');

	for(var i = 0; i < oldPrefs.length; i++) {
		try {
			aios_gPrefBranch.clearUserPref(oldPrefs[i]);
		}
		catch(e) { }
	}
}