
var aiosOS = Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULRuntime).OS;

// mostly we're just redefining functions that already exist to cope with multiple toolboxes
// (i.e the function body gets wrapped in a for(){} loop, and references to |gToolbox| get changed)

if(aiosOS != "Darwin") {
	
	var gToolboxes = null;
	var wOpener = null;
	if(window.opener && window.opener.top && typeof window.opener.top.aiostbx_adjustToolboxWidth == "function") wOpener = window.opener.top;
	var gPref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

	
	onload = function () {
		aios_moveGlobal();
		
	  InitWithToolbox(window.arguments[0]);
	  repositionDialog();
	}
	
	
	// globale Einstellungen in die Groupbox verschieben
	var aios_moveGlobal;
	aios_moveGlobal = function () {
	  try {
	    var globalBox = document.getElementById('smallicons').parentNode;
	  	document.getElementById('aios-globalGroup').appendChild(globalBox);
	  	document.getElementById('smallicons').setAttribute('flex', 1);
	
	  	// DOM Inspector-Button entfernen, wenn DOMI nicht installiert ist
	  	if(aios_checkDOMi) {
	  	  aios_checkDOMi();
	  	  window.setTimeout("aios_checkDOMi()", 200);
	  	}
	
	  	// Anpassungen fr FF 1.5 <=> FF 2.0
	  	if(aios_modBonEcho) {
	  	  aios_modBonEcho();
	  	  window.setTimeout("aios_modBonEcho()", 200);
	  	}
	
	  	// Anpassungen fr Console2
	  	if(aios_modConsole2) {
	  	  aios_modConsole2();
	  	  window.setTimeout("aios_modConsole2()", 200);
	  	}
	  }
		catch(e) { }
	}
	
	
	InitWithToolbox = function (aToolbox) {
		// mod by eXXile
		var aiosCNT = 0;
		  
		try {
			var enable_tabbar = gPref.getBoolPref('extensions.aios.tbx.tabbar');
			document.getElementById('palette-box').setAttribute('aiosTabToolbar', enable_tabbar);
		}
		catch(e) { }
		// end mod
			
		gToolbox = aToolbox;
		gToolboxDocument = gToolbox.ownerDocument;
		  
		// we pass the full array of toolboxes as the 2nd arg so as not to break
		// any other xul apps (extensions) which are using customisable toolbars
		gToolboxes = (window.arguments && window.arguments.length > 1) ? window.arguments[1] : [gToolbox];
		
		 for(var i = 0; i < gToolboxes.length; i++) {
		  // mod by eXXile
		  // Events fr Toolbaranpassungen
		  	if(wOpener != null) {
		  		gToolboxes[i].addEventListener("draggesture", wOpener.aiostbx_adjustToolboxWidth, false);
		    	gToolboxes[i].addEventListener("dragdrop", wOpener.aiostbx_adjustToolboxWidth, false);
		  	}
		
		   if(gToolboxes[i].getAttribute('id').indexOf('aios') >= 0) aiosCNT++;
		  //endmod
		
		  gToolboxes[i].addEventListener("draggesture", onToolbarDragGesture, false);
		  gToolboxes[i].addEventListener("dragover", onToolbarDragOver, false);
		  gToolboxes[i].addEventListener("dragexit", onToolbarDragExit, false);
		  gToolboxes[i].addEventListener("dragdrop", onToolbarDragDrop, false);
		  // useful for min-width styles and suchlike
		  gToolboxes[i].setAttribute("incustomisemode","true");
		}
		
		// mod by eXXile
		// Hinweis auf weitere Optionen ausblenden wenn nicht die Haupttoolbars konfiguriert werden
		// Kompatibilitt mit anderen Erweiterungen, die konfigurierbare Toolbars anbieten (z.B. Console2)
		if(aiosCNT == 0) {
			document.getElementById("aios-globalDesc").hidden = true;
		}
		//endmod
		  
		/*gToolbox.addEventListener("draggesture", onToolbarDragGesture, false);
		gToolbox.addEventListener("dragover", onToolbarDragOver, false);
		gToolbox.addEventListener("dragexit", onToolbarDragExit, false);
		gToolbox.addEventListener("dragdrop", onToolbarDragDrop, false);*/
		  
		initDialog();
	}
	
	
	
	repositionDialog = function () {
		// mod by eXXile
		if(typeof kWindowWidth == "undefined") return false;
		if(document.getElementById('CustomizeToolbarWindow').getAttribute('width')) return false;
		// endmod
	
		// Position the dialog touching the bottom of the toolbox and centered with
	  // it. We must resize the window smaller first so that it is positioned
	  // properly.
	  var screenX = gToolbox.boxObject.screenX + ((gToolbox.boxObject.width - kWindowWidth) / 2);
	  var screenY = gToolbox.boxObject.screenY + gToolbox.boxObject.height;
	
	  var newHeight = kWindowHeight;
	  if (newHeight >= screen.availHeight - screenY - kVSizeSlop) {
	    newHeight = screen.availHeight - screenY - kVSizeSlop;
	  }
	
	  window.resizeTo(kWindowWidth, newHeight);
	  window.moveTo(screenX, screenY);
	  return true;
	}
	
	
	removeToolboxListeners = function () {
	  for(var i = 0; i < gToolboxes.length; i++) {
	    gToolboxes[i].removeEventListener("draggesture", onToolbarDragGesture, false);
	    gToolboxes[i].removeEventListener("dragover", onToolbarDragOver, false);
	    gToolboxes[i].removeEventListener("dragexit", onToolbarDragExit, false);
	    gToolboxes[i].removeEventListener("dragdrop", onToolbarDragDrop, false);
	    gToolboxes[i].removeAttribute("incustomisemode");
	  }
	}
	
	
	// overriding so that we can tag changing of context menus on to the end
	initDialog = function () {
	
	  document.getElementById("main-box").collapsed = false;
	
	  var mode = gToolbox.getAttribute("mode");
	  document.getElementById("modelist").value = mode;
	  var iconSize = gToolbox.getAttribute("iconsize");
	  var smallIconsCheckbox = document.getElementById("smallicons");
	  if (mode == "text")
	    smallIconsCheckbox.disabled = true;
	  else
	    smallIconsCheckbox.checked = iconSize == "small";
	
	  // Build up the palette of other items.
	  buildPalette();
	
	  // Wrap all the items on the toolbar in toolbarpaletteitems.
	  wrapToolbarItems();
	
		// Bookmark-Buttons-Bugfix fr rechte Statusleisten-Toolbar
		//	=> Button entfernen um Irritationen bei der Konfiguration zu vermeiden
	  //aiostbx_bmBugFix(false);
	}
	
	
	wrapToolbarItems = function () {
	  for(var j = 0; j < gToolboxes.length; j++) {
	    var toolbox = gToolboxes[j];
	
	    for(var i = 0; i < toolbox.childNodes.length; ++i) {
	      var toolbar = toolbox.childNodes[i];
	      if(!isCustomizableToolbar(toolbar)) continue;
	
	      for(var k = 0; k < toolbar.childNodes.length; ++k) {
	        var item = toolbar.childNodes[k];
	
	        if(!isToolbarItem(item)) continue;
	
	        var nextSibling = item.nextSibling;
	
	        var wrapper = wrapToolbarItem(item);
	
	        if(nextSibling)
	          toolbar.insertBefore(wrapper, nextSibling);
	        else
	          toolbar.appendChild(wrapper);
	      }
	    }
	  }
	}
	
	
	unwrapToolbarItems = function () {
	  for(var j = 0; j < this.gToolboxes.length; j++) {
	    var toolbox = gToolboxes[j];
	
	    var paletteItems = toolbox.getElementsByTagName("toolbarpaletteitem");
	    var paletteItem;
	    while ((paletteItem = paletteItems.item(0)) != null) {
	      var toolbarItem = paletteItem.firstChild;
	
	      if (paletteItem.hasAttribute("itemdisabled"))
	        toolbarItem.disabled = true;
	
	      if (paletteItem.hasAttribute("itemcommand"))
	        toolbarItem.setAttribute("command", paletteItem.getAttribute("itemcommand"));
	
	      // We need the removeChild here because replaceChild and XBL no workee
	      // together.  See bug 193298.
	      paletteItem.removeChild(toolbarItem);
	      paletteItem.parentNode.replaceChild(toolbarItem, paletteItem);
	    }
	  }
	}
	
	
	// Get the list of ids for the current set of items on each toolbar. *in each toolbox*
	getCurrentItemIds = function () {
	  var currentItems = {};
	  for(var j = 0; j < gToolboxes.length; j++) {
	    var toolbox = gToolboxes[j];
	
	    for (var i = 0; i < toolbox.childNodes.length; ++i) {
	      var toolbar = toolbox.childNodes[i];
	      if (isCustomizableToolbar(toolbar)) {
	        var child = toolbar.firstChild;
	        while (child) {
	          if (isToolbarItem(child))
	            currentItems[child.id] = 1;
	          child = child.nextSibling;
	        }
	      }
	    }
	  }
	  return currentItems;
	}
	
	
	addNewToolbar = function () {
	  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
	                                .getService(Components.interfaces.nsIPromptService);
	
	  var stringBundle = document.getElementById("stringBundle");
	  var message = stringBundle.getString("enterToolbarName");
	  var title = stringBundle.getString("enterToolbarTitle");
	
	  var name = {};
	  while(true) {
	    if(!promptService.prompt(window, title, message, name, null, {})) return;
	
	    // Check for an existing toolbar with the same name and prompt again
	    // if a conflict is found
	    var nameToId = "__customToolbar_" + name.value.replace(" ", "");
	    var existingToolbar = gToolboxDocument.getElementById(nameToId);
	    if(existingToolbar) {
	      message = stringBundle.getFormattedString("enterToolbarDup", [name.value]);
	    } else {
	      break;
	    }
	  }
	
	  gToolbox.appendCustomToolbar(name.value, "", true);
	
	  repositionDialog();
	  gToolboxChanged = true;
	}
	
	
	/**
	 * Restore the default set of buttons to fixed toolbars,
	 * remove all custom toolbars, and rebuild the palette.
	 */
	restoreDefaultSet = function () {
	  for(var i = 0; i < gToolboxes.length; i++) {
	    var toolbox = gToolboxes[i];
	
	    // Restore the defaultset for fixed toolbars.
	    var toolbar = toolbox.firstChild;
	    while (toolbar) {
	      if(isCustomizableToolbar(toolbar)) {
	        if(!toolbar.hasAttribute("customindex")) {
	          var defaultSet = toolbar.getAttribute("defaultset");
	          if(defaultSet)
	            toolbar.currentSet = defaultSet;
	        }
	      }
	      toolbar = toolbar.nextSibling;
	    }
	
	    // Remove all of the customized toolbars.
	    var child = toolbox.lastChild;
	    while(child) {
	      if(child.hasAttribute("customindex")) {
	        var thisChild = child;
	        child = child.previousSibling;
	        toolbox.removeChild(thisChild);
	      } else {
	        child = child.previousSibling;
	      }
	    }
	  }
	
	  // Now rebuild the palette.
	  buildPalette();
	
	  // Now re-wrap the items on the toolbar.
	  wrapToolbarItems();
	
	  repositionDialog();
	  gToolboxChanged = true;
	}
	
	
	updateIconSize = function (aUseSmallIcons) {
	  var val = aUseSmallIcons ? "small" : null;
	
	  for(var j = 0; j < gToolboxes.length; j++) {
	    var toolbox = gToolboxes[j];
	
	    // the default theme doens't use these, but other themes might be
	    // (since they were in the original code)
	    setAttribute(toolbox, "iconsize", val);
	    gToolboxDocument.persist(toolbox.id, "iconsize");
	
	    for(var i = 0; i < toolbox.childNodes.length; ++i) {
	      var toolbar = toolbox.childNodes[i];
	      if(isCustomizableToolbar(toolbar)) {
	        setAttribute(toolbar, "iconsize", val);
	        gToolboxDocument.persist(toolbar.id, "iconsize");
	      }
	    }
	  }
	
	  repositionDialog();
	
	  // Breiten der vert. Toolboxen lschen (Anpassung der Gre), um sie kurze Zeit spter wieder festzusetzen
	  if(wOpener != null) wOpener.aiostbx_adjustToolboxWidth(toolbox);
	}
	
	
	updateToolbarMode = function (aModeValue) {
	
	  for(var j = 0; j < gToolboxes.length; j++) {
	    var toolbox = gToolboxes[j];
	
	    setAttribute(toolbox, "mode", aModeValue);
	    gToolboxDocument.persist(toolbox.id, "mode");
	
	    for (var i = 0; i < toolbox.childNodes.length; ++i) {
	      var toolbar = toolbox.childNodes[i];
	      if (isCustomizableToolbar(toolbar)) {
	        setAttribute(toolbar, "mode", aModeValue);
	        gToolboxDocument.persist(toolbar.id, "mode");
	      }
	    }
	  }
	
	  var iconSizeCheckbox = document.getElementById("smallicons");
	  if(aModeValue == "text") {
	    iconSizeCheckbox.disabled = true;
	    iconSizeCheckbox.checked = false;
	    updateIconSize(false);
	  } else {
	    iconSizeCheckbox.disabled = false;
	  }
	
	  repositionDialog();
	
	  // Breiten der vert. Toolboxen lschen (Anpassung der Gre), um sie kurze Zeit spter wieder festzusetzen
	  if(wOpener != null) wOpener.aiostbx_adjustToolboxWidth(toolbox);
	}
	
	
	// called as window closes.  inform toolboxes that customisation is complete.
	// xxx: fire DOM events as well
	notifyParentComplete = function () {
	  for(var i = 0; i < gToolboxes.length; i++) {
	    if("customizeDone" in gToolboxes[i]) gToolboxes[i].customizeDone(gToolboxChanged);
	  }
	
	  // Bookmark-Buttons-Bugfix fr rechte Statusleisten-Toolbar => Button hinzufgen
	  //aiostbx_bmBugFix(true);
	}
	
}