@echo off

rem Sets up the Allegro package for building with the specified compiler,
rem and if possible converting text files from LF to CR/LF format.

rem Test if there are too many args.
if [%3] == []        goto arg2
goto help

:arg2
rem Test if second arg is ok.
if [%2] == [--quick] goto arg1
if [%2] == []        goto arg1
goto help

:arg1
rem Test if first arg is ok.
if [%1] == [bcc32]   goto head
if [%1] == [djgpp]   goto head
if [%1] == [mingw32] goto head
if [%1] == [msvc]    goto head
if [%1] == [watcom]  goto head
goto help

:head
rem Generate header of makefile and alplatf.h,
rem then go to platform specific function.
echo # generated by fix.bat > makefile
echo /* generated by fix.bat */ > include\allegro\platform\alplatf.h

if [%1] == [bcc32]   goto bcc32
if [%1] == [djgpp]   goto djgpp
if [%1] == [mingw32] goto mingw32
if [%1] == [msvc]    goto msvc
if [%1] == [watcom]  goto watcom

echo fix.bat internal error: not reached
goto help

:bcc32
echo Configuring Allegro for Windows/BCC32...
echo MAKEFILE_INC = makefile.bcc >> makefile
echo #define ALLEGRO_BCC32 >> include\allegro\platform\alplatf.h
goto tail

:djgpp
echo Configuring Allegro for DOS/djgpp...
echo MAKEFILE_INC = makefile.dj >> makefile
echo #define ALLEGRO_DJGPP >> include\allegro\platform\alplatf.h
goto tail

:mingw32
echo Configuring Allegro for Windows/Mingw32...
echo MAKEFILE_INC = makefile.mgw >> makefile
echo #define ALLEGRO_MINGW32 >> include\allegro\platform\alplatf.h
goto tail

:msvc
echo Configuring Allegro for Windows/MSVC...
echo MAKEFILE_INC = makefile.vc >> makefile
echo #define ALLEGRO_MSVC >> include\allegro\platform\alplatf.h
goto tail

:watcom
echo Configuring Allegro for DOS/Watcom...
echo MAKEFILE_INC = makefile.wat >> makefile
echo #define ALLEGRO_WATCOM >> include\allegro\platform\alplatf.h
goto tail

:help
echo.
echo Usage: fix platform [--quick]
echo.
echo Where platform is one of: bcc32, djgpp, mingw32, msvc or watcom.
echo The --quick parameter is used to turn off LF to CR/LF conversion.
echo.
goto end

:tail
rem Generate last line of makefile and optionally convert CR/LF.
echo include makefile.all >> makefile

if [%2] == [--quick] goto done
if [%1] == [bcc32]   goto done
if [%1] == [mingw32] goto done

echo Converting Allegro files to DOS CR/LF format...
utod .../*.bat .../*.sh .../*.c *.cfg .../*.h .../*.inc .../*.rc
utod .../*.rh .../*.inl .../*.s .../*.txt .../*._tx makefile.*

:done
echo Done!

:end
