/* A lexical scanner generated by flex*/

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define MGN_FLEX_MAJOR_VERSION 2
#define MGN_FLEX_MINOR_VERSION 5

#include <stdio.h>
#include <unistd.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>

/* Use prototypes in function declarations. */
#define MGN_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define MGN_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define MGN_USE_PROTOS
#define MGN_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define MGN_USE_CONST
#define MGN_USE_PROTOS
#endif

#ifdef MGN_USE_CONST
#define mgnconst const
#else
#define mgnconst
#endif


#ifdef MGN_USE_PROTOS
#define MGN_PROTO(proto) proto
#else
#define MGN_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define MGN_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define MGN_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN mgn_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The MGNSTATE alias is for lex
 * compatibility.
 */
#define MGN_START ((mgn_start - 1) / 2)
#define MGNSTATE MGN_START

/* Action number for EOF rule of a given start state. */
#define MGN_STATE_EOF(state) (MGN_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define MGN_NEW_FILE mgnrestart( mgnin )

#define MGN_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define MGN_BUF_SIZE 16384

typedef struct mgn_buffer_state *MGN_BUFFER_STATE;

extern int mgnleng;
extern FILE *mgnin, *mgnout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		mgnless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the mgnless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define mgnless(n) \
	do \
		{ \
		/* Undo effects of setting up mgntext. */ \
		*mgn_cp = mgn_hold_char; \
		MGN_RESTORE_MGN_MORE_OFFSET \
		mgn_c_buf_p = mgn_cp = mgn_bp + n - MGN_MORE_ADJ; \
		MGN_DO_BEFORE_ACTION; /* set up mgntext again */ \
		} \
	while ( 0 )

#define unput(c) mgnunput( c, mgntext_ptr )

/* Some routines like mgn_flex_realloc() are emitted as static but are
   not called by all lexers. This generates warnings in some compilers,
   notably GCC. Arrange to suppress these. */
#ifdef __GNUC__
#define MGN_MAY_BE_UNUSED __attribute__((unused))
#else
#define MGN_MAY_BE_UNUSED
#endif

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int mgn_size_t;


struct mgn_buffer_state
	{
	FILE *mgn_input_file;

	char *mgn_ch_buf;		/* input buffer */
	char *mgn_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	mgn_size_t mgn_buf_size;

	/* Number of characters read into mgn_ch_buf, not including EOB
	 * characters.
	 */
	int mgn_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int mgn_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int mgn_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int mgn_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int mgn_fill_buffer;

	int mgn_buffer_status;
#define MGN_BUFFER_NEW 0
#define MGN_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as MGN_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via mgnrestart()), so that the user can continue scanning by
	 * just pointing mgnin at a new input file.
	 */
#define MGN_BUFFER_EOF_PENDING 2
	};

static MGN_BUFFER_STATE mgn_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define MGN_CURRENT_BUFFER mgn_current_buffer


/* mgn_hold_char holds the character lost when mgntext is formed. */
static char mgn_hold_char;

static int mgn_n_chars;		/* number of characters read into mgn_ch_buf */


int mgnleng;

/* Points to current character in buffer. */
static char *mgn_c_buf_p = (char *) 0;
static int mgn_init = 1;		/* whether we need to initialize */
static int mgn_start = 0;	/* start state number */

/* Flag which is used to allow mgnwrap()'s to do buffer switches
 * instead of setting up a fresh mgnin.  A bit of a hack ...
 */
static int mgn_did_buffer_switch_on_eof;

void mgnrestart MGN_PROTO(( FILE *input_file ));

void mgn_switch_to_buffer MGN_PROTO(( MGN_BUFFER_STATE new_buffer ));
void mgn_load_buffer_state MGN_PROTO(( void ));
MGN_BUFFER_STATE mgn_create_buffer MGN_PROTO(( FILE *file, int size ));
void mgn_delete_buffer MGN_PROTO(( MGN_BUFFER_STATE b ));
void mgn_init_buffer MGN_PROTO(( MGN_BUFFER_STATE b, FILE *file ));
void mgn_flush_buffer MGN_PROTO(( MGN_BUFFER_STATE b ));
#define MGN_FLUSH_BUFFER mgn_flush_buffer( mgn_current_buffer )

MGN_BUFFER_STATE mgn_scan_buffer MGN_PROTO(( char *base, mgn_size_t size ));
MGN_BUFFER_STATE mgn_scan_string MGN_PROTO(( mgnconst char *mgn_str ));
MGN_BUFFER_STATE mgn_scan_bytes MGN_PROTO(( mgnconst char *bytes, int len ));

static void *mgn_flex_alloc MGN_PROTO(( mgn_size_t ));
static void *mgn_flex_realloc MGN_PROTO(( void *, mgn_size_t )) MGN_MAY_BE_UNUSED;
static void mgn_flex_free MGN_PROTO(( void * ));

#define mgn_new_buffer mgn_create_buffer

#define mgn_set_interactive(is_interactive) \
	{ \
	if ( ! mgn_current_buffer ) \
		mgn_current_buffer = mgn_create_buffer( mgnin, MGN_BUF_SIZE ); \
	mgn_current_buffer->mgn_is_interactive = is_interactive; \
	}

#define mgn_set_bol(at_bol) \
	{ \
	if ( ! mgn_current_buffer ) \
		mgn_current_buffer = mgn_create_buffer( mgnin, MGN_BUF_SIZE ); \
	mgn_current_buffer->mgn_at_bol = at_bol; \
	}

#define MGN_AT_BOL() (mgn_current_buffer->mgn_at_bol)

typedef unsigned char MGN_CHAR;
FILE *mgnin = (FILE *) 0, *mgnout = (FILE *) 0;
typedef int mgn_state_type;
extern char *mgntext;
#define mgntext_ptr mgntext

static mgn_state_type mgn_get_previous_state MGN_PROTO(( void ));
static mgn_state_type mgn_try_NUL_trans MGN_PROTO(( mgn_state_type current_state ));
static int mgn_get_next_buffer MGN_PROTO(( void ));
static void mgn_fatal_error MGN_PROTO(( mgnconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up mgntext.
 */
#define MGN_DO_BEFORE_ACTION \
	mgntext_ptr = mgn_bp; \
	mgnleng = (int) (mgn_cp - mgn_bp); \
	mgn_hold_char = *mgn_cp; \
	*mgn_cp = '\0'; \
	mgn_c_buf_p = mgn_cp;

#define MGN_NUM_RULES 45
#define MGN_END_OF_BUFFER 46
static mgnconst short int mgn_accept[125] =
    {   0,
        1,    1,   46,   45,    1,    2,    4,   39,   40,   45,
       41,   45,   43,   44,   42,   36,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   25,   43,   43,   43,   43,
       37,   38,    1,    0,   44,   44,   43,    3,    0,   22,
       43,   43,   43,   43,   43,   43,   23,   24,   43,   43,
       43,   43,   43,   43,   12,   43,   43,   43,   43,   43,
       43,    0,   43,   43,   29,   28,   34,   35,   16,   43,
       43,   26,   43,   43,   27,   43,   43,   43,   43,   43,
       20,   17,   43,   43,   43,    9,   43,   32,   30,   31,
       18,    6,   43,   43,   33,   43,   43,   43,    7,   43,

       14,   43,   43,   10,   43,   19,   43,   43,   15,   21,
       43,   43,   43,   43,   43,   43,   13,   43,   43,    5,
       11,   43,    8,    0
    } ;

static mgnconst int mgn_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    4,    5,    1,    1,    1,    6,
        7,    8,    9,   10,    9,   11,   12,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,    1,   14,    1,
       15,    1,    1,    1,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       17,    1,   18,    1,   16,    1,   19,   20,   21,   22,

       23,   24,   25,   26,   27,   16,   16,   28,   29,   30,
       31,   32,   16,   33,   34,   35,   16,   36,   37,   38,
       39,   16,   40,    1,   41,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static mgnconst int mgn_meta[42] =
    {   0,
        1,    1,    1,    1,    2,    1,    1,    2,    1,    1,
        2,    2,    2,    1,    1,    2,    2,    1,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    1,
        1
    } ;

static mgnconst short int mgn_base[126] =
    {   0,
        0,    0,  121,  381,  118,  381,  381,  381,  381,   31,
      381,   84,   35,   34,  381,  381,   38,   40,   41,   42,
       43,   45,   46,   59,   53,   74,   61,   75,   87,   91,
      381,  381,   85,   66,   53,   64,   92,  381,   58,   94,
       95,   97,   99,  105,  107,  109,  111,  115,  119,  126,
      130,  131,  134,  136,  137,  144,  138,  148,  156,  149,
      162,  159,  166,  168,  170,  172,  182,  183,  185,  186,
      197,  200,  202,  205,  207,  208,  218,  222,  221,  223,
      224,  225,  226,  239,  238,  240,  243,  246,  251,  256,
      257,  258,  259,  262,  263,  264,  269,  275,  276,  279,

      280,  281,  283,  286,  298,  300,  301,  303,  304,  306,
      311,  317,  318,  319,  324,  329,  331,  332,  337,  339,
      342,  345,  347,  381,   54
    } ;

static mgnconst short int mgn_def[126] =
    {   0,
      124,    1,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  125,  124,  124,  124,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      124,  124,  124,  124,  124,  124,  125,  124,  124,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  124,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,

      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,    0,  124
    } ;

static mgnconst short int mgn_nxt[423] =
    {   0,
        4,    5,    6,    7,    4,    8,    9,    4,   10,   11,
       12,   13,   14,   15,   16,   17,    4,    4,   18,   19,
       20,   17,   17,   17,   17,   21,   17,   22,   23,   24,
       17,   25,   26,   27,   28,   29,   30,   17,   17,   31,
       32,   34,   38,   35,   34,  124,   35,  124,  124,  124,
      124,   39,  124,  124,   39,   37,   39,   39,   39,   39,
      124,   39,   39,   34,   42,   35,  124,   46,  124,   39,
       62,   41,   43,   45,   40,   39,   36,   39,   36,   44,
       51,  124,  124,   47,   48,   52,   33,   53,   54,   49,
       39,   39,   55,   50,  124,   57,   36,   58,  124,  124,

       56,  124,  124,   39,  124,   59,  124,   39,   39,   60,
       39,   39,  124,   39,  124,   39,  124,   61,  124,   33,
      124,   39,  124,   39,   64,   39,  124,   39,   65,   63,
       66,   39,   70,  124,   67,   39,   68,  124,  124,   69,
       71,  124,   39,  124,  124,  124,   39,   39,   73,  124,
       39,  124,   39,   39,   39,  124,  124,  124,   72,  124,
       39,   74,   76,  124,   39,   39,   75,  124,   77,  124,
       78,   62,   39,  124,  124,  124,   37,  124,   39,  124,
       79,   82,   39,   83,   39,   80,   39,   81,   39,  124,
      124,  124,  124,  124,   84,   86,  124,  124,   39,   39,

       85,   39,   39,   87,  124,   89,   88,  124,   90,  124,
      124,  124,  124,   39,  124,  124,   39,  124,   39,   92,
       91,   39,   93,   39,   39,  124,   95,  124,  124,  124,
      124,  124,  124,  124,   39,  124,   94,   39,   39,   39,
       39,   39,   39,   96,   97,  124,  124,  124,  124,   98,
      124,  124,  124,  124,   39,   39,   39,   99,  124,   39,
      100,  101,   39,  124,  124,  124,  124,   39,  102,  124,
      124,  124,   39,   39,   39,   39,  124,  103,   39,   39,
       39,  104,  124,  124,  105,   39,  124,  124,  124,  124,
      124,   39,   39,  124,  124,   39,   39,   39,  106,   39,

      124,  108,   39,  107,  109,  124,  124,  124,  124,  110,
      124,  124,  124,  124,   39,  111,   39,   39,  124,   39,
       39,  113,   39,  124,  124,  124,  124,   39,  124,  115,
      112,  124,  114,   39,   39,   39,  124,  118,  124,  124,
       39,  124,  124,  117,  124,   39,  124,   39,   39,  124,
      119,  116,  124,   39,  124,   39,  124,  124,   39,  121,
      124,   39,  124,   39,  124,  124,  122,  120,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  123,
        3,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,

      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124
    } ;

static mgnconst short int mgn_chk[423] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,   10,   13,   10,   14,   17,   14,   18,   19,   20,
       21,   13,   22,   23,   17,  125,   18,   19,   20,   21,
       25,   22,   23,   35,   20,   35,   24,   22,   27,   25,
       39,   19,   20,   21,   18,   24,   36,   27,   34,   20,
       25,   26,   28,   23,   23,   25,   33,   25,   25,   24,
       26,   28,   26,   24,   29,   27,   12,   28,   30,   37,

       26,   40,   41,   29,   42,   28,   43,   30,   37,   29,
       40,   41,   44,   42,   45,   43,   46,   30,   47,    5,
        3,   44,   48,   45,   42,   46,   49,   47,   43,   41,
       43,   48,   46,   50,   44,   49,   44,   51,   52,   45,
       49,   53,   50,   54,   55,   57,   51,   52,   51,    0,
       53,   56,   54,   55,   57,   58,   60,    0,   50,    0,
       56,   52,   54,   59,   58,   60,   53,    0,   56,   61,
       57,   62,   59,   63,    0,   64,   62,   65,   61,   66,
       58,   60,   63,   61,   64,   58,   65,   59,   66,   67,
       68,    0,   69,   70,   61,   64,    0,    0,   67,   68,

       63,   69,   70,   65,   71,   66,   65,   72,   66,   73,
        0,    0,   74,   71,   75,   76,   72,    0,   73,   71,
       70,   74,   73,   75,   76,   77,   76,    0,   79,   78,
       80,   81,   82,   83,   77,    0,   74,   79,   78,   80,
       81,   82,   83,   77,   78,   85,   84,   86,    0,   79,
       87,    0,    0,   88,   85,   84,   86,   80,   89,   87,
       83,   84,   88,   90,   91,   92,   93,   89,   85,   94,
       95,   96,   90,   91,   92,   93,   97,   87,   94,   95,
       96,   93,   98,   99,   94,   97,  100,  101,  102,    0,
      103,   98,   99,  104,    0,  100,  101,  102,   96,  103,

        0,   98,  104,   97,  100,  105,    0,  106,  107,  102,
      108,  109,    0,  110,  105,  103,  106,  107,  111,  108,
      109,  107,  110,    0,  112,  113,  114,  111,    0,  111,
      105,  115,  108,  112,  113,  114,  116,  114,  117,  118,
      115,    0,    0,  113,  119,  116,  120,  117,  118,  121,
      115,  112,  122,  119,  123,  120,    0,    0,  121,  118,
        0,  122,    0,  123,    0,    0,  119,  116,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  122,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,

      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124
    } ;

static mgn_state_type mgn_last_accepting_state;
static char *mgn_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define mgnmore() mgnmore_used_but_not_detected
#define MGN_MORE_ADJ 0
#define MGN_RESTORE_MGN_MORE_OFFSET
char *mgntext;
#line 1 "../../../src/mbkmg/src/mg2mbk_l.l"
#define INITIAL 0
#line 2 "../../../src/mbkmg/src/mg2mbk_l.l"
/* 
 * This file is part of the Alliance CAD System
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/alliance/
 * E-mail             : mailto:alliance-users@asim.lip6.fr
 * 
 * This library is free software; you  can redistribute it and/or modify it
 * under the terms  of the GNU Library General Public  License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * Alliance VLSI  CAD System  is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 /*
  * Parsing Philips modgen format, done during the IDPS project.
  * Author: Frdric Ptrot
  */

#include <string.h>
#include <ctype.h>
#include <mut.h>
#include "mg2mbk_y.h"
static void zweep();
extern char *filenameforlex();
/* change lex input routine to a non case sensitive one */
#ifdef FLEX_SCANNER
#ifdef MGN_INPUT
#undef MGN_INPUT
#endif
#define MGN_INPUT(buf,result,max_size) \
	do { \
	int c = getc(mgnin); \
		result = (c == EOF) ? MGN_NULL \
									: (buf[0] = isupper(c) ? tolower(c) : c, 1); \
	} while(0)

int mgnlineno;
#else /* using lex, for sure */
#ifdef input
#undef input
#endif
#define input()	(((mgntchar = mgnsptr > mgnsbuf ? U(*--mgnsptr)    \
							: getc(mgnin)) == 10 ?(mgnlineno++,mgntchar)   \
								: mgntchar) == EOF ? 0                    \
									: isupper(mgntchar) ? tolower(mgntchar) \
										: mgntchar)
#endif

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef MGN_SKIP_MGNWRAP
#ifdef __cplusplus
extern "C" int mgnwrap MGN_PROTO(( void ));
#else
extern int mgnwrap MGN_PROTO(( void ));
#endif
#endif

#ifndef MGN_NO_UNPUT
static void mgnunput MGN_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef mgntext_ptr
static void mgn_flex_strncpy MGN_PROTO(( char *, mgnconst char *, int ));
#endif

#ifdef MGN_NEED_STRLEN
static int mgn_flex_strlen MGN_PROTO(( mgnconst char * ));
#endif

#ifndef MGN_NO_INPUT
#ifdef __cplusplus
static int mgninput MGN_PROTO(( void ));
#else
static int input MGN_PROTO(( void ));
#endif
#endif

#if MGN_STACK_USED
static int mgn_start_stack_ptr = 0;
static int mgn_start_stack_depth = 0;
static int *mgn_start_stack = 0;
#ifndef MGN_NO_PUSH_STATE
static void mgn_push_state MGN_PROTO(( int new_state ));
#endif
#ifndef MGN_NO_POP_STATE
static void mgn_pop_state MGN_PROTO(( void ));
#endif
#ifndef MGN_NO_TOP_STATE
static int mgn_top_state MGN_PROTO(( void ));
#endif

#else
#define MGN_NO_PUSH_STATE 1
#define MGN_NO_POP_STATE 1
#define MGN_NO_TOP_STATE 1
#endif

#ifdef MGN_MALLOC_DECL
MGN_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef MGN_READ_BUF_SIZE
#define MGN_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( mgntext, mgnleng, 1, mgnout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or MGN_NULL,
 * is returned in "result".
 */
#ifndef MGN_INPUT
#define MGN_INPUT(buf,result,max_size) \
	if ( mgn_current_buffer->mgn_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( mgnin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( mgnin ) ) \
			MGN_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, mgnin )) == 0) \
		  && ferror( mgnin ) ) \
		MGN_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "mgnterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef mgnterminate
#define mgnterminate() return MGN_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef MGN_START_STACK_INCR
#define MGN_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef MGN_FATAL_ERROR
#define MGN_FATAL_ERROR(msg) mgn_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef MGN_DECL
#define MGN_DECL int mgnlex MGN_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after mgntext and mgnleng
 * have been set up.
 */
#ifndef MGN_USER_ACTION
#define MGN_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef MGN_BREAK
#define MGN_BREAK break;
#endif

#define MGN_RULE_SETUP \
	MGN_USER_ACTION

MGN_DECL
	{
	register mgn_state_type mgn_current_state;
	register char *mgn_cp = NULL, *mgn_bp = NULL;
	register int mgn_act;

#line 67 "../../../src/mbkmg/src/mg2mbk_l.l"


	if ( mgn_init )
		{
		mgn_init = 0;

#ifdef MGN_USER_INIT
		MGN_USER_INIT;
#endif

		if ( ! mgn_start )
			mgn_start = 1;	/* first start state */

		if ( ! mgnin )
			mgnin = stdin;

		if ( ! mgnout )
			mgnout = stdout;

		if ( ! mgn_current_buffer )
			mgn_current_buffer =
				mgn_create_buffer( mgnin, MGN_BUF_SIZE );

		mgn_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		mgn_cp = mgn_c_buf_p;

		/* Support of mgntext. */
		*mgn_cp = mgn_hold_char;

		/* mgn_bp points to the position in mgn_ch_buf of the start of
		 * the current run.
		 */
		mgn_bp = mgn_cp;

		mgn_current_state = mgn_start;
mgn_match:
		do
			{
			register MGN_CHAR mgn_c = mgn_ec[MGN_SC_TO_UI(*mgn_cp)];
			if ( mgn_accept[mgn_current_state] )
				{
				mgn_last_accepting_state = mgn_current_state;
				mgn_last_accepting_cpos = mgn_cp;
				}
			while ( mgn_chk[mgn_base[mgn_current_state] + mgn_c] != mgn_current_state )
				{
				mgn_current_state = (int) mgn_def[mgn_current_state];
				if ( mgn_current_state >= 125 )
					mgn_c = mgn_meta[(unsigned int) mgn_c];
				}
			mgn_current_state = mgn_nxt[mgn_base[mgn_current_state] + (unsigned int) mgn_c];
			++mgn_cp;
			}
		while ( mgn_base[mgn_current_state] != 381 );

mgn_find_action:
		mgn_act = mgn_accept[mgn_current_state];
		if ( mgn_act == 0 )
			{ /* have to back up */
			mgn_cp = mgn_last_accepting_cpos;
			mgn_current_state = mgn_last_accepting_state;
			mgn_act = mgn_accept[mgn_current_state];
			}

		MGN_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( mgn_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of MGN_DO_BEFORE_ACTION */
			*mgn_cp = mgn_hold_char;
			mgn_cp = mgn_last_accepting_cpos;
			mgn_current_state = mgn_last_accepting_state;
			goto mgn_find_action;

case 1:
MGN_RULE_SETUP
#line 68 "../../../src/mbkmg/src/mg2mbk_l.l"
{}
	MGN_BREAK
case 2:
MGN_RULE_SETUP
#line 69 "../../../src/mbkmg/src/mg2mbk_l.l"
{
#ifdef FLEX_SCANNER
								mgnlineno++;
#endif
							}
	MGN_BREAK
case 3:
MGN_RULE_SETUP
#line 74 "../../../src/mbkmg/src/mg2mbk_l.l"
{zweep('/');}
	MGN_BREAK
case 4:
MGN_RULE_SETUP
#line 75 "../../../src/mbkmg/src/mg2mbk_l.l"
{zweep('\n');}
	MGN_BREAK
case 5:
MGN_RULE_SETUP
#line 76 "../../../src/mbkmg/src/mg2mbk_l.l"
{zweep('}');}
	MGN_BREAK
case 6:
MGN_RULE_SETUP
#line 77 "../../../src/mbkmg/src/mg2mbk_l.l"
{zweep('}');}
	MGN_BREAK
case 7:
MGN_RULE_SETUP
#line 78 "../../../src/mbkmg/src/mg2mbk_l.l"
{zweep(';');}
	MGN_BREAK
case 8:
MGN_RULE_SETUP
#line 79 "../../../src/mbkmg/src/mg2mbk_l.l"
{zweep(';');}
	MGN_BREAK
case 9:
MGN_RULE_SETUP
#line 80 "../../../src/mbkmg/src/mg2mbk_l.l"
{return CELL;}
	MGN_BREAK
case 10:
MGN_RULE_SETUP
#line 81 "../../../src/mbkmg/src/mg2mbk_l.l"
{return PLACE;}
	MGN_BREAK
case 11:
MGN_RULE_SETUP
#line 82 "../../../src/mbkmg/src/mg2mbk_l.l"
{return TERMINAL;}
	MGN_BREAK
case 12:
MGN_RULE_SETUP
#line 83 "../../../src/mbkmg/src/mg2mbk_l.l"
{return RA;}
	MGN_BREAK
case 13:
MGN_RULE_SETUP
#line 84 "../../../src/mbkmg/src/mg2mbk_l.l"
{return STRETCH;}
	MGN_BREAK
case 14:
MGN_RULE_SETUP
#line 85 "../../../src/mbkmg/src/mg2mbk_l.l"
{return WIRE;}
	MGN_BREAK
case 15:
MGN_RULE_SETUP
#line 86 "../../../src/mbkmg/src/mg2mbk_l.l"
{return MWIDTH;}
	MGN_BREAK
case 16:
MGN_RULE_SETUP
#line 87 "../../../src/mbkmg/src/mg2mbk_l.l"
{return HORIZ;}
	MGN_BREAK
case 17:
MGN_RULE_SETUP
#line 88 "../../../src/mbkmg/src/mg2mbk_l.l"
{return VERTI;}
	MGN_BREAK
case 18:
MGN_RULE_SETUP
#line 89 "../../../src/mbkmg/src/mg2mbk_l.l"
{return MLEFT;}
	MGN_BREAK
case 19:
MGN_RULE_SETUP
#line 90 "../../../src/mbkmg/src/mg2mbk_l.l"
{return MRIGHT;}
	MGN_BREAK
case 20:
MGN_RULE_SETUP
#line 91 "../../../src/mbkmg/src/mg2mbk_l.l"
{return MTOP;}
	MGN_BREAK
case 21:
MGN_RULE_SETUP
#line 92 "../../../src/mbkmg/src/mg2mbk_l.l"
{return MBOTTOM;}
	MGN_BREAK
case 22:
MGN_RULE_SETUP
#line 93 "../../../src/mbkmg/src/mg2mbk_l.l"
{return AT;}
	MGN_BREAK
case 23:
MGN_RULE_SETUP
#line 94 "../../../src/mbkmg/src/mg2mbk_l.l"
{return MX;}
	MGN_BREAK
case 24:
MGN_RULE_SETUP
#line 95 "../../../src/mbkmg/src/mg2mbk_l.l"
{return MY;}
	MGN_BREAK
case 25:
MGN_RULE_SETUP
#line 96 "../../../src/mbkmg/src/mg2mbk_l.l"
{return R;}
	MGN_BREAK
case 26:
MGN_RULE_SETUP
#line 97 "../../../src/mbkmg/src/mg2mbk_l.l"
{return NTR;}
	MGN_BREAK
case 27:
MGN_RULE_SETUP
#line 98 "../../../src/mbkmg/src/mg2mbk_l.l"
{return PTR;}
	MGN_BREAK
case 28:
MGN_RULE_SETUP
#line 99 "../../../src/mbkmg/src/mg2mbk_l.l"
{return COP;}
	MGN_BREAK
case 29:
MGN_RULE_SETUP
#line 100 "../../../src/mbkmg/src/mg2mbk_l.l"
{return CON;}
	MGN_BREAK
case 30:
MGN_RULE_SETUP
#line 101 "../../../src/mbkmg/src/mg2mbk_l.l"
{return COPS;}
	MGN_BREAK
case 31:
MGN_RULE_SETUP
#line 102 "../../../src/mbkmg/src/mg2mbk_l.l"
{return COPW;}
	MGN_BREAK
case 32:
MGN_RULE_SETUP
#line 103 "../../../src/mbkmg/src/mg2mbk_l.l"
{return CONW;}
	MGN_BREAK
case 33:
MGN_RULE_SETUP
#line 104 "../../../src/mbkmg/src/mg2mbk_l.l"
{return PVIA;}
	MGN_BREAK
case 34:
MGN_RULE_SETUP
#line 105 "../../../src/mbkmg/src/mg2mbk_l.l"
{return CXN;}
	MGN_BREAK
case 35:
MGN_RULE_SETUP
#line 106 "../../../src/mbkmg/src/mg2mbk_l.l"
{return CXP;}
	MGN_BREAK
case 36:
MGN_RULE_SETUP
#line 107 "../../../src/mbkmg/src/mg2mbk_l.l"
{return '=';}
	MGN_BREAK
case 37:
MGN_RULE_SETUP
#line 108 "../../../src/mbkmg/src/mg2mbk_l.l"
{return '{';}
	MGN_BREAK
case 38:
MGN_RULE_SETUP
#line 109 "../../../src/mbkmg/src/mg2mbk_l.l"
{return '}';}
	MGN_BREAK
case 39:
MGN_RULE_SETUP
#line 110 "../../../src/mbkmg/src/mg2mbk_l.l"
{return '(';}
	MGN_BREAK
case 40:
MGN_RULE_SETUP
#line 111 "../../../src/mbkmg/src/mg2mbk_l.l"
{return ')';}
	MGN_BREAK
case 41:
MGN_RULE_SETUP
#line 112 "../../../src/mbkmg/src/mg2mbk_l.l"
{return ',';}
	MGN_BREAK
case 42:
MGN_RULE_SETUP
#line 113 "../../../src/mbkmg/src/mg2mbk_l.l"
{return ';';}
	MGN_BREAK
case 43:
MGN_RULE_SETUP
#line 114 "../../../src/mbkmg/src/mg2mbk_l.l"
{	mgnlval.s = mbkstrdup(mgntext);
								return STRING;}
	MGN_BREAK
case 44:
MGN_RULE_SETUP
#line 116 "../../../src/mbkmg/src/mg2mbk_l.l"
{float f;
								sscanf(mgntext, "%f", &f);
								mgnlval.n = (long)(f * SCALE_X);
#ifdef GRIDDED
								mgnlval.n *= 2;
#endif
								return NUM;}
	MGN_BREAK
case 45:
MGN_RULE_SETUP
#line 123 "../../../src/mbkmg/src/mg2mbk_l.l"
ECHO;
	MGN_BREAK
case MGN_STATE_EOF(INITIAL):
	mgnterminate();

	case MGN_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int mgn_amount_of_matched_text = (int) (mgn_cp - mgntext_ptr) - 1;

		/* Undo the effects of MGN_DO_BEFORE_ACTION. */
		*mgn_cp = mgn_hold_char;
		MGN_RESTORE_MGN_MORE_OFFSET

		if ( mgn_current_buffer->mgn_buffer_status == MGN_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed mgnin at a new source and called
			 * mgnlex().  If so, then we have to assure
			 * consistency between mgn_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			mgn_n_chars = mgn_current_buffer->mgn_n_chars;
			mgn_current_buffer->mgn_input_file = mgnin;
			mgn_current_buffer->mgn_buffer_status = MGN_BUFFER_NORMAL;
			}

		/* Note that here we test for mgn_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since mgn_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( mgn_c_buf_p <= &mgn_current_buffer->mgn_ch_buf[mgn_n_chars] )
			{ /* This was really a NUL. */
			mgn_state_type mgn_next_state;

			mgn_c_buf_p = mgntext_ptr + mgn_amount_of_matched_text;

			mgn_current_state = mgn_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * mgn_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			mgn_next_state = mgn_try_NUL_trans( mgn_current_state );

			mgn_bp = mgntext_ptr + MGN_MORE_ADJ;

			if ( mgn_next_state )
				{
				/* Consume the NUL. */
				mgn_cp = ++mgn_c_buf_p;
				mgn_current_state = mgn_next_state;
				goto mgn_match;
				}

			else
				{
				mgn_cp = mgn_c_buf_p;
				goto mgn_find_action;
				}
			}

		else switch ( mgn_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				mgn_did_buffer_switch_on_eof = 0;

				if ( mgnwrap() )
					{
					/* Note: because we've taken care in
					 * mgn_get_next_buffer() to have set up
					 * mgntext, we can now set up
					 * mgn_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * MGN_NULL, it'll still work - another
					 * MGN_NULL will get returned.
					 */
					mgn_c_buf_p = mgntext_ptr + MGN_MORE_ADJ;

					mgn_act = MGN_STATE_EOF(MGN_START);
					goto do_action;
					}

				else
					{
					if ( ! mgn_did_buffer_switch_on_eof )
						MGN_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				mgn_c_buf_p =
					mgntext_ptr + mgn_amount_of_matched_text;

				mgn_current_state = mgn_get_previous_state();

				mgn_cp = mgn_c_buf_p;
				mgn_bp = mgntext_ptr + MGN_MORE_ADJ;
				goto mgn_match;

			case EOB_ACT_LAST_MATCH:
				mgn_c_buf_p =
				&mgn_current_buffer->mgn_ch_buf[mgn_n_chars];

				mgn_current_state = mgn_get_previous_state();

				mgn_cp = mgn_c_buf_p;
				mgn_bp = mgntext_ptr + MGN_MORE_ADJ;
				goto mgn_find_action;
			}
		break;
		}

	default:
		MGN_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of mgnlex */


/* mgn_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int mgn_get_next_buffer()
	{
	register char *dest = mgn_current_buffer->mgn_ch_buf;
	register char *source = mgntext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( mgn_c_buf_p > &mgn_current_buffer->mgn_ch_buf[mgn_n_chars + 1] )
		MGN_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( mgn_current_buffer->mgn_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( mgn_c_buf_p - mgntext_ptr - MGN_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (mgn_c_buf_p - mgntext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( mgn_current_buffer->mgn_buffer_status == MGN_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		mgn_current_buffer->mgn_n_chars = mgn_n_chars = 0;

	else
		{
		int num_to_read =
			mgn_current_buffer->mgn_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef MGN_USES_REJECT
			MGN_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			MGN_BUFFER_STATE b = mgn_current_buffer;

			int mgn_c_buf_p_offset =
				(int) (mgn_c_buf_p - b->mgn_ch_buf);

			if ( b->mgn_is_our_buffer )
				{
				int new_size = b->mgn_buf_size * 2;

				if ( new_size <= 0 )
					b->mgn_buf_size += b->mgn_buf_size / 8;
				else
					b->mgn_buf_size *= 2;

				b->mgn_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					mgn_flex_realloc( (void *) b->mgn_ch_buf,
							 b->mgn_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->mgn_ch_buf = 0;

			if ( ! b->mgn_ch_buf )
				MGN_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			mgn_c_buf_p = &b->mgn_ch_buf[mgn_c_buf_p_offset];

			num_to_read = mgn_current_buffer->mgn_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > MGN_READ_BUF_SIZE )
			num_to_read = MGN_READ_BUF_SIZE;

		/* Read in more data. */
		MGN_INPUT( (&mgn_current_buffer->mgn_ch_buf[number_to_move]),
			mgn_n_chars, num_to_read );

		mgn_current_buffer->mgn_n_chars = mgn_n_chars;
		}

	if ( mgn_n_chars == 0 )
		{
		if ( number_to_move == MGN_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			mgnrestart( mgnin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			mgn_current_buffer->mgn_buffer_status =
				MGN_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	mgn_n_chars += number_to_move;
	mgn_current_buffer->mgn_ch_buf[mgn_n_chars] = MGN_END_OF_BUFFER_CHAR;
	mgn_current_buffer->mgn_ch_buf[mgn_n_chars + 1] = MGN_END_OF_BUFFER_CHAR;

	mgntext_ptr = &mgn_current_buffer->mgn_ch_buf[0];

	return ret_val;
	}


/* mgn_get_previous_state - get the state just before the EOB char was reached */

static mgn_state_type mgn_get_previous_state()
	{
	register mgn_state_type mgn_current_state;
	register char *mgn_cp;

	mgn_current_state = mgn_start;

	for ( mgn_cp = mgntext_ptr + MGN_MORE_ADJ; mgn_cp < mgn_c_buf_p; ++mgn_cp )
		{
		register MGN_CHAR mgn_c = (*mgn_cp ? mgn_ec[MGN_SC_TO_UI(*mgn_cp)] : 1);
		if ( mgn_accept[mgn_current_state] )
			{
			mgn_last_accepting_state = mgn_current_state;
			mgn_last_accepting_cpos = mgn_cp;
			}
		while ( mgn_chk[mgn_base[mgn_current_state] + mgn_c] != mgn_current_state )
			{
			mgn_current_state = (int) mgn_def[mgn_current_state];
			if ( mgn_current_state >= 125 )
				mgn_c = mgn_meta[(unsigned int) mgn_c];
			}
		mgn_current_state = mgn_nxt[mgn_base[mgn_current_state] + (unsigned int) mgn_c];
		}

	return mgn_current_state;
	}


/* mgn_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = mgn_try_NUL_trans( current_state );
 */

#ifdef MGN_USE_PROTOS
static mgn_state_type mgn_try_NUL_trans( mgn_state_type mgn_current_state )
#else
static mgn_state_type mgn_try_NUL_trans( mgn_current_state )
mgn_state_type mgn_current_state;
#endif
	{
	register int mgn_is_jam;
	register char *mgn_cp = mgn_c_buf_p;

	register MGN_CHAR mgn_c = 1;
	if ( mgn_accept[mgn_current_state] )
		{
		mgn_last_accepting_state = mgn_current_state;
		mgn_last_accepting_cpos = mgn_cp;
		}
	while ( mgn_chk[mgn_base[mgn_current_state] + mgn_c] != mgn_current_state )
		{
		mgn_current_state = (int) mgn_def[mgn_current_state];
		if ( mgn_current_state >= 125 )
			mgn_c = mgn_meta[(unsigned int) mgn_c];
		}
	mgn_current_state = mgn_nxt[mgn_base[mgn_current_state] + (unsigned int) mgn_c];
	mgn_is_jam = (mgn_current_state == 124);

	return mgn_is_jam ? 0 : mgn_current_state;
	}


#ifndef MGN_NO_UNPUT
#ifdef MGN_USE_PROTOS
static void mgnunput( int c, register char *mgn_bp )
#else
static void mgnunput( c, mgn_bp )
int c;
register char *mgn_bp;
#endif
	{
	register char *mgn_cp = mgn_c_buf_p;

	/* undo effects of setting up mgntext */
	*mgn_cp = mgn_hold_char;

	if ( mgn_cp < mgn_current_buffer->mgn_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = mgn_n_chars + 2;
		register char *dest = &mgn_current_buffer->mgn_ch_buf[
					mgn_current_buffer->mgn_buf_size + 2];
		register char *source =
				&mgn_current_buffer->mgn_ch_buf[number_to_move];

		while ( source > mgn_current_buffer->mgn_ch_buf )
			*--dest = *--source;

		mgn_cp += (int) (dest - source);
		mgn_bp += (int) (dest - source);
		mgn_current_buffer->mgn_n_chars =
			mgn_n_chars = mgn_current_buffer->mgn_buf_size;

		if ( mgn_cp < mgn_current_buffer->mgn_ch_buf + 2 )
			MGN_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--mgn_cp = (char) c;


	mgntext_ptr = mgn_bp;
	mgn_hold_char = *mgn_cp;
	mgn_c_buf_p = mgn_cp;
	}
#endif	/* ifndef MGN_NO_UNPUT */


#ifndef MGN_NO_INPUT
#ifdef __cplusplus
static int mgninput()
#else
static int input()
#endif
	{
	int c;

	*mgn_c_buf_p = mgn_hold_char;

	if ( *mgn_c_buf_p == MGN_END_OF_BUFFER_CHAR )
		{
		/* mgn_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( mgn_c_buf_p < &mgn_current_buffer->mgn_ch_buf[mgn_n_chars] )
			/* This was really a NUL. */
			*mgn_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = mgn_c_buf_p - mgntext_ptr;
			++mgn_c_buf_p;

			switch ( mgn_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because mgn_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					mgnrestart( mgnin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( mgnwrap() )
						return EOF;

					if ( ! mgn_did_buffer_switch_on_eof )
						MGN_NEW_FILE;
#ifdef __cplusplus
					return mgninput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					mgn_c_buf_p = mgntext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) mgn_c_buf_p;	/* cast for 8-bit char's */
	*mgn_c_buf_p = '\0';	/* preserve mgntext */
	mgn_hold_char = *++mgn_c_buf_p;


	return c;
	}
#endif /* MGN_NO_INPUT */

#ifdef MGN_USE_PROTOS
void mgnrestart( FILE *input_file )
#else
void mgnrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! mgn_current_buffer )
		mgn_current_buffer = mgn_create_buffer( mgnin, MGN_BUF_SIZE );

	mgn_init_buffer( mgn_current_buffer, input_file );
	mgn_load_buffer_state();
	}


#ifdef MGN_USE_PROTOS
void mgn_switch_to_buffer( MGN_BUFFER_STATE new_buffer )
#else
void mgn_switch_to_buffer( new_buffer )
MGN_BUFFER_STATE new_buffer;
#endif
	{
	if ( mgn_current_buffer == new_buffer )
		return;

	if ( mgn_current_buffer )
		{
		/* Flush out information for old buffer. */
		*mgn_c_buf_p = mgn_hold_char;
		mgn_current_buffer->mgn_buf_pos = mgn_c_buf_p;
		mgn_current_buffer->mgn_n_chars = mgn_n_chars;
		}

	mgn_current_buffer = new_buffer;
	mgn_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (mgnwrap()) processing, but the only time this flag
	 * is looked at is after mgnwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	mgn_did_buffer_switch_on_eof = 1;
	}


#ifdef MGN_USE_PROTOS
void mgn_load_buffer_state( void )
#else
void mgn_load_buffer_state()
#endif
	{
	mgn_n_chars = mgn_current_buffer->mgn_n_chars;
	mgntext_ptr = mgn_c_buf_p = mgn_current_buffer->mgn_buf_pos;
	mgnin = mgn_current_buffer->mgn_input_file;
	mgn_hold_char = *mgn_c_buf_p;
	}


#ifdef MGN_USE_PROTOS
MGN_BUFFER_STATE mgn_create_buffer( FILE *file, int size )
#else
MGN_BUFFER_STATE mgn_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	MGN_BUFFER_STATE b;

	b = (MGN_BUFFER_STATE) mgn_flex_alloc( sizeof( struct mgn_buffer_state ) );
	if ( ! b )
		MGN_FATAL_ERROR( "out of dynamic memory in mgn_create_buffer()" );

	b->mgn_buf_size = size;

	/* mgn_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->mgn_ch_buf = (char *) mgn_flex_alloc( b->mgn_buf_size + 2 );
	if ( ! b->mgn_ch_buf )
		MGN_FATAL_ERROR( "out of dynamic memory in mgn_create_buffer()" );

	b->mgn_is_our_buffer = 1;

	mgn_init_buffer( b, file );

	return b;
	}


#ifdef MGN_USE_PROTOS
void mgn_delete_buffer( MGN_BUFFER_STATE b )
#else
void mgn_delete_buffer( b )
MGN_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == mgn_current_buffer )
		mgn_current_buffer = (MGN_BUFFER_STATE) 0;

	if ( b->mgn_is_our_buffer )
		mgn_flex_free( (void *) b->mgn_ch_buf );

	mgn_flex_free( (void *) b );
	}



#ifdef MGN_USE_PROTOS
void mgn_init_buffer( MGN_BUFFER_STATE b, FILE *file )
#else
void mgn_init_buffer( b, file )
MGN_BUFFER_STATE b;
FILE *file;
#endif


	{
	mgn_flush_buffer( b );

	b->mgn_input_file = file;
	b->mgn_fill_buffer = 1;

#if MGN_ALWAYS_INTERACTIVE
	b->mgn_is_interactive = 1;
#else
#if MGN_NEVER_INTERACTIVE
	b->mgn_is_interactive = 0;
#else
	b->mgn_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef MGN_USE_PROTOS
void mgn_flush_buffer( MGN_BUFFER_STATE b )
#else
void mgn_flush_buffer( b )
MGN_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->mgn_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->mgn_ch_buf[0] = MGN_END_OF_BUFFER_CHAR;
	b->mgn_ch_buf[1] = MGN_END_OF_BUFFER_CHAR;

	b->mgn_buf_pos = &b->mgn_ch_buf[0];

	b->mgn_at_bol = 1;
	b->mgn_buffer_status = MGN_BUFFER_NEW;

	if ( b == mgn_current_buffer )
		mgn_load_buffer_state();
	}


#ifndef MGN_NO_SCAN_BUFFER
#ifdef MGN_USE_PROTOS
MGN_BUFFER_STATE mgn_scan_buffer( char *base, mgn_size_t size )
#else
MGN_BUFFER_STATE mgn_scan_buffer( base, size )
char *base;
mgn_size_t size;
#endif
	{
	MGN_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != MGN_END_OF_BUFFER_CHAR ||
	     base[size-1] != MGN_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (MGN_BUFFER_STATE) mgn_flex_alloc( sizeof( struct mgn_buffer_state ) );
	if ( ! b )
		MGN_FATAL_ERROR( "out of dynamic memory in mgn_scan_buffer()" );

	b->mgn_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->mgn_buf_pos = b->mgn_ch_buf = base;
	b->mgn_is_our_buffer = 0;
	b->mgn_input_file = 0;
	b->mgn_n_chars = b->mgn_buf_size;
	b->mgn_is_interactive = 0;
	b->mgn_at_bol = 1;
	b->mgn_fill_buffer = 0;
	b->mgn_buffer_status = MGN_BUFFER_NEW;

	mgn_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef MGN_NO_SCAN_STRING
#ifdef MGN_USE_PROTOS
MGN_BUFFER_STATE mgn_scan_string( mgnconst char *mgn_str )
#else
MGN_BUFFER_STATE mgn_scan_string( mgn_str )
mgnconst char *mgn_str;
#endif
	{
	int len;
	for ( len = 0; mgn_str[len]; ++len )
		;

	return mgn_scan_bytes( mgn_str, len );
	}
#endif


#ifndef MGN_NO_SCAN_BYTES
#ifdef MGN_USE_PROTOS
MGN_BUFFER_STATE mgn_scan_bytes( mgnconst char *bytes, int len )
#else
MGN_BUFFER_STATE mgn_scan_bytes( bytes, len )
mgnconst char *bytes;
int len;
#endif
	{
	MGN_BUFFER_STATE b;
	char *buf;
	mgn_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) mgn_flex_alloc( n );
	if ( ! buf )
		MGN_FATAL_ERROR( "out of dynamic memory in mgn_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = MGN_END_OF_BUFFER_CHAR;

	b = mgn_scan_buffer( buf, n );
	if ( ! b )
		MGN_FATAL_ERROR( "bad buffer in mgn_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->mgn_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef MGN_NO_PUSH_STATE
#ifdef MGN_USE_PROTOS
static void mgn_push_state( int new_state )
#else
static void mgn_push_state( new_state )
int new_state;
#endif
	{
	if ( mgn_start_stack_ptr >= mgn_start_stack_depth )
		{
		mgn_size_t new_size;

		mgn_start_stack_depth += MGN_START_STACK_INCR;
		new_size = mgn_start_stack_depth * sizeof( int );

		if ( ! mgn_start_stack )
			mgn_start_stack = (int *) mgn_flex_alloc( new_size );

		else
			mgn_start_stack = (int *) mgn_flex_realloc(
					(void *) mgn_start_stack, new_size );

		if ( ! mgn_start_stack )
			MGN_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	mgn_start_stack[mgn_start_stack_ptr++] = MGN_START;

	BEGIN(new_state);
	}
#endif


#ifndef MGN_NO_POP_STATE
static void mgn_pop_state()
	{
	if ( --mgn_start_stack_ptr < 0 )
		MGN_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(mgn_start_stack[mgn_start_stack_ptr]);
	}
#endif


#ifndef MGN_NO_TOP_STATE
static int mgn_top_state()
	{
	return mgn_start_stack[mgn_start_stack_ptr - 1];
	}
#endif

#ifndef MGN_EXIT_FAILURE
#define MGN_EXIT_FAILURE 2
#endif

#ifdef MGN_USE_PROTOS
static void mgn_fatal_error( mgnconst char msg[] )
#else
static void mgn_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( MGN_EXIT_FAILURE );
	}



/* Redefine mgnless() so it works in section 3 code. */

#undef mgnless
#define mgnless(n) \
	do \
		{ \
		/* Undo effects of setting up mgntext. */ \
		mgntext[mgnleng] = mgn_hold_char; \
		mgn_c_buf_p = mgntext + n; \
		mgn_hold_char = *mgn_c_buf_p; \
		*mgn_c_buf_p = '\0'; \
		mgnleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef mgntext_ptr
#ifdef MGN_USE_PROTOS
static void mgn_flex_strncpy( char *s1, mgnconst char *s2, int n )
#else
static void mgn_flex_strncpy( s1, s2, n )
char *s1;
mgnconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef MGN_NEED_STRLEN
#ifdef MGN_USE_PROTOS
static int mgn_flex_strlen( mgnconst char *s )
#else
static int mgn_flex_strlen( s )
mgnconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef MGN_USE_PROTOS
static void *mgn_flex_alloc( mgn_size_t size )
#else
static void *mgn_flex_alloc( size )
mgn_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef MGN_USE_PROTOS
static void *mgn_flex_realloc( void *ptr, mgn_size_t size )
#else
static void *mgn_flex_realloc( ptr, size )
void *ptr;
mgn_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef MGN_USE_PROTOS
static void mgn_flex_free( void *ptr )
#else
static void mgn_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if MGN_MAIN
int main()
	{
	mgnlex();
	return 0;
	}
#endif
#line 123 "../../../src/mbkmg/src/mg2mbk_l.l"


int mgnwrap()
{
	return 1;
}

static void zweep(find_it)
char find_it;
{
char c;

	while (1) {
		if ((c = input()) == 0) {
			(void)fprintf(stderr, "reached EOF before expected end line %d\n",
								mgnlineno);
			exit(12);
		}
		/* special case for comments */
		if (c == '*')
			if (find_it == '/')
				if ((c = input()) == 0) {
					(void)fprintf(stderr,
										"reached EOF before expected end of comment\n");
					exit(12);
				}
		if (c == find_it)
			return;
	}
}

int mgnerror(s)
char *s;
{
	fflush(stdout);
	fprintf(stderr, "modgen parser : syntax error line %d on %s file %s\n",
				mgnlineno, mgntext, filenameforlex());
	exit(13);
}
