/* $Id: wmbutton.h,v 1.3 2000/01/24 22:18:17 komatsu Exp $ */

#ifndef __WM_BUTTON_H__
#define __WM_BUTTON_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtk/gtkbutton.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define WM_BUTTON(obj)          GTK_CHECK_CAST (obj, wm_button_get_type (), WmButton)
#define WM_BUTTON_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, wm_button_get_type (), WmButtonClass)
#define IS_WM_BUTTON(obj)       GTK_CHECK_TYPE (obj, wm_button_get_type ())

typedef struct _WmButton        WmButton;
typedef struct _WmButtonClass   WmButtonClass;

struct _WmButton
{
    GtkButton button;
};

struct _WmButtonClass
{
    GtkButtonClass parent_class;

    void (* press1)   (WmButton *button);
    void (* press2)   (WmButton *button);
    void (* press3)   (WmButton *button);
    void (* double1)  (WmButton *button);
    void (* double2)  (WmButton *button);
    void (* double3)  (WmButton *button);
    void (* drag1)    (WmButton *button);
    void (* drag2)    (WmButton *button);
    void (* drag3)    (WmButton *button);
    void (* release1) (WmButton *button);
    void (* release2) (WmButton *button);
    void (* release3) (WmButton *button);
};

guint      wm_button_get_type (void);
GtkWidget* wm_button_new(void);
GtkWidget* wm_button_new_default(GtkWidget* client);
void wm_button_connect_event(GtkWidget *button, gpointer data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __WM_BUTTON_H__ */
