/* $Id: wmmotif.c,v 1.1 2000/02/09 04:26:17 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <gdk/gdk.h>

#include "wmmain.h"
#include "wmmotif.h"

#ifndef NEED_MOTIF_WM_HINTS

void wm_motif_init(void) { /* empty */ }

int wm_motif_prop_get_MWMHints(WmClient *client) { return 0; }

#else /* NEED_MOTIF_WM_HINTS */

static GdkAtom wm_atom_motif_wm_hints;

void wm_motif_init(void)
{
    wm_atom_motif_wm_hints = gdk_atom_intern("_MOTIF_WM_HINTS", FALSE);
}

int wm_motif_prop_get_MWMHints(WmClient *client)
{
    Window window = client->client;
    Atom actual_type;
    int actual_format;
    unsigned long nitems, bytesafter;
    MWMHints *hints;
    int return_value = 0;

    wm_message("WmClient[%x]: mwm_hints\n", window);

    /*
     *  XXX: XGetWindowProperty() Τ褤åѡо줷֤.
     *       gdk_property_get() ϻȤʤۤɤ餷.
     */
    if(XGetWindowProperty(GDK_DISPLAY(), window, wm_atom_motif_wm_hints,
			  0L, 20L, False, wm_atom_motif_wm_hints,
			  &actual_type, &actual_format, &nitems, &bytesafter,
			  (unsigned char **) &hints) != Success || !hints) {
	return 0;
    }

    if(hints->flags & MWM_HINTS_FUNCTIONS) {
	int func = hints->functions;
	if(func & MWM_FUNC_ALL)      wm_message("MWM_FUNC_ALL\n");
	if(func & MWM_FUNC_RESIZE)   wm_message("MWM_FUNC_RESIZE\n");
	if(func & MWM_FUNC_MOVE)     wm_message("MWM_FUNC_MOVE\n");
	if(func & MWM_FUNC_MINIMIZE) wm_message("MWM_FUNC_MINIMIZE\n");
	if(func & MWM_FUNC_MAXIMIZE) wm_message("MWM_FUNC_MAXIMIZE\n");
	if(func & MWM_FUNC_CLOSE)    wm_message("MWM_FUNC_CLOSE\n");
    }
    if(hints->flags & MWM_HINTS_DECORATIONS) {
	int decor = hints->decorations;
	wm_message("MWM_DECOR\n");
	if(decor & MWM_DECOR_ALL)      wm_message("MWM_DECOR_ALL\n");
	if(decor & MWM_DECOR_BORDER)   wm_message("MWM_DECOR_BORDER\n");
	if(decor & MWM_DECOR_RESIZEH)  wm_message("MWM_DECOR_RESIZEH\n");
	if(decor & MWM_DECOR_TITLE)    wm_message("MWM_DECOR_TITLE\n");
	if(decor & MWM_DECOR_MENU)     wm_message("MWM_DECOR_MENU\n");
	if(decor & MWM_DECOR_MINIMIZE) wm_message("MWM_DECOR_MINIMIZE\n");
	if(decor & MWM_DECOR_MAXIMIZE) wm_message("MWM_DECOR_MAXIMIZE\n");
	if((decor & MWM_DECOR_ALL && !(decor & MWM_DECOR_BORDER))
	   || (!(decor & MWM_DECOR_ALL) && decor & MWM_DECOR_BORDER)) {
	    return_value = 0;
	} else {
	    return_value = 1;
	}
    }

    XFree(hints);
    return return_value;
}

#endif /* NEED_MOTIF_WM_HINTS */
