# $Id: INOC.pm,v 1.1 2002/07/29 01:01:19 bengen Exp $

#
# Module for INOC Antivirus
#

package AMAVIS::AV::INOC;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_inoc_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'INOC Anti Virus';
  $cfg_inoc_binary = $AMAVIS::cfg->val('INOC', 'inocucmd');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_inoc_binary eq '') {
    writelog($args,LOG_CRIT, "Path to INOC not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_inoc_binary) {
    writelog($args,LOG_CRIT, "INOC not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan {
  my $self = shift;
  my $args = shift;

  my @output;
  my @command = ($cfg_inoc_binary, 
		 '-sec',
		 '-nex',
		 "$$args{directory}/parts");

  writelog($args,LOG_DEBUG,"Scanning with INOC");
  writelog($args,LOG_DEBUG,
	   'Output from '.join(' ',@command));
  my $output_handle = cmd_pipe($args, @command);
  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_inoc_binary\n");
  wait;
  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    if ($errval == 100) {
      my %uniq;
      foreach my $output (@output) {
	if ( $output =~ /.*: (.+) FOUND/g ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'INOC Anti Virus'}}, $1;
	  }
	}
      }
    } else {
      writelog($args,LOG_ERR,__PACKAGE__.
	       "Virus scanner failure: $cfg_inoc_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }
  # Return successfully
  return 1;
}

1;
