# $Id: NVC.pm,v 1.3 2002/07/02 12:59:21 bengen Exp $

#
# Module for Norman Virus Control
#

package AMAVIS::AV::NVC;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_nvc_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'Norman Virus Control';
  $cfg_nvc_binary = $AMAVIS::cfg->val('NVC', 'nvc');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_nvc_binary eq '') {
    writelog($args,LOG_CRIT, "Path to NVC not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_nvc_binary) {
    writelog($args,LOG_CRIT, "NVC not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my @output;

  writelog($args,LOG_DEBUG,"Scanning with NVC");
  writelog($args,LOG_DEBUG,
	   "Output from $cfg_nvc_binary -u $$args{directory}/parts");
  my $output_handle = cmd_pipe($args, $cfg_nvc_binary,
			       '-u',
			       "$$args{directory}/parts");
  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_nvc_binary\n");
  wait;

  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    if ($errval ==1) {
      my %uniq;
      foreach my $output (@output) {
	if ( $output =~ /-> \'(.*)\'/g ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'Norman Virus Control'}}, $1;
	  }
	}
      }
    }
    else {
      writelog($args,LOG_ERR,"Virus scanner failure: $cfg_nvc_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }
  # Return successfully...
  return 1;
}

1;
