# $Id: OpenAntiVirus.pm,v 1.2 2002/07/14 17:22:58 bengen Exp $

#
# Example code for virus scanners
#

package AMAVIS::AV::OpenAntiVirus;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use IO::Socket;

use vars qw(
	    $cfg_oav_socket
	    $socket
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'OpenAntiVirus ScannerDaemon';
  $cfg_oav_socket = $AMAVIS::cfg->val('OpenAntiVirus', 'socket');
  if ($cfg_oav_socket eq '') {
    writelog($args,LOG_CRIT, "Socket for OpenAntiVirus not defined");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my $output;

  $socket = IO::Socket::INET->new($cfg_oav_socket);
  unless (defined $socket) {
    writelog($args,LOG_ERR, __PACKAGE__.
	     ": Could not connect to ScannerDaemon: $!");
    return 0;
  }

  writelog($args,LOG_DEBUG,"Scanning with OpenAntiVirus");
  $socket->print("SCAN $$args{'directory'}/parts\n");
  $socket->flush;
  $output=$socket->getline();
  $socket->close;
  if ($output =~ /^FOUND: /) {
    my @virusname = ($output =~ /FOUND: (.+)/g);
    @virusname = (undef) if !@virusname;  # just in case: make list nonnil
    push @{$$args{'found_viruses'}{'OpenAntiVirus ScannerDaemon'}}, @virusname;
  }
  elsif ($output =~ /^OK/) {		# no errors, no viruses
    writelog($args,LOG_DEBUG,__PACKAGE__.
	     ": ScannerDaemon return code: OK");
  }
  elsif ($output =~ /^ERROR/) {
    writelog($args,LOG_ERR,__PACKAGE__.
	     ": Virus scanner failure: ScannerDaemon - UNKNOWN STATUS (error code: $output)");
    return 0;
  }
  # Return successfully...
  return 1;
}

1;
