# $Id: TNEF.pm,v 1.8 2003/03/11 13:19:34 bengen Exp $

#
# Module for unpacking TNEF data (winmail.dat generated by MS Outlook
# -- but not Outlook Express)
#

package AMAVIS::Extract::TNEF;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use Convert::TNEF;

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $$types{'application/ms-tnef'}=$self;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}

sub extract( $ ) {
  my $self = shift;
  my $args = shift;
  my $filename = shift;
  my $unpacked_size = 0;

  writelog($args,LOG_DEBUG, 
	   "Attempting to unpack $filename as TNEF attachment");

  my $tnef = eval {Convert::TNEF->read_in("$$args{'directory'}/parts/$filename",
					  {ignore_checksum=>"true",
					   output_dir=>$$args{'directory'}})};

  my $counter=0;
  if ($tnef) {
    for my $attachment ($tnef->attachments) {
      ++$counter;
      if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
	return 0;
      }
      writelog($args,LOG_DEBUG,"TNEF Attachment # $counter");

      my $securename=get_secure_filename($args);
      my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
				   .$securename);

      unless ($out_handle) {
	writelog($args,LOG_ERR, __PACKAGE__.'Error writing file');
	next;
      }
      # FIXME: Possible OOM DoS?
      $unpacked_size += length($attachment->data());
      if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
	$out_handle->close();
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
	return 0;
      }
      $out_handle->print($attachment->data());
      $out_handle->close();
      $ {$$args{'contents'}}{$securename} =
	{'original_filename' => $attachment->name()};
      $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
    }
    $tnef->purge();
  }
  else {
    writelog($args,LOG_ERR, $Convert::TNEF::errstr);
    return 0;
  }
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
