# $Id: Magic.pm,v 1.2 2002/06/28 09:24:10 bengen Exp $

#
# Helper class to File::MMagic.
# Does nothing but add a function 'read_magic_file' which forces the
# class to read in the whole magic file.
#

package AMAVIS::Magic;

use File::MMagic '1.15';
use strict;

use vars qw( @ISA );

@ISA=qw(File::MMagic);

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = $class->SUPER::new(@_);
  bless ($self, $class);          # reconsecrate
  return $self;
}

sub read_magic_file {
  my $self = shift @_;
  # read the whole file if we haven't already
  while (!$self->{MF}->[0]->eof()) {
    File::MMagic::readMagicEntry($self->{magic}, $self->{MF});
  }
}

1;
