# $Id: NAI.pm,v 1.8 2003/03/31 06:39:12 bengen Exp $

#
# McAfee / Network Associates
#

package AMAVIS::AV::NAI;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_uvscan_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;

  push @{$$args{'virus_scanners'}}, 'NAI VirusScan';
  $cfg_uvscan_binary = $AMAVIS::cfg->val('NAI', 'uvscan');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_uvscan_binary eq '') {
    writelog($args,LOG_CRIT, "Path to uvscan not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_uvscan_binary) {
    writelog($args,LOG_CRIT, "uvscan not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

sub scan {
  my $self = shift;
  my $args = shift;

  my @output;
  my @command=($cfg_uvscan_binary,
	       '--allole',
	       '--analyze',
	       '--noboot',
	       '--summary',
	       '--ignore-compressed',
	       "$$args{directory}/parts");

  writelog($args,LOG_DEBUG,"Scanning with NAI VirusScan");
  my $output_handle = cmd_pipe($args, @command)
    or do {
      writelog($args,LOG_ERR, __PACKAGE__.": Error running program - $!");
      return 0;
    };
  writelog($args,LOG_DEBUG,
	   'Output from '.join(' ',@command));
  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    push @output, $_;
  }
  $output_handle->close() or do {
    if ($!) {
      writelog($args,LOG_ERR, __PACKAGE__.
	       ": Error closing program - $!");
      return 0;
    }
  };
  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,__PACKAGE__.": Return code $errval");
  if ($errval != 0) {
    if ($errval == 13) {
      my %uniq;
      foreach my $output (@output) {
	
	$output =~ s/Found: (.+) NOT a/Found the $1/g;
	$output =~ s/Found the (.+) trojan/Found the $1 virus/g;
	$output =~ s/Found virus or variant (.+) /Found the $1 virus/g;
	$output =~ s/Found trojan or variant (.+) /Found the $1 virus/g;

	if ( $output =~ /Found the (.+) virus/g ) {
	  writelog($args,LOG_DEBUG,$output);
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'NAI VirusScan'}}, $1;
	  }
	}
      }
    }
    else {
      writelog($args,LOG_ERR, __PACKAGE__.
	       ": uvscan returned an error: $errval");
      return 0;
    }
  }
  return 1;
}

1;
