# $Id: RAV.pm,v 1.3 2002/07/29 01:01:19 bengen Exp $

#
# Module for RAV Antivirus
#

package AMAVIS::AV::RAV;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_rav_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'RAV Anti Virus';
  $cfg_rav_binary = $AMAVIS::cfg->val('RAV', 'ravav');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_rav_binary eq '') {
    writelog($args,LOG_CRIT, "Path to RAV not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_rav_binary) {
    writelog($args,LOG_CRIT, "RAV not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan {
  my $self = shift;
  my $args = shift;

  my @output;
  my @command = ($cfg_rav_binary, 
		 '--all',
		 '--smart',
		 '--heuristics=on',
		 '--integrity_check=on',
		 "$$args{directory}/parts");

  writelog($args,LOG_DEBUG,"Scanning with RAV");
  writelog($args,LOG_DEBUG,
	   'Output from '.join(' ',@command));
  my $output_handle = cmd_pipe($args, @command);
  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_rav_binary\n");
  wait;
  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");

  # List of Return Codes (from ravav(8)
  # 1      The file is clean.
  # 2      Infected file.
  # 3      Suspicious file.
  # 4      The file was cleaned.
  # 5      Clean failed.
  # 6      The file was deleted.
  # 7      Delete failed.
  # 8      The file was successfully copied to quarantine.
  # 9      Copy failed.
  # 10     The file was successfully moved to quarantine.
  # 11     Move failed.
  # 12     The file was renamed.
  # 13     Rename failed.
  # 20     No TARGET is defined.
  # 30     Engine error.
  # 31     Syntax error.
  # 32     Help message.
  # 33     Viruses list.
  # 34     The updating process was successfully completed.
  # 35     The updating process failed.
  # 36     Already updated.
  # 37     The licensing process was successfully completed.
  # 38     The licensing process failed.

  if ($errval != 0) {
    if ($errval == 2 || $errval == 3) {
      my %uniq;
      foreach my $output (@output) {
	if ( $output =~ /.*: (.+) FOUND/g ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'RAV Anti Virus'}}, $1;
	  }
	}
      }
    } else {
      writelog($args,LOG_ERR,__PACKAGE__.
	       ": Virus scanner failure: $cfg_rav_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }
  # Return successfully
  return 1;
}

1;
