# $Id: Tar.pm,v 1.12 2003/03/01 15:21:00 bengen Exp $

# Module from extracting from a tape archive

package AMAVIS::Extract::Tar;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use Archive::Tar;

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $$types{'application/x-tar'}=$self;
  $$types{'application/x-gtar'}=$self;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}

sub extract( $ ) {
  my $self = shift;
  my $args = shift;
  my $filename = shift;
  my $unpacked_size = 0;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as TAR file");

  my $tar = eval { Archive::Tar->new("$$args{'directory'}/parts/$filename") };
  unless (defined $tar) {
    writelog($args,LOG_ERR, __PACKAGE__.": Corrupt tar file.");
    return 0;
  }

  my @list = $tar->list_files();

  foreach (@list) {
    unless (/.*\/$/) {		# Ignore directories
      if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
	return 0;
      }
      my $data = $tar->get_content($_);
      my $securename=get_secure_filename($args);
      my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
				   .$securename);
      $unpacked_size+=length($data);
      if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
	$out_handle->close();
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
	return 0;
      }
      $out_handle->print($data);
      $out_handle->close();
      $ {$$args{'contents'}}{$securename} = {};
      $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
    }
  }
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
