# $Id: Admin.pm,v 1.21 2003/03/05 20:21:18 bengen Exp $

package AMAVIS::Notify::Admin;
use strict;
use vars qw($VERSION);
$VERSION='0.1';
use POSIX qw(strftime setlocale LC_TIME);

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_sender
	    @cfg_admin
	   );

sub init {
  my $self = shift;
  my $args = shift;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  $cfg_sender = $AMAVIS::cfg->val('Notify', 'mail from');
  $cfg_sender = 'postmaster' unless defined($cfg_sender);
  @cfg_admin = split / *, */, $AMAVIS::cfg->val('Notify', 'admin');
  @cfg_admin = ('postmaster') unless ($#cfg_admin>=0);
  # Return successfully
  return 1;
}

sub notify {
  my $self = shift;
  my $args = shift;
  # FIXME
  my $recipients = join(', ',@cfg_admin);
  setlocale(LC_TIME, 'C');
  my $date = strftime("%a, %d %b %Y %H:%M:%S %z",localtime);
  setlocale(LC_TIME, '');

  my $orig_sender = $$args{'sender'};
  if ($orig_sender eq '') {
    $orig_sender = '(empty address)';
  }

  writelog($args,LOG_DEBUG, __PACKAGE__.
	   ': Warning admin(s): '.$recipients.'.');

  my $message = <<"EOF";
From: $cfg_sender
To: $recipients
Date: $date
Subject: Found virus in mail from $orig_sender.

The virus checker has found potentially malicious code in a mail by
$orig_sender. Delivery has been stopped.

The recipient(s) for this message were:

EOF

  $message.=join "\n",@{$$args{'recipients'}};

  if (defined $$args{'quarantine_file'}) {
    $message.= << "EOF";


The message has been quarantined as
$$args{'quarantine_file'}.msg.

The corresponding logfile has been written to
$$args{'quarantine_file'}.log.
EOF
  };
  foreach my $scanner (@{$$args{'virus_scanners'}}) {
    $message.="\n$scanner found:\n";
    foreach my $virus (@{$$args{'found_viruses'}{$scanner}}) {
      $message.=" $virus\n";
    }
  }
  
  $message.="\n".('-'x 72)."\nMessage headers follow:\n";
  $message.=$$args{'headers'};
  
  $AMAVIS::mta->send_message($args, $message, '<>', @cfg_admin)
    or writelog($args,LOG_ERR,"Error notifying admin(s) $recipients");

  return 1;
}

sub notify_unpack {
  return 1;
}

1;
