# $Id: RAR.pm,v 1.11 2003/10/06 13:42:01 bengen Exp $

#
# Module for extracting RAR files
#

package AMAVIS::Extract::RAR;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_unrar_binary
	   );

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $cfg_unrar_binary=($AMAVIS::cfg->val('external', 'unrar') ||
		     '/usr/bin/unrar');
  if (! -x  $cfg_unrar_binary) {
    writelog($args,LOG_CRIT, __PACKAGE__.
	     ": unrar binary ($cfg_unrar_binary) not executable");
    return 0;
  }
  $$types{'application/x-rar'}=$self;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}

sub extract {
  my $self = shift;
  my $args = shift;
  my $filename = shift;

  my $buffer;
  my $len;
  my $unpacked_size = 0;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as RAR file");

  my @list;

  # Get listing
  my $output_handle = cmd_pipe($args, $cfg_unrar_binary, 'v',
			       "$$args{'directory'}/parts/$filename");
  while(<$output_handle>) {
    last if /^------.*/;
  }
  while(<$output_handle>) {
    next if /^    .*/;
    last if /^------.*/;
    chop;
    # Ignore directories
    next if (/.*\/$/);
    s/^ //;
    push(@list, $_);
  }
  wait;

  foreach (@list) {
    # Push every file through a pipe.
    if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
      writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
      return 0;
    }
    my $in_handle=cmd_pipe($args, $cfg_unrar_binary,
			   'p', '-inul',
			   "$$args{'directory'}/parts/$filename",
			   $_);

    my $securename=get_secure_filename($args);
    my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
				 .$securename);
    while ($len=$in_handle->read($buffer, 4096)) {
      $out_handle->write($buffer, $len);
      $unpacked_size += $len;
      if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
	$in_handle->close();
	$out_handle->close();
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
	return 0;
      }
    }
    $out_handle->close();
    $ {$$args{'contents'}}{$securename} = {'original_filename' => $_};
    $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
  }
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
