<?xml version="1.0" encoding="iso-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
       "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
  <title>Amaya - Guide utilisateur</title>
  <style type="text/css">

.xml {color: #E50000}
.exercice {color: #A9B200}
h1 {color: #FFFFFF; background-color: #7995B6; padding: 5px 1px}
address {margin-bottom: 30px}
body {background-color: #F9F7F4; color: #666666; font-family: helvetica; }
.author {font-style: italic; font-weight: bold}
.head {margin: 1em 0 3em 0}
h1 {font-size: 24pt}
body {padding-left: 2em}</style>
  <meta name="generator" content="amaya 9.3, see http://www.w3.org/Amaya/" />
</head>

<body xml:lang="fr">

<div class="head">
<h1 id="Amaya">Amaya - Guide utilisateur</h1>

<p class="head"><span class="author">Irne Vatton</span> <br />
Dernire mise  jour: <!--$date=-->2006-04-18<!--$-->
</p>
</div>

<p>Ce document a pour but d'aider les nouveaux utilisateurs d'Amaya. Pour
plus de dtail sur l'interface, il faut se reporter au <a
href="Manual.html.fr">manuel de rfrence</a>.</p>

<div>
<h3>Plan</h3>
<ol>
  <li><a href="#L85">Introduction</a>
    <ul>
      <li>Pourquoi un diteur structur pour HTML ?</li>
      <li>Pourquoi des familles HTML ?</li>
      <li>Les familles HTML</li>
      <li>Quelques rgles d'accessibilit  suivre</li>
    </ul>
  </li>
  <li><a href="#L271">Prsentation gnrale d'Amaya</a></li>
  <li><a href="#L483">Paramtrage de l'application</a></li>
  <li><a href="#L608">Cration/Edition d'une page Web</a></li>
  <li><a href="#L662">Cration du contenu (paragraphes, en-ttes de sections,
    divisions)</a></li>
  <li><a href="#L831">Le listes</a></li>
  <li><a href="#L1002">Les liens</a></li>
  <li><a href="#L11631">Mises en vidence du texte</a></li>
  <li><a href="#L12061">Les tables</a></li>
  <li><a href="#L12281">Recherche/Remplacement - Correction
  orthographique</a></li>
  <li><a href="#L1230">Attributs</a></li>
  <li><a href="#L1232">Cration de feuilles de style CSS</a></li>
  <li><a href="#L1242">Dtection des erreurs</a></li>
</ol>
</div>

<div>
<h2 id="L85">1. Introduction</h2>

<p>L'objectif du Web est de permettre l'change d'informations quelque soit
le support.</p>
<ul>
  <li>A opposer  l'approche Word :
    <p>En gnral la description d'un document Word se limite  la
    prsentation, essentiellement l'usage de fontes. Si le destinataire ne
    dispose pas des mmes fontes, le document peut tre illisible.</p>
  </li>
  <li>La solution prconise est d'utiliser un modle de description
    clairement dfini et ouvert. C'est ce que permet de faire HTML en
    dfinissant un modle de document Web standard.
    <p>Avec les CSS (Cascading Style Sheets) il y a mme sparation entre la
    structure + contenu et la prsentation.</p>
    <p></p>
  </li>
</ul>

<p>L'auteur d'un document Web doit distinguer ce qui est du ressort de la
structure (titres, paragraphes, listes, etc.) de ce qui n'est que de la
prsentation (taille de caractres, couleurs, etc.)</p>

<p>Un bon exercice : comprendre un document en lisant ses balises HTML et le
texte.</p>

<h3>Pourquoi un diteur structur pour HTML ?</h3>

<p>HTML dfinit une structure (organisation) de document.</p>
<ul>
  <li><strong>Elements</strong> : Dcoupage smantique du document mme si ce
    dcoupage a un effet sur la prsentation
    <p>Par exemple un H2 a un effet de prsentation mais donne aussi une
    information smantique. C'est un en-tte moins important qu'un H1 et plus
    important qu'un H3.</p>
    <p>De mme un lien (ancre + href) dfinit plus qu'un simple texte
    color/soulign.</p>
  </li>
  <li><strong>Attributs</strong> : Caractrisation smantique
    <p>L'attribut class="section" sur une division, la cible d'un lien
    href="http://www.w3.org/"</p>
  </li>
</ul>

<p>La dcoration des documents est confie  un langage de style CSS
(Cascading Style Sheets).</p>

<h3>Pourquoi des familles HTML ?</h3>

<p>Avant que le langage CSS ne soit finalis, HTML avait introduit des
lments et des attributs qui n'avaient pas de valeur smantique, mais
servaient  modifier la prsentation des documents. Par exemple
&lt;font&gt;...&lt;/font&gt; pour choisir une police de caractres
particulire. Avec le langage CSS, ces lments et attributs n'ont plus de
raison d'tre. La sous-famille de HTML 4.0 Strict limine les lments et
attributs HTML qui doivent tre remplac par des proprits CSS (center,
font, color, background).</p>

<p>La sous-famille de HTML 4.0 Frameset isole les lments et attributs qui
dcrivent le dcoupage en fentres (frames). Le W3C dcommande l'utilisation
des "frames" pour faire que les sites Web soient accessibles aux handicaps
(problmes de navigation et de contexte).</p>

<p>D'autres familles XHTML ont t introduites par:</p>
<ul>
  <li>Besoin de <strong>modularisation</strong> pour s'adapter  de nouveaux
    supports (PDA, tlphones, tlvision)</li>
  <li>Ncessit d'avoir des <strong>structures propres</strong> pour filtrer
    et transformer de faon automatique les documents
    <p>Exemple: extraire les titres et ne prsenter le texte qui suit qu'
    la demande</p>
  </li>
  <li>Autoriser la <strong>composition</strong> avec d'autres langages XML
    (RDF, MathML, SVG, SMIL, autres).</li>
</ul>

<h3>Les diffrences entre HTML et XHTML</h3>
<pre><span class="xml">&lt;?xml version="1.0" encoding="iso-8859-1"?&gt;</span>
<span class="xml">&lt;!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
      "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"&gt;</span>
<span style="color: #9969FF">&lt;!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
      "http://www.w3.org/TR/html4/loose.dtd"&gt;</span>
&lt;html <span class="xml">xmlns="http://www.w3.org/1999/xhtml"</span>&gt;
&lt;head&gt;
&lt;meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"<span style="color: #E50000" class="xml">/</span>&gt;
&lt;title&gt;Amaya - Guide utilisateur&lt;/title&gt;
&lt;/head&gt;
&lt;body <span class="xml">xml:lang="fr"</span>&gt;
&lt;h1 id=<span class="xml">"</span>Amaya<span class="xml">"</span>&gt;Amaya - Guide utilisateur<span class="xml">&lt;/h1&gt;</span>
&lt;h2&gt;Plan<span class="xml">&lt;/h2&gt;</span>
&lt;ol&gt;
&lt;li&gt;Introduction<span class="xml">&lt;/li&gt;</span>
&lt;li&gt;HTML<span class="xml">&lt;/li&gt;</span>
&lt;li&gt;Quelques rgles<span class="xml">&lt;/li&gt;</span>&lt;/ol&gt;
<span class="xml">&lt;/body&gt;</span>
<span class="xml">&lt;/html&gt;</span></pre>

<h3>Les familles HTML</h3>

<table border="1">
  <caption></caption>
  <tbody>
    <tr>
      <th>Famille</th>
      <th>Elments + attributs</th>
      <th>Strucutre</th>
    </tr>
    <tr>
      <td><p>HTML 4.0 Transitional</p>
      </td>
      <td>Tout sauf les frames</td>
      <td>Structure implicite</td>
    </tr>
    <tr>
      <td>HTML 4.0 Strict</td>
      <td>Sans lments de prsentation</td>
      <td>Structure implicite</td>
    </tr>
    <tr>
      <td>HTML 4.0 Frameset</td>
      <td>Les frames</td>
      <td>Structure implicite</td>
    </tr>
    <tr>
      <td>XHTML 1.0 Transitional</td>
      <td>Tout sauf les frames</td>
      <td>Structure bien forme</td>
    </tr>
    <tr>
      <td>XHTML 1.0 Strict</td>
      <td>Sans lments de prsentation</td>
      <td>Structure bien forme</td>
    </tr>
    <tr>
      <td>XHTML 1.0 Basic</td>
      <td>Adapt aux tlphones</td>
      <td>Structure bien forme</td>
    </tr>
    <tr>
      <td>XHTML 1.1</td>
      <td>XHTML 1.0 Strict + annotations Ruby</td>
      <td>Structure bien forme</td>
    </tr>
  </tbody>
</table>

<h3>Quelques rgles d'accessibilit  suivre</h3>

<p>Enonc de quelques rgles</p>
<ul>
  <li>Produire des documents valides</li>
  <li>Sparer structure et prsentation
    <p>Ne pas considrer que tout le monde dispose du mme cran que vous</p>
  </li>
  <li>Ne pas utiliser du JavaScript pour naviguer</li>
  <li>Ne pas utiliser les frames</li>
  <li>Fournir des textes alterns pour les images, les vidos, etc.</li>
</ul>
</div>

<div>
<h2 id="L271">2. Prsentation gnrale d'Amaya</h2>

<p>Amaya est  la fois navigateur et un diteur:</p>

<p><strong>Amaya</strong> est un diteur dot de capacits de navigation.
C'est  dire que pendant que l'utilisateur travaille sur les documents de son
site Web, il peut accder n'importe quel autre document Web de sites
extrieurs.</p>

<p>Lorsqu'il est utilis comme navigateur, Amaya se comporte comme beaucoup
d'autres navigateurs Web, except pour ce qui est d'activer les liens. Par
dfaut le simple clic est utilis pour poser la slection (dfinir le point
d'insertion de texte) et il faut effectuer un double-clic sur un lien pour
l'activer.</p>

<p></p>

<p>Fentre initiale:</p>

<p>Par dfaut, l'utilisateur voit la vue formate du document. C'est l'aspect
final du document tel qu'il est vu par un navigateur Web</p>

<p>La barre de menu :</p>
<ul>
  <li>Fichier: cration de documents, navigation, impression, fermeture.</li>
  <li>Edition: dition de base, recherche/remplacement, correction
    orthographique, paramtrage.</li>
  <li>XHTML : cration/remplacement d'lments (X)HTML.</li>
  <li>XML : cration d'lments XML.</li>
  <li>Liens : cration et destruction des liens.</li>
  <li>Vues : gestion des diffrentes vues du document.</li>
  <li>Style : gestion du style CSS.</li>
  <li>Annotations : cration, destruction d'annotations.</li>
  <li>Aide : donne accs au manuel en ligne.</li>
</ul>

<p>Les barres d'outils</p>

<p>Contient quelques boutons d'accs aux fonctions les plus utilises</p>
<ul>
  <li>Stop <img alt="(Stop)" src="../images/stop.gif" />: arrte le
    transfert d'information depuis un serveur Web</li>
  <li>Document prcdent <img alt="(Prcdent)" src="../images/Back.gif" />:
    retour au document prcdent (s'il y en a un)</li>
  <li>Document suivant <img alt="(Suivant)" src="../images/Forward.gif" />:
    retour au document suivant (s'il y en a un)</li>
  <li>Recharger<img alt="(Recharger)" src="../images/Reload.gif" /> :
    recharge le document (accs serveur)</li>
  <li>Page personnelle <img alt="(Home)" src="../images/home.gif" />:
    affiche la page de dmarrage</li>
  <li>Sauver <img alt="(Sauver)" src="../images/floppy.gif" />: sauver les
    modifications</li>
  <li>Imprimer <img alt="(Imprimer)" src="../images/Print.gif" />: imprime
    le document</li>
  <li>Rechercher/Remplacer <img alt="(Rechercher)" src="../images/find.gif"
    />: affiche un formulaire de recherche/remplacement de texte</li>
  <li>Mise en vidence <img alt="(Evidence)" src="../images/Em.gif" />:
    permet de crer/supprimer un lment "mise en vidence"
    (&lt;em&gt;...&lt;/em&gt;)</li>
  <li>Important <img alt="(Important)" src="../images/Strong.gif" />: permet
    de crer un lment "important" (&lt;strong&gt;...&lt;/strong&gt;)</li>
  <li>Fonte fixe <img alt="(Code)" src="../images/code.gif" />: permet de
    crer un lment "fonte fixe" (&lt;code&gt;...&lt;/code&gt;)</li>
  <li>Ajout d'une image <img alt="(Image)" src="../images/Image.gif" />:
    permet de crer un lment "image" (&lt;img/&gt;)</li>
  <li>Titre niveau 1<img alt="(H1)" src="../images/H1.gif" />: permet de
    crer un lment "titre niveau 1" (&lt;h1&gt;...&lt;/h1&gt;)</li>
  <li>Titre niveau 2 <img alt="(H2)" src="../images/H2.gif" />: permet de
    crer un lment "titre niveau 2" (&lt;h2&gt;...&lt;/h2&gt;)</li>
  <li>Titre niveau 3 <img alt="(H3)" src="../images/H3.gif" />: permet de
    crer un lment "titre niveau 3" (&lt;h3&gt;...&lt;/h3&gt;)</li>
  <li>Liste <img alt="(Liste)" src="../images/OList.gif" />: permet de crer
    un lment "liste  puces" (&lt;ul&gt;...&lt;/ul&gt;)</li>
  <li>Liste numrote <img alt="(Liste num)" src="../images/NumList.gif" />:
    permet de crer un lment "liste numrote"
  (&lt;ol&gt;...&lt;/ol&gt;)</li>
  <li>Liste de dfinitions <img alt="(Dfinitions)" src="../images/DL.gif"
    />: permet de crer un lment "liste de dfinition"
    (&lt;dl&gt;...&lt;/dl&gt;)</li>
  <li>Lien <img alt="(Lien)" src="../images/Link.gif" />: permet de crer un
    lment "titre niveau 1" (&lt;a href="..."&gt;...&lt;/a&gt;)</li>
  <li>Table <img alt="(Table)" src="../images/table.gif" />: permet de crer
    un lment "titre niveau 1" (&lt;table&gt;...&lt;/table&gt;)</li>
  <li>Maths <img alt="(Math)" src="../images/Math.gif" />: palette pour
    crer des formules</li>
  <li>Graphique <img alt="(SVG)" src="../images/Graph.gif" />: palette pour
    crer des graphiques vectoriels</li>
  <li>Bibliothque SVG <img alt="(Librairie)" src="../images/libsvg.gif" />:
    affiche la palette de graphiques prdfinis</li>
</ul>

<p>et une zone d'affichage de l'adresse du document.</p>
</div>

<div>
<h2 id="L483">3. Paramtrage de l'application</h2>

<p>Avant d'diter des documents Web avec Amaya, il est important de fixer un
certain nombre de paramtres. Pour cela il faut ouvrir au moins deux des dix
menus de prfrences disponibles dans <strong>diter/Prfrences</strong>.
Chaque menu prsente trois boutons d'action :</p>

<table border="0" cellspacing="5" cellpadding="5"
summary="action button chart">
  <tbody>
    <tr>
      <th>Appliquer</th>
      <td>Ce bouton valide et stocke les options affiches dans le menu.</td>
    </tr>
    <tr>
      <th>Dfauts</th>
      <td>Ce bouton rtablit, mais ne sauve pas, les valeurs par dfaut. Il
        faut utiliser le bouton Appliquer pour valider les options.</td>
    </tr>
    <tr>
      <th>Terminer</th>
      <td>Ce bouton ferme le menu.</td>
    </tr>
  </tbody>
</table>

<p>Voici les paramtres importants  rgler:</p>

<h4>Dans les prfrences gnrales</h4>
<ul>
  <li><strong>Page de dmarrage</strong>: Spcifie l'URI qu'Amaya chargera
    au dmarrage ou quand l'utilisateur pressera le bouton <img
    alt="(Page personelle)" src="../images/home.gif" /> (par exemple l'URI
    <code>http://www.w3.org</code>).</li>
  <li><strong><a id="Enable">Activer le coller ligne  ligne</a></strong>:
    Cette option concerne le coller depuis une autre application. Quand cette
    option est active, les lignes de l'application source sont conserves.
    Sinon les caractres fin de ligne sont remplacs par des espaces.</li>
  <li><strong>Produire des fichiers de sauvegarde</strong>: Si cette option
    est active Amaya va produire priodiquement un fichier de sauvegarde pour
    chaque document dit.</li>
  <li><strong>Montrer boutons</strong>: Contrle l'affichage de la barre de
    boutons pour tous les documents.</li>
  <li><strong>Montrer l'adresse</strong>: Contrle si Amaya affiche
    l'adresse des documents.</li>
  <li><strong>Montrer les cibles</strong>: Contrle si les cibles de liens
    sont visualises ou non. Montrer les cibles peut aider quand on veut
    crer de nouveaux liens. Cette option agit immdiatement sur tous les
    documents dits.<br />
  </li>
  <li><strong>Zoom caractres</strong>: Cette option vous permet de rduire
    ou d'augmenter les tailles des polices de caractres utilises. Cette
    option a un effet immdiat sur tous les documents dits. <br />
  </li>
  <li><strong>Langue du dialogue</strong>: Spcifie la langue utilise dans
    les menus et les messages. La langue par dfaut est l'anglais amricain
    (valeur en). D'autres langues sont possibles comme le franais (fr),
    l'italien (it), l'espagnol (es), et l'allemand (de).</li>
</ul>

<h4>Dans les prfrences de navigation</h4>
<ul>
  <li><strong>Charger les images</strong> : Contrle si les images doivent
    tre charges et affiches. Sinon, l'attribut ALT est visualis  la
    place de l'image. Cette option prend effet ds que le formulaire est
    valid. <br />
  </li>
  <li><strong>Charger les objets</strong> : Contrle si les objets doivent
    tre chargs et affichs. Sinon, le contenu de l'objet est visualis  la
    place de l'objet. Cette option prend effet ds que le formulaire est
    valid.</li>
  <li><strong>Montrer les images de fond</strong> : Contrle si les images en
    arrire plan doivent tre montres ou non. Cette option prend effet ds
    que le formulaire est valid.</li>
  <li><strong>Le double clic active les liens</strong> : Depuis la premire
    version d'Amaya, les utilisateurs ont besoin de double cliquer sur un
    lien pour l'activer. Cela permet de diffrencier l'dition d'un lien de
    son activation. Vous pouvez changer ce comportement en dsactivant cette
    option.<br />
  </li>
</ul>

<p><a href="Configure.html.fr">A voir pour plus de dtail</a></p>
</div>

<div>
<h2 id="L608">4. Cration/Edition d'une page Web</h2>

<p>L'entre <strong>Fichier/Nouveau</strong> permet de crer un nouveau
document d'un type donn. Amaya demande de spcifier l'URI ou le nom local du
document  crer (un nom par dfaut est gnr). Aprs confirmation, Amaya
ouvre un nouveau document vide.</p>

<p>L'entre <strong>Fichier/Ouvrir</strong> remplace le document affich.
Amaya utilise la mme entre de menu par le nouveau document slectionn.
Amaya utilise la mme entre de menu pour ouvrir un document local ou un
document d'un serveur Web.</p>

<p>L'entre <strong>Fichier/Ouvrir dans nouvelle fentre</strong> affiche le
nouveau document slectionn dans une nouvelle fentre.</p>

<p>Les entres du menu XHTML prsentent les lments que l'on peut insrer
dans le document affich, en fonction de la famille XHTML choisie. La manire
la plus simple de crer de nouveaux lments dans un document est de placer
le point d'insertion dans la position voulue et d'utiliser le menu</p>

<p><strong>Xhtml</strong>, ou les boutons correspondant aux lments les plus
communs (images, en-ttes, listes...). Ces boutons ou entres de menu crent
l'lment correspondant  la position courante. Si l'lment dsir ne peut
pas tre cr exactement  la position choisie. Amaya tente alors de crer
l'lment  l'endroit le plus proche possible.</p>

<h3>Dfinir le titre du document</h3>

<p>Par dfaut Amaya donne le titre "No title" au document nouvellement cr
parce que cet lment est obligatoire. Il ne faut pas oublier de mettre 
jour ce titre en activant l'entre <strong>XHTML/Changer le
titre</strong>.</p>

<h3>Dfinir la langue utilise</h3>

<p>Il est important de dfinir la langue dans laquelle est crit le document.
Sans indication explicite, le document est suppos crit en anglais. La
langue est utilise par le correcteur orthographique.</p>

<p>Pour dfinir qu'un document est crit franais, il faut slectionner
l'lment &lt;body&gt; et lui appliquer l'attribut lang=fr.</p>

<h4>Premire mthode</h4>

<p>On pose la slection n'importe o dans le document et on utilise la touche
<kbd>F2</kbd> pour remonter la slection sur l'lment &lt;body&gt;. La barre
de statut affiche l'lment slectionn. A ce moment l on slectionne
l'entre du menu <strong>Attributs/Langue</strong> pour afficher le
formulaire de choix de la langue.</p>

<h4>Deuxime mthode</h4>

<p>On ouvre la vue Structure (entre <strong>Vue/Montrer la
structure</strong>), on slectionne l'lment &lt;body&gt;.A ce moment l on
slectionne l'entre du menu <strong>Attributs/Langue</strong> pour afficher
le formulaire de choix de la langue.</p>
</div>

<div>
<h3><a id="L1104">Sauver des documents en HTML</a></h3>

<p><b>Amaya</b> ne fournit aucune vue d'ensemble des pages installes sur le
serveur. Cependant il est possible de sauver ou copier des fichiers sur un
serveur ou sur sur son disque local grce aux commandes
<strong>Sauver</strong> et <strong>Sauver comme</strong>. Pendant ces
oprations, Amaya tient compte des images.</p>

<h4><a id="L1517">La commande Sauver</a></h4>

<p>La commande sauver peut tre invoque soit en choisissant
<strong>Sauver</strong> depuis le menu <strong>Fichier</strong> (<kbd>Ctrl
s</kbd> pour Windows, <kbd>Ctrl x Ctrl s</kbd> pour Unix) ou bien en cliquant
sur le bouton <img alt="floppy" src="../images/floppy.gif" />.</p>

<h4><a id="L1518">La commande Sauver comme</a></h4>

<p>Le fait de slectionner l'entre <strong>Sauver comme</strong> dans le
menu <strong>Fichier</strong> ouvre une bote de dialogue qui permet de
sauver le document courant  une adresse diffrente (sur un serveur Web ou
sur le disque local) ou de changer certains paramtres, comme le format du
document et l'encodage.</p>

<h2 id="L662">5. Cration du contenu (paragraphes, en-ttes de sections,
divisions)</h2>

<p>Par dfaut, Amaya cre un nouveau paragraphe chaque fois que l'on active
la touche <kbd>Enter</kbd>. Une fois le paragraphe et son contenu cr, on
peut insrer un en-tte de section, avant, aprs, ou au milieu du
paragraphe,</p>
<ul>
  <li>en activant un des boutons Hn,</li>
  <li>ou en tapant <kbd>Ctrl n</kbd> (n allant de 1  6),</li>
  <li>ou en slectionnant, l'entre correspondante du menu
    <strong>XHTML</strong>.</li>
</ul>

<p>Quand l'insertion se fait au milieu du paragraphe, Amaya coupe le
paragraphe existant en deux et insre l'en-tte au milieu.</p>

<h3>Transformations</h3>

<p>Si une partie du paragraphe est slectionne au moment o on insre
l'en-tte, ce texte sera supprim dans le paragraphe et insr dans l'en-tte
cr.</p>

<p>On peut aussi slectionner le paragraphe (touche <kbd>F2</kbd>) et
transformer ainsi le paragraphe en en-tte. Un ou plusieurs paragraphes
peuvent en fait se transformer en liste, table, prformat en fonction de
l'lment cible choisi. L'entre de menu <strong>Edition/Transformer</strong>
propose les cibles possibles pour la slection courante.</p>

<h3>Prformat</h3>

<p>L'lment prformat est un paragraphe particulier qui permet de prserver
tous les caractres: espace, fin de ligne.</p>

<p>Pour transformer un paragraphe en prformat, on slectionne le paragraphe
en entier et on active l'entre de menu <strong>XHTML/Prformat</strong> (ou
<kbd>Ctrl h Ctrl p</kbd>).</p>

<p>Pour transformer un prformat en paragraphe, on slectionne le prformat
en entier et on active l'entre de menu <strong>XHTML/Paragraphe</strong>.</p>

<p>Quand la slection se trouve  la fin d'un &lt;pre&gt;, la touche
<kbd>Enter</kbd> cre une nouvelle ligne du &lt;pre&gt;. Pour crer un
paragraphe aprs le &lt;pre&gt;, il faut slectionner le &lt;pre&gt; en
utilisant la touche <kbd>F2</kbd> puis <kbd>Enter</kbd>.</p>

<h3>Division</h3>

<p>Il est possible de grouper une srie de paragraphes, en-ttes, etc. dans
une division. Pour cela, on slectionne les lments  grouper ainsi que
l'entre DIV dans le menu XHTML.</p>

<h3>La touche Enter</h3>

<p>La touche <kbd>Enter</kbd> (ou Return) joue un rle particulier. En
gnral elle clt l'lment courant et cre un paragraphe juste aprs. Si un
lment complet est slectionn, la touche <kbd>Enter</kbd> cre une autre
instance de cet lment. Par exemple si on slectionne un en-tte, la touche
<kbd>Enter</kbd> va crer un en-tte vide aprs.</p>

<h3><a id="Back">Les touches Back Space et Delete</a></h3>

<p>Des lments conscutifs peuvent tre fusionns, mme s'ils ne sont pas au
mme niveau dans la structure du document. La fusion s'effectue  l'aide des
touches <kbd>Back Space</kbd> et <kbd>Delete</kbd>. Quand le point
d'insertion est  la fin d'un lment, utilisez la touche <kbd>Delete</kbd>.
Quand il est au dbut, utilisez la touche <kbd>Back Space</kbd>. Dans les
deux cas, ces touches n'effacent aucun caractre. Elles fusionnent des
lments spars par une limite de structure.</p>

<p>Quand le point d'insertion est  l'intrieur d'un lment, ces deux
touches effacent comme d'habitude le caractre suivant ou le caractre
prcdent.</p>

<h3>Caractres spciaux</h3>

<p>Pour les caractres ISO-latin qui ne sont pas directement disponibles
depuis le clavier, Amaya utilise le support standard fournit par le
systme.</p>

<p>Amaya fournit aussi des raccourcis pour certains caractres non
disponibles au clavier comme:</p>
<ul>
  <li>Pour obtenir un espace non scable, vous devez taper <kbd>Ctrl -
    espace</kbd>. Ce caractre sera sauv comme une entit
    (<kbd>&amp;nbsp;</kbd>).</li>
  <li>Pour obtenir un &euro; (euro), vous devez taper <kbd>Alt e</kbd>.</li>
  <li>Pour obtenir un , vous devez taper <kbd>Ctrl &lt;</kbd> (ou
    <kbd>Shift</kbd> <kbd>Ctrl &lt;</kbd> selon le clavier).</li>
  <li>Pour obtenir un , vous devez taper <kbd>Shift Ctrl &gt;</kbd>.</li>
</ul>

<h3>Insrer une image</h3>

<p>Pour insrer une image, on choisit l'entre <strong>Image</strong> dans le
menu <strong>XHTML</strong> (raccourci <kbd>Ctrl h Ctrl i</kbd>) ou on clique
sur le bouton <img alt="Image " src="../images/Image.gif"
longdesc="longdesc.htm" />. Une bote de dialogue s'affiche qui permet de
rentrer le nom du fichier et le <a href="ImageMaps.html.fr#Alternative">texte
de remplacement</a> ('ALT' texte) de l'image. L'insertion n'est prise en
compte que lorsque le texte de remplacement est fourni.</p>

<p style="text-align: center"><img alt="(Insertion image)"
src="../images/create_image-fr.png" /></p>

<p>L'image est affiche avec ses dimensions par dfaut. On peut
redimensionnerer l'image insre :</p>
<ul>
  <li>soit par manipulation directe - en combinant la touche
    <kbd>Control</kbd> et le <kbd>bouton droit</kbd> ou le <kbd>bouton du
    milieu</kbd> de la souris,</li>
  <li>soit en ditant les attributs <strong>width</strong> et
    <strong>height</strong> de l'image. Quand l'image est slectionne, on
    slectionne l'entre <strong>width</strong> ou <strong>height</strong> du
    menu <strong>Attributs</strong>.</li>
</ul>

<p>Par dfaut l'image est cadre  gauche. On peut modifier le cadrage de
l'image slectionne en modifiant l'alignement dans le formulaire
<strong>Format</strong> du menu <strong>Style</strong>.</p>

<h3>Remplacer une image</h3>

<p>Pour remplacer une image il faut slectionner cette image en draguant sur
l'image avec la souris. Procdez alors comme pour l'ajout d'une image (voir
ci-dessus). Lorsqu'une image (et seulement une image) est entirement
slectionne, la bote de dialogue des images effectue le remplacement de
l'image slectionne au lieu d'insrer une nouvelle image.</p>

<h3 style="clear: both">Copier/Coller, Dfaire/Refaire</h3>

<p>Amaya permet copier/coller non seulement du texte et des images, mais
aussi une structure complexe comme une division ou une suite de paragraphes
et d'en-ttes.</p>

<p>Il est toujours possible de dfaire et de refaire les dernires
modifications opres dans le document.</p>

<p><a href="Creating.html.fr">A voir pour plus de dtail</a></p>

<p class="exercice"><em>Exercice 1:</em> Crer un document contenant des
paragraphes, des en-ttes, des divisions.</p>

<h2 id="L831">6. Les listes</h2>

<h3>Editer les listes  puces ou les listes numrotes</h3>

<h4>Premire mthode</h4>

<p>En cliquant sur <img alt="(Liste)" src="../images/OList.gif" /> (ou
<kbd>Ctrl h Ctrl l</kbd>) on cre une liste  puces et un premier item de
liste  l'intrieur.</p>
<ul>
  <li>Il ne reste plus qu' taper le texte de l'item.
    <p>La touche <kbd>Enter</kbd> en fin d'item va crer un paragraphe vide
    dans l'item et on peut immdiatement saisir le contenu de ce nouveau
    paragraphe.</p>
  </li>
  <li>Si on ne veut pas insrer de paragraphe mais passer  l'item suivant,
    on double la touche <kbd>Enter</kbd>.
    <p>Attention en cliquant sur <img alt="(Liste)" src="../images/OList.gif"
    /> (ou <kbd>Ctrl h Ctrl l</kbd>) on cre une nouvelle liste  puces 
    l'intrieur de l'item courant.</p>
  </li>
  <li>Si on veut terminer la liste, on triple la touche <kbd>Enter</kbd>.</li>
</ul>

<p>En cliquant sur <img alt="(Liste numrote)" src="../images/NumList.gif"
/> (ou <kbd>Ctrl h Ctrl n</kbd>) on cre une liste numrote et un item de
liste  l'intrieur.</p>

<h4>Deuxime mthode</h4>

<p>On peut saisir du texte sans dfinir au pralable de type d'lment. Par
dfaut, Amaya cre un nouveau paragraphe chaque fois que l'on active la
touche <kbd>Enter</kbd>. On peut ensuite slectionner plusieurs paragraphes
et cliquer sur <img alt="(Liste)" src="../images/OList.gif" /> (ou <kbd>Ctrl
h Ctrl l</kbd>) pour crer une liste  puces.</p>

<p>Pour slectionner tout le contenu d'une suite de paragraphes, on utilise
la touche <kbd>F2</kbd>.</p>

<h4>Transformation d'une liste  puces et en liste numrote</h4>

<p>On pose la slection dans un item de liste, puis en doublant la touche
<kbd>F2</kbd> on slectionne la liste complte. En cliquant sur <img
alt="(Liste numrote)" src="../images/NumList.gif" /> (ou <kbd>Ctrl h Ctrl
n</kbd>) on cre une liste numrote  la place. On peut bien sr passer de
la mme faon d'une liste numrote  une liste  puces.</p>

<h3 id="edit-dl">Editer les listes de dfinitions (dl/dt/dd)</h3>

<p>En cliquant sur <img alt="(Liste de dfinitions)" src="../images/DL.gif"
/> (ou <kbd>Ctrl h Ctrl d</kbd>) on cre une liste de dfinitions.</p>

<p>La touche <kbd>Enter</kbd> est galement utile pour diter des listes de
dfinitions. Considrez l'exemple suivant :</p>

<blockquote>
  <dl>
    <dt>Terme 1</dt>
    <dt>Terme 2</dt>
      <dd>Dfinition des deux termes.</dd>
  </dl>
</blockquote>

<p>C'est une liste de dfinitions (<code>dl</code>) contenant deux termes
(<code>dt</code>) suivis par une dfinition (<code>dd</code>). Pour ajouter
un nouveau paragraphe  l'intrieur de la dfinition (<code>dd</code>),
placez le point d'insertion  la fin (aprs le mot "termes") et appuyez sur
la touche <kbd>Enter</kbd>. Si vous pressez <kbd>Enter</kbd> deux fois, vous
sortez de la dfinition en cours (<code>dd</code>) et vous crez un nouveau
terme (<code>dt</code>). A la fin de ce nouveau terme, presser une fois la
touche <kbd>Enter</kbd> vous permet de crer encore un nouveau terme
(<code>dt</code>). La presser deux fois cre une nouvelle dfinition
(<code>dd</code>).</p>

<p>Si vous voulez crer un nouveau terme avec sa dfinition <em>avant</em> le
Terme 1, mettez le point d'insertion au dbut du terme 1 et appuyez sur
<kbd>Enter</kbd>. Tapez le nouveau terme (<code>dt</code>), puis pressez
<kbd>Enter</kbd> deux fois : une nouvelle dfinition (<code>dd</code>) est
cre directement aprs le nouveau terme.</p>
</div>

<p>De faon gnrale on utilise la touche <kbd>Enter</kbd> pour insrer des
lments de structure avant ou aprs des listes ou des items de liste, et les
touches <kbd>Back Space</kbd> et <kbd>Delete</kbd> pour fusionner des listes
ou des items de listes.</p>

<p class="exercice"><em>Exercice 2:</em> Crer et transformer des listes.</p>

<div>
<h2 id="L1002">7. Les liens</h2>

<p>Les liens hypertexte permettent de relier des parties de document
entre-elles ou des documents entre-eux.</p>

<h3>Cration de cibles</h3>

<p>La cible d'un lien hypertexte peut tre</p>
<ul>
  <li>un document entier,</li>
  <li>ou un passage du document englob par une ancre cible,</li>
  <li>ou un lment HTML qui possde un identificateur (attribut ID)</li>
</ul>

<p>Pour crer une cible dans un document, il suffit de slectionner le
passage dsir et d'activer l'entre de menu <strong>Crer cible</strong>
(<kbd>Ctrl l Ctrl t</kbd>) dans le menu <strong>Liens</strong>. Si la
slection porte sur un lment HTML entier, Amaya va lui associer un
identificateur unique. Sinon, Amaya va englober le contenu de la slection
dans une ancre cible.</p>

<p>On peut demander  Amaya d'associer un identificateur  tous les lments
d'un certain type dans le document. Pour cela on active l'entre
<strong>Ajouter/Retirer des attributs ID</strong> dans le menu
<strong>Liens</strong>. Par exemple, on peut demander d'associer un
identificateur  tous les lments H2.</p>

<h3>Cration de liens</h3>

<p>L'origine d'un lien est une ancre qui possde un attribut
<code>href</code>. On procde de la mme faon pour un lien vers un document
entier ou une cible.</p>

<h4>Lien vers un autre document dit par Amaya</h4>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On clique sur le bouton <img alt="Link " src="../images/Link.gif"
  /></li>
  <li>On clique sur le document cible affich.</li>
</ol>

<p>Autre mthode:</p>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On choisit <strong>Crer/changer lien</strong> du <a
    href="Browsing.html.fr"></a>menu <strong>Liens</strong> (raccourci
    <kbd>Ctrl l Ctrl l</kbd>) pour afficher le formulaire de cration de lien.
    <p><img alt="(Cration de lien)" src="../images/create_link-fr.png" /></p>
  </li>
  <li>Soit on saisit l'URI du document cible et on confirme. Soit on dcide
    de dsigner la cible avec la souris (bouton Clic puis clic sur le
    document cible affich).</li>
</ol>

<p>Dans tous les cas, une fois la cible choisie, Amaya va calculer l'URL
relative qui permet d'aller du document source au document cible.</p>

<h4>Lien vers une ancre cible d'un document dit par Amaya</h4>

<p>Pour crer un lien vers une ancre cible particulire ou vers un lment
cible particulier d'un document dit par Amaya, il faut d'abord demander la
visualisation des cibles <a id="target"><img src="../images/target.gif"
alt=" target " /></a> dans le document concern en activant l'entre
<strong>Montrer les cibles</strong> du menu <strong>Vues</strong> ou ouvrant
la vue des liens (entre <strong>Montrer les liens</strong> du menu
<strong>Vues</strong>). Ensuite:</p>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On clique sur le bouton <img alt="Link " src="../images/Link.gif"
  /></li>
  <li>On clique sur la cible choisie.</li>
</ol>

<h4>Lien vers un autre document non affich</h4>

<p>Pour crer un lien vers un autre document local ou distant:</p>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On clique sur le bouton <img alt="Link " src="../images/Link.gif"
  /></li>
  <li>On clique sur une zone du document qui ne peut pas tre une cible pour
    afficher le formulaire de saisie de l'URL. Si le document est local, on
    peut utiliser le browser de fichier pour slectionner le fichier.</li>
</ol>

<p>Autre mthode:</p>
<ol>
  <li>On slectionne le passage choisi.</li>
  <li>On choisit <strong>Crer/changer lien</strong> du menu
    <strong>Liens</strong> (raccourci <kbd>Ctrl l Ctrl l</kbd>)</li>
  <li>On saisit l'URL du document cible et on confirme.</li>
</ol>

<h4><a id="Changing">Mettre  jour un lien</a></h4>

<p>Pour garder une ancre mais changer la cible du lien correspondant, on
place la slection dans l'ancre et on procde comme pour la cration de lien
(bouton <img alt="Link " src="../images/Link.gif" /> ou l'entre
<strong>Crer/changer Lien</strong> du menu <strong>Liens</strong>). On peut
alors dsigner la nouvelle cible ou diter l'URI.</p>

<p>Pour changer la cible d'un lien, on peut galement diter l'attribut
<code>href</code> dans la vue structure.</p>

<h4><a id="Removing">Supprimer un lien ou une ancre cible</a></h4>

<p>Le menu <strong>Liens</strong> contient une entre <strong>Dtruire
ancre</strong> qui permet de dtruire l'ancre cible ou le lien slectionn.
Il suffit que la slection soit  l'intrieur de l'ancre  dtruire. L'ancre
est dtruite, mais son contenu reste.</p>

<p class="exercice"><em>Exercice 3:</em> Crer des liens dans un document et
entre documents, copier/coller de structures contenant des liens, remplacer,
dtruire.</p>
</div>

<div>
<h2 id="L11631">8. Mises en vidence du texte</h2>

<p>Il est possible de marquer des parties de texte mises en ligne soit en
utilisant les CSS (voir plus loin), soit en utilisant les lments mise en
vidence, important, code, citation, abrviation, etc. de HTML.</p>

<p>Les entres de menu et les boutons correspondants fonctionnent comme des
bascules (active/dsactives).</p>

<p>Souvent l'introduction de mises en vidence engendrent des problmes de
perte des blancs.</p>

<h3>Traitement des blancs</h3>

<p>Le traitement des blancs est appliqu par Amaya lors du chargement d'un
document et lors de l'dition de celui-ci. Par exemple, le code source
suivant:</p>
<pre><code>    &lt;p&gt;Amaya supprime les</code>&lt;strong&gt;<code> blancs non significatifs </code>&lt;/strong&gt;<code>au chargement&lt;/p&gt;</code></pre>

<p>donnera:</p>
<pre><code>    Amaya supprime les</code><code><strong>blancs non significatif</strong></code><code><strong>s</strong>au chargement</code></pre>

<p>car les blancs de dbut et de fin de l'lment <code>strong</code> sont
considrs comme non significatifs et sont donc supprims.</p>

<p>La forme correcte aurait t :</p>
<pre>    &lt;p&gt;Amaya supprime les &lt;strong&gt;blancs non significatifs&lt;/strong&gt; au chargement&lt;/p&gt;</pre>
</div>

<div>
<h2 id="L12061">9. Les tables</h2>

<h3><a id="Creating1">Crer une nouvelle table</a></h3>

<p>Quand on active le bouton table <img src="../images/table.gif"
alt="Table button" /> ou quand on slectionne l'entre <strong>Table</strong>
depuis le menu <strong>Xhtml</strong>, Amaya visualise une bote de dialogue
qui permet de spcifier le nombre initial de lignes, de colonnes, ainsi que
la bordure en pixels.</p>

<p style="text-align: center"><img alt="(Create table)"
src="../images/create_table-fr.png" /></p>

<p>En confirmant on cre une table comme suit.</p>

<table border="1" summary="table">
  <caption>I</caption>
  <tbody>
    <tr>
      <td></td>
      <td></td>
    </tr>
    <tr>
      <td></td>
      <td></td>
    </tr>
  </tbody>
</table>

<p>L'espace au dessus de la table est rserv  la lgende. Le point
d'insertion est automatiquement plac dans cette lgende pour en saisir le
contenu. La touche <kbd>Delete</kbd> supprime la lgende.</p>

<p>La nouvelle table contient des cellules vides. On peut cliquer sur l'une
d'entre elles au hasard et y insrer du texte, des images et autre. On peut
galement dplacer le point d'insertion de cellule en cellule par
l'intermdiaire des flches du clavier.</p>

<h3><a id="Adding3">Insrer/Ajouter une colonne</a></h3>

<p>Il n'existe deux commandes spcifiques pour crer une nouvelle
colonne:</p>
<ul>
  <li><strong>Insrer une colonne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl b</kbd>) ajoute une nouvelle
    colonne avant la colonne slectionne.</li>
  <li><strong>Ajouter une colonne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl a</kbd>)ajoute une nouvelle
    colonne aprs la colonne slectionne.</li>
</ul>

<p>Si on a slectionn une cellule complte par <kbd>F2</kbd> la touche
<kbd>Enter</kbd> cre une nouvelle cellule aprs et la colonne
correspondante.</p>

<h3>Dtruire une colonne</h3>

<p>Pour dtruire une colonne de table, il faut slectionner la colonne et
utiliser la commande <kbd>Delete</kbd>. Il y a deux mthodes pour
slectionner une colonne :</p>
<ol>
  <li>Soit l'entre <strong>Slectionner la colonne</strong> dans le
    sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl c</kbd>).</li>
  <li>Soit tendre la slection sur au moins deux cellules dans la mme
    colonne (Cell 1.1  Cell 2.1 dans l'exemple ci-dessous) puis deux fois
    <kbd>F2</kbd> pour slectionner la colonne.</li>
</ol>

<table border="1" summary="table">
  <caption>Lgende</caption>
  <tbody>
    <tr>
      <td>Cell 1.1</td>
      <td>I</td>
      <td>Cell 1.2</td>
      <td>Cell 1.3</td>
    </tr>
    <tr>
      <td>Cell 2.1</td>
      <td></td>
      <td></td>
      <td></td>
    </tr>
  </tbody>
</table>

<h3>Copier/Coller ou Dplacer une colonne</h3>

<p>Pour dplacer ou copier/coller une colonne de table:</p>
<ol>
  <li>Il faut slectionner la colonne comme dans le cas de <strong>Dtruire
    une colonne</strong> et copier (<kbd>Ctrl c</kbd>) ou couper (<kbd>Ctrl
    x</kbd> pour Windows, <kbd>Ctrl w</kbd> pour Unix) son contenu.</li>
  <li>Pour coller la colonne avant une autre colonne
    <ul>
      <li>soit on slectionne le dbut d'une cellule de colonne et on active
        la commande coller (<kbd>Ctrl v</kbd> pour Windows, <kbd>Ctrl y</kbd>
        pour Unix),</li>
      <li>soit on utilise l'entre de menu <strong>Coller avant</strong> dans
        le sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl p</kbd>).</li>
    </ul>
  </li>
  <li>Pour coller la colonne aprs une autre colonne
    <ul>
      <li>soit on slectionne la fin d'une cellule de colonne et on active la
        commande coller (<kbd>Ctrl v</kbd> pour Windows, <kbd>Ctrl y</kbd>
        pour Unix),</li>
      <li>soit on utilise l'entre de menu <strong>Coller aprs</strong> dans
        le sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl v</kbd>).</li>
    </ul>
  </li>
</ol>

<h3><a id="Adding11">Insrer/Ajouter une ligne</a></h3>

<p>Il n'existe deux commandes spcifiques pour crer une nouvelle ligne:</p>
<ul>
  <li><strong>Insrer une ligne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl i</kbd>) ajoute une nouvelle
    ligne avant la ligne slectionne.</li>
  <li><strong>Ajouter une ligne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl n</kbd>)ajoute une nouvelle
    ligne aprs la ligne slectionne.</li>
</ul>

<p>Si on a slectionn une ligne complte par <kbd>F2</kbd> la touche Enter
cre une nouvelle ligne aprs.</p>

<h3>Dtruire une ligne</h3>

<p>Pour dtruire une ligne de table, il faut slectionner la ligne et
utiliser la commande <kbd>Delete</kbd>. Il y a deux mthodes pour
slectionner une ligne :</p>
<ol>
  <li>Soit l'entre <strong>Slectionner la ligne</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl r</kbd>).</li>
  <li>Soit poser la slection sur une cellule de la ligne (Cell 1.1 dans
    l'exemple ci-dessous) puis deux fois <kbd>F2</kbd> pour slectionner la
    ligne.</li>
</ol>

<h3>Copier/Coller ou Dplacer une ligne</h3>

<p>Pour dplacer ou copier/coller une ligne de table:</p>
<ol>
  <li>Il faut slectionner la ligne comme dans le cas de <strong>Dtruire une
    ligne</strong> et copier (<kbd>Ctrl c</kbd>) ou couper (<kbd>Ctrl x</kbd>
    son contenu.</li>
  <li>Pour coller la ligne avant une autre ligne
    <ul>
      <li>soit on slectionne le dbut d'une ligne et on active la commande
        coller (<kbd>Ctrl v</kbd>,</li>
      <li>soit on utilise l'entre de menu <strong>Coller avant</strong> dans
        le sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl p</kbd>).</li>
    </ul>
  </li>
  <li>Pour coller la colonne aprs une autre colonne
    <ul>
      <li>soit on slectionne la fin d'une ligne et on active la commande
        coller (<kbd>Ctrl v</kbd> pour Windows, <kbd>Ctrl y</kbd> pour
      Unix),</li>
      <li>soit on utilise l'entre de menu <strong>Coller aprs</strong> dans
        le sous-menu <strong>Table</strong> (<kbd>Ctrl t Ctrl v</kbd>).</li>
    </ul>
  </li>
</ol>

<h3>Cellules tendues</h3>

<p>Il n'existe quatre commandes spcifiques pour tendre ou rduire
l'extension de cellules:</p>
<ul>
  <li><strong>Joindre avec la cellule  droite</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl e</kbd>) tend la cellule d'une
    position  droite et colle le contenu des deux cellules.</li>
  <li><strong>Joindre avec la cellule au-dessous</strong> dans le sous-menu
    <strong>Table</strong> (<kbd>Ctrl t Ctrl j</kbd>)tend la cellule d'une
    position vers le bas et colle le contenu des deux cellules.</li>
  <li><strong>Rduire extension horizontale</strong> (<kbd>Ctrl t Ctrl
    s</kbd>) rduit l'extension horizontale de la cellule d'une position et
    engendre une cellule vide.</li>
  <li><strong>Rduire extension verticale</strong> (<kbd>Ctrl t Ctrl m</kbd>)
    rduit l'extension verticale de la cellule d'une position et engendre une
    cellule vide.</li>
</ul>

<p>On peut aussi diter directement les attributs colspan et rowspan de la
cellule.</p>

<h3>Ajouter un nouveau corps de table (tbody)</h3>
<ol>
  <li>Pour crer un nouveau corps de table en dessous d'un corps de table
    existant, il faut placer le curseur  la fin de la dernire cellule de la
    dernire ligne du corps de table et slectionner l'entre <strong>Corps
    (tbody)</strong> dans le sous-menu <strong>Table</strong>.</li>
  <li>Pour crer un nouveau corps de table au-dessus d'une ligne existante,
    il faut placer le curseur au dbut de la premire cellule de la ligne et
    slectionner l'entre <strong>Ligne</strong> dans le sous-menu
    <strong>Table</strong>.</li>
</ol>

<p>De nouveaux corps de table peuvent tre crs efficacement avec la touche
<a href="Creating.html.fr#L906">Enter</a>. Quand le corps de table entier est
slectionn (il faut utiliser la touche <kbd>F2</kbd>), en tapant la touche
<kbd>Enter</kbd> vous crez une nouveau corps de table aprs le corps de
table slectionn.</p>

<h3><a id="Adding21">Ajouter quelque chose aprs une table</a></h3>

<p>De nombreux types d'lments peuvent tre inclus  l'intrieur des
cellules de la table. Pour cette raison, Amaya pourrait mal comprendre vos
intentions quand vous slectionnez un type d'lment (par exemple cliquant
H1, H2, etc. ou slectionnant une entre dans le menu <strong>Xhtml</strong>)
pendant qu'un composant de la table est slectionn.</p>

<h3>Cration d'un paragraphe aprs une table</h3>

<p>Quand la slection se trouve dans une table, la touche <kbd>Enter</kbd>
cre un nouveau paragraphe dans la table.</p>

<p>Pour crer un paragraphe aprs la table, il faut slectionner la table
entire en utilisant la touche <kbd>F2</kbd> puis <kbd>Enter</kbd>.</p>

<p>Ce nouveau paragraphe peut tre modifi si besoin est.</p>

<p></p>

<p class="exercice"><em>Exercice 4:</em> Crer une table, crer une ligne
avant/aprs, dplacer une ligne, crer une colonne avant/aprs, dplacer une
colonne.</p>
</div>

<div>
<h2 id="L12281">10. Recherche/Remplacement - Correction orthographique</h2>

<h3>Recherche et remplacement de texte</h3>

<p>La recherche/remplacement se lance, soit en cliquant sur le bouton <img
src="../images/find.gif" alt="find " />, soit par l'entre de menu
<strong>Edition/Rechercher</strong>. Un boite de dialogue apparat. vous avez
deux zones de saisie la premire sera pour le texte  rechercher la deuxime
zone de saisie sera pour le texte  remplacer.</p>

<p>Pour chacune des actions vous avez des choix d'options.</p>
<ul>
  <li>les options de recherche :
    <ul>
      <li>la casse : pour la recherche permet de spcifier s'il y a lieu de
        diffrencier ou non les majuscules des minuscules.</li>
      <li>case  cocher pour slectionner la zone sur laquelle raliser la
        recherche avant la slection, aprs la slection, dans la slection
        ou sur la totalit du document.</li>
    </ul>
  </li>
  <li>Les options de remplacement :
    <ul>
      <li>le type de remplacement : pas de remplacement (juste une
        recherche), remplacement avec un fentre de confirmation,
        remplacement automatique.</li>
    </ul>
  </li>
</ul>

<h3>Correction orthographique</h3>

<p>La correction orthographique se ralise  l'aide d'une boite de dialogue
active par l'action <strong>Edition/Vrifier orthographe</strong>.</p>

<p>les options de la boite de dialogue :</p>
<ul>
  <li>Le dictionnaire utilis se fait en fonction de la langue dfinie au
    niveau de l'lment ou du document.</li>
  <li>On peut spcifier le nombre de propositions (par dfaut 3).</li>
  <li>On peut exclure des lments lors de recherche de correspondance de
    mots avec le dictionnaire (par dfaut toutes les options sont activ)</li>
  <li>Options de zone de recherche vous avez la possibilit de spcifier la
    zone sur laquelle cette correction orthographique se fera avant la
    slection, aprs la slection, dans la slection ou sur la totalit du
    document.</li>
  <li>les boutons d'activation de recherche.
    <ul>
      <li>recherche du suivant (sans action) : considre que le mot est
        correcte et passe  l'erreur suivante.</li>
      <li>rajoute au dictionnaire personnel : rajoute le mot au dictionnaire
        personnel.</li>
      <li>remplace le mots et passe  l'occurrence suivante.</li>
      <li>remplace le mots et le rajoute dans le dictionnaire personnel.</li>
      <li>confirmer permet de fermer la boite de dialogue.</li>
    </ul>
  </li>
</ul>

<p class="exercice"><em>Exercice 5:</em> Rechercher/remplacer, changer la
lange d'un passage et passer le correcteur orthographique.</p>
</div>

<div>
<h2 id="L1230">11. Attributs</h2>

<p>Il y a deux manires d'diter des attributs :</p>
<ul>
  <li>Le menu <strong>Attributs</strong></li>
  <li>La Vue structure</li>
</ul>

<h3><a id="L1073">Editer des attributs par le biais du menu Attributs</a></h3>

<p>Le menu <strong>Attributs</strong> donne une liste de tous les attributs
qui peuvent tre associs  l'lment slectionn. Il peut tre utilis pour
crer un attribut, pour changer la valeur d'un attribut existant ou pour
effacer un attribut.</p>

<p>Pour diter un attribut, slectionnez d'abord l'lment appropri. Vous
devez slectionner l'lment entier et pas seulement un caractre 
l'intrieur de l'lment. Pour cela, il faut utiliser la touche
<kbd>F2</kbd>. Quand l'lment est slectionn, le menu
<strong>Attributs</strong> affiche la liste des attributs applicables. On
peut voir rapidement si l'attribut a une valeur ou non</p>

<h3><a id="Editing">Editer des attributs dans la Vue structure</a></h3>

<p>Tous les attributs sont affichs dans la Vue structure. Les attributs dont
la valeur peut tre choisie librement sont affichs en prune et vous pouvez
diter leur valeur comme n'importe quelle autre chane de caractres. Quand
la valeur de l'attribut est affiche en bleu, vous pouvez seulement la
changer  l'aide du menu <strong>Attributs</strong>. Ceci assure que seules
des valeurs correctes soient choisies.</p>

<p>Quand la slection se trouve dans une valeur d'attribut, la touche
<kbd>F2</kbd> slectionne la valeur complte. La touche <kbd>Delete</kbd>
dtruit alors la valeur, et un deuxime <kbd>Delete</kbd> supprimera
l'attribut.</p>
</div>

<div>
<h2 id="L1232">12. Cration de feuilles de style CSS</h2>

<h3><a id="feuilles">Les feuilles de style CSS externes et les feuilles de
style CSS utilisateur</a></h3>

<p>Un document peut associer plusieurs feuilles de style externes qui sont
charges avec le document et lui sont appliques. Une feuille de style
externe peut s'appliquer  plusieurs documents.</p>

<p>L'utilisateur peut dfinir une feuille de style spcifique qui s'applique
 tous les documents chargs. Cette feuille de style est appele
<strong>Feuille de Style Utilisateur</strong> et est le fichier local
<strong>amaya.css</strong> conserv dans l'environnement de l'utilisateur (le
<a href="Configure.html.fr#AmayaHome">rpertoire d'AmayaHome</a>). Par
exemple si vous prfrez afficher les document en Helvetica et imprimer avec
une police de caractres de petite taille, vous pouvez crer votre feuille de
style utilisateur avec les rgles CSS suivantes:</p>
<pre>@media print {
 BODY {font-size: 10pt}
}
@media screen {
 BODY {font-family: Helvetica}
}</pre>

<h3><a id="Managing">Grer des feuilles de style CSS externes</a></h3>

<p>L'entre de feuilles de style donne accs  une srie de commandes qui
permettent de contrler les feuilles de style CSS externes et celles qui
donnent les prfrences de l'utilisateur :</p>
<ul>
  <li>La commande <strong>Ajouter</strong> permet de lier une nouvelle
    feuille de style CSS  un document courant. On peut cliquer directement
    sur la cible de la feuille de style si elle est dj visualise dans la
    fentre Amaya. Si ce n'est pas le cas, l'utilisateur devra cliquer dans
    le document courant pour avoir accs  une bote de dialogue et taper
    l'URL de la cible de la feuille de style. Cette commande ajoute un
    lment lien avec ses attributs  la tte du document.</li>
  <li>La commande <strong>Ouvrir</strong> permet d'ouvrir une des feuilles de
    style CSS appliques au document courant.</li>
  <li>La commande <strong>Dsactiver</strong> permet de supprimer les effets
    d'une des feuilles de style actives du document courant. Cette commande
    n'affecte en rien le lien CSS dans le document.</li>
  <li>La commande <strong>Ractiver</strong> permet de rtablir les effets
    d'une des feuilles de style CSS dsactives du document courant. Cette
    commande n'affecte en rien le lien CSS dans le document.</li>
  <li>La commande <strong>Retirer</strong> permet de retirer une des feuilles
    de style CSS externes. Cette commande agit comme la commande Dsactiver.
    En plus de cela, l'lment lien qui attache les feuilles de style CSS est
    supprim.</li>
</ul>

<p>Les commandes Ouvrir, Dsactiver et Ractiver peuvent tre appliques aux
feuilles de style qui donnent les prfrences de l'utilisateur, mais les
commandes Ajouter et Retirer concernent uniquement les feuilles de style
relies. La figure suivante montre la liste des feuilles de style CSS
proposes pour la commande Ouvrir. Si aucune feuille de style CSS n'est
actuellement applique  un document, une bote de dialogue expliquera
"qu'aucun fichier CSS n'est disponible".</p>

<p><img alt="css.gif" src="../images/css.gif" /></p>

<p></p>

<h3>Visualiser le style appliqu</h3>

<p>S'il y a beaucoup de feuilles de style attaches  un document, il est
difficile de comprendre pourquoi un lment est visualis avec cette couleur
ou ces marges, etc. Pour aider l'utilisateur, Amaya fournit une commande
<strong>Montrer le style appliqu</strong> qui visualise dans une fentre
externe les proprits CSS appliques au premier lment de la slection
courante.</p>

<p>L'utilisateur peut afficher le source CSS qui engendre chaque proprit en
double (ou simple) cliquant sur la proprit. Aussi longtemps que la fentre
est ouverte, Amaya met  jour le contenu de la fentre quand la slection
change.</p>

<p>En appuyant sur la touche <kbd>F2</kbd> sur les, l'utilisateur peut voir
les proprits CSS appliques aux lments englobants.</p>

<h3>Crer des proprits CSS</h3>

<p>Amaya ne fournit pas pour le moment une liste complte des proprits CSS
2 sauf pour les proprits les plus courantes. En gnral l'utilisateur doit
donc se reporter  la spcification CSS 2 pour connatre le nom des
proprits et leurs valeurs.</p>

<p>Les quatre premires entres du menu <strong>Style</strong> permettent de
produire les proprits CSS les plus courantes pour les lments slectionns
:<strong></strong><strong></strong></p>
<ul>
  <li><h3><span style="font-size: 12pt"><span
    style="font-weight: normal">L'option</span> Style de caractres <span
    style="font-weight: normal">permet de choisir certaines polices de
    caractre, le style du caractre, la taille du corps et le style
    soulign.</span></span></h3>
  </li>
</ul>
<ul>
  <li><strong><span style="font-weight: normal">L'option</span>
    Couleurs</strong> permet de choisir les couleurs du premier plan et de
    l'arrire plan dans la palette. Cliquez sur une cellule de la palette
    avec le bouton gauche de la souris pour attribuer la couleur du premier
    plan, cliquez sur le bouton du milieu pour attribuer la couleur de
    l'arrire plan.</li>
  <li>L'option <strong>Format</strong> permet de choisir l'alignement, le
    renfoncement, la justification et l'interligne.</li>
  <li>L'option <strong>Image de fond</strong> permet de choisir une image de
    fond et son mode de rptition.</li>
</ul>

<p>Pour le moment le style est associ  un ou plusieurs lments
particuliers. Un lment peut tre utilis comme un modle pour crer ou
modifier une rgle de style:</p>
<ul>
  <li>On slectionne cet lment (un seul lment ayant un attribut
    <code>style</code>)</li>
  <li>On slectionne l'entre <strong>Crer une rgle</strong> du menu
    <strong>Style</strong>. Une bote de dialogue surgit et visualise une
    liste de slecteurs CSS. Cette liste inclus toutes les classes qui sont
    dfinies pour le document courant (y compris les classes dfinies par les
    feuilles de style lies au document), ainsi que les types d'lment
    auquel le style est associ.</li>
  <li>On choisit un slecteur dans cette liste ou on saisit un nouveau nom de
    classe puis on confirme. Le style de l'lment slectionn est dsormais
    associ au slecteur choisi et l'attribut <code>style</code> est supprim
    pour l'lment slectionn. Son contenu est dplac  l'lment
    <code>STYLE</code>, dans le <code>HEAD</code> document, et tous les
    lments correspondant au slecteur sont visualiss dans le nouveau
  style.</li>
  <li>Si une nouvelle classe est cre, elle peut tre applique  d'autre
    lments du document par la commande <strong>Appliquer une
    classe</strong> du menu <strong>Style</strong>. Une bote de dialogue
    surgit, affichant toutes les classes existantes. On choisit une de ces
    classes. Les lments slectionns sont dsormais visualiss avec le
    style associ  la classe choisie.</li>
</ul>

<p>Pour associer une classe  un lment, vous pouvez galement utiliser le
<a href="Attributes.html.fr#L1073">menu <strong>Attributs</strong></a>. Ce
menu permet aussi d'effacer un attribut de classe pour un lment ou de le
changer : l'attribut de classe se manipule comme un autre attribut.</p>

<p class="exercice"><em>Exercice 6:</em> Mettre de la couleur, appliquer une
feuille de style, voir le style.</p>
</div>

<div>
<h2 id="L1242">13. Dtection des erreurs</h2>

<p>Au chargement d'un document, Amaya peut dtecter des erreurs de HTML (mais
le parseur HTML est trs tolrant) ou des incompatibilits avec la famille
XHTML choisie.</p>
</div>
<dl>
  <dt>1er exemple:</dt>
    <dd>Un document est dclar comme HTML 4.0 Strict et contient des
      attributs non accepts.
      <p><img alt="(profil invalide)" src="../images/invalid_profile-fr.png"
      /></p>
    </dd>
  <dt>2me exemple:</dt>
    <dd>Un document XHTML mal form
      <p><img alt="(mal form)" src="../images/not_well_formed-fr.png" /></p>
    </dd>
</dl>

<div>
<h4>On peut corriger les erreurs</h4>

<p>On peut voir le dtail des erreurs dtectes dans l'entre <strong>Montrer
les erreurs</strong> du menu <strong>Vues</strong>. Pour corriger ces
erreurs, on active le lien vers la vue source du document pour visualiser la
position de l'erreur dans le source.</p>

<p>Une fois les erreurs corriges on synchronise pour voir si tout est
correct, on peut alors sauver le document corrig.</p>

<h4>On peut aussi modifier le type du document</h4>

<p>L'entre <strong>Modifier le doctype</strong> du menu
<strong>Fichier</strong> permet de modifier le type du document.</p>

<p>Dans le 2me exemple, le bouton <strong>Recharger</strong> permet de lire
le document comme un document HTML au lieu de XHTML et donc viter de bloquer
sur le parseur XML.</p>
</div>

<p></p>
</body>
</html>
