////////////////////////////////////////////////////////////////////////////////
/// Name:         Main wxBase App
///
/// Purpose:      aMule ed2k link creator
///
/// Author:       ThePolish <thepolish@vipmail.ru>
///
/// Copyright (C) 2004 by ThePolish
///
/// This program is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// This program is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with this program; if not, write to the
/// Free Software Foundation, Inc.,
/// 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
////////////////////////////////////////////////////////////////////////////////

#ifndef _ALCC_H
#define _ALCC_H


#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include <wx/cmdline.h>

// ADUNANZA BEGIN
// #include <wx/chartype.h> // Needed for macro wxS
// ADUNANZA END

//-----------------------------------------------------------------------------
// This can be put in a separete include file
#include <wx/strconv.h>
static wxCSConv aMuleConv(wxT("iso8859-1"));
#ifdef wxUSE_UNICODE
        #define unicode2char(x) (const char*) aMuleConv.cWX2MB(x)
        #define char2unicode(x) aMuleConv.cMB2WX(x)
#else
        #define unicode2char(x) x.c_str()
        #define char2unicode(x) x
#endif
//-----------------------------------------------------------------------------

/// Command line parameters
static const wxCmdLineEntryDesc cmdLineDesc[] =
  {
// ADUNANZA BEGIN
// Per wxWidgets 2.9.x e Snow Leopard
#if 0
    {
      wxCMD_LINE_SWITCH, wxT("h"), wxT("help"), wxT("show this help message"), wxCMD_LINE_VAL_NONE, wxCMD_LINE_OPTION_HELP
    },
    { wxCMD_LINE_SWITCH, wxT("v"), wxT("verbose"), wxT("be verbose"), wxCMD_LINE_VAL_NONE, wxCMD_LINE_PARAM_OPTIONAL},

    { wxCMD_LINE_SWITCH, wxT("p"), wxT("parthashes"), wxT("add part-hashes to ed2k link"), wxCMD_LINE_VAL_NONE,wxCMD_LINE_PARAM_OPTIONAL },

    { wxCMD_LINE_PARAM,  NULL, NULL, wxT("input files"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_MULTIPLE },
#else
// La macro wxS esiste a partire da wxWidgets 2.8.8
// Se avete wxWidgets <= 2.8.8 e' meglio che aggiorniate!
#if wxCHECK_VERSION(2, 8, 8)
    {
      wxCMD_LINE_SWITCH, wxS("h"), wxS("help"), wxS("show this help message"), wxCMD_LINE_VAL_NONE, wxCMD_LINE_OPTION_HELP
    },
    { wxCMD_LINE_SWITCH, wxS("v"), wxS("verbose"), wxS("be verbose"), wxCMD_LINE_VAL_NONE, wxCMD_LINE_PARAM_OPTIONAL},

    { wxCMD_LINE_SWITCH, wxS("p"), wxS("parthashes"), wxS("add part-hashes to ed2k link"), wxCMD_LINE_VAL_NONE,wxCMD_LINE_PARAM_OPTIONAL },

    { wxCMD_LINE_PARAM,  NULL, NULL, wxS("input files"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_MULTIPLE },
#else
#warning You are using a outdated version of wxWidgets, please upgrade at least to version 2.8.8
    {
      wxCMD_LINE_SWITCH, wxT("h"), wxT("help"), wxT("show this help message"), wxCMD_LINE_VAL_NONE, wxCMD_LINE_OPTION_HELP
    },
    { wxCMD_LINE_SWITCH, wxT("v"), wxT("verbose"), wxT("be verbose"), wxCMD_LINE_VAL_NONE, wxCMD_LINE_PARAM_OPTIONAL},

    { wxCMD_LINE_SWITCH, wxT("p"), wxT("parthashes"), wxT("add part-hashes to ed2k link"), wxCMD_LINE_VAL_NONE,wxCMD_LINE_PARAM_OPTIONAL },

    { wxCMD_LINE_PARAM,  NULL, NULL, wxT("input files"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_MULTIPLE },
#endif

#endif
// ADUNANZA END

    { wxCMD_LINE_NONE, NULL, NULL, NULL, wxCMD_LINE_VAL_NONE, 0 }
  };


// Application
class alcc : public wxAppConsole
{
  private:
    bool m_flagVerbose ;
    bool m_flagPartHashes;
    wxArrayString m_filesToHash;

    /// Parse command line
    virtual void OnInitCmdLine(wxCmdLineParser& cmdline);

    /// Command line preocessing
    virtual bool OnCmdLineParsed(wxCmdLineParser& cmdline);
    
  protected:
    wxLocale m_locale; // Used to tell wxCas to use aMule catalog
    
  public:
    /// Application
    virtual int OnRun ();
    
    /// Cleaning on exit
    virtual int OnExit();
};

DECLARE_APP(alcc)

#endif /* _ALCC_H */

// File_checked_for_headers
