/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-document-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-document-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_document_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-document-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_document_manager_add_buffer:
* @obj: Self
* @name: fixme
* @content: fixme
* @err: Error propagation and reporting.
* 
* New editor buffer
*/
IAnjutaEditor*
ianjuta_document_manager_add_buffer (IAnjutaDocumentManager *obj, const gchar *name, const gchar* content, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->add_buffer (obj, name, content, err);
}

/**
* ianjuta_document_manager_find_editor_with_path:
* @obj: Self
* @file_path: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
IAnjutaEditor*
ianjuta_document_manager_find_editor_with_path (IAnjutaDocumentManager *obj, const gchar *file_path, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->find_editor_with_path (obj, file_path, err);
}

/**
* ianjuta_document_manager_get_current_editor:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
IAnjutaEditor*
ianjuta_document_manager_get_current_editor (IAnjutaDocumentManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->get_current_editor (obj, err);
}

/**
* ianjuta_document_manager_get_editors:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
GList*
ianjuta_document_manager_get_editors (IAnjutaDocumentManager *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->get_editors (obj, err);
}

/**
* ianjuta_document_manager_get_full_filename:
* @obj: Self
* @file: fixme
* @err: Error propagation and reporting.
* 
* fixme.
*/
const gchar *
ianjuta_document_manager_get_full_filename (IAnjutaDocumentManager *obj, const gchar *file, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj), NULL);
	g_return_val_if_fail (file != NULL, NULL);
	return IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->get_full_filename (obj, file, err);
}

/**
* ianjuta_document_manager_goto_file_line:
* @obj: Self
* @file: fixme
* @lineno: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_document_manager_goto_file_line (IAnjutaDocumentManager *obj, const gchar *file, gint lineno, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj));
	g_return_if_fail (file != NULL);
	IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->goto_file_line (obj, file, lineno, err);
}

/** 
* ianjuta_document_manager_goto_file_line_mark:
* @obj: Self
* @file: fixme
* @lineno: fixme
* @mark: fixme
* @err: Error propagation and reporting
* 
* fixme
*/
void
ianjuta_document_manager_goto_file_line_mark (IAnjutaDocumentManager *obj, const gchar *file, gint lineno, gboolean mark, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj));
	g_return_if_fail (file != NULL);
	IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->goto_file_line_mark (obj, file, lineno, mark, err);
}

/** 
* ianjuta_document_manager_set_current_editor:
* @obj: Self
* @editor: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_document_manager_set_current_editor (IAnjutaDocumentManager *obj, IAnjutaEditor *editor, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT_MANAGER(obj));
	g_return_if_fail (IANJUTA_IS_EDITOR(editor));
	IANJUTA_DOCUMENT_MANAGER_GET_IFACE (obj)->set_current_editor (obj, editor, err);
}

static void
ianjuta_document_manager_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_document_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDocumentManagerIface),
			ianjuta_document_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDocumentManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_document_manager_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_DOCUMENT_MANAGER_DOESNT_EXIST, "IANJUTA_DOCUMENT_MANAGER_DOESNT_EXIST", "doesnt-exist" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaDocumentManagerError", values);
	}

	return type;
}
