/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-iterable.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-iterable.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_iterable_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-iterable-quark");
	}
	
	return quark;
}

/**
* ianjuta_iterable_first:
* @obj: Self
* @err: Error propagation and reporting
*
* Set iter to first element position. Returns FALSE if
* there is no element in the iterable (hence does not have last).
*
* Returns: TRUE if sucessful, other FALSE.
*/
gboolean
ianjuta_iterable_first (IAnjutaIterable *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), FALSE);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->first (obj, err);
}

/**
* ianjuta_iterable_foreach:
* @obj: Self
* @callback: Callback to call for each element.
* @user_data: user data that is passed back to the callback.
* @err: Error propagation and reporting
*
* Call callback for each element.
*/
void
ianjuta_iterable_foreach (IAnjutaIterable *obj, GFunc callback, gpointer user_data, GError **err)
{
	g_return_if_fail (IANJUTA_IS_ITERABLE(obj));
	g_return_if_fail (user_data != NULL);
	IANJUTA_ITERABLE_GET_IFACE (obj)->foreach (obj, callback, user_data, err);
}

/**
* ianjuta_iterable_get:
* @obj: Self
* @data_type: Data type of the value being retrieved.
* @err: Error propagation and reporting
* 
* Gets the value at current iter position.
* Interpretation of 'data' really depends on implementation and is of
* type 'data_type'. get_nth() gets the element at given position without
* altering the position of current iter.
*
* Returns: The data at current iter position.
*/
gpointer
ianjuta_iterable_get (IAnjutaIterable *obj, GType data_type, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), NULL);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->get (obj, data_type, err);
}

/**
* ianjuta_iterable_get_length:
* @obj: Self
* @err: Error propagation and reporting
* 
* Length of the iterable
*
* Returns: total lenght of the list.
*/
gint
ianjuta_iterable_get_length (IAnjutaIterable *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), -1);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->get_length (obj, err);
}

/**
* ianjuta_iterable_get_nth:
* @obj: Self
* @data_type: Data type of the value being retrieved.
* @position: Index of the iter.
* @err: Error propagation and reporting
* 
* Returns the nth element in the list.
*
* Returns: The data at nth position.
*/
gpointer
ianjuta_iterable_get_nth (IAnjutaIterable *obj, GType data_type, gint position, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), NULL);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->get_nth (obj, data_type, position, err);
}

/**
* ianjuta_iterable_get_position:
* @obj: Self
* @err: Error propagation and reporting
*
* Index of the current iter in the iterable
*
* Returns: integer index.
*/
gint
ianjuta_iterable_get_position (IAnjutaIterable *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), -1);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->get_position (obj, err);
}

/**
* ianjuta_iterable_get_settable:
* @obj: Self
* @err: Error propagation and reporting
* 
* If the iterable is settable.
* 
* Returns: TRUE if data can be set in this implementation.
*/
gboolean
ianjuta_iterable_get_settable (IAnjutaIterable *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), FALSE);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->get_settable (obj, err);
}

/**
* ianjuta_iterable_last:
* @obj: Self
* @err: Error propagation and reporting
* 
* Set iter position to last element position. Returns FALSE if
* there is no element in the iterable (hence does not have last).
*
* Returns: TRUE if sucessful, other FALSE.
*/
gboolean
ianjuta_iterable_last (IAnjutaIterable *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), FALSE);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->last (obj, err);
}

/**
* ianjuta_iterable_next:
* @obj: Self
* @err: Error propagation and reporting
*
* Set the iter position to next element position. Returns FALSE if there
* is no next element.
*
* Returns: TRUE if sucessful, other FALSE..
*/
gboolean
ianjuta_iterable_next (IAnjutaIterable *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), FALSE);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->next (obj, err);
}

/**
* ianjuta_iterable_previous:
* @obj: Self
* @err: Error propagation and reporting
* 
* Set the iter position to previous element position. Returns FALSE if
* there is no previous element.
*
* Returns: TRUE if sucessful, other FALSE.
*/
gboolean
ianjuta_iterable_previous (IAnjutaIterable *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE(obj), FALSE);
	return IANJUTA_ITERABLE_GET_IFACE (obj)->previous (obj, err);
}

/**
* ianjuta_iterable_set:
* @obj: Self
* @data_type: Data type of the value being set.
* @data: The data being set.
* @err: Error propagation and reporting
* 
* Sets the value at current iter position. The iterable be be settable.
* Interpretation of 'data' really depends on implementation. The data
* must be of type 'data_type'.
*/
void
ianjuta_iterable_set (IAnjutaIterable *obj, GType data_type, gpointer data, GError **err)
{
	g_return_if_fail (IANJUTA_IS_ITERABLE(obj));
	g_return_if_fail (data != NULL);
	IANJUTA_ITERABLE_GET_IFACE (obj)->set (obj, data_type, data, err);
}

/** 
* ianjuta_iterable_set_nth:
* @obj: Self
* @data_type: Data type of the value being set.
* @data: The data being set.
* @position: element position where data is set.
* @err: Error propagation and reporting
* 
* Sets the @data at given @position. Current iter position is not altered.
*/
void
ianjuta_iterable_set_nth (IAnjutaIterable *obj, GType data_type, gpointer data, gint position, GError **err)
{
	g_return_if_fail (IANJUTA_IS_ITERABLE(obj));
	g_return_if_fail (data != NULL);
	IANJUTA_ITERABLE_GET_IFACE (obj)->set_nth (obj, data_type, data, position, err);
}

static void
ianjuta_iterable_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_iterable_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaIterableIface),
			ianjuta_iterable_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaIterable", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
