#!/bin/bash

function anjuta_tags {

    FILES=""
    BASEDIR=`pwd`
    PROGDIR=. # `dirname $0`
    CFLAGS=""
    ANJUTA_TAGS_BIN="/usr/local/share/anjuta/scripts/anjuta-tags"
    OUTPUT_FILE=$1
    shift
    
    if [ -x "$ANJUTA_TAGS_BIN" ]
	then
	for cflag in $*
	  do
	  infile=`echo $cflag | sed 's/^-I//'`
	  if [ -d "$infile" -a "$infile" != "/usr/include" -a "$infile" != "/usr/local/include" ]
	      then
	      FILES="$FILES \"$infile/*.h\" \"$infile/*/*.h\" \"$infile/*/*/*.h\""
	  elif [ ! -d "$infile" -a -e "$infile" ]
	      then
	      FILES="$FILES $infile"
	  fi
	done
    else
	echo "Can not execute $ANJUTA_TAGS_BIN"
	exit 1
    fi
    CFLAGS="$CFLAGS $*"
    export CFLAGS
    
    FILES_COUNT=`echo $FILES | wc -w`
    
    echo "Creating $OUTPUT_FILE"
    echo "Number of files to scan: $FILES_COUNT"
    echo "Files to scan: $FILES"
    
    if [ $FILES_COUNT -gt 0 ] ; then
	rm -f $OUTPUT_FILE
	$ANJUTA_TAGS_BIN $OUTPUT_FILE $FILES >"$OUTPUT_FILE.log" 2>&1
	
    # If global tags file could not be generated
	if [ ! -e $OUTPUT_FILE ] ; then
	    echo "WARNING: Could not create tags file $OUTPUT_FILE!" >&2
	else
	    gzip -f $OUTPUT_FILE
	fi
    fi
}

## FILES="\"/usr/include/*.h\" \"/usr/local/include/*.h\""
FILES=""
BASEDIR=`pwd`
PROGDIR=. # `dirname $0`
CFLAGS=""

echo "Generating System tags..."

mkdir -p "$HOME/.anjuta/tags"

# pkg-config libraries
PKG_CONFIG=`which pkg-config 2>/dev/null`
if ( [ ! -z $PKG_CONFIG ] && [ -x $PKG_CONFIG ] ) ; then
    ##
	## We are scaning .pc files directly because --cflags option
	## produces include paths and flags for other packages depended by
	## the packages, which we don't like. We only want cflags relevent
	## to the packages alone.
	##
    PKG_DEFAULT_CONFIG_PATH=`echo $PKG_CONFIG | sed -e 's/\/bin\/pkg-config/\/lib\/pkgconfig'/`
    PKG_CONFIG_PATH="$PKG_CONFIG_PATH:$PKG_DEFAULT_CONFIG_PATH"
    PKG_DEFAULT_CONFIG_PATH=`echo $PKG_CONFIG | sed -e 's/\/bin\/pkg-config/\/lib64\/pkgconfig'/`
    PKG_CONFIG_PATH="$PKG_CONFIG_PATH:$PKG_DEFAULT_CONFIG_PATH"
	
    PKG_CONFIG_PATH_PROPER=`echo $PKG_CONFIG_PATH | sed -e 's/\:/ /g'`

    pkg_files_count=0
    for pkg_path in $PKG_CONFIG_PATH_PROPER; do
	for pkg_file in `find "$pkg_path" -name '*.pc' 2>/dev/null`; do
	    pkg_files_count=`expr $pkg_files_count + 1`
	done
    done

    ## This line is important for the progress bar. Don't change it.
    echo "Scanning $pkg_files_count packages"

    for pkg_path in $PKG_CONFIG_PATH_PROPER; do
	for pkg_file in `find "$pkg_path" -name '*.pc' 2>/dev/null`; do
		# echo "Scanning package: $pkg_file"
	    PKG_CFLAGS=`grep -e '^\(\w\+=\|\s*Cflags:\)' "$pkg_file"|sed -e 's/Cflags:\s*"\?\(.*\)"\?\s*/echo "\1"/' -e 's/^\(\w\+\)=\("\([^"]*\)"\|\(.*\)\)/\1="\3\4"/'|sh`
		# echo $PKG_CFLAGS
	    package=`basename "$pkg_file" '.pc'`
	    # if [ ! -e $BASEDIR/tags/$package.anjutatags.gz ] ; then
		echo "Creating tags file: $HOME/.anjuta/tags/$package.anjutatags.gz ..."
		anjuta_tags "$HOME/.anjuta/tags/$package.anjutatags" $PKG_CFLAGS > /dev/null
	    # fi
	done
    done
	echo "Done"
    echo "This is just a timestamp" > $HOME/.anjuta/system-tags.cache
fi
