/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-symbol
 * @title: IAnjutaSymbol
 * @short_description: Source code symbol interface
 * @see_also: #IAnjutaSymbolQuery, #IAnjutaSymbolManager
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-symbol.h
 *
 * This interface is used to define a symbol, normally got from symbol
 * queries. A symbol has various fields that can be retrieved by using
 * their get methods. A symbol will have only those fields which have
 * been selected to be included in their respective queries, so make sure
 * the needed fields are correctly specified during query creation.
 */

#include "ianjuta-symbol.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_symbol_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-symbol-quark");
	}
	
	return quark;
}

/**
 * ianjuta_symbol_get_boolean:
 * @obj: Self
 * @field: The field to retrieve.
 * @err: Error propagation and reporting.
 *
 * Retreives the boolean value of a boolean @field.
 *
 * Returns: The boolean
 */
gboolean
ianjuta_symbol_get_boolean (IAnjutaSymbol *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), FALSE);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_boolean (obj, field, err);
}

/* Default implementation */
static gboolean
ianjuta_symbol_get_boolean_default (IAnjutaSymbol *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_symbol_get_file:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * A convenience method to get GFile object for
 * #IANJUTA_SYMBOL_FIELD_FILE_PATH field. The file where the
 * symbol is declared. It contains the absolute path of the file
 * unlike raw value of field #IANJUTA_SYMBOL_FIELD_FILE_PATH.
 *
 * Returns: A GFile object. It must be unrefed after use.
 */
GFile*
ianjuta_symbol_get_file (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_file (obj, err);
}

/* Default implementation */
static GFile*
ianjuta_symbol_get_file_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_get_icon:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * A convenience method to get a small icon (16x16) representing the symbol
 * kind. You *need* a query with fields #IANJUTA_SYMBOL_FIELD_ACCESS and
 * #IANJUTA_SYMBOL_FIELD_KIND selected.
 *
 * Returns: a Pixbuf icon representing the symbol. Ref the icon if you
 * need to keep it.
 */
const GdkPixbuf *
ianjuta_symbol_get_icon (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_icon (obj, err);
}

/* Default implementation */
static const GdkPixbuf *
ianjuta_symbol_get_icon_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_get_int:
 * @obj: Self
 * @field: The field to retrieve.
 * @err: Error propagation and reporting.
 *
 * Retreives the integer value of an integer @field.
 *
 * Returns: The integer
 */
gint
ianjuta_symbol_get_int (IAnjutaSymbol *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), -1);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_int (obj, field, err);
}

/* Default implementation */
static gint
ianjuta_symbol_get_int_default (IAnjutaSymbol *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
 * ianjuta_symbol_get_string:
 * @obj: Self
 * @field: The field to retrieve.
 * @err: Error propagation and reporting.
 *
 * Retreives the string value of a string @field.
 *
 * Returns: The string
 */
const gchar*
ianjuta_symbol_get_string (IAnjutaSymbol *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_string (obj, field, err);
}

/* Default implementation */
static const gchar*
ianjuta_symbol_get_string_default (IAnjutaSymbol *obj, IAnjutaSymbolField field, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_get_sym_type:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * A convenience method to get value of #IANJUTA_SYMBOL_FIELD_TYPE
 * field typecasted to IAnjutaSymbolType. Numerical value is unchanged.
 *
 * Returns: a #IAnjutaSymbolType
 */
IAnjutaSymbolType
ianjuta_symbol_get_sym_type (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), 0);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_sym_type (obj, err);
}

/* Default implementation */
static IAnjutaSymbolType
ianjuta_symbol_get_sym_type_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (0);
}

static void
ianjuta_symbol_base_init (IAnjutaSymbolIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_boolean = ianjuta_symbol_get_boolean_default;
	klass->get_file = ianjuta_symbol_get_file_default;
	klass->get_icon = ianjuta_symbol_get_icon_default;
	klass->get_int = ianjuta_symbol_get_int_default;
	klass->get_string = ianjuta_symbol_get_string_default;
	klass->get_sym_type = ianjuta_symbol_get_sym_type_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_symbol_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSymbolIface),
			(GBaseInitFunc) ianjuta_symbol_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSymbol", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_symbol_field_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_FIELD_ID, "IANJUTA_SYMBOL_FIELD_ID", "field-id" }, 
		{ IANJUTA_SYMBOL_FIELD_NAME, "IANJUTA_SYMBOL_FIELD_NAME", "field-name" }, 
		{ IANJUTA_SYMBOL_FIELD_FILE_POS, "IANJUTA_SYMBOL_FIELD_FILE_POS", "field-file-pos" }, 
		{ IANJUTA_SYMBOL_FILED_SCOPE_DEF_ID, "IANJUTA_SYMBOL_FILED_SCOPE_DEF_ID", "filed-scope-def-id" }, 
		{ IANJUTA_SYMBOL_FIELD_FILE_SCOPE, "IANJUTA_SYMBOL_FIELD_FILE_SCOPE", "field-file-scope" }, 
		{ IANJUTA_SYMBOL_FIELD_SIGNATURE, "IANJUTA_SYMBOL_FIELD_SIGNATURE", "field-signature" }, 
		{ IANJUTA_SYMBOL_FIELD_RETURNTYPE, "IANJUTA_SYMBOL_FIELD_RETURNTYPE", "field-returntype" }, 
		{ IANJUTA_SYMBOL_FIELD_TYPE, "IANJUTA_SYMBOL_FIELD_TYPE", "field-type" }, 
		{ IANJUTA_SYMBOL_FIELD_TYPE_NAME, "IANJUTA_SYMBOL_FIELD_TYPE_NAME", "field-type-name" }, 
		{ IANJUTA_SYMBOL_FIELD_FILE_PATH, "IANJUTA_SYMBOL_FIELD_FILE_PATH", "field-file-path" }, 
		{ IANJUTA_SYMBOL_FIELD_PROJECT_NAME, "IANJUTA_SYMBOL_FIELD_PROJECT_NAME", "field-project-name" }, 
		{ IANJUTA_SYMBOL_FIELD_PROJECT_VERSION, "IANJUTA_SYMBOL_FIELD_PROJECT_VERSION", "field-project-version" }, 
		{ IANJUTA_SYMBOL_FIELD_IMPLEMENTATION, "IANJUTA_SYMBOL_FIELD_IMPLEMENTATION", "field-implementation" }, 
		{ IANJUTA_SYMBOL_FIELD_ACCESS, "IANJUTA_SYMBOL_FIELD_ACCESS", "field-access" }, 
		{ IANJUTA_SYMBOL_FIELD_KIND, "IANJUTA_SYMBOL_FIELD_KIND", "field-kind" }, 
		{ IANJUTA_SYMBOL_FIELD_IS_CONTAINER, "IANJUTA_SYMBOL_FIELD_IS_CONTAINER", "field-is-container" }, 
		{ IANJUTA_SYMBOL_FIELD_END, "IANJUTA_SYMBOL_FIELD_END", "field-end" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolField", values);
	}

	return type;
}

GType
ianjuta_symbol_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_TYPE_NONE, "IANJUTA_SYMBOL_TYPE_NONE", "type-none" }, 
		{ IANJUTA_SYMBOL_TYPE_UNDEF, "IANJUTA_SYMBOL_TYPE_UNDEF", "type-undef" }, 
		{ IANJUTA_SYMBOL_TYPE_CLASS, "IANJUTA_SYMBOL_TYPE_CLASS", "type-class" }, 
		{ IANJUTA_SYMBOL_TYPE_ENUM, "IANJUTA_SYMBOL_TYPE_ENUM", "type-enum" }, 
		{ IANJUTA_SYMBOL_TYPE_ENUMERATOR, "IANJUTA_SYMBOL_TYPE_ENUMERATOR", "type-enumerator" }, 
		{ IANJUTA_SYMBOL_TYPE_FIELD, "IANJUTA_SYMBOL_TYPE_FIELD", "type-field" }, 
		{ IANJUTA_SYMBOL_TYPE_FUNCTION, "IANJUTA_SYMBOL_TYPE_FUNCTION", "type-function" }, 
		{ IANJUTA_SYMBOL_TYPE_INTERFACE, "IANJUTA_SYMBOL_TYPE_INTERFACE", "type-interface" }, 
		{ IANJUTA_SYMBOL_TYPE_MEMBER, "IANJUTA_SYMBOL_TYPE_MEMBER", "type-member" }, 
		{ IANJUTA_SYMBOL_TYPE_METHOD, "IANJUTA_SYMBOL_TYPE_METHOD", "type-method" }, 
		{ IANJUTA_SYMBOL_TYPE_NAMESPACE, "IANJUTA_SYMBOL_TYPE_NAMESPACE", "type-namespace" }, 
		{ IANJUTA_SYMBOL_TYPE_PACKAGE, "IANJUTA_SYMBOL_TYPE_PACKAGE", "type-package" }, 
		{ IANJUTA_SYMBOL_TYPE_PROTOTYPE, "IANJUTA_SYMBOL_TYPE_PROTOTYPE", "type-prototype" }, 
		{ IANJUTA_SYMBOL_TYPE_STRUCT, "IANJUTA_SYMBOL_TYPE_STRUCT", "type-struct" }, 
		{ IANJUTA_SYMBOL_TYPE_TYPEDEF, "IANJUTA_SYMBOL_TYPE_TYPEDEF", "type-typedef" }, 
		{ IANJUTA_SYMBOL_TYPE_UNION, "IANJUTA_SYMBOL_TYPE_UNION", "type-union" }, 
		{ IANJUTA_SYMBOL_TYPE_VARIABLE, "IANJUTA_SYMBOL_TYPE_VARIABLE", "type-variable" }, 
		{ IANJUTA_SYMBOL_TYPE_EXTERNVAR, "IANJUTA_SYMBOL_TYPE_EXTERNVAR", "type-externvar" }, 
		{ IANJUTA_SYMBOL_TYPE_MACRO, "IANJUTA_SYMBOL_TYPE_MACRO", "type-macro" }, 
		{ IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG, "IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG", "type-macro-with-arg" }, 
		{ IANJUTA_SYMBOL_TYPE_FILE, "IANJUTA_SYMBOL_TYPE_FILE", "type-file" }, 
		{ IANJUTA_SYMBOL_TYPE_OTHER, "IANJUTA_SYMBOL_TYPE_OTHER", "type-other" }, 
		{ IANJUTA_SYMBOL_TYPE_SCOPE_CONTAINER, "IANJUTA_SYMBOL_TYPE_SCOPE_CONTAINER", "type-scope-container" }, 
		{ IANJUTA_SYMBOL_TYPE_MAX, "IANJUTA_SYMBOL_TYPE_MAX", "type-max" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolType", values);
	}

	return type;
}
