/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-vcs.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-vcs
 * @title: IAnjutaVcs
 * @short_description: Version control system interface
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-vcs.h
 *
 */

#include "ianjuta-vcs.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_vcs_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-vcs-quark");
	}
	
	return quark;
}

/**
 * ianjuta_vcs_add:
 * @obj: Self
 * @files: (element-type GFile): List of List of files, represented as #Gfile objects, to add
 * @notify: #AnjutaAsyncNotify object for finish notification and error
 * reporting.
 *
 * Add files to the VCS repository.
 */
void
ianjuta_vcs_add (IAnjutaVcs *obj, GList* files,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail ((notify == NULL) ||ANJUTA_IS_ASYNC_NOTIFY(notify));
	IANJUTA_VCS_GET_IFACE (obj)->add (obj, files, notify, err);
}

/* Default implementation */
static void
ianjuta_vcs_add_default (IAnjutaVcs *obj, GList* files,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_vcs_checkout:
 * @obj: Self
 * @repository_location: Location of repository to check out
 * @dest: Destination of checked out copy
 * @cancel: An optional #GCancellable object to cancel the operation, or NULL
 * @notify: #AnjutaAsyncNotify object for finish notification and error
 * reporting.
 *
 * Check out a copy of a code repository.
 */
void
ianjuta_vcs_checkout (IAnjutaVcs *obj, const gchar *repository_location,   GFile *dest,   GCancellable *cancel,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail ((notify == NULL) ||ANJUTA_IS_ASYNC_NOTIFY(notify));
	IANJUTA_VCS_GET_IFACE (obj)->checkout (obj, repository_location, dest, cancel, notify, err);
}

/* Default implementation */
static void
ianjuta_vcs_checkout_default (IAnjutaVcs *obj, const gchar *repository_location,   GFile *dest,   GCancellable *cancel,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_reached ();
}

    /**
     * ianjuta_vcs_diff:
     * @obj: Self
     * @file: File to diff
     * @callback: Callback to call when diff data becomes available
     * @user_data: User data passed to @callback
     * @cancel: An optional #GCancellable object to cancel the operation, or NULL
     * @notify: #AnjutaAsyncNotify object for finish notification and error
 * reporting.
     *
     * Generates a unified diff of the file represented by @file.
     */
void
ianjuta_vcs_diff (IAnjutaVcs *obj, GFile* file,   IAnjutaVcsDiffCallback callback,   gpointer user_data,   GCancellable* cancel,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail (user_data != NULL);
	g_return_if_fail ((notify == NULL) ||ANJUTA_IS_ASYNC_NOTIFY(notify));
	IANJUTA_VCS_GET_IFACE (obj)->diff (obj, file, callback, user_data, cancel, notify, err);
}

/* Default implementation */
static void
ianjuta_vcs_diff_default (IAnjutaVcs *obj, GFile* file,   IAnjutaVcsDiffCallback callback,   gpointer user_data,   GCancellable* cancel,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_reached ();
}

    /**
 * ianjuta_vcs_query_status:
 * @obj: Self
 * @file: File/directory to query
 * @callback: callback to call when data for a particular file is available
 * @user_data: User data passed to callback
 * @cancel: An optional #GCancellable object to cancel the operation, or NULL
 * @notify: #AnjutaAsyncNotify object for finish notification and error
 * reporting.
 *
 * Querys the status of files in the repository.
 */
void
ianjuta_vcs_query_status (IAnjutaVcs *obj, GFile* file,   IAnjutaVcsStatusCallback callback,   gpointer user_data,   GCancellable* cancel,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail (user_data != NULL);
	g_return_if_fail ((notify == NULL) ||ANJUTA_IS_ASYNC_NOTIFY(notify));
	IANJUTA_VCS_GET_IFACE (obj)->query_status (obj, file, callback, user_data, cancel, notify, err);
}

/* Default implementation */
static void
ianjuta_vcs_query_status_default (IAnjutaVcs *obj, GFile* file,   IAnjutaVcsStatusCallback callback,   gpointer user_data,   GCancellable* cancel,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_vcs_remove:
 * @obj: Self
 * @files: (element-type GFile): List of files, represented as #Gfile objects, to remove
 * @notify: #AnjutaAsyncNotify object for finish notification and error
 * reporting.
 *
 * Remove files from the VCS repository.
 */
void
ianjuta_vcs_remove (IAnjutaVcs *obj, GList* files,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_fail (IANJUTA_IS_VCS(obj));
	g_return_if_fail ((notify == NULL) ||ANJUTA_IS_ASYNC_NOTIFY(notify));
	IANJUTA_VCS_GET_IFACE (obj)->remove (obj, files, notify, err);
}

/* Default implementation */
static void
ianjuta_vcs_remove_default (IAnjutaVcs *obj, GList* files,   AnjutaAsyncNotify *notify, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_vcs_base_init (IAnjutaVcsIface* klass)
{
	static gboolean initialized = FALSE;

	klass->add = ianjuta_vcs_add_default;
	klass->checkout = ianjuta_vcs_checkout_default;
	klass->diff = ianjuta_vcs_diff_default;
	klass->query_status = ianjuta_vcs_query_status_default;
	klass->remove = ianjuta_vcs_remove_default;
	
	if (!initialized) {

		/**
		 * IAnjutaVcsStatus
		 * @obj: Self
		 	 *
		 	 * This signal is emited when the git pull command is finished, and refreshes the tree of files with the new pulled files without the need to
		 	 * fold- unfold the tree.
		 */
		g_signal_new ("status-changed",
			IANJUTA_TYPE_VCS,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaVcsIface, status_changed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		initialized = TRUE;
	}
}

GType
ianjuta_vcs_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaVcsIface),
			(GBaseInitFunc) ianjuta_vcs_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaVcs", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_vcs_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_VCS_UNKOWN_ERROR, "IANJUTA_VCS_UNKOWN_ERROR", "unkown-error" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaVcsError", values);
	}

	return type;
}
