// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef ANALYSEPLUGIN_H
#define ANALYSEPLUGIN_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "plugin.h"

/** This Plugin controls the execution of every analysis.
  *@author Tobias Erbsland
  */
class analysePlugin : public Plugin
{
private:
	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	bool execPlugin( ps_e ( Plugin::*fp ) ( Analyse * ), pa_e pa, const std::string &name, Analyse * ap );

public:
	analysePlugin();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual int pa( void ) { return PA_BEFORE_PARAM | PA_INIT | PA_ANALYSE; };

	virtual void beforeParam( void );

	virtual ps_e init( void ) { return PS_ENABLE; };

	virtual ps_e analyse( void );

	~analysePlugin();
};

#endif
