// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "mtanalyse.h"
#include <iostream>

mtAnalyse::mtAnalyse() :
		strPrefix( "mt" ),
		strName( "Mailcount To someone" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Create statistics how many mails received." )
{
	addParam( "limit", "Limit Output to n Lines.", "Integer from 1 to x.", G_STRING, "25" );
	addParam( "no-delivery", "Statistic with not delivered mail",
	          "If set, not delivered mails are included.", G_FLAG, "0" );
	addParam( "only-no-delivery", "Statistic ONLY with not delivered mail",
	          "If set, ONLY not delivered mails are included.", G_FLAG, "0" );
}

void mtAnalyse::run( std::map< std::string, unity_t > * unity_map )
{
	bool not_del = false;
	bool del = true;

	std::map< std::string, long > mailc_2l_c;
	std::map< std::string, long > mailc_2e_c;

	std::map< std::string, unity_t >::iterator i;
	std::list< std::string >::iterator m;
	std::map< std::string, long >::iterator j;

	if ( getFlagParam( "no-delivery" ) ) not_del = true; // Auch falsche;
	if ( getFlagParam( "only-no-delivery" ) )  // Hat auch vorrang.
	{
		not_del = true;
		del = false;
	};

	for ( i = unity_map->begin(); i != unity_map->end(); i++ )
	{
		// Nichtzugestellte oder zugestellte Mails aus statistik entfernen.
		if ( !not_del && ( i->second.to_intern.size() + i->second.to_extern.size() == 0 ) ) continue;
		if ( !del && ( i->second.to_intern.size() + i->second.to_extern.size() != 0 ) ) continue;

		// Belastung fuer User rechnen, duch addieres der mailgroesse zu den
		// empfaengerkonten.
		for ( m = i->second.to_intern.begin(); m != i->second.to_intern.end(); m++ )
		{
			mailc_2l_c[ *m ] ++; // Zaehlen.
			// Calculate only traffic from external users.
			if ( i->second.from.find( "@" ) != std::string::npos )
				mailc_e2l_c[ *m ] ++;
			else
				mailc_l2l_c[ *m ] ++;
		}
		for ( m = i->second.to_extern.begin(); m != i->second.to_extern.end(); m++ )
			mailc_2e_c[ *m ] ++; // Zaehlen.
	}
	// Temp map umrechnen.
	for ( j = mailc_2l_c.begin(); j != mailc_2l_c.end(); j++ )
		mailc_2l.insert( std::make_pair( j->second, j->first ) );
	for ( j = mailc_2e_c.begin(); j != mailc_2e_c.end(); j++ )
		mailc_2e.insert( std::make_pair( j->second, j->first ) );
}

void mtAnalyse::print( void )
{
	if ( !report ) return ; // be sure :-)

	int limit = getIntParam( "limit" );

	std::multimap< long, std::string >::reverse_iterator j, k;

	report->startNewReport( "Mailcount To someone - received mails", Report::TABLE );
	report->addCol( 4, Report::COUNTER, Report::RIGHT, "nr", Report::NONE );
	// -1 = soviel platz verwenden, wie noch vorhanden.
	report->addCol( 16, Report::STRING, Report::LEFT, "to local", Report::NONE );
	report->addCol( 6, Report::INTEGER, Report::RIGHT, "ext.", Report::ROUND );
	report->addCol( 6, Report::INTEGER, Report::RIGHT, "int.", Report::ROUND );
	report->addCol( 5, Report::INTEGER, Report::RIGHT, "total", Report::NONE, Report::SUM );
	report->addCol( -1, Report::STRING, Report::LEFT, "to external", Report::NONE );
	report->addCol( 6, Report::INTEGER, Report::RIGHT, "total", Report::NONE, Report::SUM );
	report->printHeader();
	j = mailc_2l.rbegin();
	k = mailc_2e.rbegin();

	while ( ( j != mailc_2l.rend() || k != mailc_2e.rend() ) && ( limit-- > 0 ) )
	{
		if ( j != mailc_2l.rend() )
		{
			report->printField( j->second );
			report->printField( mailc_e2l_c[ j->second ] );
			report->printField( mailc_l2l_c[ j->second ] );
			report->printField( j->first );
			j++;
		}
		else
		{
			report->skipField();
			report->skipField();
			report->skipField();
			report->skipField();
		};
		if ( k != mailc_2e.rend() )
		{
			report->printField( k->second );
			report->printField( k->first );
			k++;
		}
		else
		{
			report->skipField();
			report->skipField();
		};
	}
	report->printFooter();
}

void mtAnalyse::free( void )
{
	mailc_2l.clear();
	mailc_2e.clear();
	mailc_l2l_c.clear();
	mailc_e2l_c.clear();
}
