/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**  Antenna Visualization Toolkit                                          **/
/**                                                                         **/
/**  Adrian Agogino  agogino@ece.utexas.edu                                 **/
/**  Ken Harker      kharker@cs.utexas.edu                                  **/
/**                                                                         **/
/**  May 1998                                                               **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include "MyTypes.h"
#include "TkAntenna.h"


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                            Global Variables                             **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


char *TKA_PrgName;  /* Name of the Program (= argv[0]) */


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                                 Init                                    **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


local int Init(Tcl_Interp *interp) {

  /* Initialize Tcl, Tk, Togl and the TkAntenna widget module. */
  if (Tcl_Init(interp) == TCL_ERROR)  return TCL_ERROR;
  if (Tk_Init(interp) == TCL_ERROR)   return TCL_ERROR;
  if (Togl_Init(interp) == TCL_ERROR) return TCL_ERROR;
  if (TKA_Init(interp) == TCL_ERROR)  return TCL_ERROR;
  return TCL_OK;

}  /**  End of Init  **/


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                                 Main                                    **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


int  main(int argc, char **argv) {

  TKA_PrgName = argv[0];
  Tk_Main(argc, argv, Init );
  return 0;

}  /**  End of main  **/


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                         End of TkAntenna.c                              **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


