/* Copyright (C) 2002, 2003, 2004, 2005, 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __XSLPARSEERROR_HPP
#define __XSLPARSEERROR_HPP

#include <boost/shared_ptr.hpp>
#include <iostream>
#include "error.hpp"

/** Exception for an error during applying a XSL-script
    @date Mon Sep 25 2006
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class XSLParseError: public Error {
public:
  /// Constructor.
  XSLParseError( const std::string &_xslScriptFileName,
                 const std::string &_message ):
    xslScriptFileName(_xslScriptFileName), message(_message) {}
  ///
  virtual ~XSLParseError(void) throw() {}
  ///
  const std::string &getXSLScriptFileName(void) const
    { return xslScriptFileName; }
  ///
  const std::string &getMessage(void) const
    { return message; }
protected:
  ///
  std::string xslScriptFileName;
  ///
  std::string message;
};

///
typedef boost::shared_ptr< XSLParseError > XSLParseErrorPtr;

#endif
