//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006-2011 Mikhail Fedotov <anyremote@mail.ru>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
//

#ifndef _UTILS_H
#define _UTILS_H

#include "parse.h"
#include <sys/types.h>
#include <pwd.h>

#define LOGFILE 	"/anyremote.log"

#define TIMER_RUN       1
#define TIMER_PAUSE     2
#define TIMER_CANCEL    3

#define CFG2(...)     sprintf(tmp,__VA_ARGS__);logger("CFG", tmp);
#define DEBUG2(...)   sprintf(tmp,__VA_ARGS__);logger("DBG", tmp);
#define ERROR2(...)   sprintf(tmp,__VA_ARGS__);logger("ERR", tmp);
#define INFO2(...)    sprintf(tmp,__VA_ARGS__);logger("INF", tmp);
#define WARNING2(...) sprintf(tmp,__VA_ARGS__);logger("WRN", tmp);

#define M_ABORT 	0
#define M_DISCONNECT 	1
#define M_DEV_DISCONN 	2

typedef struct TC
{	
	cmdItem *timer;
        
	int	ticks;
	int	times;
        
        int     status;
        
	struct TC  *next;
} timerCmd;

typedef struct VV
{	
	char *name;
	char *value;
	int  size;
	struct VV  *next;
} varData;

void        printHelp       (void);
void        printTime       (void);
void        printVars       (void);
void        initLog         (void);
void        logger          (char *head, char *str);

timerCmd*   createTimer     (cmdItem *ci);
timerCmd*   findTimer       (char *id, timerCmd **prev);
void        verifyTimers    (int ticksInSec);
void        cancelTimer     (char *id);
void        freeTimers      (void);

int         setVarSimple    (const char *name, const char *val);
int         setVar          (const char *name, const char *val, int size);
varData*    searchVar       (const char *id, int len);
void        freeVars        (void);

int         isDataNew       (int what, char *data, int size);
void        freeCachedData  (void);

int         flushData       (void);
void        flushOldConf    (void);

void        setCmdFiles     (void);
char*       getResFile      (void);
char*       getCmdFile      (void);

int         getUidGid       (char *username, uid_t *uid, gid_t *gid);

char* 	    getStoredPass   (void);
void 	    addInternalVars (void);

void  	    sendAbort       (void);
void        sendDisconnect  (void);

#endif
