#ifndef INDEXABLE_SET_H
#define INDEXABLE_SET_H

#include "imageset.h"

#include "../../msio/baselinereader.h"

#include <memory>
#include <string>

namespace rfiStrategy
{
	class IndexableSet : public ImageSet
	{
	public:
		virtual BaselineReaderPtr Reader() const = 0;
		virtual size_t GetAntenna1(const ImageSetIndex &index) const = 0;
		virtual size_t GetAntenna2(const ImageSetIndex &index) const = 0;
		virtual size_t GetBand(const ImageSetIndex &index) const = 0;
		virtual size_t GetField(const ImageSetIndex &index) const = 0;
		virtual size_t GetSequenceId(const ImageSetIndex &index) const = 0;
		virtual size_t AntennaCount() const = 0;
		virtual AntennaInfo GetAntennaInfo(unsigned antennaIndex) const = 0;
		virtual size_t BandCount() const = 0;
		virtual BandInfo GetBandInfo(unsigned bandIndex) const = 0;
		virtual size_t SequenceCount() const = 0;
		virtual ImageSetIndex Index(size_t antenna1, size_t antenna2, size_t bandIndex, size_t sequenceId) const = 0;
		virtual FieldInfo GetFieldInfo(unsigned fieldIndex) const = 0;

		virtual std::string TelescopeName() final override;
	};
}
	
inline std::string rfiStrategy::IndexableSet::TelescopeName()
{
	return Reader()->MetaData().TelescopeName();
}

#endif

