#ifndef _APACHETOP_H_
#define _APACHETOP_H_

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>

#if HAVE_STRINGS_H
# include <strings.h>
#endif

#include <fcntl.h>

#include <signal.h>

#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif

#if HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#if HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif

#if HAVE_NETDB_H
# include <netdb.h>
#endif

#if HAVE_PCRE_H
# include <pcre.h>
# include "pcre_cpp_wrapper.h"
#endif

#include <curses.h>

#include <readline/readline.h>
#include <readline/history.h>


#if HAVE_KQUEUE
# include <sys/event.h>
#endif

#if HAVE_PTHREAD
# include <pthread.h>
#endif

#define getMIN(a,b) (a < b ? a : b)
#define getMAX(a,b) (a > b ? a : b)

/* upon startup, each input file is put into an element of this array,
 * starting at 0. The struct under this maps the current fd into this array
 * so we can find it without iterating.
*/
struct input {
	char *filename;
	int fd;
	ino_t inode;
	short type; /* types defined in log.h */
	time_t lastreq;

	/* if open == false, then ApacheTop will periodically try to re-open
	 * this input file. */
	bool open; /* is the file open or not? */

	bool is_stdin; /* is this 'file' really the stdin? */
};

/* this table translates fd's into element positions of the above struct */
struct input_fd_table {
	int element;
};
/* thus input_fd_table[3] is fd3, and
 * input_fd_table[3].element points at the input element fd3 matches
*/

#include "filters.h"

struct config {
	#define SORT_REQCOUNT 1
	#define SORT_REQPERSEC 2
	#define SORT_BYTECOUNT 3
	#define SORT_BYTESPERSEC 4
	short sort;
	short refresh_delay;

	short selected_item_screen; /* screen position our marker is at */
	unsigned int selected_item_pos; /* which url/ip/refpos it relates to */
	short selected_item_mode; /* is it url/ip/ref pos? */
	unsigned int selected_item_hash;

	short current_display_size; /* how many lines we're displaying */

	short input_count;

	#define TIMED_CIRCLE 'T'
	#define HITS_CIRCLE  'H'
	int circle_mode;
	int circle_size;

	/* these defines are used in cf.filter too */
	#define DISPLAY_URLS   1
	#define DISPLAY_HOSTS  2
	#define DISPLAY_REFS   3
	#define DISPLAY_FILES  4
	#define DISPLAY_DETAIL 9
	short display_mode;

	/* when in DISPLAY_DETAIL mode, display_mode is copied in here */
	short display_mode_detail;
	/* what would we like to display in DISPLAY_DETAIL modes? */
	bool detail_display_hosts, detail_display_refs, detail_display_urls;

	bool display_paused;
	bool do_immed_display; /* signals a screen update is req'd */

	/* filters */
	Filter *urlfilter, *hostfilter, *reffilter;

	/* url munging */
	bool keep_querystring;
	bool lowercase_urls;
	unsigned short keep_segments;
	bool preserve_ref_protocol;

	bool debug;

	bool exit; /* true when we want to finish */

	/* keypress submenu */
	#define SUBMENU_NONE 0
	#define SUBMENU_SORT 1
	#define SUBMENU_DISP 2

	#define SUBMENU_FILT 3
	#define SUBMENU_FILT_ADD 4
	#define SUBMENU_FILT_SHOW 5

	#define SUBMENU_HELP 9
	unsigned short in_submenu;
	bool in_submenu_stay; /* stay in submenu till keypress? */
	time_t in_submenu_time;

};

struct gstat {
	time_t start; /* when did we start */

	struct hitinfo
	{
		double bytecount;
		double reqcount;
		time_t first, last;
	};

	/* space for 1xx-5xx return codes */
	struct hitinfo r_codes[6];

	/* space for counting global hits and bytes per sec */
	struct hitinfo alltime;
};

//#include "opt.h"
#include "ohtbl.h"
#include "map.h"
#include "circle.h"
#include "hits_circle.h"
#include "timed_circle.h"
#include "display.h"
#include "log.h"


#define JAN 281
#define FEB 269
#define MAR 288
#define APR 291
#define MAY 295
#define JUN 301
#define JUL 299
#define AUG 285
#define SEP 296
#define OCT 294
#define NOV 307
#define DEC 268

#define DEBUG_OUTPUT "/tmp/atop.debug"

/* this can be overridden from config.h via ./configure --with-logfile .. */
#ifndef DEFAULT_LOGFILE
# define DEFAULT_LOGFILE "/var/httpd/apache_log"
#endif
#define DEFAULT_CIRCLE_SIZE 30
#define DEFAULT_CIRCLE_MODE TIMED_CIRCLE
#define DEFAULT_SORT SORT_REQCOUNT
#define DEFAULT_REFRESH_DELAY 5
#define DEFAULT_DISPLAY_MODE DISPLAY_URLS

/* if the layout of the display changes, these need updating */
#define COLS_RESERVED 25
#define LINES_RESERVED 7

#define MAX_INPUT_FILES 50

int recordstats(struct logbits l);

#if HAVE_PTHREAD
void *key_processor(void *);
#endif
int read_key(int ch);

#define SEEK_TO_END true
#define NO_SEEK_TO_END false
int new_file(char *filename, bool do_seek_to_end);

void usage(void);
int dprintf(const char *fmt, ...);

static void catchsig(int s);
static void catchwinch(int s);

#endif
