#ifndef _LOG_H_
#define _LOG_H_

/* types */
#define LOG_COMMON 1
#define LOG_COMBINED 2
#define LOG_ATOP 3

/* parse*() fills in this struct */
struct logbits {
	int url_pos;              /* location of url in urlmap */
	int url_hash;             /* hash of url string */

	//unsigned int ipl;         /* numerical representation of IP */
	int host_pos;             /* location of host in hostmap */
	int host_hash;            /* hash of host string */

	int ref_pos;              /* location of referrer in map */
	int ref_hash;             /* hash of Referrer string */

	int fileid;               /* which file descriptor we're from */
	int file_pos;             /* location of file in filemap */

	unsigned short retcode;   /* return code */
	unsigned int bytes;       /* body of result page */
	time_t time;              /* time of request, unixtime */
};

class LogParser
{
	public:
	virtual int parse(char *logline, struct logbits *b) = 0;

	char *processURL(char **buf);
	int mungeURL(char **url, int *length);
};

class CommonLogParser : public LogParser
{
	int parse(char *logline, struct logbits *b);
};
class AtopLogParser : public LogParser
{
	int parse(char *logline, struct logbits *b);
};

#endif
