      SUBROUTINE SRATQR(N,EPS1,D,E,E2,M,W,IND,BD,TYPE,IDEF,IERR)
C
      INTEGER I,J,K,M,N,II,JJ,K1,IDEF,IERR,JDEF
      REAL D(N),E(N),E2(N),W(N),BD(N)
      REAL F,P,Q,R,S,EP,QP,ERR,TOT,EPS1,DELTA,MACHEP
C     REAL ABS,AMIN1
      INTEGER IND(N)
      LOGICAL TYPE
C
C     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE SRATQR,
C     NUM. MATH. 11, 264-272(1968) BY REINSCH AND BAUER.
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 257-265(1971).
C
C     THIS SUBROUTINE FINDS THE ALGEBRAICALLY SMALLEST OR LARGEST
C     EIGENVALUES OF A SYMMETRIC TRIDIAGONAL MATRIX BY THE
C     RATIONAL QR METHOD WITH NEWTON CORRECTIONS.
C
C     ON INPUT-
C
C        N IS THE ORDER OF THE MATRIX,
C
C        EPS1 IS A THEORETICAL ABSOLUTE ERROR TOLERANCE FOR THE
C          COMPUTED EIGENVALUES.  IF THE INPUT EPS1 IS NON-POSITIVE,
C          OR INDEED SMALLER THAN ITS DEFAULT VALUE, IT IS RESET
C          AT EACH ITERATION TO THE RESPECTIVE DEFAULT VALUE,
C          NAMELY, THE PRODUCT OF THE RELATIVE MACHINE PRECISION
C          AND THE MAGNITUDE OF THE CURRENT EIGENVALUE ITERATE.
C          THE THEORETICAL ABSOLUTE ERROR IN THE K-TH EIGENVALUE
C          IS USUALLY NOT GREATER THAN K TIMES EPS1,
C
C        D CONTAINS THE DIAGONAL ELEMENTS OF THE INPUT MATRIX,
C
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE INPUT MATRIX
C          IN ITS LAST N-1 POSITIONS.  E(1) IS ARBITRARY,
C
C        E2 CONTAINS THE SQUARES OF THE CORRESPONDING ELEMENTS OF E.
C          E2(1) IS ARBITRARY,
C
C        M IS THE NUMBER OF EIGENVALUES TO BE FOUND,
C
C        IDEF SHOULD BE SET TO 1 IF THE INPUT MATRIX IS KNOWN TO BE
C          POSITIVE DEFINITE, TO -1 IF THE INPUT MATRIX IS KNOWN TO
C          BE NEGATIVE DEFINITE, AND TO 0 OTHERWISE,
C
C        TYPE SHOULD BE SET TO .TRUE. IF THE SMALLEST EIGENVALUES
C          ARE TO BE FOUND, AND TO .FALSE. IF THE LARGEST EIGENVALUES
C          ARE TO BE FOUND.
C
C     ON OUTPUT-
C
C        EPS1 IS UNALTERED UNLESS IT HAS BEEN RESET TO ITS
C          (LAST) DEFAULT VALUE,
C
C        D AND E ARE UNALTERED (UNLESS W OVERWRITES D),
C
C        ELEMENTS OF E2, CORRESPONDING TO ELEMENTS OF E REGARDED
C          AS NEGLIGIBLE, HAVE BEEN REPLACED BY ZERO CAUSING THE
C          MATRIX TO SPLIT INTO A DIRECT SUM OF SUBMATRICES.
C          E2(1) IS SET TO 0.0 IF THE SMALLEST EIGENVALUES HAVE BEEN
C          FOUND, AND TO 2.0 IF THE LARGEST EIGENVALUES HAVE BEEN
C          FOUND.  E2 IS OTHERWISE UNALTERED (UNLESS OVERWRITTEN BY BD),
C
C        W CONTAINS THE M ALGEBRAICALLY SMALLEST EIGENVALUES IN
C          ASCENDING ORDER, OR THE M LARGEST EIGENVALUES IN
C          DESCENDING ORDER.  IF AN ERROR EXIT IS MADE BECAUSE OF
C          AN INCORRECT SPECIFICATION OF IDEF, NO EIGENVALUES
C          ARE FOUND.  IF THE NEWTON ITERATES FOR A PARTICULAR
C          EIGENVALUE ARE NOT MONOTONE, THE BEST ESTIMATE OBTAINED
C          IS RETURNED AND IERR IS SET.  W MAY COINCIDE WITH D,
C
C        IND CONTAINS IN ITS FIRST M POSITIONS THE SUBMATRIX INDICES
C          ASSOCIATED WITH THE CORRESPONDING EIGENVALUES IN W --
C          1 FOR EIGENVALUES BELONGING TO THE FIRST SUBMATRIX FROM
C          THE TOP, 2 FOR THOSE BELONGING TO THE SECOND SUBMATRIX, ETC.,
C
C        BD CONTAINS REFINED BOUNDS FOR THE THEORETICAL ERRORS OF THE
C          CORRESPONDING EIGENVALUES IN W.  THESE BOUNDS ARE USUALLY
C          WITHIN THE TOLERANCE SPECIFIED BY EPS1.  BD MAY COINCIDE
C          WITH E2,
C
C        IERR IS SET TO
C          ZERO       FOR NORMAL RETURN,
C          6*N+1      IF  IDEF  IS SET TO 1 AND  TYPE  TO .TRUE.
C                     WHEN THE MATRIX IS NOT POSITIVE DEFINITE, OR
C                     IF  IDEF  IS SET TO -1 AND  TYPE  TO .FALSE.
C                     WHEN THE MATRIX IS NOT NEGATIVE DEFINITE,
C          5*N+K      IF SUCCESSIVE ITERATES TO THE K-TH EIGENVALUE
C                     ARE NOT MONOTONE INCREASING, WHERE K REFERS
C                     TO THE LAST SUCH OCCURRENCE.
C
C     NOTE THAT SUBROUTINE TRIDIB IS GENERALLY FASTER AND MORE
C     ACCURATE THAN SRATQR IF THE EIGENVALUES ARE CLUSTERED.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO B. S. GARBOW,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C
C     ------------------------------------------------------------------
C
C     ********** MACHEP IS A MACHINE DEPENDENT PARAMETER SPECIFYING
C                THE RELATIVE PRECISION OF FLOATING POINT ARITHMETIC.
C
C                **********
      MACHEP = R1MACH(4)
C
      IERR = 0
      JDEF = IDEF
C     ********** COPY D ARRAY INTO W **********
      DO 20 I = 1, N
   20 W(I) = D(I)
C
      IF (TYPE) GO TO 40
      J = 1
      GO TO 400
   40 ERR = 0.0
      S = 0.0
C     ********** LOOK FOR SMALL SUB-DIAGONAL ENTRIES AND DEFINE
C                INITIAL SHIFT FROM LOWER GERSCHGORIN BOUND.
C                COPY E2 ARRAY INTO BD **********
      TOT = W(1)
      Q = 0.0
      J = 0
C
      DO 100 I = 1, N
         P = Q
         IF (I .EQ. 1) GO TO 60
         IF (P .GT. MACHEP * (ABS(D(I)) + ABS(D(I-1)))) GO TO 80
   60    E2(I) = 0.0
   80    BD(I) = E2(I)
C     ********** COUNT ALSO IF ELEMENT OF E2 HAS UNDERFLOWED **********
         IF (E2(I) .EQ. 0.0) J = J + 1
         IND(I) = J
         Q = 0.0
         IF (I .NE. N) Q = ABS(E(I+1))
         TOT = AMIN1(W(I)-P-Q,TOT)
  100 CONTINUE
C
      IF (JDEF .EQ. 1 .AND. TOT .LT. 0.0) GO TO 140
C
      DO 110 I = 1, N
  110 W(I) = W(I) - TOT
C
      GO TO 160
  140 TOT = 0.0
C
  160 DO 360 K = 1, M
C     ********** NEXT QR TRANSFORMATION **********
  180    TOT = TOT + S
         DELTA = W(N) - S
         I = N
         F = ABS(MACHEP*TOT)
         IF (EPS1 .LT. F) EPS1 = F
         IF (DELTA .GT. EPS1) GO TO 190
         IF (DELTA .LT. (-EPS1)) GO TO 1000
         GO TO 300
C     ********** REPLACE SMALL SUB-DIAGONAL SQUARES BY ZERO
C                TO REDUCE THE INCIDENCE OF UNDERFLOWS **********
  190    IF (K .EQ. N) GO TO 210
         K1 = K + 1
         DO 200 J = K1, N
            IF (BD(J) .LE. (MACHEP*(W(J)+W(J-1))) ** 2) BD(J) = 0.0
  200    CONTINUE
C
  210    F = BD(N) / DELTA
         QP = DELTA + F
         P = 1.0
         IF (K .EQ. N) GO TO 260
         K1 = N - K
C     ********** FOR I=N-1 STEP -1 UNTIL K DO -- **********
         DO 240 II = 1, K1
            I = N - II
            Q = W(I) - S - F
            R = Q / QP
            P = P * R + 1.0
            EP = F * R
            W(I+1) = QP + EP
            DELTA = Q - EP
            IF (DELTA .GT. EPS1) GO TO 220
            IF (DELTA .LT. (-EPS1)) GO TO 1000
            GO TO 300
  220       F = BD(I) / Q
            QP = DELTA + F
            BD(I+1) = QP * EP
  240    CONTINUE
C
  260    W(K) = QP
         S = QP / P
         IF (TOT + S .GT. TOT) GO TO 180
C     ********** SET ERROR -- IRREGULAR END OF ITERATION.
C                DEFLATE MINIMUM DIAGONAL ELEMENT **********
         IERR = 5 * N + K
         S = 0.0
         DELTA = QP
C
         DO 280 J = K, N
            IF (W(J) .GT. DELTA) GO TO 280
            I = J
            DELTA = W(J)
  280    CONTINUE
C     ********** CONVERGENCE **********
  300    IF (I .LT. N) BD(I+1) = BD(I) * F / QP
         II = IND(I)
         IF (I .EQ. K) GO TO 340
         K1 = I - K
C     ********** FOR J=I-1 STEP -1 UNTIL K DO -- **********
         DO 320 JJ = 1, K1
            J = I - JJ
            W(J+1) = W(J) - S
            BD(J+1) = BD(J)
            IND(J+1) = IND(J)
  320    CONTINUE
C
  340    W(K) = TOT
         ERR = ERR + ABS(DELTA)
         BD(K) = ERR
         IND(K) = II
  360 CONTINUE
C
      IF (TYPE) GO TO 1001
      F = BD(1)
      E2(1) = 2.0
      BD(1) = F
      J = 2
C     ********** NEGATE ELEMENTS OF W FOR LARGEST VALUES **********
  400 DO 500 I = 1, N
  500 W(I) = -W(I)
C
      JDEF = -JDEF
      GO TO (40,1001), J
C     ********** SET ERROR -- IDEF SPECIFIED INCORRECTLY **********
 1000 IERR = 6 * N + 1
 1001 RETURN
C     ********** LAST CARD OF SRATQR **********
      END
