;;; emu-mule.el --- emu module for Mule 1.* and Mule 2.*

;; Copyright (C) 1995,1996,1997,1998 MORIOKA Tomohiko

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;;         Katsumi Yamaoka <yamaoka@jpl.org>
;; Keywords: emulation, compatibility, Mule

;; This file is part of emu.

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'poem)


;;; @ regulation
;;;

(defun regulate-latin-char (chr)
  (cond ((and (<= ?$B#A(B chr)(<= chr ?$B#Z(B))
	 (+ (- chr ?$B#A(B) ?A))
	((and (<= ?$B#a(B chr)(<= chr ?$B#z(B))
	 (+ (- chr ?$B#a(B) ?a))
	((eq chr ?$B!%(B) ?.)
	((eq chr ?$B!$(B) ?,)
	(t chr)))

(defun regulate-latin-string (str)
  (let ((len (length str))
	(i 0)
	chr (dest ""))
    (while (< i len)
      (setq chr (sref str i))
      (setq dest (concat dest
			 (char-to-string (regulate-latin-char chr))))
      (setq i (+ i (char-bytes chr))))
    dest))


;;; @ end
;;;

(require 'product)
(product-provide (provide 'emu-mule) (require 'apel-ver))

;;; emu-mule.el ends here
