/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffArguments;
import cz.startnet.utils.pgdiff.PgDiffConstraints;
import cz.startnet.utils.pgdiff.PgDiffFunctions;
import cz.startnet.utils.pgdiff.PgDiffIndexes;
import cz.startnet.utils.pgdiff.PgDiffPolicies;
import cz.startnet.utils.pgdiff.PgDiffRules;
import cz.startnet.utils.pgdiff.PgDiffSequences;
import cz.startnet.utils.pgdiff.PgDiffTables;
import cz.startnet.utils.pgdiff.PgDiffTriggers;
import cz.startnet.utils.pgdiff.PgDiffTypes;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.PgDiffViews;
import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.loader.PgDumpLoader;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgExtension;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.io.InputStream;
import java.io.PrintWriter;

public class PgDiff {
    public static void createDiff(PrintWriter printWriter, PgDiffArguments pgDiffArguments) {
        if (pgDiffArguments.getOldDumpFile().equals("-") && pgDiffArguments.getNewDumpFile().equals("-")) {
            return;
        }
        PgDatabase pgDatabase = PgDumpLoader.loadDatabaseSchema(pgDiffArguments.getOldDumpFile(), pgDiffArguments.getInCharsetName(), pgDiffArguments.isOutputIgnoredStatements(), pgDiffArguments.isIgnoreSlonyTriggers(), pgDiffArguments.isIgnoreSchemaCreation());
        PgDatabase pgDatabase2 = PgDumpLoader.loadDatabaseSchema(pgDiffArguments.getNewDumpFile(), pgDiffArguments.getInCharsetName(), pgDiffArguments.isOutputIgnoredStatements(), pgDiffArguments.isIgnoreSlonyTriggers(), pgDiffArguments.isIgnoreSchemaCreation());
        PgDiff.diffDatabaseSchemas(printWriter, pgDiffArguments, pgDatabase, pgDatabase2);
    }

    public static void createDiff(PrintWriter printWriter, PgDiffArguments pgDiffArguments, InputStream inputStream, InputStream inputStream2) {
        PgDatabase pgDatabase = PgDumpLoader.loadDatabaseSchema(inputStream, pgDiffArguments.getInCharsetName(), pgDiffArguments.isOutputIgnoredStatements(), pgDiffArguments.isIgnoreSlonyTriggers(), pgDiffArguments.isIgnoreSchemaCreation());
        PgDatabase pgDatabase2 = PgDumpLoader.loadDatabaseSchema(inputStream2, pgDiffArguments.getInCharsetName(), pgDiffArguments.isOutputIgnoredStatements(), pgDiffArguments.isIgnoreSlonyTriggers(), pgDiffArguments.isIgnoreSchemaCreation());
        PgDiff.diffDatabaseSchemas(printWriter, pgDiffArguments, pgDatabase, pgDatabase2);
    }

    private static void createNewSchemas(PrintWriter printWriter, PgDatabase pgDatabase, PgDatabase pgDatabase2) {
        for (PgSchema pgSchema : pgDatabase2.getSchemas()) {
            if (pgDatabase.getSchema(pgSchema.getName()) != null) continue;
            printWriter.println();
            printWriter.println(pgSchema.getCreationSQL());
        }
    }

    private static void createNewExtensions(PrintWriter printWriter, PgDatabase pgDatabase, PgDatabase pgDatabase2) {
        for (PgExtension pgExtension : pgDatabase2.getExtensions()) {
            if (pgDatabase.getExtension(pgExtension.getName()) != null) continue;
            printWriter.println();
            printWriter.println(pgExtension.getCreationSQL());
        }
    }

    private static void diffDatabaseSchemas(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgDatabase pgDatabase, PgDatabase pgDatabase2) {
        if (pgDiffArguments.isAddTransaction()) {
            printWriter.println("START TRANSACTION;");
        }
        if (pgDatabase.getComment() == null && pgDatabase2.getComment() != null || pgDatabase.getComment() != null && pgDatabase2.getComment() != null && !pgDatabase.getComment().equals(pgDatabase2.getComment())) {
            printWriter.println();
            printWriter.print("COMMENT ON DATABASE current_database() IS ");
            printWriter.print(pgDatabase2.getComment());
            printWriter.println(';');
        } else if (pgDatabase.getComment() != null && pgDatabase2.getComment() == null) {
            printWriter.println();
            printWriter.println("COMMENT ON DATABASE current_database() IS NULL;");
        }
        PgDiff.dropOldSchemas(printWriter, pgDatabase, pgDatabase2);
        PgDiff.createNewSchemas(printWriter, pgDatabase, pgDatabase2);
        PgDiff.dropOldExtensions(printWriter, pgDatabase, pgDatabase2);
        PgDiff.createNewExtensions(printWriter, pgDatabase, pgDatabase2);
        PgDiff.updateSchemas(printWriter, pgDiffArguments, pgDatabase, pgDatabase2);
        if (pgDiffArguments.isAddTransaction()) {
            printWriter.println();
            printWriter.println("COMMIT TRANSACTION;");
        }
        if (pgDiffArguments.isOutputIgnoredStatements()) {
            if (!pgDatabase.getIgnoredStatements().isEmpty()) {
                printWriter.println();
                printWriter.print("/* ");
                printWriter.println(Resources.getString("OriginalDatabaseIgnoredStatements"));
                for (String string : pgDatabase.getIgnoredStatements()) {
                    printWriter.println();
                    printWriter.println(string);
                }
                printWriter.println("*/");
            }
            if (!pgDatabase2.getIgnoredStatements().isEmpty()) {
                printWriter.println();
                printWriter.print("/* ");
                printWriter.println(Resources.getString("NewDatabaseIgnoredStatements"));
                for (String string : pgDatabase2.getIgnoredStatements()) {
                    printWriter.println();
                    printWriter.println(string);
                }
                printWriter.println("*/");
            }
        }
    }

    private static void dropOldSchemas(PrintWriter printWriter, PgDatabase pgDatabase, PgDatabase pgDatabase2) {
        for (PgSchema pgSchema : pgDatabase.getSchemas()) {
            if (pgDatabase2.getSchema(pgSchema.getName()) != null) continue;
            printWriter.println();
            printWriter.println("DROP SCHEMA " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(pgSchema.getName()) + " CASCADE;");
        }
    }

    private static void dropOldExtensions(PrintWriter printWriter, PgDatabase pgDatabase, PgDatabase pgDatabase2) {
        for (PgExtension pgExtension : pgDatabase.getExtensions()) {
            if (pgDatabase2.getExtension(pgExtension.getName()) != null) continue;
            printWriter.println();
            printWriter.println("DROP EXTENSION " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(pgExtension.getName()) + " CASCADE;");
        }
    }

    private static void updateSchemas(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgDatabase pgDatabase, PgDatabase pgDatabase2) {
        boolean bl = pgDatabase2.getSchemas().size() > 1 || !pgDatabase2.getSchemas().get(0).getName().equals("public");
        for (PgSchema pgSchema : pgDatabase2.getSchemas()) {
            SearchPathHelper searchPathHelper = bl ? new SearchPathHelper("SET search_path = " + PgDiffUtils.getQuotedName(pgSchema.getName(), true) + ", pg_catalog;") : new SearchPathHelper(null);
            PgSchema pgSchema2 = pgDatabase.getSchema(pgSchema.getName());
            if (pgSchema2 != null) {
                if (pgSchema2.getComment() == null && pgSchema.getComment() != null || pgSchema2.getComment() != null && pgSchema.getComment() != null && !pgSchema2.getComment().equals(pgSchema.getComment())) {
                    printWriter.println();
                    printWriter.print("COMMENT ON SCHEMA ");
                    printWriter.print(PgDiffUtils.getQuotedName(pgSchema.getName()));
                    printWriter.print(" IS ");
                    printWriter.print(pgSchema.getComment());
                    printWriter.println(';');
                } else if (pgSchema2.getComment() != null && pgSchema.getComment() == null) {
                    printWriter.println();
                    printWriter.print("COMMENT ON SCHEMA ");
                    printWriter.print(PgDiffUtils.getQuotedName(pgSchema.getName()));
                    printWriter.println(" IS NULL;");
                }
            }
            PgDiffTriggers.dropTriggers(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffRules.dropRules(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffFunctions.dropFunctions(printWriter, pgDiffArguments, pgSchema2, pgSchema, searchPathHelper);
            PgDiffViews.dropViews(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffConstraints.dropConstraints(printWriter, pgSchema2, pgSchema, true, searchPathHelper);
            PgDiffConstraints.dropConstraints(printWriter, pgSchema2, pgSchema, false, searchPathHelper);
            PgDiffIndexes.dropIndexes(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTables.dropClusters(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTables.dropTables(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffSequences.dropSequences(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffPolicies.dropPolicies(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffSequences.createSequences(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffSequences.alterSequences(printWriter, pgDiffArguments, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTypes.alterTypes(printWriter, pgDiffArguments, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTypes.createTypes(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTypes.dropTypes(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTables.createTables(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTables.alterTables(printWriter, pgDiffArguments, pgSchema2, pgSchema, searchPathHelper);
            PgDiffSequences.alterCreatedSequences(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffFunctions.createFunctions(printWriter, pgDiffArguments, pgSchema2, pgSchema, searchPathHelper);
            PgDiffConstraints.createConstraints(printWriter, pgSchema2, pgSchema, true, searchPathHelper);
            PgDiffConstraints.createConstraints(printWriter, pgSchema2, pgSchema, false, searchPathHelper);
            PgDiffIndexes.createIndexes(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTables.createClusters(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTriggers.createTriggers(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTriggers.disableOrEnableTriggers(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffViews.createViews(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffRules.createRules(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffViews.alterViews(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffPolicies.createPolicies(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffPolicies.alterPolicies(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffFunctions.alterComments(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffConstraints.alterComments(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffIndexes.alterComments(printWriter, pgSchema2, pgSchema, searchPathHelper);
            PgDiffTriggers.alterComments(printWriter, pgSchema2, pgSchema, searchPathHelper);
        }
    }

    private PgDiff() {
    }
}

