/***************************************************************************
                          Apollonplayertab.cpp  -  description
                             -------------------
    begin                : Sat June 7 2003
    copyright            : (C) 2003 by Arend van Beelen
    email                : arend@auton.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdesktopfile.h>
#include <kjanuswidget.h>
#include <klocale.h>
#include <kmediaplayer/player.h>
#include <kmimetype.h>
#include <kparts/componentfactory.h>

#include <qframe.h>
#include <qlabel.h>

#include <qtextedit.h>
#include <qlayout.h>

#include <qvbox.h>

#include "apollonplayertab.h"

ApollonPlayerTab::ApollonPlayerTab(QWidget *parent, const char *name, KJanusWidget *janus, int pageNum) :
  ApollonTab(parent, name),
  m_part(0),
  m_errorView(0),
  m_janus(janus),
  m_pageNum(pageNum)
{
	QVBox *vbox = new QVBox(this);

	KService::Ptr service = KService::serviceByDesktopPath("kaboodle_component.desktop");

	if(service)
	{
		m_titleFrame = new QFrame(vbox);
		m_titleFrame->setFrameShape(QFrame::GroupBoxPanel);
		m_titleFrame->setFrameShadow(QFrame::Raised);
		m_titleFrame->setMinimumHeight(40);

		m_titleFrameLayout = new QVBoxLayout(m_titleFrame, 11, 6, "m_titleFrameLayout");
		m_titleLabel = new KSqueezedTextLabel(m_titleFrame);

		m_titleLabel->setText(i18n("(No file selected)"));
		m_titleFrameLayout->addWidget(m_titleLabel);

		m_part = KParts::ComponentFactory::createPartInstanceFromService<KParts::ReadOnlyPart>(service, vbox, 0, vbox, 0);

		if(m_part)
		{
			m_part->widget()->show();

			return;
		}
	}

	m_errorView = new QTextEdit(this);
	m_errorView->setReadOnly(TRUE);
	m_errorView->setText(i18n("<h3>Media player could not be loaded</h3>"
	                          "<p>Please install the KDE multimedia-video package to enable the media player.</p>"));
}

ApollonPlayerTab::~ApollonPlayerTab()
{
}

void ApollonPlayerTab::play(KURL url, const QString &previewTitle)
{
	if(m_part)
	{
		m_part->openURL(url);
		dynamic_cast<KMediaPlayer::Player *>(m_part)->play();

		if(previewTitle != QString::null)
		{
			m_titleLabel->setText(previewTitle + i18n(" (Preview)"));
		}
		else
		{
			m_titleLabel->setText(url.fileName().section('/', -1));
		}
	}

	// directly switch to the media player if we start playing a movie
	if(KMimeType::findByURL(url)->name().left(6) == "video/" && m_janus)
	{
		m_janus->showPage(m_pageNum);
	}
}
