// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package iam provides a client for AWS Identity and Access Management.
package iam

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddClientIDToOpenIDConnectProvider = "AddClientIDToOpenIDConnectProvider"

// AddClientIDToOpenIDConnectProviderRequest generates a request for the AddClientIDToOpenIDConnectProvider operation.
func (c *IAM) AddClientIDToOpenIDConnectProviderRequest(input *AddClientIDToOpenIDConnectProviderInput) (req *request.Request, output *AddClientIDToOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opAddClientIDToOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddClientIDToOpenIDConnectProviderInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AddClientIDToOpenIDConnectProviderOutput{}
	req.Data = output
	return
}

// Adds a new client ID (also known as audience) to the list of client IDs already
// registered for the specified IAM OpenID Connect provider.
//
// This action is idempotent; it does not fail or return an error if you add
// an existing client ID to the provider.
func (c *IAM) AddClientIDToOpenIDConnectProvider(input *AddClientIDToOpenIDConnectProviderInput) (*AddClientIDToOpenIDConnectProviderOutput, error) {
	req, out := c.AddClientIDToOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opAddRoleToInstanceProfile = "AddRoleToInstanceProfile"

// AddRoleToInstanceProfileRequest generates a request for the AddRoleToInstanceProfile operation.
func (c *IAM) AddRoleToInstanceProfileRequest(input *AddRoleToInstanceProfileInput) (req *request.Request, output *AddRoleToInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opAddRoleToInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddRoleToInstanceProfileInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AddRoleToInstanceProfileOutput{}
	req.Data = output
	return
}

// Adds the specified role to the specified instance profile. For more information
// about roles, go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
// For more information about instance profiles, go to About Instance Profiles
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
func (c *IAM) AddRoleToInstanceProfile(input *AddRoleToInstanceProfileInput) (*AddRoleToInstanceProfileOutput, error) {
	req, out := c.AddRoleToInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opAddUserToGroup = "AddUserToGroup"

// AddUserToGroupRequest generates a request for the AddUserToGroup operation.
func (c *IAM) AddUserToGroupRequest(input *AddUserToGroupInput) (req *request.Request, output *AddUserToGroupOutput) {
	op := &request.Operation{
		Name:       opAddUserToGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddUserToGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AddUserToGroupOutput{}
	req.Data = output
	return
}

// Adds the specified user to the specified group.
func (c *IAM) AddUserToGroup(input *AddUserToGroupInput) (*AddUserToGroupOutput, error) {
	req, out := c.AddUserToGroupRequest(input)
	err := req.Send()
	return out, err
}

const opAttachGroupPolicy = "AttachGroupPolicy"

// AttachGroupPolicyRequest generates a request for the AttachGroupPolicy operation.
func (c *IAM) AttachGroupPolicyRequest(input *AttachGroupPolicyInput) (req *request.Request, output *AttachGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachGroupPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AttachGroupPolicyOutput{}
	req.Data = output
	return
}

// Attaches the specified managed policy to the specified group.
//
// You use this API to attach a managed policy to a group. To embed an inline
// policy in a group, use PutGroupPolicy.
//
// For more information about policies, refer to Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) AttachGroupPolicy(input *AttachGroupPolicyInput) (*AttachGroupPolicyOutput, error) {
	req, out := c.AttachGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opAttachRolePolicy = "AttachRolePolicy"

// AttachRolePolicyRequest generates a request for the AttachRolePolicy operation.
func (c *IAM) AttachRolePolicyRequest(input *AttachRolePolicyInput) (req *request.Request, output *AttachRolePolicyOutput) {
	op := &request.Operation{
		Name:       opAttachRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachRolePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AttachRolePolicyOutput{}
	req.Data = output
	return
}

// Attaches the specified managed policy to the specified role.
//
// When you attach a managed policy to a role, the managed policy is used as
// the role's access (permissions) policy. You cannot use a managed policy as
// the role's trust policy. The role's trust policy is created at the same time
// as the role, using CreateRole. You can update a role's trust policy using
// UpdateAssumeRolePolicy.
//
// Use this API to attach a managed policy to a role. To embed an inline policy
// in a role, use PutRolePolicy. For more information about policies, refer
// to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) AttachRolePolicy(input *AttachRolePolicyInput) (*AttachRolePolicyOutput, error) {
	req, out := c.AttachRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opAttachUserPolicy = "AttachUserPolicy"

// AttachUserPolicyRequest generates a request for the AttachUserPolicy operation.
func (c *IAM) AttachUserPolicyRequest(input *AttachUserPolicyInput) (req *request.Request, output *AttachUserPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachUserPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AttachUserPolicyOutput{}
	req.Data = output
	return
}

// Attaches the specified managed policy to the specified user.
//
// You use this API to attach a managed policy to a user. To embed an inline
// policy in a user, use PutUserPolicy.
//
// For more information about policies, refer to Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) AttachUserPolicy(input *AttachUserPolicyInput) (*AttachUserPolicyOutput, error) {
	req, out := c.AttachUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opChangePassword = "ChangePassword"

// ChangePasswordRequest generates a request for the ChangePassword operation.
func (c *IAM) ChangePasswordRequest(input *ChangePasswordInput) (req *request.Request, output *ChangePasswordOutput) {
	op := &request.Operation{
		Name:       opChangePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ChangePasswordInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ChangePasswordOutput{}
	req.Data = output
	return
}

// Changes the password of the IAM user who is calling this action. The root
// account password is not affected by this action.
//
// To change the password for a different user, see UpdateLoginProfile. For
// more information about modifying passwords, see Managing Passwords (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
// in the IAM User Guide.
func (c *IAM) ChangePassword(input *ChangePasswordInput) (*ChangePasswordOutput, error) {
	req, out := c.ChangePasswordRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAccessKey = "CreateAccessKey"

// CreateAccessKeyRequest generates a request for the CreateAccessKey operation.
func (c *IAM) CreateAccessKeyRequest(input *CreateAccessKeyInput) (req *request.Request, output *CreateAccessKeyOutput) {
	op := &request.Operation{
		Name:       opCreateAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccessKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAccessKeyOutput{}
	req.Data = output
	return
}

// Creates a new AWS secret access key and corresponding AWS access key ID for
// the specified user. The default status for new keys is Active.
//
//  If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request. Because this action works
// for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
//  For information about limits on the number of keys you can create, see
// Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
//  To ensure the security of your AWS account, the secret access key is accessible
// only during key and user creation. You must save the key (for example, in
// a text file) if you want to be able to access it again. If a secret key is
// lost, you can delete the access keys for the associated user and then create
// new keys.
func (c *IAM) CreateAccessKey(input *CreateAccessKeyInput) (*CreateAccessKeyOutput, error) {
	req, out := c.CreateAccessKeyRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAccountAlias = "CreateAccountAlias"

// CreateAccountAliasRequest generates a request for the CreateAccountAlias operation.
func (c *IAM) CreateAccountAliasRequest(input *CreateAccountAliasInput) (req *request.Request, output *CreateAccountAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAccountAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccountAliasInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateAccountAliasOutput{}
	req.Data = output
	return
}

// Creates an alias for your AWS account. For information about using an AWS
// account alias, see Using an Alias for Your AWS Account ID (http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
// in the IAM User Guide.
func (c *IAM) CreateAccountAlias(input *CreateAccountAliasInput) (*CreateAccountAliasOutput, error) {
	req, out := c.CreateAccountAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a request for the CreateGroup operation.
func (c *IAM) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateGroupOutput{}
	req.Data = output
	return
}

// Creates a new group.
//
//  For information about the number of groups you can create, see Limitations
// on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
func (c *IAM) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInstanceProfile = "CreateInstanceProfile"

// CreateInstanceProfileRequest generates a request for the CreateInstanceProfile operation.
func (c *IAM) CreateInstanceProfileRequest(input *CreateInstanceProfileInput) (req *request.Request, output *CreateInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateInstanceProfileOutput{}
	req.Data = output
	return
}

// Creates a new instance profile. For information about instance profiles,
// go to About Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
//  For information about the number of instance profiles you can create, see
// Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
func (c *IAM) CreateInstanceProfile(input *CreateInstanceProfileInput) (*CreateInstanceProfileOutput, error) {
	req, out := c.CreateInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLoginProfile = "CreateLoginProfile"

// CreateLoginProfileRequest generates a request for the CreateLoginProfile operation.
func (c *IAM) CreateLoginProfileRequest(input *CreateLoginProfileInput) (req *request.Request, output *CreateLoginProfileOutput) {
	op := &request.Operation{
		Name:       opCreateLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoginProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLoginProfileOutput{}
	req.Data = output
	return
}

// Creates a password for the specified user, giving the user the ability to
// access AWS services through the AWS Management Console. For more information
// about managing passwords, see Managing Passwords (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
// in the Using IAM guide.
func (c *IAM) CreateLoginProfile(input *CreateLoginProfileInput) (*CreateLoginProfileOutput, error) {
	req, out := c.CreateLoginProfileRequest(input)
	err := req.Send()
	return out, err
}

const opCreateOpenIDConnectProvider = "CreateOpenIDConnectProvider"

// CreateOpenIDConnectProviderRequest generates a request for the CreateOpenIDConnectProvider operation.
func (c *IAM) CreateOpenIDConnectProviderRequest(input *CreateOpenIDConnectProviderInput) (req *request.Request, output *CreateOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opCreateOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOpenIDConnectProviderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateOpenIDConnectProviderOutput{}
	req.Data = output
	return
}

// Creates an IAM entity to describe an identity provider (IdP) that supports
// OpenID Connect (OIDC) (http://openid.net/connect/).
//
// The OIDC provider that you create with this operation can be used as a principal
// in a role's trust policy to establish a trust relationship between AWS and
// the OIDC provider.
//
// When you create the IAM OIDC provider, you specify the URL of the OIDC identity
// provider (IdP) to trust, a list of client IDs (also known as audiences) that
// identify the application or applications that are allowed to authenticate
// using the OIDC provider, and a list of thumbprints of the server certificate(s)
// that the IdP uses. You get all of this information from the OIDC IdP that
// you want to use for access to AWS.
//
// Because trust for the OIDC provider is ultimately derived from the IAM provider
// that this action creates, it is a best practice to limit access to the CreateOpenIDConnectProvider
// action to highly-privileged users.
func (c *IAM) CreateOpenIDConnectProvider(input *CreateOpenIDConnectProviderInput) (*CreateOpenIDConnectProviderOutput, error) {
	req, out := c.CreateOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a request for the CreatePolicy operation.
func (c *IAM) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePolicyOutput{}
	req.Data = output
	return
}

// Creates a new managed policy for your AWS account.
//
// This operation creates a policy version with a version identifier of v1
// and sets v1 as the policy's default version. For more information about policy
// versions, see Versioning for Managed Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
// in the IAM User Guide.
//
// For more information about managed policies in general, refer to Managed
// Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePolicyVersion = "CreatePolicyVersion"

// CreatePolicyVersionRequest generates a request for the CreatePolicyVersion operation.
func (c *IAM) CreatePolicyVersionRequest(input *CreatePolicyVersionInput) (req *request.Request, output *CreatePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePolicyVersionOutput{}
	req.Data = output
	return
}

// Creates a new version of the specified managed policy. To update a managed
// policy, you create a new policy version. A managed policy can have up to
// five versions. If the policy has five versions, you must delete an existing
// version using DeletePolicyVersion before you create a new version.
//
// Optionally, you can set the new version as the policy's default version.
// The default version is the operative version; that is, the version that is
// in effect for the IAM users, groups, and roles that the policy is attached
// to.
//
// For more information about managed policy versions, see Versioning for Managed
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
// in the IAM User Guide.
func (c *IAM) CreatePolicyVersion(input *CreatePolicyVersionInput) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRole = "CreateRole"

// CreateRoleRequest generates a request for the CreateRole operation.
func (c *IAM) CreateRoleRequest(input *CreateRoleInput) (req *request.Request, output *CreateRoleOutput) {
	op := &request.Operation{
		Name:       opCreateRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRoleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateRoleOutput{}
	req.Data = output
	return
}

// Creates a new role for your AWS account. For more information about roles,
// go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
// For information about limitations on role names and the number of roles you
// can create, go to Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
func (c *IAM) CreateRole(input *CreateRoleInput) (*CreateRoleOutput, error) {
	req, out := c.CreateRoleRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSAMLProvider = "CreateSAMLProvider"

// CreateSAMLProviderRequest generates a request for the CreateSAMLProvider operation.
func (c *IAM) CreateSAMLProviderRequest(input *CreateSAMLProviderInput) (req *request.Request, output *CreateSAMLProviderOutput) {
	op := &request.Operation{
		Name:       opCreateSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSAMLProviderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSAMLProviderOutput{}
	req.Data = output
	return
}

// Creates an IAM entity to describe an identity provider (IdP) that supports
// SAML 2.0.
//
//  The SAML provider that you create with this operation can be used as a
// principal in a role's trust policy to establish a trust relationship between
// AWS and a SAML identity provider. You can create an IAM role that supports
// Web-based single sign-on (SSO) to the AWS Management Console or one that
// supports API access to AWS.
//
//  When you create the SAML provider, you upload an a SAML metadata document
// that you get from your IdP and that includes the issuer's name, expiration
// information, and keys that can be used to validate the SAML authentication
// response (assertions) that are received from the IdP. You must generate the
// metadata document using the identity management software that is used as
// your organization's IdP.
//
//  This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//   For more information, see Enabling SAML 2.0 Federated Users to Access the
// AWS Management Console (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html)
// and About SAML 2.0-based Federation (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
// in the IAM User Guide.
func (c *IAM) CreateSAMLProvider(input *CreateSAMLProviderInput) (*CreateSAMLProviderOutput, error) {
	req, out := c.CreateSAMLProviderRequest(input)
	err := req.Send()
	return out, err
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a request for the CreateUser operation.
func (c *IAM) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateUserOutput{}
	req.Data = output
	return
}

// Creates a new user for your AWS account.
//
//  For information about limitations on the number of users you can create,
// see Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
func (c *IAM) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVirtualMFADevice = "CreateVirtualMFADevice"

// CreateVirtualMFADeviceRequest generates a request for the CreateVirtualMFADevice operation.
func (c *IAM) CreateVirtualMFADeviceRequest(input *CreateVirtualMFADeviceInput) (req *request.Request, output *CreateVirtualMFADeviceOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVirtualMFADeviceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateVirtualMFADeviceOutput{}
	req.Data = output
	return
}

// Creates a new virtual MFA device for the AWS account. After creating the
// virtual MFA, use EnableMFADevice to attach the MFA device to an IAM user.
// For more information about creating and working with virtual MFA devices,
// go to Using a Virtual MFA Device (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
// in the Using IAM guide.
//
// For information about limits on the number of MFA devices you can create,
// see Limitations on Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the Using IAM guide.
//
// The seed information contained in the QR code and the Base32 string should
// be treated like any other secret access information, such as your AWS access
// keys or your passwords. After you provision your virtual device, you should
// ensure that the information is destroyed following secure procedures.
func (c *IAM) CreateVirtualMFADevice(input *CreateVirtualMFADeviceInput) (*CreateVirtualMFADeviceOutput, error) {
	req, out := c.CreateVirtualMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opDeactivateMFADevice = "DeactivateMFADevice"

// DeactivateMFADeviceRequest generates a request for the DeactivateMFADevice operation.
func (c *IAM) DeactivateMFADeviceRequest(input *DeactivateMFADeviceInput) (req *request.Request, output *DeactivateMFADeviceOutput) {
	op := &request.Operation{
		Name:       opDeactivateMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivateMFADeviceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeactivateMFADeviceOutput{}
	req.Data = output
	return
}

// Deactivates the specified MFA device and removes it from association with
// the user name for which it was originally enabled.
//
// For more information about creating and working with virtual MFA devices,
// go to Using a Virtual MFA Device (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
// in the Using IAM guide.
func (c *IAM) DeactivateMFADevice(input *DeactivateMFADeviceInput) (*DeactivateMFADeviceOutput, error) {
	req, out := c.DeactivateMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAccessKey = "DeleteAccessKey"

// DeleteAccessKeyRequest generates a request for the DeleteAccessKey operation.
func (c *IAM) DeleteAccessKeyRequest(input *DeleteAccessKeyInput) (req *request.Request, output *DeleteAccessKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccessKeyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAccessKeyOutput{}
	req.Data = output
	return
}

// Deletes the access key associated with the specified user.
//
//  If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request. Because this action works
// for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
func (c *IAM) DeleteAccessKey(input *DeleteAccessKeyInput) (*DeleteAccessKeyOutput, error) {
	req, out := c.DeleteAccessKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAccountAlias = "DeleteAccountAlias"

// DeleteAccountAliasRequest generates a request for the DeleteAccountAlias operation.
func (c *IAM) DeleteAccountAliasRequest(input *DeleteAccountAliasInput) (req *request.Request, output *DeleteAccountAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountAliasInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAccountAliasOutput{}
	req.Data = output
	return
}

// Deletes the specified AWS account alias. For information about using an AWS
// account alias, see Using an Alias for Your AWS Account ID (http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
// in the IAM User Guide.
func (c *IAM) DeleteAccountAlias(input *DeleteAccountAliasInput) (*DeleteAccountAliasOutput, error) {
	req, out := c.DeleteAccountAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAccountPasswordPolicy = "DeleteAccountPasswordPolicy"

// DeleteAccountPasswordPolicyRequest generates a request for the DeleteAccountPasswordPolicy operation.
func (c *IAM) DeleteAccountPasswordPolicyRequest(input *DeleteAccountPasswordPolicyInput) (req *request.Request, output *DeleteAccountPasswordPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountPasswordPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountPasswordPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAccountPasswordPolicyOutput{}
	req.Data = output
	return
}

// Deletes the password policy for the AWS account.
func (c *IAM) DeleteAccountPasswordPolicy(input *DeleteAccountPasswordPolicyInput) (*DeleteAccountPasswordPolicyOutput, error) {
	req, out := c.DeleteAccountPasswordPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a request for the DeleteGroup operation.
func (c *IAM) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteGroupOutput{}
	req.Data = output
	return
}

// Deletes the specified group. The group must not contain any users or have
// any attached policies.
func (c *IAM) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteGroupPolicy = "DeleteGroupPolicy"

// DeleteGroupPolicyRequest generates a request for the DeleteGroupPolicy operation.
func (c *IAM) DeleteGroupPolicyRequest(input *DeleteGroupPolicyInput) (req *request.Request, output *DeleteGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteGroupPolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified inline policy that is embedded in the specified group.
//
// A group can also have managed policies attached to it. To detach a managed
// policy from a group, use DetachGroupPolicy. For more information about policies,
// refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) DeleteGroupPolicy(input *DeleteGroupPolicyInput) (*DeleteGroupPolicyOutput, error) {
	req, out := c.DeleteGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteInstanceProfile = "DeleteInstanceProfile"

// DeleteInstanceProfileRequest generates a request for the DeleteInstanceProfile operation.
func (c *IAM) DeleteInstanceProfileRequest(input *DeleteInstanceProfileInput) (req *request.Request, output *DeleteInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceProfileInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteInstanceProfileOutput{}
	req.Data = output
	return
}

// Deletes the specified instance profile. The instance profile must not have
// an associated role.
//
//  Make sure you do not have any Amazon EC2 instances running with the instance
// profile you are about to delete. Deleting a role or instance profile that
// is associated with a running instance will break any applications running
// on the instance.  For more information about instance profiles, go to About
// Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
func (c *IAM) DeleteInstanceProfile(input *DeleteInstanceProfileInput) (*DeleteInstanceProfileOutput, error) {
	req, out := c.DeleteInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLoginProfile = "DeleteLoginProfile"

// DeleteLoginProfileRequest generates a request for the DeleteLoginProfile operation.
func (c *IAM) DeleteLoginProfileRequest(input *DeleteLoginProfileInput) (req *request.Request, output *DeleteLoginProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoginProfileInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteLoginProfileOutput{}
	req.Data = output
	return
}

// Deletes the password for the specified user, which terminates the user's
// ability to access AWS services through the AWS Management Console.
//
//  Deleting a user's password does not prevent a user from accessing IAM through
// the command line interface or the API. To prevent all user access you must
// also either make the access key inactive or delete it. For more information
// about making keys inactive or deleting them, see UpdateAccessKey and DeleteAccessKey.
func (c *IAM) DeleteLoginProfile(input *DeleteLoginProfileInput) (*DeleteLoginProfileOutput, error) {
	req, out := c.DeleteLoginProfileRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteOpenIDConnectProvider = "DeleteOpenIDConnectProvider"

// DeleteOpenIDConnectProviderRequest generates a request for the DeleteOpenIDConnectProvider operation.
func (c *IAM) DeleteOpenIDConnectProviderRequest(input *DeleteOpenIDConnectProviderInput) (req *request.Request, output *DeleteOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOpenIDConnectProviderInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteOpenIDConnectProviderOutput{}
	req.Data = output
	return
}

// Deletes an IAM OpenID Connect identity provider.
//
// Deleting an OIDC provider does not update any roles that reference the provider
// as a principal in their trust policies. Any attempt to assume a role that
// references a provider that has been deleted will fail.
//
// This action is idempotent; it does not fail or return an error if you call
// the action for a provider that was already deleted.
func (c *IAM) DeleteOpenIDConnectProvider(input *DeleteOpenIDConnectProviderInput) (*DeleteOpenIDConnectProviderOutput, error) {
	req, out := c.DeleteOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a request for the DeletePolicy operation.
func (c *IAM) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeletePolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified managed policy.
//
// Before you can delete a managed policy, you must detach the policy from
// all users, groups, and roles that it is attached to, and you must delete
// all of the policy's versions. The following steps describe the process for
// deleting a managed policy:  Detach the policy from all users, groups, and
// roles that the policy is attached to, using the DetachUserPolicy, DetachGroupPolicy,
// or DetachRolePolicy APIs. To list all the users, groups, and roles that a
// policy is attached to, use ListEntitiesForPolicy.  Delete all versions of
// the policy using DeletePolicyVersion. To list the policy's versions, use
// ListPolicyVersions. You cannot use DeletePolicyVersion to delete the version
// that is marked as the default version. You delete the policy's default version
// in the next step of the process.  Delete the policy (this automatically deletes
// the policy's default version) using this API.
//
// For information about managed policies, refer to Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePolicyVersion = "DeletePolicyVersion"

// DeletePolicyVersionRequest generates a request for the DeletePolicyVersion operation.
func (c *IAM) DeletePolicyVersionRequest(input *DeletePolicyVersionInput) (req *request.Request, output *DeletePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeletePolicyVersionOutput{}
	req.Data = output
	return
}

// Deletes the specified version of the specified managed policy.
//
// You cannot delete the default version of a policy using this API. To delete
// the default version of a policy, use DeletePolicy. To find out which version
// of a policy is marked as the default version, use ListPolicyVersions.
//
// For information about versions for managed policies, refer to Versioning
// for Managed Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
// in the IAM User Guide.
func (c *IAM) DeletePolicyVersion(input *DeletePolicyVersionInput) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRole = "DeleteRole"

// DeleteRoleRequest generates a request for the DeleteRole operation.
func (c *IAM) DeleteRoleRequest(input *DeleteRoleInput) (req *request.Request, output *DeleteRoleOutput) {
	op := &request.Operation{
		Name:       opDeleteRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRoleInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteRoleOutput{}
	req.Data = output
	return
}

// Deletes the specified role. The role must not have any policies attached.
// For more information about roles, go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
//
// Make sure you do not have any Amazon EC2 instances running with the role
// you are about to delete. Deleting a role or instance profile that is associated
// with a running instance will break any applications running on the instance.
func (c *IAM) DeleteRole(input *DeleteRoleInput) (*DeleteRoleOutput, error) {
	req, out := c.DeleteRoleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRolePolicy = "DeleteRolePolicy"

// DeleteRolePolicyRequest generates a request for the DeleteRolePolicy operation.
func (c *IAM) DeleteRolePolicyRequest(input *DeleteRolePolicyInput) (req *request.Request, output *DeleteRolePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRolePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteRolePolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified inline policy that is embedded in the specified role.
//
// A role can also have managed policies attached to it. To detach a managed
// policy from a role, use DetachRolePolicy. For more information about policies,
// refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) DeleteRolePolicy(input *DeleteRolePolicyInput) (*DeleteRolePolicyOutput, error) {
	req, out := c.DeleteRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSAMLProvider = "DeleteSAMLProvider"

// DeleteSAMLProviderRequest generates a request for the DeleteSAMLProvider operation.
func (c *IAM) DeleteSAMLProviderRequest(input *DeleteSAMLProviderInput) (req *request.Request, output *DeleteSAMLProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSAMLProviderInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteSAMLProviderOutput{}
	req.Data = output
	return
}

// Deletes a SAML provider.
//
//  Deleting the provider does not update any roles that reference the SAML
// provider as a principal in their trust policies. Any attempt to assume a
// role that references a SAML provider that has been deleted will fail.
//
//  This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
func (c *IAM) DeleteSAMLProvider(input *DeleteSAMLProviderInput) (*DeleteSAMLProviderOutput, error) {
	req, out := c.DeleteSAMLProviderRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSSHPublicKey = "DeleteSSHPublicKey"

// DeleteSSHPublicKeyRequest generates a request for the DeleteSSHPublicKey operation.
func (c *IAM) DeleteSSHPublicKeyRequest(input *DeleteSSHPublicKeyInput) (req *request.Request, output *DeleteSSHPublicKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSSHPublicKeyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteSSHPublicKeyOutput{}
	req.Data = output
	return
}

// Deletes the specified SSH public key.
//
// The SSH public key deleted by this action is used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
func (c *IAM) DeleteSSHPublicKey(input *DeleteSSHPublicKeyInput) (*DeleteSSHPublicKeyOutput, error) {
	req, out := c.DeleteSSHPublicKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteServerCertificate = "DeleteServerCertificate"

// DeleteServerCertificateRequest generates a request for the DeleteServerCertificate operation.
func (c *IAM) DeleteServerCertificateRequest(input *DeleteServerCertificateInput) (req *request.Request, output *DeleteServerCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteServerCertificateOutput{}
	req.Data = output
	return
}

// Deletes the specified server certificate.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
//
//  If you are using a server certificate with Elastic Load Balancing, deleting
// the certificate could have implications for your application. If Elastic
// Load Balancing doesn't detect the deletion of bound certificates, it may
// continue to use the certificates. This could cause Elastic Load Balancing
// to stop accepting traffic. We recommend that you remove the reference to
// the certificate from Elastic Load Balancing before using this command to
// delete the certificate. For more information, go to DeleteLoadBalancerListeners
// (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html)
// in the Elastic Load Balancing API Reference.
func (c *IAM) DeleteServerCertificate(input *DeleteServerCertificateInput) (*DeleteServerCertificateOutput, error) {
	req, out := c.DeleteServerCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSigningCertificate = "DeleteSigningCertificate"

// DeleteSigningCertificateRequest generates a request for the DeleteSigningCertificate operation.
func (c *IAM) DeleteSigningCertificateRequest(input *DeleteSigningCertificateInput) (req *request.Request, output *DeleteSigningCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSigningCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteSigningCertificateOutput{}
	req.Data = output
	return
}

// Deletes the specified signing certificate associated with the specified user.
//
// If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request. Because this action works
// for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
func (c *IAM) DeleteSigningCertificate(input *DeleteSigningCertificateInput) (*DeleteSigningCertificateOutput, error) {
	req, out := c.DeleteSigningCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a request for the DeleteUser operation.
func (c *IAM) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteUserOutput{}
	req.Data = output
	return
}

// Deletes the specified user. The user must not belong to any groups, have
// any keys or signing certificates, or have any attached policies.
func (c *IAM) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUserPolicy = "DeleteUserPolicy"

// DeleteUserPolicyRequest generates a request for the DeleteUserPolicy operation.
func (c *IAM) DeleteUserPolicyRequest(input *DeleteUserPolicyInput) (req *request.Request, output *DeleteUserPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteUserPolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified inline policy that is embedded in the specified user.
//
// A user can also have managed policies attached to it. To detach a managed
// policy from a user, use DetachUserPolicy. For more information about policies,
// refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) DeleteUserPolicy(input *DeleteUserPolicyInput) (*DeleteUserPolicyOutput, error) {
	req, out := c.DeleteUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVirtualMFADevice = "DeleteVirtualMFADevice"

// DeleteVirtualMFADeviceRequest generates a request for the DeleteVirtualMFADevice operation.
func (c *IAM) DeleteVirtualMFADeviceRequest(input *DeleteVirtualMFADeviceInput) (req *request.Request, output *DeleteVirtualMFADeviceOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVirtualMFADeviceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteVirtualMFADeviceOutput{}
	req.Data = output
	return
}

// Deletes a virtual MFA device.
//
//  You must deactivate a user's virtual MFA device before you can delete it.
// For information about deactivating MFA devices, see DeactivateMFADevice.
func (c *IAM) DeleteVirtualMFADevice(input *DeleteVirtualMFADeviceInput) (*DeleteVirtualMFADeviceOutput, error) {
	req, out := c.DeleteVirtualMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opDetachGroupPolicy = "DetachGroupPolicy"

// DetachGroupPolicyRequest generates a request for the DetachGroupPolicy operation.
func (c *IAM) DetachGroupPolicyRequest(input *DetachGroupPolicyInput) (req *request.Request, output *DetachGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachGroupPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DetachGroupPolicyOutput{}
	req.Data = output
	return
}

// Removes the specified managed policy from the specified group.
//
// A group can also have inline policies embedded with it. To delete an inline
// policy, use the DeleteGroupPolicy API. For information about policies, refer
// to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) DetachGroupPolicy(input *DetachGroupPolicyInput) (*DetachGroupPolicyOutput, error) {
	req, out := c.DetachGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDetachRolePolicy = "DetachRolePolicy"

// DetachRolePolicyRequest generates a request for the DetachRolePolicy operation.
func (c *IAM) DetachRolePolicyRequest(input *DetachRolePolicyInput) (req *request.Request, output *DetachRolePolicyOutput) {
	op := &request.Operation{
		Name:       opDetachRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachRolePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DetachRolePolicyOutput{}
	req.Data = output
	return
}

// Removes the specified managed policy from the specified role.
//
// A role can also have inline policies embedded with it. To delete an inline
// policy, use the DeleteRolePolicy API. For information about policies, refer
// to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) DetachRolePolicy(input *DetachRolePolicyInput) (*DetachRolePolicyOutput, error) {
	req, out := c.DetachRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDetachUserPolicy = "DetachUserPolicy"

// DetachUserPolicyRequest generates a request for the DetachUserPolicy operation.
func (c *IAM) DetachUserPolicyRequest(input *DetachUserPolicyInput) (req *request.Request, output *DetachUserPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachUserPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DetachUserPolicyOutput{}
	req.Data = output
	return
}

// Removes the specified managed policy from the specified user.
//
// A user can also have inline policies embedded with it. To delete an inline
// policy, use the DeleteUserPolicy API. For information about policies, refer
// to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) DetachUserPolicy(input *DetachUserPolicyInput) (*DetachUserPolicyOutput, error) {
	req, out := c.DetachUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opEnableMFADevice = "EnableMFADevice"

// EnableMFADeviceRequest generates a request for the EnableMFADevice operation.
func (c *IAM) EnableMFADeviceRequest(input *EnableMFADeviceInput) (req *request.Request, output *EnableMFADeviceOutput) {
	op := &request.Operation{
		Name:       opEnableMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableMFADeviceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &EnableMFADeviceOutput{}
	req.Data = output
	return
}

// Enables the specified MFA device and associates it with the specified user
// name. When enabled, the MFA device is required for every subsequent login
// by the user name associated with the device.
func (c *IAM) EnableMFADevice(input *EnableMFADeviceInput) (*EnableMFADeviceOutput, error) {
	req, out := c.EnableMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateCredentialReport = "GenerateCredentialReport"

// GenerateCredentialReportRequest generates a request for the GenerateCredentialReport operation.
func (c *IAM) GenerateCredentialReportRequest(input *GenerateCredentialReportInput) (req *request.Request, output *GenerateCredentialReportOutput) {
	op := &request.Operation{
		Name:       opGenerateCredentialReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateCredentialReportInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateCredentialReportOutput{}
	req.Data = output
	return
}

// Generates a credential report for the AWS account. For more information about
// the credential report, see Getting Credential Reports (http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
// in the IAM User Guide.
func (c *IAM) GenerateCredentialReport(input *GenerateCredentialReportInput) (*GenerateCredentialReportOutput, error) {
	req, out := c.GenerateCredentialReportRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccessKeyLastUsed = "GetAccessKeyLastUsed"

// GetAccessKeyLastUsedRequest generates a request for the GetAccessKeyLastUsed operation.
func (c *IAM) GetAccessKeyLastUsedRequest(input *GetAccessKeyLastUsedInput) (req *request.Request, output *GetAccessKeyLastUsedOutput) {
	op := &request.Operation{
		Name:       opGetAccessKeyLastUsed,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccessKeyLastUsedInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetAccessKeyLastUsedOutput{}
	req.Data = output
	return
}

// Retrieves information about when the specified access key was last used.
// The information includes the date and time of last use, along with the AWS
// service and region that were specified in the last request made with that
// key.
func (c *IAM) GetAccessKeyLastUsed(input *GetAccessKeyLastUsedInput) (*GetAccessKeyLastUsedOutput, error) {
	req, out := c.GetAccessKeyLastUsedRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccountAuthorizationDetails = "GetAccountAuthorizationDetails"

// GetAccountAuthorizationDetailsRequest generates a request for the GetAccountAuthorizationDetails operation.
func (c *IAM) GetAccountAuthorizationDetailsRequest(input *GetAccountAuthorizationDetailsInput) (req *request.Request, output *GetAccountAuthorizationDetailsOutput) {
	op := &request.Operation{
		Name:       opGetAccountAuthorizationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &GetAccountAuthorizationDetailsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetAccountAuthorizationDetailsOutput{}
	req.Data = output
	return
}

// Retrieves information about all IAM users, groups, roles, and policies in
// your account, including their relationships to one another. Use this API
// to obtain a snapshot of the configuration of IAM permissions (users, groups,
// roles, and policies) in your account.
//
// You can optionally filter the results using the Filter parameter. You can
// paginate the results using the MaxItems and Marker parameters.
func (c *IAM) GetAccountAuthorizationDetails(input *GetAccountAuthorizationDetailsInput) (*GetAccountAuthorizationDetailsOutput, error) {
	req, out := c.GetAccountAuthorizationDetailsRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) GetAccountAuthorizationDetailsPages(input *GetAccountAuthorizationDetailsInput, fn func(p *GetAccountAuthorizationDetailsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetAccountAuthorizationDetailsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetAccountAuthorizationDetailsOutput), lastPage)
	})
}

const opGetAccountPasswordPolicy = "GetAccountPasswordPolicy"

// GetAccountPasswordPolicyRequest generates a request for the GetAccountPasswordPolicy operation.
func (c *IAM) GetAccountPasswordPolicyRequest(input *GetAccountPasswordPolicyInput) (req *request.Request, output *GetAccountPasswordPolicyOutput) {
	op := &request.Operation{
		Name:       opGetAccountPasswordPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountPasswordPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetAccountPasswordPolicyOutput{}
	req.Data = output
	return
}

// Retrieves the password policy for the AWS account. For more information about
// using a password policy, go to Managing an IAM Password Policy (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html).
func (c *IAM) GetAccountPasswordPolicy(input *GetAccountPasswordPolicyInput) (*GetAccountPasswordPolicyOutput, error) {
	req, out := c.GetAccountPasswordPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccountSummary = "GetAccountSummary"

// GetAccountSummaryRequest generates a request for the GetAccountSummary operation.
func (c *IAM) GetAccountSummaryRequest(input *GetAccountSummaryInput) (req *request.Request, output *GetAccountSummaryOutput) {
	op := &request.Operation{
		Name:       opGetAccountSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSummaryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetAccountSummaryOutput{}
	req.Data = output
	return
}

// Retrieves information about IAM entity usage and IAM quotas in the AWS account.
//
//  For information about limitations on IAM entities, see Limitations on IAM
// Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
func (c *IAM) GetAccountSummary(input *GetAccountSummaryInput) (*GetAccountSummaryOutput, error) {
	req, out := c.GetAccountSummaryRequest(input)
	err := req.Send()
	return out, err
}

const opGetContextKeysForCustomPolicy = "GetContextKeysForCustomPolicy"

// GetContextKeysForCustomPolicyRequest generates a request for the GetContextKeysForCustomPolicy operation.
func (c *IAM) GetContextKeysForCustomPolicyRequest(input *GetContextKeysForCustomPolicyInput) (req *request.Request, output *GetContextKeysForPolicyResponse) {
	op := &request.Operation{
		Name:       opGetContextKeysForCustomPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContextKeysForCustomPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetContextKeysForPolicyResponse{}
	req.Data = output
	return
}

// Gets a list of all of the context keys referenced in Condition elements in
// the input policies. The policies are supplied as a list of one or more strings.
// To get the context keys from policies associated with an IAM user, group,
// or role, use GetContextKeysForPrincipalPolicy.
//
// Context keys are variables maintained by AWS and its services that provide
// details about the context of an API query request, and can be evaluated by
// using the Condition element of an IAM policy. Use GetContextKeysForCustomPolicy
// to understand what key names and values you must supply when you call SimulateCustomPolicy.
// Note that all parameters are shown in unencoded form here for clarity, but
// must be URL encoded to be included as a part of a real HTML request.
func (c *IAM) GetContextKeysForCustomPolicy(input *GetContextKeysForCustomPolicyInput) (*GetContextKeysForPolicyResponse, error) {
	req, out := c.GetContextKeysForCustomPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetContextKeysForPrincipalPolicy = "GetContextKeysForPrincipalPolicy"

// GetContextKeysForPrincipalPolicyRequest generates a request for the GetContextKeysForPrincipalPolicy operation.
func (c *IAM) GetContextKeysForPrincipalPolicyRequest(input *GetContextKeysForPrincipalPolicyInput) (req *request.Request, output *GetContextKeysForPolicyResponse) {
	op := &request.Operation{
		Name:       opGetContextKeysForPrincipalPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContextKeysForPrincipalPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetContextKeysForPolicyResponse{}
	req.Data = output
	return
}

// Gets a list of all of the context keys referenced in Condition elements in
// all of the IAM policies attached to the specified IAM entity. The entity
// can be an IAM user, group, or role. If you specify a user, then the request
// also includes all of the policies attached to groups that the user is a member
// of.
//
// You can optionally include a list of one or more additional policies, specified
// as strings. If you want to include only a list of policies by string, use
// GetContextKeysForCustomPolicy instead.
//
// Note: This API discloses information about the permissions granted to other
// users. If you do not want users to see other user's permissions, then consider
// allowing them to use GetContextKeysForCustomPolicy instead.
//
// Context keys are variables maintained by AWS and its services that provide
// details about the context of an API query request, and can be evaluated by
// using the Condition element of an IAM policy. Use GetContextKeysForPrincipalPolicy
// to understand what key names and values you must supply when you call SimulatePrincipalPolicy.
func (c *IAM) GetContextKeysForPrincipalPolicy(input *GetContextKeysForPrincipalPolicyInput) (*GetContextKeysForPolicyResponse, error) {
	req, out := c.GetContextKeysForPrincipalPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetCredentialReport = "GetCredentialReport"

// GetCredentialReportRequest generates a request for the GetCredentialReport operation.
func (c *IAM) GetCredentialReportRequest(input *GetCredentialReportInput) (req *request.Request, output *GetCredentialReportOutput) {
	op := &request.Operation{
		Name:       opGetCredentialReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCredentialReportInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCredentialReportOutput{}
	req.Data = output
	return
}

// Retrieves a credential report for the AWS account. For more information about
// the credential report, see Getting Credential Reports (http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
// in the IAM User Guide.
func (c *IAM) GetCredentialReport(input *GetCredentialReportInput) (*GetCredentialReportOutput, error) {
	req, out := c.GetCredentialReportRequest(input)
	err := req.Send()
	return out, err
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a request for the GetGroup operation.
func (c *IAM) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetGroupOutput{}
	req.Data = output
	return
}

// Returns a list of users that are in the specified group. You can paginate
// the results using the MaxItems and Marker parameters.
func (c *IAM) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) GetGroupPages(input *GetGroupInput, fn func(p *GetGroupOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetGroupRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetGroupOutput), lastPage)
	})
}

const opGetGroupPolicy = "GetGroupPolicy"

// GetGroupPolicyRequest generates a request for the GetGroupPolicy operation.
func (c *IAM) GetGroupPolicyRequest(input *GetGroupPolicyInput) (req *request.Request, output *GetGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opGetGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGroupPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetGroupPolicyOutput{}
	req.Data = output
	return
}

// Retrieves the specified inline policy document that is embedded in the specified
// group.
//
// A group can also have managed policies attached to it. To retrieve a managed
// policy document that is attached to a group, use GetPolicy to determine the
// policy's default version, then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, refer to Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) GetGroupPolicy(input *GetGroupPolicyInput) (*GetGroupPolicyOutput, error) {
	req, out := c.GetGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetInstanceProfile = "GetInstanceProfile"

// GetInstanceProfileRequest generates a request for the GetInstanceProfile operation.
func (c *IAM) GetInstanceProfileRequest(input *GetInstanceProfileInput) (req *request.Request, output *GetInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opGetInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetInstanceProfileOutput{}
	req.Data = output
	return
}

// Retrieves information about the specified instance profile, including the
// instance profile's path, GUID, ARN, and role. For more information about
// instance profiles, go to About Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
// For more information about ARNs, go to ARNs (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html#Identifiers_ARNs).
func (c *IAM) GetInstanceProfile(input *GetInstanceProfileInput) (*GetInstanceProfileOutput, error) {
	req, out := c.GetInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opGetLoginProfile = "GetLoginProfile"

// GetLoginProfileRequest generates a request for the GetLoginProfile operation.
func (c *IAM) GetLoginProfileRequest(input *GetLoginProfileInput) (req *request.Request, output *GetLoginProfileOutput) {
	op := &request.Operation{
		Name:       opGetLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoginProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetLoginProfileOutput{}
	req.Data = output
	return
}

// Retrieves the user name and password-creation date for the specified user.
// If the user has not been assigned a password, the action returns a 404 (NoSuchEntity)
// error.
func (c *IAM) GetLoginProfile(input *GetLoginProfileInput) (*GetLoginProfileOutput, error) {
	req, out := c.GetLoginProfileRequest(input)
	err := req.Send()
	return out, err
}

const opGetOpenIDConnectProvider = "GetOpenIDConnectProvider"

// GetOpenIDConnectProviderRequest generates a request for the GetOpenIDConnectProvider operation.
func (c *IAM) GetOpenIDConnectProviderRequest(input *GetOpenIDConnectProviderInput) (req *request.Request, output *GetOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opGetOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpenIDConnectProviderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetOpenIDConnectProviderOutput{}
	req.Data = output
	return
}

// Returns information about the specified OpenID Connect provider.
func (c *IAM) GetOpenIDConnectProvider(input *GetOpenIDConnectProviderInput) (*GetOpenIDConnectProviderOutput, error) {
	req, out := c.GetOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a request for the GetPolicy operation.
func (c *IAM) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPolicyOutput{}
	req.Data = output
	return
}

// Retrieves information about the specified managed policy, including the policy's
// default version and the total number of users, groups, and roles that the
// policy is attached to. For a list of the specific users, groups, and roles
// that the policy is attached to, use the ListEntitiesForPolicy API. This API
// returns metadata about the policy. To retrieve the policy document for a
// specific version of the policy, use GetPolicyVersion.
//
// This API retrieves information about managed policies. To retrieve information
// about an inline policy that is embedded with a user, group, or role, use
// the GetUserPolicy, GetGroupPolicy, or GetRolePolicy API.
//
// For more information about policies, refer to Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicyVersion = "GetPolicyVersion"

// GetPolicyVersionRequest generates a request for the GetPolicyVersion operation.
func (c *IAM) GetPolicyVersionRequest(input *GetPolicyVersionInput) (req *request.Request, output *GetPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opGetPolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPolicyVersionOutput{}
	req.Data = output
	return
}

// Retrieves information about the specified version of the specified managed
// policy, including the policy document.
//
// To list the available versions for a policy, use ListPolicyVersions.
//
// This API retrieves information about managed policies. To retrieve information
// about an inline policy that is embedded in a user, group, or role, use the
// GetUserPolicy, GetGroupPolicy, or GetRolePolicy API.
//
// For more information about the types of policies, refer to Managed Policies
// and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) GetPolicyVersion(input *GetPolicyVersionInput) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opGetRole = "GetRole"

// GetRoleRequest generates a request for the GetRole operation.
func (c *IAM) GetRoleRequest(input *GetRoleInput) (req *request.Request, output *GetRoleOutput) {
	op := &request.Operation{
		Name:       opGetRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRoleOutput{}
	req.Data = output
	return
}

// Retrieves information about the specified role, including the role's path,
// GUID, ARN, and the policy granting permission to assume the role. For more
// information about ARNs, go to ARNs (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html#Identifiers_ARNs).
// For more information about roles, go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
func (c *IAM) GetRole(input *GetRoleInput) (*GetRoleOutput, error) {
	req, out := c.GetRoleRequest(input)
	err := req.Send()
	return out, err
}

const opGetRolePolicy = "GetRolePolicy"

// GetRolePolicyRequest generates a request for the GetRolePolicy operation.
func (c *IAM) GetRolePolicyRequest(input *GetRolePolicyInput) (req *request.Request, output *GetRolePolicyOutput) {
	op := &request.Operation{
		Name:       opGetRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRolePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRolePolicyOutput{}
	req.Data = output
	return
}

// Retrieves the specified inline policy document that is embedded with the
// specified role.
//
// A role can also have managed policies attached to it. To retrieve a managed
// policy document that is attached to a role, use GetPolicy to determine the
// policy's default version, then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, refer to Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For more information about roles, go to Using Roles to Delegate Permissions
// and Federate Identities (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
func (c *IAM) GetRolePolicy(input *GetRolePolicyInput) (*GetRolePolicyOutput, error) {
	req, out := c.GetRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetSAMLProvider = "GetSAMLProvider"

// GetSAMLProviderRequest generates a request for the GetSAMLProvider operation.
func (c *IAM) GetSAMLProviderRequest(input *GetSAMLProviderInput) (req *request.Request, output *GetSAMLProviderOutput) {
	op := &request.Operation{
		Name:       opGetSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSAMLProviderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSAMLProviderOutput{}
	req.Data = output
	return
}

// Returns the SAML provider metadocument that was uploaded when the provider
// was created or updated.
//
// This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
func (c *IAM) GetSAMLProvider(input *GetSAMLProviderInput) (*GetSAMLProviderOutput, error) {
	req, out := c.GetSAMLProviderRequest(input)
	err := req.Send()
	return out, err
}

const opGetSSHPublicKey = "GetSSHPublicKey"

// GetSSHPublicKeyRequest generates a request for the GetSSHPublicKey operation.
func (c *IAM) GetSSHPublicKeyRequest(input *GetSSHPublicKeyInput) (req *request.Request, output *GetSSHPublicKeyOutput) {
	op := &request.Operation{
		Name:       opGetSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSSHPublicKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSSHPublicKeyOutput{}
	req.Data = output
	return
}

// Retrieves the specified SSH public key, including metadata about the key.
//
// The SSH public key retrieved by this action is used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
func (c *IAM) GetSSHPublicKey(input *GetSSHPublicKeyInput) (*GetSSHPublicKeyOutput, error) {
	req, out := c.GetSSHPublicKeyRequest(input)
	err := req.Send()
	return out, err
}

const opGetServerCertificate = "GetServerCertificate"

// GetServerCertificateRequest generates a request for the GetServerCertificate operation.
func (c *IAM) GetServerCertificateRequest(input *GetServerCertificateInput) (req *request.Request, output *GetServerCertificateOutput) {
	op := &request.Operation{
		Name:       opGetServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServerCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetServerCertificateOutput{}
	req.Data = output
	return
}

// Retrieves information about the specified server certificate.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
func (c *IAM) GetServerCertificate(input *GetServerCertificateInput) (*GetServerCertificateOutput, error) {
	req, out := c.GetServerCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opGetUser = "GetUser"

// GetUserRequest generates a request for the GetUser operation.
func (c *IAM) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetUserOutput{}
	req.Data = output
	return
}

// Retrieves information about the specified user, including the user's creation
// date, path, unique ID, and ARN.
//
// If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID used to sign the request.
func (c *IAM) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	err := req.Send()
	return out, err
}

const opGetUserPolicy = "GetUserPolicy"

// GetUserPolicyRequest generates a request for the GetUserPolicy operation.
func (c *IAM) GetUserPolicyRequest(input *GetUserPolicyInput) (req *request.Request, output *GetUserPolicyOutput) {
	op := &request.Operation{
		Name:       opGetUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetUserPolicyOutput{}
	req.Data = output
	return
}

// Retrieves the specified inline policy document that is embedded in the specified
// user.
//
// A user can also have managed policies attached to it. To retrieve a managed
// policy document that is attached to a user, use GetPolicy to determine the
// policy's default version, then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, refer to Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) GetUserPolicy(input *GetUserPolicyInput) (*GetUserPolicyOutput, error) {
	req, out := c.GetUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opListAccessKeys = "ListAccessKeys"

// ListAccessKeysRequest generates a request for the ListAccessKeys operation.
func (c *IAM) ListAccessKeysRequest(input *ListAccessKeysInput) (req *request.Request, output *ListAccessKeysOutput) {
	op := &request.Operation{
		Name:       opListAccessKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAccessKeysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAccessKeysOutput{}
	req.Data = output
	return
}

// Returns information about the access key IDs associated with the specified
// user. If there are none, the action returns an empty list.
//
// Although each user is limited to a small number of keys, you can still paginate
// the results using the MaxItems and Marker parameters.
//
// If the UserName field is not specified, the UserName is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// To ensure the security of your AWS account, the secret access key is accessible
// only during key and user creation.
func (c *IAM) ListAccessKeys(input *ListAccessKeysInput) (*ListAccessKeysOutput, error) {
	req, out := c.ListAccessKeysRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListAccessKeysPages(input *ListAccessKeysInput, fn func(p *ListAccessKeysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAccessKeysRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAccessKeysOutput), lastPage)
	})
}

const opListAccountAliases = "ListAccountAliases"

// ListAccountAliasesRequest generates a request for the ListAccountAliases operation.
func (c *IAM) ListAccountAliasesRequest(input *ListAccountAliasesInput) (req *request.Request, output *ListAccountAliasesOutput) {
	op := &request.Operation{
		Name:       opListAccountAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAccountAliasesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAccountAliasesOutput{}
	req.Data = output
	return
}

// Lists the account alias associated with the account (Note: you can have only
// one). For information about using an AWS account alias, see Using an Alias
// for Your AWS Account ID (http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
// in the IAM User Guide.
func (c *IAM) ListAccountAliases(input *ListAccountAliasesInput) (*ListAccountAliasesOutput, error) {
	req, out := c.ListAccountAliasesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListAccountAliasesPages(input *ListAccountAliasesInput, fn func(p *ListAccountAliasesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAccountAliasesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAccountAliasesOutput), lastPage)
	})
}

const opListAttachedGroupPolicies = "ListAttachedGroupPolicies"

// ListAttachedGroupPoliciesRequest generates a request for the ListAttachedGroupPolicies operation.
func (c *IAM) ListAttachedGroupPoliciesRequest(input *ListAttachedGroupPoliciesInput) (req *request.Request, output *ListAttachedGroupPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAttachedGroupPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAttachedGroupPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAttachedGroupPoliciesOutput{}
	req.Data = output
	return
}

// Lists all managed policies that are attached to the specified group.
//
// A group can also have inline policies embedded with it. To list the inline
// policies for a group, use the ListGroupPolicies API. For information about
// policies, refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. You
// can use the PathPrefix parameter to limit the list of policies to only those
// matching the specified path prefix. If there are no policies attached to
// the specified group (or none that match the specified path prefix), the action
// returns an empty list.
func (c *IAM) ListAttachedGroupPolicies(input *ListAttachedGroupPoliciesInput) (*ListAttachedGroupPoliciesOutput, error) {
	req, out := c.ListAttachedGroupPoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListAttachedGroupPoliciesPages(input *ListAttachedGroupPoliciesInput, fn func(p *ListAttachedGroupPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAttachedGroupPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAttachedGroupPoliciesOutput), lastPage)
	})
}

const opListAttachedRolePolicies = "ListAttachedRolePolicies"

// ListAttachedRolePoliciesRequest generates a request for the ListAttachedRolePolicies operation.
func (c *IAM) ListAttachedRolePoliciesRequest(input *ListAttachedRolePoliciesInput) (req *request.Request, output *ListAttachedRolePoliciesOutput) {
	op := &request.Operation{
		Name:       opListAttachedRolePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAttachedRolePoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAttachedRolePoliciesOutput{}
	req.Data = output
	return
}

// Lists all managed policies that are attached to the specified role.
//
// A role can also have inline policies embedded with it. To list the inline
// policies for a role, use the ListRolePolicies API. For information about
// policies, refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. You
// can use the PathPrefix parameter to limit the list of policies to only those
// matching the specified path prefix. If there are no policies attached to
// the specified role (or none that match the specified path prefix), the action
// returns an empty list.
func (c *IAM) ListAttachedRolePolicies(input *ListAttachedRolePoliciesInput) (*ListAttachedRolePoliciesOutput, error) {
	req, out := c.ListAttachedRolePoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListAttachedRolePoliciesPages(input *ListAttachedRolePoliciesInput, fn func(p *ListAttachedRolePoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAttachedRolePoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAttachedRolePoliciesOutput), lastPage)
	})
}

const opListAttachedUserPolicies = "ListAttachedUserPolicies"

// ListAttachedUserPoliciesRequest generates a request for the ListAttachedUserPolicies operation.
func (c *IAM) ListAttachedUserPoliciesRequest(input *ListAttachedUserPoliciesInput) (req *request.Request, output *ListAttachedUserPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAttachedUserPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAttachedUserPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAttachedUserPoliciesOutput{}
	req.Data = output
	return
}

// Lists all managed policies that are attached to the specified user.
//
// A user can also have inline policies embedded with it. To list the inline
// policies for a user, use the ListUserPolicies API. For information about
// policies, refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. You
// can use the PathPrefix parameter to limit the list of policies to only those
// matching the specified path prefix. If there are no policies attached to
// the specified group (or none that match the specified path prefix), the action
// returns an empty list.
func (c *IAM) ListAttachedUserPolicies(input *ListAttachedUserPoliciesInput) (*ListAttachedUserPoliciesOutput, error) {
	req, out := c.ListAttachedUserPoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListAttachedUserPoliciesPages(input *ListAttachedUserPoliciesInput, fn func(p *ListAttachedUserPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAttachedUserPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAttachedUserPoliciesOutput), lastPage)
	})
}

const opListEntitiesForPolicy = "ListEntitiesForPolicy"

// ListEntitiesForPolicyRequest generates a request for the ListEntitiesForPolicy operation.
func (c *IAM) ListEntitiesForPolicyRequest(input *ListEntitiesForPolicyInput) (req *request.Request, output *ListEntitiesForPolicyOutput) {
	op := &request.Operation{
		Name:       opListEntitiesForPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListEntitiesForPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListEntitiesForPolicyOutput{}
	req.Data = output
	return
}

// Lists all users, groups, and roles that the specified managed policy is attached
// to.
//
// You can use the optional EntityFilter parameter to limit the results to
// a particular type of entity (users, groups, or roles). For example, to list
// only the roles that are attached to the specified policy, set EntityFilter
// to Role.
//
// You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListEntitiesForPolicy(input *ListEntitiesForPolicyInput) (*ListEntitiesForPolicyOutput, error) {
	req, out := c.ListEntitiesForPolicyRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListEntitiesForPolicyPages(input *ListEntitiesForPolicyInput, fn func(p *ListEntitiesForPolicyOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListEntitiesForPolicyRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListEntitiesForPolicyOutput), lastPage)
	})
}

const opListGroupPolicies = "ListGroupPolicies"

// ListGroupPoliciesRequest generates a request for the ListGroupPolicies operation.
func (c *IAM) ListGroupPoliciesRequest(input *ListGroupPoliciesInput) (req *request.Request, output *ListGroupPoliciesOutput) {
	op := &request.Operation{
		Name:       opListGroupPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListGroupPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGroupPoliciesOutput{}
	req.Data = output
	return
}

// Lists the names of the inline policies that are embedded in the specified
// group.
//
// A group can also have managed policies attached to it. To list the managed
// policies that are attached to a group, use ListAttachedGroupPolicies. For
// more information about policies, refer to Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. If
// there are no inline policies embedded with the specified group, the action
// returns an empty list.
func (c *IAM) ListGroupPolicies(input *ListGroupPoliciesInput) (*ListGroupPoliciesOutput, error) {
	req, out := c.ListGroupPoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListGroupPoliciesPages(input *ListGroupPoliciesInput, fn func(p *ListGroupPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGroupPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGroupPoliciesOutput), lastPage)
	})
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a request for the ListGroups operation.
func (c *IAM) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGroupsOutput{}
	req.Data = output
	return
}

// Lists the groups that have the specified path prefix.
//
//  You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListGroupsPages(input *ListGroupsInput, fn func(p *ListGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGroupsOutput), lastPage)
	})
}

const opListGroupsForUser = "ListGroupsForUser"

// ListGroupsForUserRequest generates a request for the ListGroupsForUser operation.
func (c *IAM) ListGroupsForUserRequest(input *ListGroupsForUserInput) (req *request.Request, output *ListGroupsForUserOutput) {
	op := &request.Operation{
		Name:       opListGroupsForUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListGroupsForUserInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGroupsForUserOutput{}
	req.Data = output
	return
}

// Lists the groups the specified user belongs to.
//
// You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListGroupsForUser(input *ListGroupsForUserInput) (*ListGroupsForUserOutput, error) {
	req, out := c.ListGroupsForUserRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListGroupsForUserPages(input *ListGroupsForUserInput, fn func(p *ListGroupsForUserOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGroupsForUserRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGroupsForUserOutput), lastPage)
	})
}

const opListInstanceProfiles = "ListInstanceProfiles"

// ListInstanceProfilesRequest generates a request for the ListInstanceProfiles operation.
func (c *IAM) ListInstanceProfilesRequest(input *ListInstanceProfilesInput) (req *request.Request, output *ListInstanceProfilesOutput) {
	op := &request.Operation{
		Name:       opListInstanceProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListInstanceProfilesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListInstanceProfilesOutput{}
	req.Data = output
	return
}

// Lists the instance profiles that have the specified path prefix. If there
// are none, the action returns an empty list. For more information about instance
// profiles, go to About Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
// You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListInstanceProfiles(input *ListInstanceProfilesInput) (*ListInstanceProfilesOutput, error) {
	req, out := c.ListInstanceProfilesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListInstanceProfilesPages(input *ListInstanceProfilesInput, fn func(p *ListInstanceProfilesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInstanceProfilesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInstanceProfilesOutput), lastPage)
	})
}

const opListInstanceProfilesForRole = "ListInstanceProfilesForRole"

// ListInstanceProfilesForRoleRequest generates a request for the ListInstanceProfilesForRole operation.
func (c *IAM) ListInstanceProfilesForRoleRequest(input *ListInstanceProfilesForRoleInput) (req *request.Request, output *ListInstanceProfilesForRoleOutput) {
	op := &request.Operation{
		Name:       opListInstanceProfilesForRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListInstanceProfilesForRoleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListInstanceProfilesForRoleOutput{}
	req.Data = output
	return
}

// Lists the instance profiles that have the specified associated role. If there
// are none, the action returns an empty list. For more information about instance
// profiles, go to About Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
// You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListInstanceProfilesForRole(input *ListInstanceProfilesForRoleInput) (*ListInstanceProfilesForRoleOutput, error) {
	req, out := c.ListInstanceProfilesForRoleRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListInstanceProfilesForRolePages(input *ListInstanceProfilesForRoleInput, fn func(p *ListInstanceProfilesForRoleOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInstanceProfilesForRoleRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInstanceProfilesForRoleOutput), lastPage)
	})
}

const opListMFADevices = "ListMFADevices"

// ListMFADevicesRequest generates a request for the ListMFADevices operation.
func (c *IAM) ListMFADevicesRequest(input *ListMFADevicesInput) (req *request.Request, output *ListMFADevicesOutput) {
	op := &request.Operation{
		Name:       opListMFADevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListMFADevicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListMFADevicesOutput{}
	req.Data = output
	return
}

// Lists the MFA devices. If the request includes the user name, then this action
// lists all the MFA devices associated with the specified user name. If you
// do not specify a user name, IAM determines the user name implicitly based
// on the AWS access key ID signing the request.
//
// You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListMFADevices(input *ListMFADevicesInput) (*ListMFADevicesOutput, error) {
	req, out := c.ListMFADevicesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListMFADevicesPages(input *ListMFADevicesInput, fn func(p *ListMFADevicesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListMFADevicesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListMFADevicesOutput), lastPage)
	})
}

const opListOpenIDConnectProviders = "ListOpenIDConnectProviders"

// ListOpenIDConnectProvidersRequest generates a request for the ListOpenIDConnectProviders operation.
func (c *IAM) ListOpenIDConnectProvidersRequest(input *ListOpenIDConnectProvidersInput) (req *request.Request, output *ListOpenIDConnectProvidersOutput) {
	op := &request.Operation{
		Name:       opListOpenIDConnectProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOpenIDConnectProvidersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListOpenIDConnectProvidersOutput{}
	req.Data = output
	return
}

// Lists information about the OpenID Connect providers in the AWS account.
func (c *IAM) ListOpenIDConnectProviders(input *ListOpenIDConnectProvidersInput) (*ListOpenIDConnectProvidersOutput, error) {
	req, out := c.ListOpenIDConnectProvidersRequest(input)
	err := req.Send()
	return out, err
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a request for the ListPolicies operation.
func (c *IAM) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPoliciesOutput{}
	req.Data = output
	return
}

// Lists all the managed policies that are available to your account, including
// your own customer managed policies and all AWS managed policies.
//
// You can filter the list of policies that is returned using the optional
// OnlyAttached, Scope, and PathPrefix parameters. For example, to list only
// the customer managed policies in your AWS account, set Scope to Local. To
// list only AWS managed policies, set Scope to AWS.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListPoliciesPages(input *ListPoliciesInput, fn func(p *ListPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPoliciesOutput), lastPage)
	})
}

const opListPolicyVersions = "ListPolicyVersions"

// ListPolicyVersionsRequest generates a request for the ListPolicyVersions operation.
func (c *IAM) ListPolicyVersionsRequest(input *ListPolicyVersionsInput) (req *request.Request, output *ListPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListPolicyVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPolicyVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPolicyVersionsOutput{}
	req.Data = output
	return
}

// Lists information about the versions of the specified managed policy, including
// the version that is set as the policy's default version.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) ListPolicyVersions(input *ListPolicyVersionsInput) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	err := req.Send()
	return out, err
}

const opListRolePolicies = "ListRolePolicies"

// ListRolePoliciesRequest generates a request for the ListRolePolicies operation.
func (c *IAM) ListRolePoliciesRequest(input *ListRolePoliciesInput) (req *request.Request, output *ListRolePoliciesOutput) {
	op := &request.Operation{
		Name:       opListRolePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListRolePoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRolePoliciesOutput{}
	req.Data = output
	return
}

// Lists the names of the inline policies that are embedded in the specified
// role.
//
// A role can also have managed policies attached to it. To list the managed
// policies that are attached to a role, use ListAttachedRolePolicies. For more
// information about policies, refer to Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. If
// there are no inline policies embedded with the specified role, the action
// returns an empty list.
func (c *IAM) ListRolePolicies(input *ListRolePoliciesInput) (*ListRolePoliciesOutput, error) {
	req, out := c.ListRolePoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListRolePoliciesPages(input *ListRolePoliciesInput, fn func(p *ListRolePoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListRolePoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListRolePoliciesOutput), lastPage)
	})
}

const opListRoles = "ListRoles"

// ListRolesRequest generates a request for the ListRoles operation.
func (c *IAM) ListRolesRequest(input *ListRolesInput) (req *request.Request, output *ListRolesOutput) {
	op := &request.Operation{
		Name:       opListRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListRolesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRolesOutput{}
	req.Data = output
	return
}

// Lists the roles that have the specified path prefix. If there are none, the
// action returns an empty list. For more information about roles, go to Working
// with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
//
// You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListRoles(input *ListRolesInput) (*ListRolesOutput, error) {
	req, out := c.ListRolesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListRolesPages(input *ListRolesInput, fn func(p *ListRolesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListRolesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListRolesOutput), lastPage)
	})
}

const opListSAMLProviders = "ListSAMLProviders"

// ListSAMLProvidersRequest generates a request for the ListSAMLProviders operation.
func (c *IAM) ListSAMLProvidersRequest(input *ListSAMLProvidersInput) (req *request.Request, output *ListSAMLProvidersOutput) {
	op := &request.Operation{
		Name:       opListSAMLProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSAMLProvidersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSAMLProvidersOutput{}
	req.Data = output
	return
}

// Lists the SAML providers in the account.
//
//  This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
func (c *IAM) ListSAMLProviders(input *ListSAMLProvidersInput) (*ListSAMLProvidersOutput, error) {
	req, out := c.ListSAMLProvidersRequest(input)
	err := req.Send()
	return out, err
}

const opListSSHPublicKeys = "ListSSHPublicKeys"

// ListSSHPublicKeysRequest generates a request for the ListSSHPublicKeys operation.
func (c *IAM) ListSSHPublicKeysRequest(input *ListSSHPublicKeysInput) (req *request.Request, output *ListSSHPublicKeysOutput) {
	op := &request.Operation{
		Name:       opListSSHPublicKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSSHPublicKeysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSSHPublicKeysOutput{}
	req.Data = output
	return
}

// Returns information about the SSH public keys associated with the specified
// IAM user. If there are none, the action returns an empty list.
//
// The SSH public keys returned by this action are used only for authenticating
// the IAM user to an AWS CodeCommit repository. For more information about
// using SSH keys to authenticate to an AWS CodeCommit repository, see Set up
// AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
// Although each user is limited to a small number of keys, you can still paginate
// the results using the MaxItems and Marker parameters.
func (c *IAM) ListSSHPublicKeys(input *ListSSHPublicKeysInput) (*ListSSHPublicKeysOutput, error) {
	req, out := c.ListSSHPublicKeysRequest(input)
	err := req.Send()
	return out, err
}

const opListServerCertificates = "ListServerCertificates"

// ListServerCertificatesRequest generates a request for the ListServerCertificates operation.
func (c *IAM) ListServerCertificatesRequest(input *ListServerCertificatesInput) (req *request.Request, output *ListServerCertificatesOutput) {
	op := &request.Operation{
		Name:       opListServerCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListServerCertificatesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListServerCertificatesOutput{}
	req.Data = output
	return
}

// Lists the server certificates that have the specified path prefix. If none
// exist, the action returns an empty list.
//
//  You can paginate the results using the MaxItems and Marker parameters.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
func (c *IAM) ListServerCertificates(input *ListServerCertificatesInput) (*ListServerCertificatesOutput, error) {
	req, out := c.ListServerCertificatesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListServerCertificatesPages(input *ListServerCertificatesInput, fn func(p *ListServerCertificatesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListServerCertificatesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListServerCertificatesOutput), lastPage)
	})
}

const opListSigningCertificates = "ListSigningCertificates"

// ListSigningCertificatesRequest generates a request for the ListSigningCertificates operation.
func (c *IAM) ListSigningCertificatesRequest(input *ListSigningCertificatesInput) (req *request.Request, output *ListSigningCertificatesOutput) {
	op := &request.Operation{
		Name:       opListSigningCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListSigningCertificatesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSigningCertificatesOutput{}
	req.Data = output
	return
}

// Returns information about the signing certificates associated with the specified
// user. If there are none, the action returns an empty list.
//
// Although each user is limited to a small number of signing certificates,
// you can still paginate the results using the MaxItems and Marker parameters.
//
// If the UserName field is not specified, the user name is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
func (c *IAM) ListSigningCertificates(input *ListSigningCertificatesInput) (*ListSigningCertificatesOutput, error) {
	req, out := c.ListSigningCertificatesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListSigningCertificatesPages(input *ListSigningCertificatesInput, fn func(p *ListSigningCertificatesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSigningCertificatesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSigningCertificatesOutput), lastPage)
	})
}

const opListUserPolicies = "ListUserPolicies"

// ListUserPoliciesRequest generates a request for the ListUserPolicies operation.
func (c *IAM) ListUserPoliciesRequest(input *ListUserPoliciesInput) (req *request.Request, output *ListUserPoliciesOutput) {
	op := &request.Operation{
		Name:       opListUserPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListUserPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListUserPoliciesOutput{}
	req.Data = output
	return
}

// Lists the names of the inline policies embedded in the specified user.
//
// A user can also have managed policies attached to it. To list the managed
// policies that are attached to a user, use ListAttachedUserPolicies. For more
// information about policies, refer to Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. If
// there are no inline policies embedded with the specified user, the action
// returns an empty list.
func (c *IAM) ListUserPolicies(input *ListUserPoliciesInput) (*ListUserPoliciesOutput, error) {
	req, out := c.ListUserPoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListUserPoliciesPages(input *ListUserPoliciesInput, fn func(p *ListUserPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListUserPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListUserPoliciesOutput), lastPage)
	})
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a request for the ListUsers operation.
func (c *IAM) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListUsersOutput{}
	req.Data = output
	return
}

// Lists the IAM users that have the specified path prefix. If no path prefix
// is specified, the action returns all users in the AWS account. If there are
// none, the action returns an empty list.
//
// You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListUsersPages(input *ListUsersInput, fn func(p *ListUsersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListUsersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListUsersOutput), lastPage)
	})
}

const opListVirtualMFADevices = "ListVirtualMFADevices"

// ListVirtualMFADevicesRequest generates a request for the ListVirtualMFADevices operation.
func (c *IAM) ListVirtualMFADevicesRequest(input *ListVirtualMFADevicesInput) (req *request.Request, output *ListVirtualMFADevicesOutput) {
	op := &request.Operation{
		Name:       opListVirtualMFADevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListVirtualMFADevicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVirtualMFADevicesOutput{}
	req.Data = output
	return
}

// Lists the virtual MFA devices under the AWS account by assignment status.
// If you do not specify an assignment status, the action returns a list of
// all virtual MFA devices. Assignment status can be Assigned, Unassigned, or
// Any.
//
// You can paginate the results using the MaxItems and Marker parameters.
func (c *IAM) ListVirtualMFADevices(input *ListVirtualMFADevicesInput) (*ListVirtualMFADevicesOutput, error) {
	req, out := c.ListVirtualMFADevicesRequest(input)
	err := req.Send()
	return out, err
}

func (c *IAM) ListVirtualMFADevicesPages(input *ListVirtualMFADevicesInput, fn func(p *ListVirtualMFADevicesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListVirtualMFADevicesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListVirtualMFADevicesOutput), lastPage)
	})
}

const opPutGroupPolicy = "PutGroupPolicy"

// PutGroupPolicyRequest generates a request for the PutGroupPolicy operation.
func (c *IAM) PutGroupPolicyRequest(input *PutGroupPolicyInput) (req *request.Request, output *PutGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opPutGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutGroupPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutGroupPolicyOutput{}
	req.Data = output
	return
}

// Adds (or updates) an inline policy document that is embedded in the specified
// group.
//
// A user can also have managed policies attached to it. To attach a managed
// policy to a group, use AttachGroupPolicy. To create a new managed policy,
// use CreatePolicy. For information about policies, refer to Managed Policies
// and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For information about limits on the number of inline policies that you can
// embed in a group, see Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Because policy documents can be large, you should use POST rather than GET
// when calling PutGroupPolicy. For general information about using the Query
// API with IAM, go to Making Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the Using IAM guide.
func (c *IAM) PutGroupPolicy(input *PutGroupPolicyInput) (*PutGroupPolicyOutput, error) {
	req, out := c.PutGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opPutRolePolicy = "PutRolePolicy"

// PutRolePolicyRequest generates a request for the PutRolePolicy operation.
func (c *IAM) PutRolePolicyRequest(input *PutRolePolicyInput) (req *request.Request, output *PutRolePolicyOutput) {
	op := &request.Operation{
		Name:       opPutRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRolePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutRolePolicyOutput{}
	req.Data = output
	return
}

// Adds (or updates) an inline policy document that is embedded in the specified
// role.
//
// When you embed an inline policy in a role, the inline policy is used as
// the role's access (permissions) policy. The role's trust policy is created
// at the same time as the role, using CreateRole. You can update a role's trust
// policy using UpdateAssumeRolePolicy. For more information about roles, go
// to Using Roles to Delegate Permissions and Federate Identities (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
//
// A role can also have a managed policy attached to it. To attach a managed
// policy to a role, use AttachRolePolicy. To create a new managed policy, use
// CreatePolicy. For information about policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For information about limits on the number of inline policies that you can
// embed with a role, see Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Because policy documents can be large, you should use POST rather than GET
// when calling PutRolePolicy. For general information about using the Query
// API with IAM, go to Making Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the Using IAM guide.
func (c *IAM) PutRolePolicy(input *PutRolePolicyInput) (*PutRolePolicyOutput, error) {
	req, out := c.PutRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opPutUserPolicy = "PutUserPolicy"

// PutUserPolicyRequest generates a request for the PutUserPolicy operation.
func (c *IAM) PutUserPolicyRequest(input *PutUserPolicyInput) (req *request.Request, output *PutUserPolicyOutput) {
	op := &request.Operation{
		Name:       opPutUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutUserPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutUserPolicyOutput{}
	req.Data = output
	return
}

// Adds (or updates) an inline policy document that is embedded in the specified
// user.
//
// A user can also have a managed policy attached to it. To attach a managed
// policy to a user, use AttachUserPolicy. To create a new managed policy, use
// CreatePolicy. For information about policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For information about limits on the number of inline policies that you can
// embed in a user, see Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Because policy documents can be large, you should use POST rather than GET
// when calling PutUserPolicy. For general information about using the Query
// API with IAM, go to Making Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the Using IAM guide.
func (c *IAM) PutUserPolicy(input *PutUserPolicyInput) (*PutUserPolicyOutput, error) {
	req, out := c.PutUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveClientIDFromOpenIDConnectProvider = "RemoveClientIDFromOpenIDConnectProvider"

// RemoveClientIDFromOpenIDConnectProviderRequest generates a request for the RemoveClientIDFromOpenIDConnectProvider operation.
func (c *IAM) RemoveClientIDFromOpenIDConnectProviderRequest(input *RemoveClientIDFromOpenIDConnectProviderInput) (req *request.Request, output *RemoveClientIDFromOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opRemoveClientIDFromOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveClientIDFromOpenIDConnectProviderInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RemoveClientIDFromOpenIDConnectProviderOutput{}
	req.Data = output
	return
}

// Removes the specified client ID (also known as audience) from the list of
// client IDs registered for the specified IAM OpenID Connect provider.
//
// This action is idempotent; it does not fail or return an error if you try
// to remove a client ID that was removed previously.
func (c *IAM) RemoveClientIDFromOpenIDConnectProvider(input *RemoveClientIDFromOpenIDConnectProviderInput) (*RemoveClientIDFromOpenIDConnectProviderOutput, error) {
	req, out := c.RemoveClientIDFromOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveRoleFromInstanceProfile = "RemoveRoleFromInstanceProfile"

// RemoveRoleFromInstanceProfileRequest generates a request for the RemoveRoleFromInstanceProfile operation.
func (c *IAM) RemoveRoleFromInstanceProfileRequest(input *RemoveRoleFromInstanceProfileInput) (req *request.Request, output *RemoveRoleFromInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opRemoveRoleFromInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRoleFromInstanceProfileInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RemoveRoleFromInstanceProfileOutput{}
	req.Data = output
	return
}

// Removes the specified role from the specified instance profile.
//
//  Make sure you do not have any Amazon EC2 instances running with the role
// you are about to remove from the instance profile. Removing a role from an
// instance profile that is associated with a running instance will break any
// applications running on the instance.   For more information about roles,
// go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
// For more information about instance profiles, go to About Instance Profiles
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
func (c *IAM) RemoveRoleFromInstanceProfile(input *RemoveRoleFromInstanceProfileInput) (*RemoveRoleFromInstanceProfileOutput, error) {
	req, out := c.RemoveRoleFromInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveUserFromGroup = "RemoveUserFromGroup"

// RemoveUserFromGroupRequest generates a request for the RemoveUserFromGroup operation.
func (c *IAM) RemoveUserFromGroupRequest(input *RemoveUserFromGroupInput) (req *request.Request, output *RemoveUserFromGroupOutput) {
	op := &request.Operation{
		Name:       opRemoveUserFromGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveUserFromGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RemoveUserFromGroupOutput{}
	req.Data = output
	return
}

// Removes the specified user from the specified group.
func (c *IAM) RemoveUserFromGroup(input *RemoveUserFromGroupInput) (*RemoveUserFromGroupOutput, error) {
	req, out := c.RemoveUserFromGroupRequest(input)
	err := req.Send()
	return out, err
}

const opResyncMFADevice = "ResyncMFADevice"

// ResyncMFADeviceRequest generates a request for the ResyncMFADevice operation.
func (c *IAM) ResyncMFADeviceRequest(input *ResyncMFADeviceInput) (req *request.Request, output *ResyncMFADeviceOutput) {
	op := &request.Operation{
		Name:       opResyncMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResyncMFADeviceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ResyncMFADeviceOutput{}
	req.Data = output
	return
}

// Synchronizes the specified MFA device with AWS servers.
//
// For more information about creating and working with virtual MFA devices,
// go to Using a Virtual MFA Device (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
// in the Using IAM guide.
func (c *IAM) ResyncMFADevice(input *ResyncMFADeviceInput) (*ResyncMFADeviceOutput, error) {
	req, out := c.ResyncMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opSetDefaultPolicyVersion = "SetDefaultPolicyVersion"

// SetDefaultPolicyVersionRequest generates a request for the SetDefaultPolicyVersion operation.
func (c *IAM) SetDefaultPolicyVersionRequest(input *SetDefaultPolicyVersionInput) (req *request.Request, output *SetDefaultPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opSetDefaultPolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDefaultPolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetDefaultPolicyVersionOutput{}
	req.Data = output
	return
}

// Sets the specified version of the specified policy as the policy's default
// (operative) version.
//
// This action affects all users, groups, and roles that the policy is attached
// to. To list the users, groups, and roles that the policy is attached to,
// use the ListEntitiesForPolicy API.
//
// For information about managed policies, refer to Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
func (c *IAM) SetDefaultPolicyVersion(input *SetDefaultPolicyVersionInput) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opSimulateCustomPolicy = "SimulateCustomPolicy"

// SimulateCustomPolicyRequest generates a request for the SimulateCustomPolicy operation.
func (c *IAM) SimulateCustomPolicyRequest(input *SimulateCustomPolicyInput) (req *request.Request, output *SimulatePolicyResponse) {
	op := &request.Operation{
		Name:       opSimulateCustomPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SimulateCustomPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SimulatePolicyResponse{}
	req.Data = output
	return
}

// Simulate how a set of IAM policies and optionally a resource-based policy
// works with a list of API actions and AWS resources to determine the policies'
// effective permissions. The policies are provided as strings.
//
// The simulation does not perform the API actions; it only checks the authorization
// to determine if the simulated policies allow or deny the actions.
//
// If you want to simulate existing policies attached to an IAM user, group,
// or role, use SimulatePrincipalPolicy instead.
//
// Context keys are variables maintained by AWS and its services that provide
// details about the context of an API query request. You can use the Condition
// element of an IAM policy to evaluate context keys. To get the list of context
// keys that the policies require for correct simulation, use GetContextKeysForCustomPolicy.
//
// If the output is long, you can use MaxItems and Marker parameters to paginate
// the results.
func (c *IAM) SimulateCustomPolicy(input *SimulateCustomPolicyInput) (*SimulatePolicyResponse, error) {
	req, out := c.SimulateCustomPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opSimulatePrincipalPolicy = "SimulatePrincipalPolicy"

// SimulatePrincipalPolicyRequest generates a request for the SimulatePrincipalPolicy operation.
func (c *IAM) SimulatePrincipalPolicyRequest(input *SimulatePrincipalPolicyInput) (req *request.Request, output *SimulatePolicyResponse) {
	op := &request.Operation{
		Name:       opSimulatePrincipalPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SimulatePrincipalPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SimulatePolicyResponse{}
	req.Data = output
	return
}

// Simulate how a set of IAM policies attached to an IAM entity works with a
// list of API actions and AWS resources to determine the policies' effective
// permissions. The entity can be an IAM user, group, or role. If you specify
// a user, then the simulation also includes all of the policies that are attached
// to groups that the user belongs to .
//
// You can optionally include a list of one or more additional policies specified
// as strings to include in the simulation. If you want to simulate only policies
// specified as strings, use SimulateCustomPolicy instead.
//
// You can also optionally include one resource-based policy to be evaluated
// with each of the resources included in the simulation.
//
// The simulation does not perform the API actions, it only checks the authorization
// to determine if the simulated policies allow or deny the actions.
//
// Note: This API discloses information about the permissions granted to other
// users. If you do not want users to see other user's permissions, then consider
// allowing them to use SimulateCustomPolicy instead.
//
// Context keys are variables maintained by AWS and its services that provide
// details about the context of an API query request. You can use the Condition
// element of an IAM policy to evaluate context keys. To get the list of context
// keys that the policies require for correct simulation, use GetContextKeysForPrincipalPolicy.
//
// If the output is long, you can use the MaxItems and Marker parameters to
// paginate the results.
func (c *IAM) SimulatePrincipalPolicy(input *SimulatePrincipalPolicyInput) (*SimulatePolicyResponse, error) {
	req, out := c.SimulatePrincipalPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAccessKey = "UpdateAccessKey"

// UpdateAccessKeyRequest generates a request for the UpdateAccessKey operation.
func (c *IAM) UpdateAccessKeyRequest(input *UpdateAccessKeyInput) (req *request.Request, output *UpdateAccessKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccessKeyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateAccessKeyOutput{}
	req.Data = output
	return
}

// Changes the status of the specified access key from Active to Inactive, or
// vice versa. This action can be used to disable a user's key as part of a
// key rotation work flow.
//
// If the UserName field is not specified, the UserName is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// For information about rotating keys, see Managing Keys and Certificates
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html)
// in the IAM User Guide.
func (c *IAM) UpdateAccessKey(input *UpdateAccessKeyInput) (*UpdateAccessKeyOutput, error) {
	req, out := c.UpdateAccessKeyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAccountPasswordPolicy = "UpdateAccountPasswordPolicy"

// UpdateAccountPasswordPolicyRequest generates a request for the UpdateAccountPasswordPolicy operation.
func (c *IAM) UpdateAccountPasswordPolicyRequest(input *UpdateAccountPasswordPolicyInput) (req *request.Request, output *UpdateAccountPasswordPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountPasswordPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccountPasswordPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateAccountPasswordPolicyOutput{}
	req.Data = output
	return
}

// Updates the password policy settings for the AWS account.
//
//  This action does not support partial updates. No parameters are required,
// but if you do not specify a parameter, that parameter's value reverts to
// its default value. See the Request Parameters section for each parameter's
// default value.
//
//   For more information about using a password policy, see Managing an IAM
// Password Policy (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html)
// in the IAM User Guide.
func (c *IAM) UpdateAccountPasswordPolicy(input *UpdateAccountPasswordPolicyInput) (*UpdateAccountPasswordPolicyOutput, error) {
	req, out := c.UpdateAccountPasswordPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAssumeRolePolicy = "UpdateAssumeRolePolicy"

// UpdateAssumeRolePolicyRequest generates a request for the UpdateAssumeRolePolicy operation.
func (c *IAM) UpdateAssumeRolePolicyRequest(input *UpdateAssumeRolePolicyInput) (req *request.Request, output *UpdateAssumeRolePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateAssumeRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssumeRolePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateAssumeRolePolicyOutput{}
	req.Data = output
	return
}

// Updates the policy that grants an entity permission to assume a role. For
// more information about roles, go to Using Roles to Delegate Permissions and
// Federate Identities (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
func (c *IAM) UpdateAssumeRolePolicy(input *UpdateAssumeRolePolicyInput) (*UpdateAssumeRolePolicyOutput, error) {
	req, out := c.UpdateAssumeRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a request for the UpdateGroup operation.
func (c *IAM) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateGroupOutput{}
	req.Data = output
	return
}

// Updates the name and/or the path of the specified group.
//
//  You should understand the implications of changing a group's path or name.
// For more information, see Renaming Users and Groups (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html)
// in the IAM User Guide.  To change a group name the requester must have appropriate
// permissions on both the source object and the target object. For example,
// to change Managers to MGRs, the entity making the request must have permission
// on Managers and MGRs, or must have permission on all (*). For more information
// about permissions, see Permissions and Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html"
// target="blank).
func (c *IAM) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateLoginProfile = "UpdateLoginProfile"

// UpdateLoginProfileRequest generates a request for the UpdateLoginProfile operation.
func (c *IAM) UpdateLoginProfileRequest(input *UpdateLoginProfileInput) (req *request.Request, output *UpdateLoginProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLoginProfileInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateLoginProfileOutput{}
	req.Data = output
	return
}

// Changes the password for the specified user.
//
// Users can change their own passwords by calling ChangePassword. For more
// information about modifying passwords, see Managing Passwords (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
// in the IAM User Guide.
func (c *IAM) UpdateLoginProfile(input *UpdateLoginProfileInput) (*UpdateLoginProfileOutput, error) {
	req, out := c.UpdateLoginProfileRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateOpenIDConnectProviderThumbprint = "UpdateOpenIDConnectProviderThumbprint"

// UpdateOpenIDConnectProviderThumbprintRequest generates a request for the UpdateOpenIDConnectProviderThumbprint operation.
func (c *IAM) UpdateOpenIDConnectProviderThumbprintRequest(input *UpdateOpenIDConnectProviderThumbprintInput) (req *request.Request, output *UpdateOpenIDConnectProviderThumbprintOutput) {
	op := &request.Operation{
		Name:       opUpdateOpenIDConnectProviderThumbprint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOpenIDConnectProviderThumbprintInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateOpenIDConnectProviderThumbprintOutput{}
	req.Data = output
	return
}

// Replaces the existing list of server certificate thumbprints with a new list.
//
// The list that you pass with this action completely replaces the existing
// list of thumbprints. (The lists are not merged.)
//
// Typically, you need to update a thumbprint only when the identity provider's
// certificate changes, which occurs rarely. However, if the provider's certificate
// does change, any attempt to assume an IAM role that specifies the OIDC provider
// as a principal will fail until the certificate thumbprint is updated.
//
// Because trust for the OpenID Connect provider is ultimately derived from
// the provider's certificate and is validated by the thumbprint, it is a best
// practice to limit access to the UpdateOpenIDConnectProviderThumbprint action
// to highly-privileged users.
func (c *IAM) UpdateOpenIDConnectProviderThumbprint(input *UpdateOpenIDConnectProviderThumbprintInput) (*UpdateOpenIDConnectProviderThumbprintOutput, error) {
	req, out := c.UpdateOpenIDConnectProviderThumbprintRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSAMLProvider = "UpdateSAMLProvider"

// UpdateSAMLProviderRequest generates a request for the UpdateSAMLProvider operation.
func (c *IAM) UpdateSAMLProviderRequest(input *UpdateSAMLProviderInput) (req *request.Request, output *UpdateSAMLProviderOutput) {
	op := &request.Operation{
		Name:       opUpdateSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSAMLProviderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateSAMLProviderOutput{}
	req.Data = output
	return
}

// Updates the metadata document for an existing SAML provider.
//
// This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
func (c *IAM) UpdateSAMLProvider(input *UpdateSAMLProviderInput) (*UpdateSAMLProviderOutput, error) {
	req, out := c.UpdateSAMLProviderRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSSHPublicKey = "UpdateSSHPublicKey"

// UpdateSSHPublicKeyRequest generates a request for the UpdateSSHPublicKey operation.
func (c *IAM) UpdateSSHPublicKeyRequest(input *UpdateSSHPublicKeyInput) (req *request.Request, output *UpdateSSHPublicKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSSHPublicKeyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateSSHPublicKeyOutput{}
	req.Data = output
	return
}

// Sets the status of the specified SSH public key to active or inactive. SSH
// public keys that are inactive cannot be used for authentication. This action
// can be used to disable a user's SSH public key as part of a key rotation
// work flow.
//
// The SSH public key affected by this action is used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
func (c *IAM) UpdateSSHPublicKey(input *UpdateSSHPublicKeyInput) (*UpdateSSHPublicKeyOutput, error) {
	req, out := c.UpdateSSHPublicKeyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateServerCertificate = "UpdateServerCertificate"

// UpdateServerCertificateRequest generates a request for the UpdateServerCertificate operation.
func (c *IAM) UpdateServerCertificateRequest(input *UpdateServerCertificateInput) (req *request.Request, output *UpdateServerCertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateServerCertificateOutput{}
	req.Data = output
	return
}

// Updates the name and/or the path of the specified server certificate.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
//
// You should understand the implications of changing a server certificate's
// path or name. For more information, see Renaming a Server Certificate (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts)
// in the IAM User Guide. To change a server certificate name the requester
// must have appropriate permissions on both the source object and the target
// object. For example, to change the name from ProductionCert to ProdCert,
// the entity making the request must have permission on ProductionCert and
// ProdCert, or must have permission on all (*). For more information about
// permissions, see Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
// in the IAM User Guide.
func (c *IAM) UpdateServerCertificate(input *UpdateServerCertificateInput) (*UpdateServerCertificateOutput, error) {
	req, out := c.UpdateServerCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSigningCertificate = "UpdateSigningCertificate"

// UpdateSigningCertificateRequest generates a request for the UpdateSigningCertificate operation.
func (c *IAM) UpdateSigningCertificateRequest(input *UpdateSigningCertificateInput) (req *request.Request, output *UpdateSigningCertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSigningCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateSigningCertificateOutput{}
	req.Data = output
	return
}

// Changes the status of the specified signing certificate from active to disabled,
// or vice versa. This action can be used to disable a user's signing certificate
// as part of a certificate rotation work flow.
//
// If the UserName field is not specified, the UserName is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
func (c *IAM) UpdateSigningCertificate(input *UpdateSigningCertificateInput) (*UpdateSigningCertificateOutput, error) {
	req, out := c.UpdateSigningCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a request for the UpdateUser operation.
func (c *IAM) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateUserOutput{}
	req.Data = output
	return
}

// Updates the name and/or the path of the specified user.
//
//  You should understand the implications of changing a user's path or name.
// For more information, see Renaming Users and Groups (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html)
// in the IAM User Guide.   To change a user name the requester must have appropriate
// permissions on both the source object and the target object. For example,
// to change Bob to Robert, the entity making the request must have permission
// on Bob and Robert, or must have permission on all (*). For more information
// about permissions, see Permissions and Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html"
// target="blank).
func (c *IAM) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	err := req.Send()
	return out, err
}

const opUploadSSHPublicKey = "UploadSSHPublicKey"

// UploadSSHPublicKeyRequest generates a request for the UploadSSHPublicKey operation.
func (c *IAM) UploadSSHPublicKeyRequest(input *UploadSSHPublicKeyInput) (req *request.Request, output *UploadSSHPublicKeyOutput) {
	op := &request.Operation{
		Name:       opUploadSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadSSHPublicKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadSSHPublicKeyOutput{}
	req.Data = output
	return
}

// Uploads an SSH public key and associates it with the specified IAM user.
//
// The SSH public key uploaded by this action can be used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
func (c *IAM) UploadSSHPublicKey(input *UploadSSHPublicKeyInput) (*UploadSSHPublicKeyOutput, error) {
	req, out := c.UploadSSHPublicKeyRequest(input)
	err := req.Send()
	return out, err
}

const opUploadServerCertificate = "UploadServerCertificate"

// UploadServerCertificateRequest generates a request for the UploadServerCertificate operation.
func (c *IAM) UploadServerCertificateRequest(input *UploadServerCertificateInput) (req *request.Request, output *UploadServerCertificateOutput) {
	op := &request.Operation{
		Name:       opUploadServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadServerCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadServerCertificateOutput{}
	req.Data = output
	return
}

// Uploads a server certificate entity for the AWS account. The server certificate
// entity includes a public key certificate, a private key, and an optional
// certificate chain, which should all be PEM-encoded.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
//
// For information about the number of server certificates you can upload,
// see Limitations on IAM Entities and Objects (http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-limits.html)
// in the IAM User Guide.
//
// Because the body of the public key certificate, private key, and the certificate
// chain can be large, you should use POST rather than GET when calling UploadServerCertificate.
// For information about setting up signatures and authorization through the
// API, go to Signing AWS API Requests (http://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
// in the AWS General Reference. For general information about using the Query
// API with IAM, go to Calling the API by Making HTTP Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html)
// in the IAM User Guide.
func (c *IAM) UploadServerCertificate(input *UploadServerCertificateInput) (*UploadServerCertificateOutput, error) {
	req, out := c.UploadServerCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUploadSigningCertificate = "UploadSigningCertificate"

// UploadSigningCertificateRequest generates a request for the UploadSigningCertificate operation.
func (c *IAM) UploadSigningCertificateRequest(input *UploadSigningCertificateInput) (req *request.Request, output *UploadSigningCertificateOutput) {
	op := &request.Operation{
		Name:       opUploadSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadSigningCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadSigningCertificateOutput{}
	req.Data = output
	return
}

// Uploads an X.509 signing certificate and associates it with the specified
// user. Some AWS services use X.509 signing certificates to validate requests
// that are signed with a corresponding private key. When you upload the certificate,
// its default status is Active.
//
// If the UserName field is not specified, the user name is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// Because the body of a X.509 certificate can be large, you should use POST
// rather than GET when calling UploadSigningCertificate. For information about
// setting up signatures and authorization through the API, go to Signing AWS
// API Requests (http://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
// in the AWS General Reference. For general information about using the Query
// API with IAM, go to Making Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the Using IAMguide.
func (c *IAM) UploadSigningCertificate(input *UploadSigningCertificateInput) (*UploadSigningCertificateOutput, error) {
	req, out := c.UploadSigningCertificateRequest(input)
	err := req.Send()
	return out, err
}

// Contains information about an AWS access key.
//
//  This data type is used as a response element in the CreateAccessKey and
// ListAccessKeys actions.
//
// The SecretAccessKey value is returned only in response to CreateAccessKey.
// You can get a secret access key only when you first create an access key;
// you cannot recover the secret access key later. If you lose a secret access
// key, you must create a new access key.
type AccessKey struct {
	_ struct{} `type:"structure"`

	// The ID for this access key.
	AccessKeyId *string `min:"16" type:"string" required:"true"`

	// The date when the access key was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The secret key used to sign requests.
	SecretAccessKey *string `type:"string" required:"true"`

	// The status of the access key. Active means the key is valid for API calls,
	// while Inactive means it is not.
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the IAM user that the access key is associated with.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AccessKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKey) GoString() string {
	return s.String()
}

// Contains information about the last time an AWS access key was used.
//
// This data type is used as a response element in the GetAccessKeyLastUsed
// action.
type AccessKeyLastUsed struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the access key was most recently used. This field is null when:
	//
	//   The user does not have an access key.
	//
	//   An access key exists but has never been used, at least not since IAM started
	// tracking this information on April 22nd, 2015.
	//
	//   There is no sign-in data associated with the user
	LastUsedDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The AWS region where this access key was most recently used. This field is
	// null when:
	//
	//   The user does not have an access key.
	//
	//   An access key exists but has never been used, at least not since IAM started
	// tracking this information on April 22nd, 2015.
	//
	//   There is no sign-in data associated with the user
	//
	//   For more information about AWS regions, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html)
	// in the Amazon Web Services General Reference.
	Region *string `type:"string" required:"true"`

	// The name of the AWS service with which this access key was most recently
	// used. This field is null when:
	//
	//   The user does not have an access key.
	//
	//   An access key exists but has never been used, at least not since IAM started
	// tracking this information on April 22nd, 2015.
	//
	//   There is no sign-in data associated with the user
	ServiceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AccessKeyLastUsed) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKeyLastUsed) GoString() string {
	return s.String()
}

// Contains information about an AWS access key, without its secret key.
//
// This data type is used as a response element in the ListAccessKeys action.
type AccessKeyMetadata struct {
	_ struct{} `type:"structure"`

	// The ID for this access key.
	AccessKeyId *string `min:"16" type:"string"`

	// The date when the access key was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The status of the access key. Active means the key is valid for API calls;
	// Inactive means it is not.
	Status *string `type:"string" enum:"statusType"`

	// The name of the IAM user that the key is associated with.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AccessKeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKeyMetadata) GoString() string {
	return s.String()
}

type AddClientIDToOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The client ID (also known as audience) to add to the IAM OpenID Connect provider.
	ClientID *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
	// to add the client ID to. You can get a list of OIDC provider ARNs by using
	// the ListOpenIDConnectProviders action.
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AddClientIDToOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddClientIDToOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

type AddClientIDToOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddClientIDToOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddClientIDToOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

type AddRoleToInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to update.
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The name of the role to add.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddRoleToInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToInstanceProfileInput) GoString() string {
	return s.String()
}

type AddRoleToInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddRoleToInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToInstanceProfileOutput) GoString() string {
	return s.String()
}

type AddUserToGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to update.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name of the user to add.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddUserToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUserToGroupInput) GoString() string {
	return s.String()
}

type AddUserToGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddUserToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUserToGroupOutput) GoString() string {
	return s.String()
}

type AttachGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) of the group to attach the policy to.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachGroupPolicyInput) GoString() string {
	return s.String()
}

type AttachGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachGroupPolicyOutput) GoString() string {
	return s.String()
}

type AttachRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the role to attach the policy to.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachRolePolicyInput) GoString() string {
	return s.String()
}

type AttachRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachRolePolicyOutput) GoString() string {
	return s.String()
}

type AttachUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the user to attach the policy to.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachUserPolicyInput) GoString() string {
	return s.String()
}

type AttachUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachUserPolicyOutput) GoString() string {
	return s.String()
}

// Contains information about an attached policy.
//
// An attached policy is a managed policy that has been attached to a user,
// group, or role. This data type is used as a response element in the ListAttachedGroupPolicies,
// ListAttachedRolePolicies, ListAttachedUserPolicies, and GetAccountAuthorizationDetails
// actions.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
type AttachedPolicy struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string"`

	// The friendly name of the attached policy.
	PolicyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AttachedPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachedPolicy) GoString() string {
	return s.String()
}

type ChangePasswordInput struct {
	_ struct{} `type:"structure"`

	// The new password. The new password must conform to the AWS account's password
	// policy, if one exists.
	NewPassword *string `min:"1" type:"string" required:"true"`

	// The IAM user's current password.
	OldPassword *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ChangePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangePasswordInput) GoString() string {
	return s.String()
}

type ChangePasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ChangePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangePasswordOutput) GoString() string {
	return s.String()
}

// Contains information about a condition context key. It includes the name
// of the key and specifies the value (or values, if the context key supports
// multiple values) to use in the simulation. This information is used when
// evaluating the Condition elements of the input policies.
//
// This data type is used as an input parameter to SimulatePolicy.
type ContextEntry struct {
	_ struct{} `type:"structure"`

	// The full name of a condition context key, including the service prefix. For
	// example, aws:SourceIp or s3:VersionId.
	ContextKeyName *string `min:"5" type:"string"`

	// The data type of the value (or values) specified in the ContextKeyValues
	// parameter.
	ContextKeyType *string `type:"string" enum:"ContextKeyTypeEnum"`

	// The value (or values, if the condition context key supports multiple values)
	// to provide to the simulation for use when the key is referenced by a Condition
	// element in an input policy.
	ContextKeyValues []*string `type:"list"`
}

// String returns the string representation
func (s ContextEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContextEntry) GoString() string {
	return s.String()
}

type CreateAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The user name that the new key will belong to.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessKeyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateAccessKey request.
type CreateAccessKeyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the access key.
	AccessKey *AccessKey `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessKeyOutput) GoString() string {
	return s.String()
}

type CreateAccountAliasInput struct {
	_ struct{} `type:"structure"`

	// The account alias to create.
	AccountAlias *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAccountAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountAliasInput) GoString() string {
	return s.String()
}

type CreateAccountAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAccountAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountAliasOutput) GoString() string {
	return s.String()
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to create. Do not include the path in this value.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The path to the group. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	Path *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateGroup request.
type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the group.
	Group *Group `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

type CreateInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to create.
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The path to the instance profile. For more information about paths, see IAM
	// Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	Path *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceProfileInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateInstanceProfile request.
type CreateInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instance profile.
	InstanceProfile *InstanceProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceProfileOutput) GoString() string {
	return s.String()
}

type CreateLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The new password for the user.
	Password *string `min:"1" type:"string" required:"true"`

	// Specifies whether the user is required to set a new password on next sign-in.
	PasswordResetRequired *bool `type:"boolean"`

	// The name of the user to create a password for.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoginProfileInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateLoginProfile request.
type CreateLoginProfileOutput struct {
	_ struct{} `type:"structure"`

	// The user name and password create date.
	LoginProfile *LoginProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoginProfileOutput) GoString() string {
	return s.String()
}

type CreateOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// A list of client IDs (also known as audiences). When a mobile or web app
	// registers with an OpenID Connect provider, they establish a value that identifies
	// the application. (This is the value that's sent as the client_id parameter
	// on OAuth requests.)
	//
	// You can register multiple client IDs with the same provider. For example,
	// you might have multiple applications that use the same OIDC provider. You
	// cannot register more than 100 client IDs with a single IAM OIDC provider.
	//
	// There is no defined format for a client ID. The CreateOpenIDConnectProviderRequest
	// action accepts client IDs up to 255 characters long.
	ClientIDList []*string `type:"list"`

	// A list of server certificate thumbprints for the OpenID Connect (OIDC) identity
	// provider's server certificate(s). Typically this list includes only one entry.
	// However, IAM lets you have up to five thumbprints for an OIDC provider. This
	// lets you maintain multiple thumbprints if the identity provider is rotating
	// certificates.
	//
	// The server certificate thumbprint is the hex-encoded SHA-1 hash value of
	// the X.509 certificate used by the domain where the OpenID Connect provider
	// makes its keys available. It is always a 40-character string.
	//
	// You must provide at least one thumbprint when creating an IAM OIDC provider.
	// For example, if the OIDC provider is server.example.com and the provider
	// stores its keys at "https://keys.server.example.com/openid-connect", the
	// thumbprint string would be the hex-encoded SHA-1 hash value of the certificate
	// used by https://keys.server.example.com.
	//
	// For more information about obtaining the OIDC provider's thumbprint, see
	// Obtaining the Thumbprint for an OpenID Connect Provider (http://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html)
	// in the IAM User Guide.
	ThumbprintList []*string `type:"list" required:"true"`

	// The URL of the identity provider. The URL must begin with "https://" and
	// should correspond to the iss claim in the provider's OpenID Connect ID tokens.
	// Per the OIDC standard, path components are allowed but query parameters are
	// not. Typically the URL consists of only a host name, like "https://server.example.org"
	// or "https://example.com".
	//
	// You cannot register the same provider multiple times in a single AWS account.
	// If you try to submit a URL that has already been used for an OpenID Connect
	// provider in the AWS account, you will get an error.
	Url *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateOpenIDConnectProvider request.
type CreateOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect provider that was
	// created. For more information, see OpenIDConnectProviderListEntry.
	OpenIDConnectProviderArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// A friendly description of the policy.
	//
	// Typically used to store information about the permissions defined in the
	// policy. For example, "Grants access to production DynamoDB tables."
	//
	// The policy description is immutable. After a value is assigned, it cannot
	// be changed.
	Description *string `type:"string"`

	// The path for the policy.
	//
	// For more information about paths, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	Path *string `type:"string"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy document.
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreatePolicy request.
type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

type CreatePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// Specifies whether to set this version as the policy's default version.
	//
	// When this parameter is true, the new policy version becomes the operative
	// version; that is, the version that is in effect for the IAM users, groups,
	// and roles that the policy is attached to.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	SetAsDefault *bool `type:"boolean"`
}

// String returns the string representation
func (s CreatePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreatePolicyVersion request.
type CreatePolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the policy version.
	PolicyVersion *PolicyVersion `type:"structure"`
}

// String returns the string representation
func (s CreatePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionOutput) GoString() string {
	return s.String()
}

type CreateRoleInput struct {
	_ struct{} `type:"structure"`

	// The trust relationship policy document that grants an entity permission to
	// assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string" required:"true"`

	// The path to the role. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	Path *string `min:"1" type:"string"`

	// The name of the role to create.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoleInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateRole request.
type CreateRoleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the role.
	Role *Role `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoleOutput) GoString() string {
	return s.String()
}

type CreateSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// The name of the provider to create.
	Name *string `min:"1" type:"string" required:"true"`

	// An XML document generated by an identity provider (IdP) that supports SAML
	// 2.0. The document includes the issuer's name, expiration information, and
	// keys that can be used to validate the SAML authentication response (assertions)
	// that are received from the IdP. You must generate the metadata document using
	// the identity management software that is used as your organization's IdP.
	//
	// For more information, see About SAML 2.0-based Federation (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
	// in the IAM User Guide
	SAMLMetadataDocument *string `min:"1000" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSAMLProviderInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateSAMLProvider request.
type CreateSAMLProviderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider.
	SAMLProviderArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSAMLProviderOutput) GoString() string {
	return s.String()
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The path for the user name. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	Path *string `min:"1" type:"string"`

	// The name of the user to create.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateUser request.
type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// Information about the user.
	User *User `type:"structure"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

type CreateVirtualMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// The path for the virtual MFA device. For more information about paths, see
	// IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	Path *string `min:"1" type:"string"`

	// The name of the virtual MFA device. Use with path to uniquely identify a
	// virtual MFA device.
	VirtualMFADeviceName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVirtualMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualMFADeviceInput) GoString() string {
	return s.String()
}

// Contains the response to a successful CreateVirtualMFADevice request.
type CreateVirtualMFADeviceOutput struct {
	_ struct{} `type:"structure"`

	// A newly created virtual MFA device.
	VirtualMFADevice *VirtualMFADevice `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVirtualMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualMFADeviceOutput) GoString() string {
	return s.String()
}

type DeactivateMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the device ARN.
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The name of the user whose MFA device you want to deactivate.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeactivateMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivateMFADeviceInput) GoString() string {
	return s.String()
}

type DeactivateMFADeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeactivateMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivateMFADeviceOutput) GoString() string {
	return s.String()
}

type DeleteAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The access key ID for the access key ID and secret access key you want to
	// delete.
	AccessKeyId *string `min:"16" type:"string" required:"true"`

	// The name of the user whose key you want to delete.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessKeyInput) GoString() string {
	return s.String()
}

type DeleteAccessKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessKeyOutput) GoString() string {
	return s.String()
}

type DeleteAccountAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the account alias to delete.
	AccountAlias *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccountAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAliasInput) GoString() string {
	return s.String()
}

type DeleteAccountAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAliasOutput) GoString() string {
	return s.String()
}

type DeleteAccountPasswordPolicyInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountPasswordPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountPasswordPolicyInput) GoString() string {
	return s.String()
}

type DeleteAccountPasswordPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountPasswordPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountPasswordPolicyOutput) GoString() string {
	return s.String()
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to delete.
	GroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) identifying the group that the policy is
	// embedded in.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name identifying the policy document to delete.
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupPolicyInput) GoString() string {
	return s.String()
}

type DeleteGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupPolicyOutput) GoString() string {
	return s.String()
}

type DeleteInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to delete.
	InstanceProfileName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceProfileInput) GoString() string {
	return s.String()
}

type DeleteInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceProfileOutput) GoString() string {
	return s.String()
}

type DeleteLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the user whose password you want to delete.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoginProfileInput) GoString() string {
	return s.String()
}

type DeleteLoginProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoginProfileOutput) GoString() string {
	return s.String()
}

type DeleteOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect provider to delete.
	// You can get a list of OpenID Connect provider ARNs by using the ListOpenIDConnectProviders
	// action.
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

type DeleteOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

type DeletePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The policy version to delete.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	VersionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionInput) GoString() string {
	return s.String()
}

type DeletePolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionOutput) GoString() string {
	return s.String()
}

type DeleteRoleInput struct {
	_ struct{} `type:"structure"`

	// The name of the role to delete.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoleInput) GoString() string {
	return s.String()
}

type DeleteRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoleOutput) GoString() string {
	return s.String()
}

type DeleteRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name identifying the policy document to delete.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name (friendly name, not ARN) identifying the role that the policy is
	// embedded in.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRolePolicyInput) GoString() string {
	return s.String()
}

type DeleteRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRolePolicyOutput) GoString() string {
	return s.String()
}

type DeleteSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider to delete.
	SAMLProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSAMLProviderInput) GoString() string {
	return s.String()
}

type DeleteSAMLProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSAMLProviderOutput) GoString() string {
	return s.String()
}

type DeleteSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the SSH public key.
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The name of the IAM user associated with the SSH public key.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSSHPublicKeyInput) GoString() string {
	return s.String()
}

type DeleteSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSSHPublicKeyOutput) GoString() string {
	return s.String()
}

type DeleteServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name of the server certificate you want to delete.
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerCertificateInput) GoString() string {
	return s.String()
}

type DeleteServerCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerCertificateOutput) GoString() string {
	return s.String()
}

type DeleteSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the signing certificate to delete.
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The name of the user the signing certificate belongs to.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSigningCertificateInput) GoString() string {
	return s.String()
}

type DeleteSigningCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSigningCertificateOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The name of the user to delete.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DeleteUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name identifying the policy document to delete.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name (friendly name, not ARN) identifying the user that the policy is
	// embedded in.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPolicyInput) GoString() string {
	return s.String()
}

type DeleteUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPolicyOutput) GoString() string {
	return s.String()
}

type DeleteVirtualMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the same as the ARN.
	SerialNumber *string `min:"9" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualMFADeviceInput) GoString() string {
	return s.String()
}

type DeleteVirtualMFADeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVirtualMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualMFADeviceOutput) GoString() string {
	return s.String()
}

type DetachGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) of the group to detach the policy from.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachGroupPolicyInput) GoString() string {
	return s.String()
}

type DetachGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachGroupPolicyOutput) GoString() string {
	return s.String()
}

type DetachRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the role to detach the policy from.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachRolePolicyInput) GoString() string {
	return s.String()
}

type DetachRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachRolePolicyOutput) GoString() string {
	return s.String()
}

type DetachUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the user to detach the policy from.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachUserPolicyInput) GoString() string {
	return s.String()
}

type DetachUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachUserPolicyOutput) GoString() string {
	return s.String()
}

type EnableMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// An authentication code emitted by the device.
	AuthenticationCode1 *string `min:"6" type:"string" required:"true"`

	// A subsequent authentication code emitted by the device.
	AuthenticationCode2 *string `min:"6" type:"string" required:"true"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the device ARN.
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The name of the user for whom you want to enable the MFA device.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMFADeviceInput) GoString() string {
	return s.String()
}

type EnableMFADeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMFADeviceOutput) GoString() string {
	return s.String()
}

// Contains the results of a simulation.
//
// This data type is used by the return parameter of SimulatePolicy.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// The name of the API action tested on the indicated resource.
	EvalActionName *string `min:"3" type:"string" required:"true"`

	// The result of the simulation.
	EvalDecision *string `type:"string" required:"true" enum:"PolicyEvaluationDecisionType"`

	// Additional details about the results of the evaluation decision. When there
	// are both IAM policies and resource policies, this parameter explains how
	// each set of policies contributes to the final evaluation decision. When simulating
	// cross-account access to a resource, both the resource-based policy and the
	// caller's IAM policy must grant access. See How IAM Roles Differ from Resource-based
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_compare-resource-policies.html)
	EvalDecisionDetails map[string]*string `type:"map"`

	// The ARN of the resource that the indicated API action was tested on.
	EvalResourceName *string `min:"1" type:"string"`

	// A list of the statements in the input policies that determine the result
	// for this scenario. Remember that even if multiple statements allow the action
	// on the resource, if only one statement denies that action, then the explicit
	// deny overrides any allow, and the deny statement is the only entry included
	// in the result.
	MatchedStatements []*Statement `type:"list"`

	// A list of context keys that are required by the included input policies but
	// that were not provided by one of the input parameters. To discover the context
	// keys used by a set of policies, you can call GetContextKeysForCustomPolicy
	// or GetContextKeysForPrincipalPolicy.
	//
	//  If the response includes any keys in this list, then the reported results
	// might be untrustworthy because the simulation could not completely evaluate
	// all of the conditions specified in the policies that would occur in a real
	// world request.
	MissingContextValues []*string `type:"list"`

	// The individual results of the simulation of the API action specified in EvalActionName
	// on each resource.
	ResourceSpecificResults []*ResourceSpecificResult `type:"list"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResult) GoString() string {
	return s.String()
}

type GenerateCredentialReportInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GenerateCredentialReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateCredentialReportInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GenerateCredentialReport request.
type GenerateCredentialReportOutput struct {
	_ struct{} `type:"structure"`

	// Information about the credential report.
	Description *string `type:"string"`

	// Information about the state of the credential report.
	State *string `type:"string" enum:"ReportStateType"`
}

// String returns the string representation
func (s GenerateCredentialReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateCredentialReportOutput) GoString() string {
	return s.String()
}

type GetAccessKeyLastUsedInput struct {
	_ struct{} `type:"structure"`

	// The identifier of an access key.
	AccessKeyId *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessKeyLastUsedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessKeyLastUsedInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetAccessKeyLastUsed request. It is
// also returned as a member of the AccessKeyMetaData structure returned by
// the ListAccessKeys action.
type GetAccessKeyLastUsedOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the last time the access key was used.
	AccessKeyLastUsed *AccessKeyLastUsed `type:"structure"`

	// The name of the AWS IAM user that owns this access key.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetAccessKeyLastUsedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessKeyLastUsedOutput) GoString() string {
	return s.String()
}

type GetAccountAuthorizationDetailsInput struct {
	_ struct{} `type:"structure"`

	// A list of entity types (user, group, role, local managed policy, or AWS managed
	// policy) for filtering the results.
	Filter []*string `type:"list"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GetAccountAuthorizationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountAuthorizationDetailsInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetAccountAuthorizationDetails request.
type GetAccountAuthorizationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing information about IAM groups.
	GroupDetailList []*GroupDetail `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list containing information about managed policies.
	Policies []*ManagedPolicyDetail `type:"list"`

	// A list containing information about IAM roles.
	RoleDetailList []*RoleDetail `type:"list"`

	// A list containing information about IAM users.
	UserDetailList []*UserDetail `type:"list"`
}

// String returns the string representation
func (s GetAccountAuthorizationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountAuthorizationDetailsOutput) GoString() string {
	return s.String()
}

type GetAccountPasswordPolicyInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountPasswordPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountPasswordPolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetAccountPasswordPolicy request.
type GetAccountPasswordPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the account password policy.
	//
	//  This data type is used as a response element in the GetAccountPasswordPolicy
	// action.
	PasswordPolicy *PasswordPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAccountPasswordPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountPasswordPolicyOutput) GoString() string {
	return s.String()
}

type GetAccountSummaryInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSummaryInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetAccountSummary request.
type GetAccountSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A set of key value pairs containing information about IAM entity usage and
	// IAM quotas.
	//
	//  SummaryMap contains the following keys:   AccessKeysPerUserQuota
	//
	// The maximum number of active access keys allowed for each IAM user.
	//
	//   AccountAccessKeysPresent
	//
	// This value is 1 if the AWS account (root) has an access key, otherwise it
	// is 0.
	//
	//   AccountMFAEnabled
	//
	// This value is 1 if the AWS account (root) has an MFA device assigned, otherwise
	// it is 0.
	//
	//   AccountSigningCertificatesPresent
	//
	// This value is 1 if the AWS account (root) has a signing certificate, otherwise
	// it is 0.
	//
	//   AssumeRolePolicySizeQuota
	//
	// The maximum allowed size for assume role policy documents (trust policies),
	// in non-whitespace characters.
	//
	//   AttachedPoliciesPerGroupQuota
	//
	// The maximum number of managed policies that can be attached to an IAM group.
	//
	//   AttachedPoliciesPerRoleQuota
	//
	// The maximum number of managed policies that can be attached to an IAM role.
	//
	//   AttachedPoliciesPerUserQuota
	//
	// The maximum number of managed policies that can be attached to an IAM user.
	//
	//   GroupPolicySizeQuota
	//
	// The maximum allowed size for the aggregate of all inline policies embedded
	// in an IAM group, in non-whitespace characters.
	//
	//   Groups
	//
	// The number of IAM groups in the AWS account.
	//
	//   GroupsPerUserQuota
	//
	// The maximum number of IAM groups each IAM user can belong to.
	//
	//   GroupsQuota
	//
	// The maximum number of IAM groups allowed in the AWS account.
	//
	//   InstanceProfiles
	//
	// The number of instance profiles in the AWS account.
	//
	//   InstanceProfilesQuota
	//
	// The maximum number of instance profiles allowed in the AWS account.
	//
	//   MFADevices
	//
	// The number of MFA devices in the AWS account, including those assigned and
	// unassigned.
	//
	//   MFADevicesInUse
	//
	// The number of MFA devices that have been assigned to an IAM user or to the
	// AWS account (root).
	//
	//   Policies
	//
	// The number of customer managed policies in the AWS account.
	//
	//   PoliciesQuota
	//
	// The maximum number of customer managed policies allowed in the AWS account.
	//
	//   PolicySizeQuota
	//
	// The maximum allowed size of a customer managed policy, in non-whitespace
	// characters.
	//
	//   PolicyVersionsInUse
	//
	// The number of managed policies that are attached to IAM users, groups, or
	// roles in the AWS account.
	//
	//   PolicyVersionsInUseQuota
	//
	// The maximum number of managed policies that can be attached to IAM users,
	// groups, or roles in the AWS account.
	//
	//   Providers
	//
	// The number of identity providers in the AWS account.
	//
	//   RolePolicySizeQuota
	//
	// The maximum allowed size for the aggregate of all inline policies (access
	// policies, not the trust policy) embedded in an IAM role, in non-whitespace
	// characters.
	//
	//   Roles
	//
	// The number of IAM roles in the AWS account.
	//
	//   RolesQuota
	//
	// The maximum number of IAM roles allowed in the AWS account.
	//
	//   ServerCertificates
	//
	// The number of server certificates in the AWS account.
	//
	//   ServerCertificatesQuota
	//
	// The maximum number of server certificates allowed in the AWS account.
	//
	//   SigningCertificatesPerUserQuota
	//
	// The maximum number of X.509 signing certificates allowed for each IAM user.
	//
	//   UserPolicySizeQuota
	//
	// The maximum allowed size for the aggregate of all inline policies embedded
	// in an IAM user, in non-whitespace characters.
	//
	//   Users
	//
	// The number of IAM users in the AWS account.
	//
	//   UsersQuota
	//
	// The maximum number of IAM users allowed in the AWS account.
	//
	//   VersionsPerPolicyQuota
	//
	// The maximum number of policy versions allowed for each managed policy.
	SummaryMap map[string]*int64 `type:"map"`
}

// String returns the string representation
func (s GetAccountSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSummaryOutput) GoString() string {
	return s.String()
}

type GetContextKeysForCustomPolicyInput struct {
	_ struct{} `type:"structure"`

	// A list of policies for which you want list of context keys used in Condition
	// elements. Each document is specified as a string containing the complete,
	// valid JSON text of an IAM policy.
	PolicyInputList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetContextKeysForCustomPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContextKeysForCustomPolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetContextKeysForPrincipalPolicy or
// GetContextKeysForCustomPolicy request.
type GetContextKeysForPolicyResponse struct {
	_ struct{} `type:"structure"`

	// The list of context keys that are used in the Condition elements of the input
	// policies.
	ContextKeyNames []*string `type:"list"`
}

// String returns the string representation
func (s GetContextKeysForPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContextKeysForPolicyResponse) GoString() string {
	return s.String()
}

type GetContextKeysForPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// A optional list of additional policies for which you want list of context
	// keys used in Condition elements.
	PolicyInputList []*string `type:"list"`

	// The ARN of a user, group, or role whose policies contain the context keys
	// that you want listed. If you specify a user, the list includes context keys
	// that are found in all policies attached to the user as well as to all groups
	// that the user is a member of. If you pick a group or a role, then it includes
	// only those context keys that are found in policies attached to that entity.
	// Note that all parameters are shown in unencoded form here for clarity, but
	// must be URL encoded to be included as a part of a real HTML request.
	PolicySourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetContextKeysForPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContextKeysForPrincipalPolicyInput) GoString() string {
	return s.String()
}

type GetCredentialReportInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetCredentialReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCredentialReportInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetCredentialReport request.
type GetCredentialReportOutput struct {
	_ struct{} `type:"structure"`

	// Contains the credential report. The report is Base64-encoded.
	Content []byte `type:"blob"`

	// The date and time when the credential report was created, in ISO 8601 date-time
	// format (http://www.iso.org/iso/iso8601).
	GeneratedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The format (MIME type) of the credential report.
	ReportFormat *string `type:"string" enum:"ReportFormatType"`
}

// String returns the string representation
func (s GetCredentialReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCredentialReportOutput) GoString() string {
	return s.String()
}

type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	GroupName *string `min:"1" type:"string" required:"true"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetGroup request.
type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the group.
	Group *Group `type:"structure" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of users in the group.
	Users []*User `type:"list" required:"true"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupOutput) GoString() string {
	return s.String()
}

type GetGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the group the policy is associated with.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name of the policy document to get.
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupPolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetGroupPolicy request.
type GetGroupPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The group the policy is associated with.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupPolicyOutput) GoString() string {
	return s.String()
}

type GetInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to get information about.
	InstanceProfileName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceProfileInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetInstanceProfile request.
type GetInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instance profile.
	InstanceProfile *InstanceProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceProfileOutput) GoString() string {
	return s.String()
}

type GetLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the user whose login profile you want to retrieve.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoginProfileInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetLoginProfile request.
type GetLoginProfileOutput struct {
	_ struct{} `type:"structure"`

	// The user name and password create date for the user.
	LoginProfile *LoginProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoginProfileOutput) GoString() string {
	return s.String()
}

type GetOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
	// to get information for. You can get a list of OIDC provider ARNs by using
	// the ListOpenIDConnectProviders action.
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetOpenIDConnectProvider request.
type GetOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`

	// A list of client IDs (also known as audiences) that are associated with the
	// specified IAM OpenID Connect provider. For more information, see CreateOpenIDConnectProvider.
	ClientIDList []*string `type:"list"`

	// The date and time when the IAM OpenID Connect provider entity was created
	// in the AWS account.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of certificate thumbprints that are associated with the specified
	// IAM OpenID Connect provider. For more information, see CreateOpenIDConnectProvider.
	ThumbprintList []*string `type:"list"`

	// The URL that the IAM OpenID Connect provider is associated with. For more
	// information, see CreateOpenIDConnectProvider.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetPolicy request.
type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

type GetPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// Identifies the policy version to retrieve.
	VersionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetPolicyVersion request.
type GetPolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the policy version.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	PolicyVersion *PolicyVersion `type:"structure"`
}

// String returns the string representation
func (s GetPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionOutput) GoString() string {
	return s.String()
}

type GetRoleInput struct {
	_ struct{} `type:"structure"`

	// The name of the role to get information about.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoleInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetRole request.
type GetRoleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the role.
	Role *Role `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoleOutput) GoString() string {
	return s.String()
}

type GetRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy document to get.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the role associated with the policy.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRolePolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetRolePolicy request.
type GetRolePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The role the policy is associated with.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRolePolicyOutput) GoString() string {
	return s.String()
}

type GetSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider to get information about.
	SAMLProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSAMLProviderInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetSAMLProvider request.
type GetSAMLProviderOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when the SAML provider was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The XML metadata document that includes information about an identity provider.
	SAMLMetadataDocument *string `min:"1000" type:"string"`

	// The expiration date and time for the SAML provider.
	ValidUntil *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSAMLProviderOutput) GoString() string {
	return s.String()
}

type GetSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the public key encoding format to use in the response. To retrieve
	// the public key in ssh-rsa format, use SSH. To retrieve the public key in
	// PEM format, use PEM.
	Encoding *string `type:"string" required:"true" enum:"encodingType"`

	// The unique identifier for the SSH public key.
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The name of the IAM user associated with the SSH public key.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSSHPublicKeyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetSSHPublicKey request.
type GetSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SSH public key.
	SSHPublicKey *SSHPublicKey `type:"structure"`
}

// String returns the string representation
func (s GetSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSSHPublicKeyOutput) GoString() string {
	return s.String()
}

type GetServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name of the server certificate you want to retrieve information about.
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServerCertificateInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetServerCertificate request.
type GetServerCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the server certificate.
	ServerCertificate *ServerCertificate `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServerCertificateOutput) GoString() string {
	return s.String()
}

type GetUserInput struct {
	_ struct{} `type:"structure"`

	// The name of the user to get information about.
	//
	// This parameter is optional. If it is not included, it defaults to the user
	// making the request.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetUser request.
type GetUserOutput struct {
	_ struct{} `type:"structure"`

	// Information about the user.
	User *User `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserOutput) GoString() string {
	return s.String()
}

type GetUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy document to get.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the user who the policy is associated with.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserPolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetUserPolicy request.
type GetUserPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The user the policy is associated with.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserPolicyOutput) GoString() string {
	return s.String()
}

// Contains information about an IAM group entity.
//
//  This data type is used as a response element in the following actions:
//
//   CreateGroup   GetGroup   ListGroups
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the group. For more information
	// about ARNs and how to use them in policies, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Arn *string `min:"20" type:"string" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the group was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The stable and unique string identifying the group. For more information
	// about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	GroupId *string `min:"16" type:"string" required:"true"`

	// The friendly name that identifies the group.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The path to the group. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// Contains information about an IAM group, including all of the group's policies.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
type GroupDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// A list of the managed policies attached to the group.
	AttachedManagedPolicies []*AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the group was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The stable and unique string identifying the group. For more information
	// about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	GroupId *string `min:"16" type:"string"`

	// The friendly name that identifies the group.
	GroupName *string `min:"1" type:"string"`

	// A list of the inline policies embedded in the group.
	GroupPolicyList []*PolicyDetail `type:"list"`

	// The path to the group. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupDetail) GoString() string {
	return s.String()
}

// Contains information about an instance profile.
//
// This data type is used as a response element in the following actions:
//
//    CreateInstanceProfile
//
//    GetInstanceProfile
//
//    ListInstanceProfiles
//
//    ListInstanceProfilesForRole
type InstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the instance profile. For more
	// information about ARNs and how to use them in policies, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Arn *string `min:"20" type:"string" required:"true"`

	// The date when the instance profile was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The stable and unique string identifying the instance profile. For more information
	// about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	InstanceProfileId *string `min:"16" type:"string" required:"true"`

	// The name identifying the instance profile.
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The path to the instance profile. For more information about paths, see IAM
	// Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string" required:"true"`

	// The role associated with the instance profile.
	Roles []*Role `type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceProfile) GoString() string {
	return s.String()
}

type ListAccessKeysInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessKeysInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListAccessKeys request.
type ListAccessKeysOutput struct {
	_ struct{} `type:"structure"`

	// A list of access key metadata.
	AccessKeyMetadata []*AccessKeyMetadata `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessKeysOutput) GoString() string {
	return s.String()
}

type ListAccountAliasesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListAccountAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAliasesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListAccountAliases request.
type ListAccountAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of aliases associated with the account. AWS supports only one alias
	// per account.
	AccountAliases []*string `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccountAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAliasesOutput) GoString() string {
	return s.String()
}

type ListAttachedGroupPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) of the group to list attached policies
	// for.
	GroupName *string `min:"1" type:"string" required:"true"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all policies.
	PathPrefix *string `type:"string"`
}

// String returns the string representation
func (s ListAttachedGroupPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedGroupPoliciesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListAttachedGroupPolicies request.
type ListAttachedGroupPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the attached policies.
	AttachedPolicies []*AttachedPolicy `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAttachedGroupPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedGroupPoliciesOutput) GoString() string {
	return s.String()
}

type ListAttachedRolePoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all policies.
	PathPrefix *string `type:"string"`

	// The name (friendly name, not ARN) of the role to list attached policies for.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAttachedRolePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedRolePoliciesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListAttachedRolePolicies request.
type ListAttachedRolePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the attached policies.
	AttachedPolicies []*AttachedPolicy `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAttachedRolePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedRolePoliciesOutput) GoString() string {
	return s.String()
}

type ListAttachedUserPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all policies.
	PathPrefix *string `type:"string"`

	// The name (friendly name, not ARN) of the user to list attached policies for.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAttachedUserPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedUserPoliciesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListAttachedUserPolicies request.
type ListAttachedUserPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the attached policies.
	AttachedPolicies []*AttachedPolicy `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAttachedUserPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedUserPoliciesOutput) GoString() string {
	return s.String()
}

type ListEntitiesForPolicyInput struct {
	_ struct{} `type:"structure"`

	// The entity type to use for filtering the results.
	//
	// For example, when EntityFilter is Role, only the roles that are attached
	// to the specified policy are returned. This parameter is optional. If it is
	// not included, all attached entities (users, groups, and roles) are returned.
	EntityFilter *string `type:"string" enum:"EntityType"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all entities.
	PathPrefix *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListEntitiesForPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesForPolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListEntitiesForPolicy request.
type ListEntitiesForPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of groups that the policy is attached to.
	PolicyGroups []*PolicyGroup `type:"list"`

	// A list of roles that the policy is attached to.
	PolicyRoles []*PolicyRole `type:"list"`

	// A list of users that the policy is attached to.
	PolicyUsers []*PolicyUser `type:"list"`
}

// String returns the string representation
func (s ListEntitiesForPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesForPolicyOutput) GoString() string {
	return s.String()
}

type ListGroupPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to list policies for.
	GroupName *string `min:"1" type:"string" required:"true"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListGroupPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupPoliciesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListGroupPolicies request.
type ListGroupPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policy names.
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListGroupPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupPoliciesOutput) GoString() string {
	return s.String()
}

type ListGroupsForUserInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user to list groups for.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupsForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsForUserInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListGroupsForUser request.
type ListGroupsForUserOutput struct {
	_ struct{} `type:"structure"`

	// A list of groups.
	Groups []*Group `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsForUserOutput) GoString() string {
	return s.String()
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example, the prefix /division_abc/subdivision_xyz/
	// gets all groups whose path starts with /division_abc/subdivision_xyz/.
	//
	//  This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all groups.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListGroups request.
type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of groups.
	Groups []*Group `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

type ListInstanceProfilesForRoleInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the role to list instance profiles for.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListInstanceProfilesForRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceProfilesForRoleInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListInstanceProfilesForRole request.
type ListInstanceProfilesForRoleOutput struct {
	_ struct{} `type:"structure"`

	// A list of instance profiles.
	InstanceProfiles []*InstanceProfile `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInstanceProfilesForRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceProfilesForRoleOutput) GoString() string {
	return s.String()
}

type ListInstanceProfilesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example, the prefix /application_abc/component_xyz/
	// gets all instance profiles whose path starts with /application_abc/component_xyz/.
	//
	//  This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all instance profiles.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInstanceProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceProfilesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListInstanceProfiles request.
type ListInstanceProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A list of instance profiles.
	InstanceProfiles []*InstanceProfile `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInstanceProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceProfilesOutput) GoString() string {
	return s.String()
}

type ListMFADevicesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user whose MFA devices you want to list.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMFADevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMFADevicesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListMFADevices request.
type ListMFADevicesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// A list of MFA devices.
	MFADevices []*MFADevice `type:"list" required:"true"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMFADevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMFADevicesOutput) GoString() string {
	return s.String()
}

type ListOpenIDConnectProvidersInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListOpenIDConnectProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOpenIDConnectProvidersInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListOpenIDConnectProviders request.
type ListOpenIDConnectProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The list of IAM OpenID Connect providers in the AWS account.
	OpenIDConnectProviderList []*OpenIDConnectProviderListEntry `type:"list"`
}

// String returns the string representation
func (s ListOpenIDConnectProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOpenIDConnectProvidersOutput) GoString() string {
	return s.String()
}

type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// A flag to filter the results to only the attached policies.
	//
	// When OnlyAttached is true, the returned list contains only the policies
	// that are attached to a user, group, or role. When OnlyAttached is false,
	// or when the parameter is not included, all policies are returned.
	OnlyAttached *bool `type:"boolean"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all policies.
	PathPrefix *string `type:"string"`

	// The scope to use for filtering the results.
	//
	// To list only AWS managed policies, set Scope to AWS. To list only the customer
	// managed policies in your AWS account, set Scope to Local.
	//
	// This parameter is optional. If it is not included, or if it is set to All,
	// all policies are returned.
	Scope *string `type:"string" enum:"policyScopeType"`
}

// String returns the string representation
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListPolicies request.
type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policies.
	Policies []*Policy `type:"list"`
}

// String returns the string representation
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

type ListPolicyVersionsInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListPolicyVersions request.
type ListPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policy versions.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	Versions []*PolicyVersion `type:"list"`
}

// String returns the string representation
func (s ListPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsOutput) GoString() string {
	return s.String()
}

type ListRolePoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the role to list policies for.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRolePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRolePoliciesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListRolePolicies request.
type ListRolePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policy names.
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListRolePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRolePoliciesOutput) GoString() string {
	return s.String()
}

type ListRolesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example, the prefix /application_abc/component_xyz/
	// gets all roles whose path starts with /application_abc/component_xyz/.
	//
	//  This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all roles.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRolesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRolesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListRoles request.
type ListRolesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of roles.
	Roles []*Role `type:"list" required:"true"`
}

// String returns the string representation
func (s ListRolesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRolesOutput) GoString() string {
	return s.String()
}

type ListSAMLProvidersInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListSAMLProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSAMLProvidersInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListSAMLProviders request.
type ListSAMLProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The list of SAML providers for this account.
	SAMLProviderList []*SAMLProviderListEntry `type:"list"`
}

// String returns the string representation
func (s ListSAMLProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSAMLProvidersOutput) GoString() string {
	return s.String()
}

type ListSSHPublicKeysInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the IAM user to list SSH public keys for. If none is specified,
	// the UserName field is determined implicitly based on the AWS access key used
	// to sign the request.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSSHPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSSHPublicKeysInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListSSHPublicKeys request.
type ListSSHPublicKeysOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of SSH public keys.
	SSHPublicKeys []*SSHPublicKeyMetadata `type:"list"`
}

// String returns the string representation
func (s ListSSHPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSSHPublicKeysOutput) GoString() string {
	return s.String()
}

type ListServerCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example: /company/servercerts
	// would get all server certificates for which the path starts with /company/servercerts.
	//
	//  This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all server certificates.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServerCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServerCertificatesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListServerCertificates request.
type ListServerCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of server certificates.
	ServerCertificateMetadataList []*ServerCertificateMetadata `type:"list" required:"true"`
}

// String returns the string representation
func (s ListServerCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServerCertificatesOutput) GoString() string {
	return s.String()
}

type ListSigningCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSigningCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningCertificatesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListSigningCertificates request.
type ListSigningCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the user's signing certificate information.
	Certificates []*SigningCertificate `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSigningCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningCertificatesOutput) GoString() string {
	return s.String()
}

type ListUserPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user to list policies for.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoliciesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListUserPolicies request.
type ListUserPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policy names.
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListUserPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoliciesOutput) GoString() string {
	return s.String()
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example: /division_abc/subdivision_xyz/,
	// which would get all user names whose path starts with /division_abc/subdivision_xyz/.
	//
	//  This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all user names.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListUsers request.
type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of users.
	Users []*User `type:"list" required:"true"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

type ListVirtualMFADevicesInput struct {
	_ struct{} `type:"structure"`

	// The status (unassigned or assigned) of the devices to list. If you do not
	// specify an AssignmentStatus, the action defaults to Any which lists both
	// assigned and unassigned virtual MFA devices.
	AssignmentStatus *string `type:"string" enum:"assignmentStatusType"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListVirtualMFADevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualMFADevicesInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListVirtualMFADevices request.
type ListVirtualMFADevicesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// The list of virtual MFA devices in the current account that match the AssignmentStatus
	// value that was passed in the request.
	VirtualMFADevices []*VirtualMFADevice `type:"list" required:"true"`
}

// String returns the string representation
func (s ListVirtualMFADevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualMFADevicesOutput) GoString() string {
	return s.String()
}

// Contains the user name and password create date for a user.
//
//  This data type is used as a response element in the CreateLoginProfile
// and GetLoginProfile actions.
type LoginProfile struct {
	_ struct{} `type:"structure"`

	// The date when the password for the user was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Specifies whether the user is required to set a new password on next sign-in.
	PasswordResetRequired *bool `type:"boolean"`

	// The name of the user, which can be used for signing in to the AWS Management
	// Console.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LoginProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoginProfile) GoString() string {
	return s.String()
}

// Contains information about an MFA device.
//
// This data type is used as a response element in the ListMFADevices action.
type MFADevice struct {
	_ struct{} `type:"structure"`

	// The date when the MFA device was enabled for the user.
	EnableDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the device ARN.
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The user with whom the MFA device is associated.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MFADevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MFADevice) GoString() string {
	return s.String()
}

// Contains information about a managed policy, including the policy's ARN,
// versions, and the number of principal entities (users, groups, and roles)
// that the policy is attached to.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
//
// For more information about managed policies, see Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
type ManagedPolicyDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The number of principal entities (users, groups, and roles) that the policy
	// is attached to.
	AttachmentCount *int64 `type:"integer"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the version of the policy that is set as the default (operative)
	// version.
	//
	// For more information about policy versions, see Versioning for Managed Policies
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the Using IAM guide.
	DefaultVersionId *string `type:"string"`

	// A friendly description of the policy.
	Description *string `type:"string"`

	// Specifies whether the policy can be attached to an IAM user, group, or role.
	IsAttachable *bool `type:"boolean"`

	// The path to the policy.
	//
	// For more information about paths, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `type:"string"`

	// The stable and unique string identifying the policy.
	//
	// For more information about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	PolicyId *string `min:"16" type:"string"`

	// The friendly name (not ARN) identifying the policy.
	PolicyName *string `min:"1" type:"string"`

	// A list containing information about the versions of the policy.
	PolicyVersionList []*PolicyVersion `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was last updated.
	//
	// When a policy has only one version, this field contains the date and time
	// when the policy was created. When a policy has more than one version, this
	// field contains the date and time when the most recent policy version was
	// created.
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ManagedPolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedPolicyDetail) GoString() string {
	return s.String()
}

// Contains the Amazon Resource Name (ARN) for an IAM OpenID Connect provider.
type OpenIDConnectProviderListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s OpenIDConnectProviderListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenIDConnectProviderListEntry) GoString() string {
	return s.String()
}

// Contains information about the account password policy.
//
//  This data type is used as a response element in the GetAccountPasswordPolicy
// action.
type PasswordPolicy struct {
	_ struct{} `type:"structure"`

	// Specifies whether IAM users are allowed to change their own password.
	AllowUsersToChangePassword *bool `type:"boolean"`

	// Indicates whether passwords in the account expire. Returns true if MaxPasswordAge
	// is contains a value greater than 0. Returns false if MaxPasswordAge is 0
	// or not present.
	ExpirePasswords *bool `type:"boolean"`

	// Specifies whether IAM users are prevented from setting a new password after
	// their password has expired.
	HardExpiry *bool `type:"boolean"`

	// The number of days that an IAM user password is valid.
	MaxPasswordAge *int64 `min:"1" type:"integer"`

	// Minimum length to require for IAM user passwords.
	MinimumPasswordLength *int64 `min:"6" type:"integer"`

	// Specifies the number of previous passwords that IAM users are prevented from
	// reusing.
	PasswordReusePrevention *int64 `min:"1" type:"integer"`

	// Specifies whether to require lowercase characters for IAM user passwords.
	RequireLowercaseCharacters *bool `type:"boolean"`

	// Specifies whether to require numbers for IAM user passwords.
	RequireNumbers *bool `type:"boolean"`

	// Specifies whether to require symbols for IAM user passwords.
	RequireSymbols *bool `type:"boolean"`

	// Specifies whether to require uppercase characters for IAM user passwords.
	RequireUppercaseCharacters *bool `type:"boolean"`
}

// String returns the string representation
func (s PasswordPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PasswordPolicy) GoString() string {
	return s.String()
}

// Contains information about a managed policy.
//
// This data type is used as a response element in the CreatePolicy, GetPolicy,
// and ListPolicies actions.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
type Policy struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The number of entities (users, groups, and roles) that the policy is attached
	// to.
	AttachmentCount *int64 `type:"integer"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the version of the policy that is set as the default version.
	DefaultVersionId *string `type:"string"`

	// A friendly description of the policy.
	//
	// This element is included in the response to the GetPolicy operation. It
	// is not included in the response to the ListPolicies operation.
	Description *string `type:"string"`

	// Specifies whether the policy can be attached to an IAM user, group, or role.
	IsAttachable *bool `type:"boolean"`

	// The path to the policy.
	//
	// For more information about paths, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `type:"string"`

	// The stable and unique string identifying the policy.
	//
	// For more information about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	PolicyId *string `min:"16" type:"string"`

	// The friendly name (not ARN) identifying the policy.
	PolicyName *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was last updated.
	//
	// When a policy has only one version, this field contains the date and time
	// when the policy was created. When a policy has more than one version, this
	// field contains the date and time when the most recent policy version was
	// created.
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Policy) GoString() string {
	return s.String()
}

// Contains information about an IAM policy, including the policy document.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
type PolicyDetail struct {
	_ struct{} `type:"structure"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string"`

	// The name of the policy.
	PolicyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyDetail) GoString() string {
	return s.String()
}

// Contains information about a group that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// action.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
type PolicyGroup struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) identifying the group.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyGroup) GoString() string {
	return s.String()
}

// Contains information about a role that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// action.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
type PolicyRole struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) identifying the role.
	RoleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyRole) GoString() string {
	return s.String()
}

// Contains information about a user that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// action.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
type PolicyUser struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) identifying the user.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyUser) GoString() string {
	return s.String()
}

// Contains information about a version of a managed policy.
//
// This data type is used as a response element in the CreatePolicyVersion,
// GetPolicyVersion, ListPolicyVersions, and GetAccountAuthorizationDetails
// actions.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
type PolicyVersion struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy version was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The policy document.
	//
	// The policy document is returned in the response to the GetPolicyVersion
	// and GetAccountAuthorizationDetails operations. It is not returned in the
	// response to the CreatePolicyVersion or ListPolicyVersions operations.
	Document *string `min:"1" type:"string"`

	// Specifies whether the policy version is set as the policy's default version.
	IsDefaultVersion *bool `type:"boolean"`

	// The identifier for the policy version.
	//
	// Policy version identifiers always begin with v (always lowercase). When
	// a policy is created, the first policy version is v1.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s PolicyVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyVersion) GoString() string {
	return s.String()
}

// Contains the row and column of a location of a Statement element in a policy
// document.
//
// This data type is used as a member of the Statement type.
type Position struct {
	_ struct{} `type:"structure"`

	// The column in the line containing the specified position in the document.
	Column *int64 `type:"integer"`

	// The line containing the specified position in the document.
	Line *int64 `type:"integer"`
}

// String returns the string representation
func (s Position) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Position) GoString() string {
	return s.String()
}

type PutGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to associate the policy with.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy document.
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutGroupPolicyInput) GoString() string {
	return s.String()
}

type PutGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutGroupPolicyOutput) GoString() string {
	return s.String()
}

type PutRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy document.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the role to associate the policy with.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRolePolicyInput) GoString() string {
	return s.String()
}

type PutRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRolePolicyOutput) GoString() string {
	return s.String()
}

type PutUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy document.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the user to associate the policy with.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutUserPolicyInput) GoString() string {
	return s.String()
}

type PutUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutUserPolicyOutput) GoString() string {
	return s.String()
}

type RemoveClientIDFromOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The client ID (also known as audience) to remove from the IAM OpenID Connect
	// provider. For more information about client IDs, see CreateOpenIDConnectProvider.
	ClientID *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
	// to remove the client ID from. You can get a list of OIDC provider ARNs by
	// using the ListOpenIDConnectProviders action.
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

type RemoveClientIDFromOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

type RemoveRoleFromInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to update.
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The name of the role to remove.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveRoleFromInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRoleFromInstanceProfileInput) GoString() string {
	return s.String()
}

type RemoveRoleFromInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveRoleFromInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRoleFromInstanceProfileOutput) GoString() string {
	return s.String()
}

type RemoveUserFromGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to update.
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name of the user to remove.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveUserFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveUserFromGroupInput) GoString() string {
	return s.String()
}

type RemoveUserFromGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveUserFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveUserFromGroupOutput) GoString() string {
	return s.String()
}

// Contains the result of the simulation of a single API action call on a single
// resource.
//
// This data type is used by a member of the EvaluationResult data type.
type ResourceSpecificResult struct {
	_ struct{} `type:"structure"`

	// Additional details about the results of the evaluation decision. When there
	// are both IAM policies and resource policies, this parameter explains how
	// each set of policies contributes to the final evaluation decision. When simulating
	// cross-account access to a resource, both the resource-based policy and the
	// caller's IAM policy must grant access.
	EvalDecisionDetails map[string]*string `type:"map"`

	// The result of the simulation of the simulated API action on the resource
	// specified in EvalResourceName.
	EvalResourceDecision *string `type:"string" required:"true" enum:"PolicyEvaluationDecisionType"`

	// The name of the simulated resource, in Amazon Resource Name (ARN) format.
	EvalResourceName *string `min:"1" type:"string" required:"true"`

	// A list of the statements in the input policies that determine the result
	// for this part of the simulation. Remember that even if multiple statements
	// allow the action on the resource, if any statement denies that action, then
	// the explicit deny overrides any allow, and the deny statement is the only
	// entry included in the result.
	MatchedStatements []*Statement `type:"list"`

	// A list of context keys that are required by the included input policies but
	// that were not provided by one of the input parameters. To discover the context
	// keys used by a set of policies, you can call GetContextKeysForCustomPolicy
	// or GetContextKeysForPrincipalPolicy.
	MissingContextValues []*string `type:"list"`
}

// String returns the string representation
func (s ResourceSpecificResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceSpecificResult) GoString() string {
	return s.String()
}

type ResyncMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// An authentication code emitted by the device.
	AuthenticationCode1 *string `min:"6" type:"string" required:"true"`

	// A subsequent authentication code emitted by the device.
	AuthenticationCode2 *string `min:"6" type:"string" required:"true"`

	// Serial number that uniquely identifies the MFA device.
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The name of the user whose MFA device you want to resynchronize.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResyncMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResyncMFADeviceInput) GoString() string {
	return s.String()
}

type ResyncMFADeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResyncMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResyncMFADeviceOutput) GoString() string {
	return s.String()
}

// Contains information about an IAM role.
//
//  This data type is used as a response element in the following actions:
//
//    CreateRole
//
//    GetRole
//
//    ListRoles
type Role struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the role. For more information
	// about ARNs and how to use them in policies, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Arn *string `min:"20" type:"string" required:"true"`

	// The policy that grants an entity permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the role was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The path to the role. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string" required:"true"`

	// The stable and unique string identifying the role. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	RoleId *string `min:"16" type:"string" required:"true"`

	// The friendly name that identifies the role.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Role) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Role) GoString() string {
	return s.String()
}

// Contains information about an IAM role, including all of the role's policies.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
type RoleDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// A list of managed policies attached to the role. These policies are the role's
	// access (permissions) policies.
	AttachedManagedPolicies []*AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the role was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Contains a list of instance profiles.
	InstanceProfileList []*InstanceProfile `type:"list"`

	// The path to the role. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`

	// The stable and unique string identifying the role. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	RoleId *string `min:"16" type:"string"`

	// The friendly name that identifies the role.
	RoleName *string `min:"1" type:"string"`

	// A list of inline policies embedded in the role. These policies are the role's
	// access (permissions) policies.
	RolePolicyList []*PolicyDetail `type:"list"`
}

// String returns the string representation
func (s RoleDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleDetail) GoString() string {
	return s.String()
}

// Contains the list of SAML providers for this account.
type SAMLProviderListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider.
	Arn *string `min:"20" type:"string"`

	// The date and time when the SAML provider was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The expiration date and time for the SAML provider.
	ValidUntil *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SAMLProviderListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SAMLProviderListEntry) GoString() string {
	return s.String()
}

// Contains information about an SSH public key.
//
// This data type is used as a response element in the GetSSHPublicKey and
// UploadSSHPublicKey actions.
type SSHPublicKey struct {
	_ struct{} `type:"structure"`

	// The MD5 message digest of the SSH public key.
	Fingerprint *string `min:"48" type:"string" required:"true"`

	// The SSH public key.
	SSHPublicKeyBody *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the SSH public key.
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The status of the SSH public key. Active means the key can be used for authentication
	// with an AWS CodeCommit repository. Inactive means the key cannot be used.
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the SSH public key was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the IAM user associated with the SSH public key.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SSHPublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSHPublicKey) GoString() string {
	return s.String()
}

// Contains information about an SSH public key, without the key's body or fingerprint.
//
// This data type is used as a response element in the ListSSHPublicKeys action.
type SSHPublicKeyMetadata struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the SSH public key.
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The status of the SSH public key. Active means the key can be used for authentication
	// with an AWS CodeCommit repository. Inactive means the key cannot be used.
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the SSH public key was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the IAM user associated with the SSH public key.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SSHPublicKeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSHPublicKeyMetadata) GoString() string {
	return s.String()
}

// Contains information about a server certificate.
//
//  This data type is used as a response element in the GetServerCertificate
// action.
type ServerCertificate struct {
	_ struct{} `type:"structure"`

	// The contents of the public key certificate.
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The contents of the public key certificate chain.
	CertificateChain *string `min:"1" type:"string"`

	// The meta information of the server certificate, such as its name, path, ID,
	// and ARN.
	ServerCertificateMetadata *ServerCertificateMetadata `type:"structure" required:"true"`
}

// String returns the string representation
func (s ServerCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerCertificate) GoString() string {
	return s.String()
}

// Contains information about a server certificate without its certificate body,
// certificate chain, and private key.
//
//  This data type is used as a response element in the UploadServerCertificate
// and ListServerCertificates actions.
type ServerCertificateMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the server certificate. For more
	// information about ARNs and how to use them in policies, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Arn *string `min:"20" type:"string" required:"true"`

	// The date on which the certificate is set to expire.
	Expiration *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The path to the server certificate. For more information about paths, see
	// IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string" required:"true"`

	// The stable and unique string identifying the server certificate. For more
	// information about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	ServerCertificateId *string `min:"16" type:"string" required:"true"`

	// The name that identifies the server certificate.
	ServerCertificateName *string `min:"1" type:"string" required:"true"`

	// The date when the server certificate was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ServerCertificateMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerCertificateMetadata) GoString() string {
	return s.String()
}

type SetDefaultPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The version of the policy to set as the default (operative) version.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	VersionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDefaultPolicyVersionInput) GoString() string {
	return s.String()
}

type SetDefaultPolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDefaultPolicyVersionOutput) GoString() string {
	return s.String()
}

// Contains information about an X.509 signing certificate.
//
// This data type is used as a response element in the UploadSigningCertificate
// and ListSigningCertificates actions.
type SigningCertificate struct {
	_ struct{} `type:"structure"`

	// The contents of the signing certificate.
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The ID for the signing certificate.
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The status of the signing certificate. Active means the key is valid for
	// API calls, while Inactive means it is not.
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The date when the signing certificate was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the user the signing certificate is associated with.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SigningCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningCertificate) GoString() string {
	return s.String()
}

type SimulateCustomPolicyInput struct {
	_ struct{} `type:"structure"`

	// A list of names of API actions to evaluate in the simulation. Each action
	// is evaluated against each resource. Each action must include the service
	// identifier, such as iam:CreateUser.
	ActionNames []*string `type:"list" required:"true"`

	// The ARN of the user that you want to use as the simulated caller of the APIs.
	// CallerArn is required if you include a ResourcePolicy so that the policy's
	// Principal element has a value to use in evaluating the policy.
	//
	// You can specify only the ARN of an IAM user. You cannot specify the ARN
	// of an assumed role, federated user, or a service principal.
	CallerArn *string `min:"1" type:"string"`

	// A list of context keys and corresponding values for the simulation to use.
	// Whenever a context key is evaluated by a Condition element in one of the
	// simulated IAM permission policies, the corresponding value is supplied.
	ContextEntries []*ContextEntry `type:"list"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// A list of policy documents to include in the simulation. Each document is
	// specified as a string containing the complete, valid JSON text of an IAM
	// policy. Do not include any resource-based policies in this parameter. Any
	// resource-based policy must be submitted with the ResourcePolicy parameter.
	// The policies cannot be "scope-down" policies, such as you could include in
	// a call to GetFederationToken (http://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html)
	// or one of the AssumeRole (http://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html)
	// APIs to restrict what a user can do while using the temporary credentials.
	PolicyInputList []*string `type:"list" required:"true"`

	// A list of ARNs of AWS resources to include in the simulation. If this parameter
	// is not provided then the value defaults to * (all resources). Each API in
	// the ActionNames parameter is evaluated for each resource in this list. The
	// simulation determines the access result (allowed or denied) of each combination
	// and reports it in the response.
	//
	// The simulation does not automatically retrieve policies for the specified
	// resources. If you want to include a resource policy in the simulation, then
	// you must include the policy as a string in the ResourcePolicy parameter.
	//
	// If you include a ResourcePolicy, then it must be applicable to all of the
	// resources included in the simulation or you receive an invalid input error.
	ResourceArns []*string `type:"list"`

	// Specifies the type of simulation to run. Different APIs that support resource-based
	// policies require different combinations of resources. By specifying the type
	// of simulation to run, you enable the policy simulator to enforce the presence
	// of the required resources to ensure reliable simulation results. If your
	// simulation does not match one of the following scenarios, then you can omit
	// this parameter. The following list shows each of the supported scenario values
	// and the resources that you must define to run the simulation.
	//
	// Each of the EC2 scenarios requires that you specify instance, image, and
	// security-group resources. If your scenario includes an EBS volume, then you
	// must specify that volume as a resource. If the EC2 scenario includes VPC,
	// then you must supply the network-interface resource. If it includes an IP
	// subnet, then you must specify the subnet resource. For more information on
	// the EC2 scenario options, see Supported Platforms (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html)
	// in the AWS EC2 User Guide.
	//
	//  EC2-Classic-InstanceStore
	//
	// instance, image, security-group
	//
	//  EC2-Classic-EBS
	//
	// instance, image, security-group, volume
	//
	//  EC2-VPC-InstanceStore
	//
	// instance, image, security-group, network-interface
	//
	//  EC2-VPC-InstanceStore-Subnet
	//
	// instance, image, security-group, network-interface, subnet
	//
	//  EC2-VPC-EBS
	//
	// instance, image, security-group, network-interface, volume
	//
	//  EC2-VPC-EBS-Subnet
	//
	// instance, image, security-group, network-interface, subnet, volume
	ResourceHandlingOption *string `min:"1" type:"string"`

	// An AWS account ID that specifies the owner of any simulated resource that
	// does not identify its owner in the resource ARN, such as an S3 bucket or
	// object. If ResourceOwner is specified, it is also used as the account owner
	// of any ResourcePolicy included in the simulation. If the ResourceOwner parameter
	// is not specified, then the owner of the resources and the resource policy
	// defaults to the account of the identity provided in CallerArn. This parameter
	// is required only if you specify a resource-based policy and account that
	// owns the resource is different from the account that owns the simulated calling
	// user CallerArn.
	ResourceOwner *string `min:"1" type:"string"`

	// A resource-based policy to include in the simulation provided as a string.
	// Each resource in the simulation is treated as if it had this policy attached.
	// You can include only one resource-based policy in a simulation.
	ResourcePolicy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SimulateCustomPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulateCustomPolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful SimulatePrincipalPolicy or SimulateCustomPolicy
// request.
type SimulatePolicyResponse struct {
	_ struct{} `type:"structure"`

	// The results of the simulation.
	EvaluationResults []*EvaluationResult `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SimulatePolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulatePolicyResponse) GoString() string {
	return s.String()
}

type SimulatePrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// A list of names of API actions to evaluate in the simulation. Each action
	// is evaluated for each resource. Each action must include the service identifier,
	// such as iam:CreateUser.
	ActionNames []*string `type:"list" required:"true"`

	// The ARN of the user that you want to specify as the simulated caller of the
	// APIs. If you do not specify a CallerArn, it defaults to the ARN of the user
	// that you specify in PolicySourceArn, if you specified a user. If you include
	// both a PolicySourceArn (for example, arn:aws:iam::123456789012:user/David)
	// and a CallerArn (for example, arn:aws:iam::123456789012:user/Bob), the result
	// is that you simulate calling the APIs as Bob, as if Bob had David's policies.
	//
	// You can specify only the ARN of an IAM user. You cannot specify the ARN
	// of an assumed role, federated user, or a service principal.
	//
	// CallerArn is required if you include a ResourcePolicy and the PolicySourceArn
	// is not the ARN for an IAM user. This is required so that the resource-based
	// policy's Principal element has a value to use in evaluating the policy.
	CallerArn *string `min:"1" type:"string"`

	// A list of context keys and corresponding values for the simulation to use.
	// Whenever a context key is evaluated by a Condition element in one of the
	// simulated policies, the corresponding value is supplied.
	ContextEntries []*ContextEntry `type:"list"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// This parameter is optional. If you do not include it, it defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// An optional list of additional policy documents to include in the simulation.
	// Each document is specified as a string containing the complete, valid JSON
	// text of an IAM policy.
	PolicyInputList []*string `type:"list"`

	// The Amazon Resource Name (ARN) of a user, group, or role whose policies you
	// want to include in the simulation. If you specify a user, group, or role,
	// the simulation includes all policies that are associated with that entity.
	// If you specify a user, the simulation also includes all policies that are
	// attached to any groups the user belongs to.
	PolicySourceArn *string `min:"20" type:"string" required:"true"`

	// A list of ARNs of AWS resources to include in the simulation. If this parameter
	// is not provided then the value defaults to * (all resources). Each API in
	// the ActionNames parameter is evaluated for each resource in this list. The
	// simulation determines the access result (allowed or denied) of each combination
	// and reports it in the response.
	//
	// The simulation does not automatically retrieve policies for the specified
	// resources. If you want to include a resource policy in the simulation, then
	// you must include the policy as a string in the ResourcePolicy parameter.
	ResourceArns []*string `type:"list"`

	// Specifies the type of simulation to run. Different APIs that support resource-based
	// policies require different combinations of resources. By specifying the type
	// of simulation to run, you enable the policy simulator to enforce the presence
	// of the required resources to ensure reliable simulation results. If your
	// simulation does not match one of the following scenarios, then you can omit
	// this parameter. The following list shows each of the supported scenario values
	// and the resources that you must define to run the simulation.
	//
	// Each of the EC2 scenarios requires that you specify instance, image, and
	// security-group resources. If your scenario includes an EBS volume, then you
	// must specify that volume as a resource. If the EC2 scenario includes VPC,
	// then you must supply the network-interface resource. If it includes an IP
	// subnet, then you must specify the subnet resource. For more information on
	// the EC2 scenario options, see Supported Platforms (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html)
	// in the AWS EC2 User Guide.
	//
	//  EC2-Classic-InstanceStore
	//
	// instance, image, security-group
	//
	//  EC2-Classic-EBS
	//
	// instance, image, security-group, volume
	//
	//  EC2-VPC-InstanceStore
	//
	// instance, image, security-group, network-interface
	//
	//  EC2-VPC-InstanceStore-Subnet
	//
	// instance, image, security-group, network-interface, subnet
	//
	//  EC2-VPC-EBS
	//
	// instance, image, security-group, network-interface, volume
	//
	//  EC2-VPC-EBS-Subnet
	//
	// instance, image, security-group, network-interface, subnet, volume
	ResourceHandlingOption *string `min:"1" type:"string"`

	// An AWS account ID that specifies the owner of any simulated resource that
	// does not identify its owner in the resource ARN, such as an S3 bucket or
	// object. If ResourceOwner is specified, it is also used as the account owner
	// of any ResourcePolicy included in the simulation. If the ResourceOwner parameter
	// is not specified, then the owner of the resources and the resource policy
	// defaults to the account of the identity provided in CallerArn. This parameter
	// is required only if you specify a resource-based policy and account that
	// owns the resource is different from the account that owns the simulated calling
	// user CallerArn.
	ResourceOwner *string `min:"1" type:"string"`

	// A resource-based policy to include in the simulation provided as a string.
	// Each resource in the simulation is treated as if it had this policy attached.
	// You can include only one resource-based policy in a simulation.
	ResourcePolicy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SimulatePrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulatePrincipalPolicyInput) GoString() string {
	return s.String()
}

// Contains a reference to a Statement element in a policy document that determines
// the result of the simulation.
//
// This data type is used by the MatchedStatements member of the EvaluationResult
// type.
type Statement struct {
	_ struct{} `type:"structure"`

	// The row and column of the end of a Statement in an IAM policy.
	EndPosition *Position `type:"structure"`

	// The identifier of the policy that was provided as an input.
	SourcePolicyId *string `type:"string"`

	// The type of the policy.
	SourcePolicyType *string `type:"string" enum:"PolicySourceType"`

	// The row and column of the beginning of the Statement in an IAM policy.
	StartPosition *Position `type:"structure"`
}

// String returns the string representation
func (s Statement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Statement) GoString() string {
	return s.String()
}

type UpdateAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The access key ID of the secret access key you want to update.
	AccessKeyId *string `min:"16" type:"string" required:"true"`

	// The status you want to assign to the secret access key. Active means the
	// key can be used for API calls to AWS, while Inactive means the key cannot
	// be used.
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the user whose key you want to update.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccessKeyInput) GoString() string {
	return s.String()
}

type UpdateAccessKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccessKeyOutput) GoString() string {
	return s.String()
}

type UpdateAccountPasswordPolicyInput struct {
	_ struct{} `type:"structure"`

	// Allows all IAM users in your account to use the AWS Management Console to
	// change their own passwords. For more information, see Letting IAM Users Change
	// Their Own Passwords (http://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html)
	// in the IAM User Guide.
	//
	// Default value: false
	AllowUsersToChangePassword *bool `type:"boolean"`

	// Prevents IAM users from setting a new password after their password has expired.
	//
	// Default value: false
	HardExpiry *bool `type:"boolean"`

	// The number of days that an IAM user password is valid. The default value
	// of 0 means IAM user passwords never expire.
	//
	// Default value: 0
	MaxPasswordAge *int64 `min:"1" type:"integer"`

	// The minimum number of characters allowed in an IAM user password.
	//
	// Default value: 6
	MinimumPasswordLength *int64 `min:"6" type:"integer"`

	// Specifies the number of previous passwords that IAM users are prevented from
	// reusing. The default value of 0 means IAM users are not prevented from reusing
	// previous passwords.
	//
	// Default value: 0
	PasswordReusePrevention *int64 `min:"1" type:"integer"`

	// Specifies whether IAM user passwords must contain at least one lowercase
	// character from the ISO basic Latin alphabet (a to z).
	//
	// Default value: false
	RequireLowercaseCharacters *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one numeric character
	// (0 to 9).
	//
	// Default value: false
	RequireNumbers *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one of the following
	// non-alphanumeric characters:
	//
	// ! @ # $ % ^ &amp; * ( ) _ + - = [ ] { } | '
	//
	// Default value: false
	RequireSymbols *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one uppercase
	// character from the ISO basic Latin alphabet (A to Z).
	//
	// Default value: false
	RequireUppercaseCharacters *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateAccountPasswordPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountPasswordPolicyInput) GoString() string {
	return s.String()
}

type UpdateAccountPasswordPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAccountPasswordPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountPasswordPolicyOutput) GoString() string {
	return s.String()
}

type UpdateAssumeRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy that grants an entity permission to assume the role.
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the role to update.
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAssumeRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssumeRolePolicyInput) GoString() string {
	return s.String()
}

type UpdateAssumeRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAssumeRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssumeRolePolicyOutput) GoString() string {
	return s.String()
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// Name of the group to update. If you're changing the name of the group, this
	// is the original name.
	GroupName *string `min:"1" type:"string" required:"true"`

	// New name for the group. Only include this if changing the group's name.
	NewGroupName *string `min:"1" type:"string"`

	// New path for the group. Only include this if changing the group's path.
	NewPath *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

type UpdateLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The new password for the specified user.
	Password *string `min:"1" type:"string"`

	// Require the specified user to set a new password on next sign-in.
	PasswordResetRequired *bool `type:"boolean"`

	// The name of the user whose password you want to update.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoginProfileInput) GoString() string {
	return s.String()
}

type UpdateLoginProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoginProfileOutput) GoString() string {
	return s.String()
}

type UpdateOpenIDConnectProviderThumbprintInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
	// to update the thumbprint for. You can get a list of OIDC provider ARNs by
	// using the ListOpenIDConnectProviders action.
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`

	// A list of certificate thumbprints that are associated with the specified
	// IAM OpenID Connect provider. For more information, see CreateOpenIDConnectProvider.
	ThumbprintList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateOpenIDConnectProviderThumbprintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOpenIDConnectProviderThumbprintInput) GoString() string {
	return s.String()
}

type UpdateOpenIDConnectProviderThumbprintOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateOpenIDConnectProviderThumbprintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOpenIDConnectProviderThumbprintOutput) GoString() string {
	return s.String()
}

type UpdateSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// An XML document generated by an identity provider (IdP) that supports SAML
	// 2.0. The document includes the issuer's name, expiration information, and
	// keys that can be used to validate the SAML authentication response (assertions)
	// that are received from the IdP. You must generate the metadata document using
	// the identity management software that is used as your organization's IdP.
	SAMLMetadataDocument *string `min:"1000" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the SAML provider to update.
	SAMLProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSAMLProviderInput) GoString() string {
	return s.String()
}

// Contains the response to a successful UpdateSAMLProvider request.
type UpdateSAMLProviderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider that was updated.
	SAMLProviderArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSAMLProviderOutput) GoString() string {
	return s.String()
}

type UpdateSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the SSH public key.
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The status to assign to the SSH public key. Active means the key can be used
	// for authentication with an AWS CodeCommit repository. Inactive means the
	// key cannot be used.
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the IAM user associated with the SSH public key.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSSHPublicKeyInput) GoString() string {
	return s.String()
}

type UpdateSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSSHPublicKeyOutput) GoString() string {
	return s.String()
}

type UpdateServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The new path for the server certificate. Include this only if you are updating
	// the server certificate's path.
	NewPath *string `min:"1" type:"string"`

	// The new name for the server certificate. Include this only if you are updating
	// the server certificate's name. The name of the certificate cannot contain
	// any spaces.
	NewServerCertificateName *string `min:"1" type:"string"`

	// The name of the server certificate that you want to update.
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerCertificateInput) GoString() string {
	return s.String()
}

type UpdateServerCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerCertificateOutput) GoString() string {
	return s.String()
}

type UpdateSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the signing certificate you want to update.
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The status you want to assign to the certificate. Active means the certificate
	// can be used for API calls to AWS, while Inactive means the certificate cannot
	// be used.
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the user the signing certificate belongs to.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSigningCertificateInput) GoString() string {
	return s.String()
}

type UpdateSigningCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSigningCertificateOutput) GoString() string {
	return s.String()
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// New path for the user. Include this parameter only if you're changing the
	// user's path.
	NewPath *string `min:"1" type:"string"`

	// New name for the user. Include this parameter only if you're changing the
	// user's name.
	NewUserName *string `min:"1" type:"string"`

	// Name of the user to update. If you're changing the name of the user, this
	// is the original user name.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

type UploadSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The SSH public key. The public key must be encoded in ssh-rsa format or PEM
	// format.
	SSHPublicKeyBody *string `min:"1" type:"string" required:"true"`

	// The name of the IAM user to associate the SSH public key with.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSSHPublicKeyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful UploadSSHPublicKey request.
type UploadSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the SSH public key.
	SSHPublicKey *SSHPublicKey `type:"structure"`
}

// String returns the string representation
func (s UploadSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSSHPublicKeyOutput) GoString() string {
	return s.String()
}

type UploadServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The contents of the public key certificate in PEM-encoded format.
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The contents of the certificate chain. This is typically a concatenation
	// of the PEM-encoded public key certificates of the chain.
	CertificateChain *string `min:"1" type:"string"`

	// The path for the server certificate. For more information about paths, see
	// IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	//
	//  If you are uploading a server certificate specifically for use with Amazon
	// CloudFront distributions, you must specify a path using the --path option.
	// The path must begin with /cloudfront and must include a trailing slash (for
	// example, /cloudfront/test/).
	Path *string `min:"1" type:"string"`

	// The contents of the private key in PEM-encoded format.
	PrivateKey *string `min:"1" type:"string" required:"true"`

	// The name for the server certificate. Do not include the path in this value.
	// The name of the certificate cannot contain any spaces.
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadServerCertificateInput) GoString() string {
	return s.String()
}

// Contains the response to a successful UploadServerCertificate request.
type UploadServerCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The meta information of the uploaded server certificate without its certificate
	// body, certificate chain, and private key.
	ServerCertificateMetadata *ServerCertificateMetadata `type:"structure"`
}

// String returns the string representation
func (s UploadServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadServerCertificateOutput) GoString() string {
	return s.String()
}

type UploadSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The contents of the signing certificate.
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The name of the user the signing certificate is for.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UploadSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSigningCertificateInput) GoString() string {
	return s.String()
}

// Contains the response to a successful UploadSigningCertificate request.
type UploadSigningCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the certificate.
	Certificate *SigningCertificate `type:"structure" required:"true"`
}

// String returns the string representation
func (s UploadSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSigningCertificateOutput) GoString() string {
	return s.String()
}

// Contains information about an IAM user entity.
//
//  This data type is used as a response element in the following actions:
//
//    CreateUser
//
//    GetUser
//
//    ListUsers
type User struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Arn *string `min:"20" type:"string" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user's password was last used to sign in to an AWS website. For
	// a list of AWS websites that capture a user's last sign-in time, see the Credential
	// Reports (http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
	// topic in the Using IAM guide. If a password is used more than once in a five-minute
	// span, only the first use is returned in this field. This field is null (not
	// present) when:
	//
	//   The user does not have a password
	//
	//   The password exists but has never been used (at least not since IAM started
	// tracking this information on October 20th, 2014
	//
	//   there is no sign-in data associated with the user
	//
	//   This value is returned only in the GetUser and ListUsers actions.
	PasswordLastUsed *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The path to the user. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string" required:"true"`

	// The stable and unique string identifying the user. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	UserId *string `min:"16" type:"string" required:"true"`

	// The friendly name identifying the user.
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// Contains information about an IAM user, including all the user's policies
// and all the IAM groups the user is in.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
type UserDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and
	// AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// A list of the managed policies attached to the user.
	AttachedManagedPolicies []*AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of IAM groups that the user is in.
	GroupList []*string `type:"list"`

	// The path to the user. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`

	// The stable and unique string identifying the user. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	UserId *string `min:"16" type:"string"`

	// The friendly name identifying the user.
	UserName *string `min:"1" type:"string"`

	// A list of the inline policies embedded in the user.
	UserPolicyList []*PolicyDetail `type:"list"`
}

// String returns the string representation
func (s UserDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserDetail) GoString() string {
	return s.String()
}

// Contains information about a virtual MFA device.
type VirtualMFADevice struct {
	_ struct{} `type:"structure"`

	// The Base32 seed defined as specified in RFC3548 (http://www.ietf.org/rfc/rfc3548.txt).
	// The Base32StringSeed is Base64-encoded.
	Base32StringSeed []byte `type:"blob"`

	// The date and time on which the virtual MFA device was enabled.
	EnableDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A QR code PNG image that encodes otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String
	// where $virtualMFADeviceName is one of the create call arguments, AccountName
	// is the user name if set (otherwise, the account ID otherwise), and Base32String
	// is the seed in Base32 format. The Base32String value is Base64-encoded.
	QRCodePNG []byte `type:"blob"`

	// The serial number associated with VirtualMFADevice.
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// Contains information about an IAM user entity.
	//
	//  This data type is used as a response element in the following actions:
	//
	//    CreateUser
	//
	//    GetUser
	//
	//    ListUsers
	User *User `type:"structure"`
}

// String returns the string representation
func (s VirtualMFADevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualMFADevice) GoString() string {
	return s.String()
}

const (
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumString = "string"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumStringList = "stringList"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumNumeric = "numeric"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumNumericList = "numericList"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumBoolean = "boolean"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumBooleanList = "booleanList"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumIp = "ip"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumIpList = "ipList"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumBinary = "binary"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumBinaryList = "binaryList"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumDate = "date"
	// @enum ContextKeyTypeEnum
	ContextKeyTypeEnumDateList = "dateList"
)

const (
	// @enum EntityType
	EntityTypeUser = "User"
	// @enum EntityType
	EntityTypeRole = "Role"
	// @enum EntityType
	EntityTypeGroup = "Group"
	// @enum EntityType
	EntityTypeLocalManagedPolicy = "LocalManagedPolicy"
	// @enum EntityType
	EntityTypeAwsmanagedPolicy = "AWSManagedPolicy"
)

const (
	// @enum PolicyEvaluationDecisionType
	PolicyEvaluationDecisionTypeAllowed = "allowed"
	// @enum PolicyEvaluationDecisionType
	PolicyEvaluationDecisionTypeExplicitDeny = "explicitDeny"
	// @enum PolicyEvaluationDecisionType
	PolicyEvaluationDecisionTypeImplicitDeny = "implicitDeny"
)

const (
	// @enum PolicySourceType
	PolicySourceTypeUser = "user"
	// @enum PolicySourceType
	PolicySourceTypeGroup = "group"
	// @enum PolicySourceType
	PolicySourceTypeRole = "role"
	// @enum PolicySourceType
	PolicySourceTypeAwsManaged = "aws-managed"
	// @enum PolicySourceType
	PolicySourceTypeUserManaged = "user-managed"
	// @enum PolicySourceType
	PolicySourceTypeResource = "resource"
	// @enum PolicySourceType
	PolicySourceTypeNone = "none"
)

const (
	// @enum ReportFormatType
	ReportFormatTypeTextCsv = "text/csv"
)

const (
	// @enum ReportStateType
	ReportStateTypeStarted = "STARTED"
	// @enum ReportStateType
	ReportStateTypeInprogress = "INPROGRESS"
	// @enum ReportStateType
	ReportStateTypeComplete = "COMPLETE"
)

const (
	// @enum assignmentStatusType
	AssignmentStatusTypeAssigned = "Assigned"
	// @enum assignmentStatusType
	AssignmentStatusTypeUnassigned = "Unassigned"
	// @enum assignmentStatusType
	AssignmentStatusTypeAny = "Any"
)

const (
	// @enum encodingType
	EncodingTypeSsh = "SSH"
	// @enum encodingType
	EncodingTypePem = "PEM"
)

const (
	// @enum policyScopeType
	PolicyScopeTypeAll = "All"
	// @enum policyScopeType
	PolicyScopeTypeAws = "AWS"
	// @enum policyScopeType
	PolicyScopeTypeLocal = "Local"
)

const (
	// @enum statusType
	StatusTypeActive = "Active"
	// @enum statusType
	StatusTypeInactive = "Inactive"
)

const (
	// @enum summaryKeyType
	SummaryKeyTypeUsers = "Users"
	// @enum summaryKeyType
	SummaryKeyTypeUsersQuota = "UsersQuota"
	// @enum summaryKeyType
	SummaryKeyTypeGroups = "Groups"
	// @enum summaryKeyType
	SummaryKeyTypeGroupsQuota = "GroupsQuota"
	// @enum summaryKeyType
	SummaryKeyTypeServerCertificates = "ServerCertificates"
	// @enum summaryKeyType
	SummaryKeyTypeServerCertificatesQuota = "ServerCertificatesQuota"
	// @enum summaryKeyType
	SummaryKeyTypeUserPolicySizeQuota = "UserPolicySizeQuota"
	// @enum summaryKeyType
	SummaryKeyTypeGroupPolicySizeQuota = "GroupPolicySizeQuota"
	// @enum summaryKeyType
	SummaryKeyTypeGroupsPerUserQuota = "GroupsPerUserQuota"
	// @enum summaryKeyType
	SummaryKeyTypeSigningCertificatesPerUserQuota = "SigningCertificatesPerUserQuota"
	// @enum summaryKeyType
	SummaryKeyTypeAccessKeysPerUserQuota = "AccessKeysPerUserQuota"
	// @enum summaryKeyType
	SummaryKeyTypeMfadevices = "MFADevices"
	// @enum summaryKeyType
	SummaryKeyTypeMfadevicesInUse = "MFADevicesInUse"
	// @enum summaryKeyType
	SummaryKeyTypeAccountMfaenabled = "AccountMFAEnabled"
	// @enum summaryKeyType
	SummaryKeyTypeAccountAccessKeysPresent = "AccountAccessKeysPresent"
	// @enum summaryKeyType
	SummaryKeyTypeAccountSigningCertificatesPresent = "AccountSigningCertificatesPresent"
	// @enum summaryKeyType
	SummaryKeyTypeAttachedPoliciesPerGroupQuota = "AttachedPoliciesPerGroupQuota"
	// @enum summaryKeyType
	SummaryKeyTypeAttachedPoliciesPerRoleQuota = "AttachedPoliciesPerRoleQuota"
	// @enum summaryKeyType
	SummaryKeyTypeAttachedPoliciesPerUserQuota = "AttachedPoliciesPerUserQuota"
	// @enum summaryKeyType
	SummaryKeyTypePolicies = "Policies"
	// @enum summaryKeyType
	SummaryKeyTypePoliciesQuota = "PoliciesQuota"
	// @enum summaryKeyType
	SummaryKeyTypePolicySizeQuota = "PolicySizeQuota"
	// @enum summaryKeyType
	SummaryKeyTypePolicyVersionsInUse = "PolicyVersionsInUse"
	// @enum summaryKeyType
	SummaryKeyTypePolicyVersionsInUseQuota = "PolicyVersionsInUseQuota"
	// @enum summaryKeyType
	SummaryKeyTypeVersionsPerPolicyQuota = "VersionsPerPolicyQuota"
)
