// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ssm provides a client for Amazon Simple Systems Management Service.
package ssm

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCancelCommand = "CancelCommand"

// CancelCommandRequest generates a request for the CancelCommand operation.
func (c *SSM) CancelCommandRequest(input *CancelCommandInput) (req *request.Request, output *CancelCommandOutput) {
	op := &request.Operation{
		Name:       opCancelCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelCommandInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelCommandOutput{}
	req.Data = output
	return
}

// Attempts to cancel the command specified by the Command ID. There is no guarantee
// that the command will be terminated and the underlying process stopped.
func (c *SSM) CancelCommand(input *CancelCommandInput) (*CancelCommandOutput, error) {
	req, out := c.CancelCommandRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAssociation = "CreateAssociation"

// CreateAssociationRequest generates a request for the CreateAssociation operation.
func (c *SSM) CreateAssociationRequest(input *CreateAssociationInput) (req *request.Request, output *CreateAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAssociationOutput{}
	req.Data = output
	return
}

// Associates the specified SSM document with the specified instance.
//
// When you associate an SSM document with an instance, the configuration agent
// on the instance processes the document and configures the instance as specified.
//
// If you associate a document with an instance that already has an associated
// document, the system throws the AssociationAlreadyExists exception.
func (c *SSM) CreateAssociation(input *CreateAssociationInput) (*CreateAssociationOutput, error) {
	req, out := c.CreateAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAssociationBatch = "CreateAssociationBatch"

// CreateAssociationBatchRequest generates a request for the CreateAssociationBatch operation.
func (c *SSM) CreateAssociationBatchRequest(input *CreateAssociationBatchInput) (req *request.Request, output *CreateAssociationBatchOutput) {
	op := &request.Operation{
		Name:       opCreateAssociationBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationBatchInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAssociationBatchOutput{}
	req.Data = output
	return
}

// Associates the specified SSM document with the specified instances.
//
// When you associate an SSM document with an instance, the configuration agent
// on the instance processes the document and configures the instance as specified.
//
// If you associate a document with an instance that already has an associated
// document, the system throws the AssociationAlreadyExists exception.
func (c *SSM) CreateAssociationBatch(input *CreateAssociationBatchInput) (*CreateAssociationBatchOutput, error) {
	req, out := c.CreateAssociationBatchRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDocument = "CreateDocument"

// CreateDocumentRequest generates a request for the CreateDocument operation.
func (c *SSM) CreateDocumentRequest(input *CreateDocumentInput) (req *request.Request, output *CreateDocumentOutput) {
	op := &request.Operation{
		Name:       opCreateDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDocumentOutput{}
	req.Data = output
	return
}

// Creates an SSM document.
//
// After you create an SSM document, you can use CreateAssociation to associate
// it with one or more running instances.
func (c *SSM) CreateDocument(input *CreateDocumentInput) (*CreateDocumentOutput, error) {
	req, out := c.CreateDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAssociation = "DeleteAssociation"

// DeleteAssociationRequest generates a request for the DeleteAssociation operation.
func (c *SSM) DeleteAssociationRequest(input *DeleteAssociationInput) (req *request.Request, output *DeleteAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAssociationOutput{}
	req.Data = output
	return
}

// Disassociates the specified SSM document from the specified instance.
//
// When you disassociate an SSM document from an instance, it does not change
// the configuration of the instance. To change the configuration state of an
// instance after you disassociate a document, you must create a new document
// with the desired configuration and associate it with the instance.
func (c *SSM) DeleteAssociation(input *DeleteAssociationInput) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDocument = "DeleteDocument"

// DeleteDocumentRequest generates a request for the DeleteDocument operation.
func (c *SSM) DeleteDocumentRequest(input *DeleteDocumentInput) (req *request.Request, output *DeleteDocumentOutput) {
	op := &request.Operation{
		Name:       opDeleteDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDocumentOutput{}
	req.Data = output
	return
}

// Deletes the SSM document and all instance associations to the document.
//
// Before you delete the SSM document, we recommend that you use DeleteAssociation
// to disassociate all instances that are associated with the document.
func (c *SSM) DeleteDocument(input *DeleteDocumentInput) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAssociation = "DescribeAssociation"

// DescribeAssociationRequest generates a request for the DescribeAssociation operation.
func (c *SSM) DescribeAssociationRequest(input *DescribeAssociationInput) (req *request.Request, output *DescribeAssociationOutput) {
	op := &request.Operation{
		Name:       opDescribeAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAssociationOutput{}
	req.Data = output
	return
}

// Describes the associations for the specified SSM document or instance.
func (c *SSM) DescribeAssociation(input *DescribeAssociationInput) (*DescribeAssociationOutput, error) {
	req, out := c.DescribeAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDocument = "DescribeDocument"

// DescribeDocumentRequest generates a request for the DescribeDocument operation.
func (c *SSM) DescribeDocumentRequest(input *DescribeDocumentInput) (req *request.Request, output *DescribeDocumentOutput) {
	op := &request.Operation{
		Name:       opDescribeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDocumentOutput{}
	req.Data = output
	return
}

// Describes the specified SSM document.
func (c *SSM) DescribeDocument(input *DescribeDocumentInput) (*DescribeDocumentOutput, error) {
	req, out := c.DescribeDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInstanceInformation = "DescribeInstanceInformation"

// DescribeInstanceInformationRequest generates a request for the DescribeInstanceInformation operation.
func (c *SSM) DescribeInstanceInformationRequest(input *DescribeInstanceInformationInput) (req *request.Request, output *DescribeInstanceInformationOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceInformationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInstanceInformationOutput{}
	req.Data = output
	return
}

// Describes one or more of your instances. You can use this to get information
// about instances like the operating system platform, the SSM agent version,
// status etc. If you specify one or more instance IDs, it returns information
// for those instances. If you do not specify instance IDs, it returns information
// for all your instances. If you specify an instance ID that is not valid or
// an instance that you do not own, you receive an error.
func (c *SSM) DescribeInstanceInformation(input *DescribeInstanceInformationInput) (*DescribeInstanceInformationOutput, error) {
	req, out := c.DescribeInstanceInformationRequest(input)
	err := req.Send()
	return out, err
}

const opGetDocument = "GetDocument"

// GetDocumentRequest generates a request for the GetDocument operation.
func (c *SSM) GetDocumentRequest(input *GetDocumentInput) (req *request.Request, output *GetDocumentOutput) {
	op := &request.Operation{
		Name:       opGetDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDocumentOutput{}
	req.Data = output
	return
}

// Gets the contents of the specified SSM document.
func (c *SSM) GetDocument(input *GetDocumentInput) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opListAssociations = "ListAssociations"

// ListAssociationsRequest generates a request for the ListAssociations operation.
func (c *SSM) ListAssociationsRequest(input *ListAssociationsInput) (req *request.Request, output *ListAssociationsOutput) {
	op := &request.Operation{
		Name:       opListAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAssociationsOutput{}
	req.Data = output
	return
}

// Lists the associations for the specified SSM document or instance.
func (c *SSM) ListAssociations(input *ListAssociationsInput) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SSM) ListAssociationsPages(input *ListAssociationsInput, fn func(p *ListAssociationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAssociationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAssociationsOutput), lastPage)
	})
}

const opListCommandInvocations = "ListCommandInvocations"

// ListCommandInvocationsRequest generates a request for the ListCommandInvocations operation.
func (c *SSM) ListCommandInvocationsRequest(input *ListCommandInvocationsInput) (req *request.Request, output *ListCommandInvocationsOutput) {
	op := &request.Operation{
		Name:       opListCommandInvocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandInvocationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListCommandInvocationsOutput{}
	req.Data = output
	return
}

// An invocation is copy of a command sent to a specific instance. A command
// can apply to one or more instances. A command invocation applies to one instance.
// For example, if a user executes SendCommand against three instances, then
// a command invocation is created for each requested instance ID. ListCommandInvocations
// provide status about command execution.
func (c *SSM) ListCommandInvocations(input *ListCommandInvocationsInput) (*ListCommandInvocationsOutput, error) {
	req, out := c.ListCommandInvocationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SSM) ListCommandInvocationsPages(input *ListCommandInvocationsInput, fn func(p *ListCommandInvocationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListCommandInvocationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListCommandInvocationsOutput), lastPage)
	})
}

const opListCommands = "ListCommands"

// ListCommandsRequest generates a request for the ListCommands operation.
func (c *SSM) ListCommandsRequest(input *ListCommandsInput) (req *request.Request, output *ListCommandsOutput) {
	op := &request.Operation{
		Name:       opListCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListCommandsOutput{}
	req.Data = output
	return
}

// Lists the commands requested by users of the AWS account.
func (c *SSM) ListCommands(input *ListCommandsInput) (*ListCommandsOutput, error) {
	req, out := c.ListCommandsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SSM) ListCommandsPages(input *ListCommandsInput, fn func(p *ListCommandsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListCommandsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListCommandsOutput), lastPage)
	})
}

const opListDocuments = "ListDocuments"

// ListDocumentsRequest generates a request for the ListDocuments operation.
func (c *SSM) ListDocumentsRequest(input *ListDocumentsInput) (req *request.Request, output *ListDocumentsOutput) {
	op := &request.Operation{
		Name:       opListDocuments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDocumentsOutput{}
	req.Data = output
	return
}

// Describes one or more of your SSM documents.
func (c *SSM) ListDocuments(input *ListDocumentsInput) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SSM) ListDocumentsPages(input *ListDocumentsInput, fn func(p *ListDocumentsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDocumentsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDocumentsOutput), lastPage)
	})
}

const opSendCommand = "SendCommand"

// SendCommandRequest generates a request for the SendCommand operation.
func (c *SSM) SendCommandRequest(input *SendCommandInput) (req *request.Request, output *SendCommandOutput) {
	op := &request.Operation{
		Name:       opSendCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendCommandInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendCommandOutput{}
	req.Data = output
	return
}

// Executes commands on one or more remote instances.
func (c *SSM) SendCommand(input *SendCommandInput) (*SendCommandOutput, error) {
	req, out := c.SendCommandRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAssociationStatus = "UpdateAssociationStatus"

// UpdateAssociationStatusRequest generates a request for the UpdateAssociationStatus operation.
func (c *SSM) UpdateAssociationStatusRequest(input *UpdateAssociationStatusInput) (req *request.Request, output *UpdateAssociationStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssociationStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAssociationStatusOutput{}
	req.Data = output
	return
}

// Updates the status of the SSM document associated with the specified instance.
func (c *SSM) UpdateAssociationStatus(input *UpdateAssociationStatusInput) (*UpdateAssociationStatusOutput, error) {
	req, out := c.UpdateAssociationStatusRequest(input)
	err := req.Send()
	return out, err
}

// Describes an association of an SSM document and an instance.
type Association struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The name of the SSM document.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Association) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Association) GoString() string {
	return s.String()
}

// Describes the parameters for a document.
type AssociationDescription struct {
	_ struct{} `type:"structure"`

	// The date when the association was made.
	Date *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The name of the SSM document.
	Name *string `type:"string"`

	// A description of the parameters for a document.
	Parameters map[string][]*string `type:"map"`

	// The association status.
	Status *AssociationStatus `type:"structure"`
}

// String returns the string representation
func (s AssociationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationDescription) GoString() string {
	return s.String()
}

// Describes a filter.
type AssociationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Key *string `locationName:"key" type:"string" required:"true" enum:"AssociationFilterKey"`

	// The filter value.
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationFilter) GoString() string {
	return s.String()
}

// Describes an association status.
type AssociationStatus struct {
	_ struct{} `type:"structure"`

	// A user-defined string.
	AdditionalInfo *string `type:"string"`

	// The date when the status changed.
	Date *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The reason for the status.
	Message *string `type:"string" required:"true"`

	// The status.
	Name *string `type:"string" required:"true" enum:"AssociationStatusName"`
}

// String returns the string representation
func (s AssociationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationStatus) GoString() string {
	return s.String()
}

type CancelCommandInput struct {
	_ struct{} `type:"structure"`

	// The ID of the command you want to cancel.
	CommandId *string `min:"36" type:"string" required:"true"`

	// (Optional) A list of instance IDs on which you want to cancel the command.
	// If not provided, the command is canceled on every instance on which it was
	// requested.
	InstanceIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s CancelCommandInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCommandInput) GoString() string {
	return s.String()
}

// Whether or not the command was successfully canceled. There is no guarantee
// that a request can be canceled.
type CancelCommandOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelCommandOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCommandOutput) GoString() string {
	return s.String()
}

// Describes a command request.
type Command struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this command.
	CommandId *string `min:"36" type:"string"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The name of the SSM document requested for execution.
	DocumentName *string `type:"string"`

	// If this time is reached and the command has not already started executing,
	// it will not execute. Calculated based on the ExpiresAfter user input provided
	// as part of the SendCommand API.
	ExpiresAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The instance IDs against which this command was requested.
	InstanceIds []*string `min:"1" type:"list"`

	// The S3 bucket where the responses to the command executions should be stored.
	// This was requested when issuing the command.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 directory path inside the bucket where the responses to the command
	// executions should be stored. This was requested when issuing the command.
	OutputS3KeyPrefix *string `type:"string"`

	// The parameter values to be inserted in the SSM document when executing the
	// command.
	Parameters map[string][]*string `type:"map"`

	// The date and time the command was requested.
	RequestedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of the command.
	Status *string `type:"string" enum:"CommandStatus"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Command) GoString() string {
	return s.String()
}

// Describes a command filter.
type CommandFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. For example, requested date and time.
	Key *string `locationName:"key" type:"string" required:"true" enum:"CommandFilterKey"`

	// The filter value. For example: June 30, 2015.
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CommandFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandFilter) GoString() string {
	return s.String()
}

// An invocation is copy of a command sent to a specific instance. A command
// can apply to one or more instances. A command invocation applies to one instance.
// For example, if a user executes SendCommand against three instances, then
// a command invocation is created for each requested instance ID. A command
// invocation returns status and detail information about a command you executed.
type CommandInvocation struct {
	_ struct{} `type:"structure"`

	// The command against which this invocation was requested.
	CommandId *string `min:"36" type:"string"`

	CommandPlugins []*CommandPlugin `type:"list"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The document name that was requested for execution.
	DocumentName *string `type:"string"`

	// The instance ID in which this invocation was requested.
	InstanceId *string `type:"string"`

	// The time and date the request was sent to this instance.
	RequestedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Whether or not the invocation succeeded, failed, or is pending.
	Status *string `type:"string" enum:"CommandInvocationStatus"`

	// Gets the trace output sent by the agent.
	TraceOutput *string `type:"string"`
}

// String returns the string representation
func (s CommandInvocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandInvocation) GoString() string {
	return s.String()
}

// Describes plugin details.
type CommandPlugin struct {
	_ struct{} `type:"structure"`

	// The name of the plugin. Must be one of the following: aws:updateAgent, aws:domainjoin,
	// aws:applications, aws:runPowerShellScript, aws:psmodule, aws:cloudWatch,
	// aws:runShellScript, or aws:updateSSMAgent.
	Name *string `min:"4" type:"string"`

	// Output of the plugin execution.
	Output *string `type:"string"`

	// The S3 bucket where the responses to the command executions should be stored.
	// This was requested when issuing the command.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 directory path inside the bucket where the responses to the command
	// executions should be stored. This was requested when issuing the command.
	OutputS3KeyPrefix *string `type:"string"`

	// A numeric response code generated after executing the plugin.
	ResponseCode *int64 `type:"integer"`

	// The time the plugin stopped executing. Could stop prematurely if, for example,
	// a cancel command was sent.
	ResponseFinishDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time the plugin started executing.
	ResponseStartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of this plugin. You can execute a document with multiple plugins.
	Status *string `type:"string" enum:"CommandPluginStatus"`
}

// String returns the string representation
func (s CommandPlugin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandPlugin) GoString() string {
	return s.String()
}

type CreateAssociationBatchInput struct {
	_ struct{} `type:"structure"`

	// One or more associations.
	Entries []*CreateAssociationBatchRequestEntry `locationNameList:"entries" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateAssociationBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchInput) GoString() string {
	return s.String()
}

type CreateAssociationBatchOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations that failed.
	Failed []*FailedCreateAssociation `locationNameList:"FailedCreateAssociationEntry" type:"list"`

	// Information about the associations that succeeded.
	Successful []*AssociationDescription `locationNameList:"AssociationDescription" type:"list"`
}

// String returns the string representation
func (s CreateAssociationBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchOutput) GoString() string {
	return s.String()
}

// Describes the association of an SSM document and an instance.
type CreateAssociationBatchRequestEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The name of the configuration document.
	Name *string `type:"string"`

	// A description of the parameters for a document.
	Parameters map[string][]*string `type:"map"`
}

// String returns the string representation
func (s CreateAssociationBatchRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchRequestEntry) GoString() string {
	return s.String()
}

type CreateAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Windows Server instance ID.
	InstanceId *string `type:"string" required:"true"`

	// The name of the SSM document.
	Name *string `type:"string" required:"true"`

	// The parameters for the documents runtime configuration.
	Parameters map[string][]*string `type:"map"`
}

// String returns the string representation
func (s CreateAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationInput) GoString() string {
	return s.String()
}

type CreateAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s CreateAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationOutput) GoString() string {
	return s.String()
}

type CreateDocumentInput struct {
	_ struct{} `type:"structure"`

	// A valid JSON string. For more information about the contents of this string,
	// see SSM Document (http://docs.aws.amazon.com/ssm/latest/APIReference/aws-ssm-document.html).
	Content *string `min:"1" type:"string" required:"true"`

	// A name for the SSM document.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentInput) GoString() string {
	return s.String()
}

type CreateDocumentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SSM document.
	DocumentDescription *DocumentDescription `type:"structure"`
}

// String returns the string representation
func (s CreateDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentOutput) GoString() string {
	return s.String()
}

type DeleteAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `type:"string" required:"true"`

	// The name of the SSM document.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssociationInput) GoString() string {
	return s.String()
}

type DeleteAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssociationOutput) GoString() string {
	return s.String()
}

type DeleteDocumentInput struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentInput) GoString() string {
	return s.String()
}

type DeleteDocumentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentOutput) GoString() string {
	return s.String()
}

type DescribeAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Windows Server instance ID.
	InstanceId *string `type:"string" required:"true"`

	// The name of the SSM document.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationInput) GoString() string {
	return s.String()
}

type DescribeAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationOutput) GoString() string {
	return s.String()
}

type DescribeDocumentInput struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentInput) GoString() string {
	return s.String()
}

type DescribeDocumentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SSM document.
	Document *DocumentDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentOutput) GoString() string {
	return s.String()
}

type DescribeInstanceInformationInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of instances.
	InstanceInformationFilterList []*InstanceInformationFilter `locationNameList:"InstanceInformationFilter" min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceInformationInput) GoString() string {
	return s.String()
}

type DescribeInstanceInformationOutput struct {
	_ struct{} `type:"structure"`

	// The instance information list.
	InstanceInformationList []*InstanceInformation `locationNameList:"InstanceInformation" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceInformationOutput) GoString() string {
	return s.String()
}

// Describes an SSM document.
type DocumentDescription struct {
	_ struct{} `type:"structure"`

	// The date when the SSM document was created.
	CreatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A description of the document.
	Description *string `type:"string"`

	// The name of the SSM document.
	Name *string `type:"string"`

	// A description of the parameters for a document.
	Parameters []*DocumentParameter `locationNameList:"DocumentParameter" type:"list"`

	// The list of OS platforms compatible with this SSM document.
	PlatformTypes []*string `locationNameList:"PlatformType" type:"list"`

	// The SHA1 hash of the document, which you can use for verification purposes.
	Sha1 *string `type:"string"`

	// The status of the SSM document.
	Status *string `type:"string" enum:"DocumentStatus"`
}

// String returns the string representation
func (s DocumentDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentDescription) GoString() string {
	return s.String()
}

// Describes a filter.
type DocumentFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Key *string `locationName:"key" type:"string" required:"true" enum:"DocumentFilterKey"`

	// The value of the filter.
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DocumentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentFilter) GoString() string {
	return s.String()
}

// Describes the name of an SSM document.
type DocumentIdentifier struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document.
	Name *string `type:"string"`

	// The operating system platform.
	PlatformTypes []*string `locationNameList:"PlatformType" type:"list"`
}

// String returns the string representation
func (s DocumentIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentIdentifier) GoString() string {
	return s.String()
}

type DocumentParameter struct {
	_ struct{} `type:"structure"`

	// If specified, the default values for the parameters. Parameters without a
	// default value are required. Parameters with a default value are optional.
	DefaultValue *string `type:"string"`

	// A description of what the parameter does, how to use it, the default value,
	// and whether or not the parameter is optional.
	Description *string `type:"string"`

	// The name of the parameter.
	Name *string `type:"string"`

	// The type of parameter. The type can be either “String” or “StringList”.
	Type *string `type:"string" enum:"DocumentParameterType"`
}

// String returns the string representation
func (s DocumentParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentParameter) GoString() string {
	return s.String()
}

// Describes a failed association.
type FailedCreateAssociation struct {
	_ struct{} `type:"structure"`

	// The association.
	Entry *CreateAssociationBatchRequestEntry `type:"structure"`

	// The source of the failure.
	Fault *string `type:"string" enum:"Fault"`

	// A description of the failure.
	Message *string `type:"string"`
}

// String returns the string representation
func (s FailedCreateAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedCreateAssociation) GoString() string {
	return s.String()
}

type GetDocumentInput struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentInput) GoString() string {
	return s.String()
}

type GetDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the SSM document.
	Content *string `min:"1" type:"string"`

	// The name of the SSM document.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GetDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentOutput) GoString() string {
	return s.String()
}

// Describes a filter for a specific list of instances.
type InstanceInformation struct {
	_ struct{} `type:"structure"`

	// The version of the SSM agent running on your instance.
	AgentVersion *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// Indicates whether latest version of the SSM agent is running on your instance.
	IsLatestVersion *bool `type:"boolean"`

	// The date and time when agent last pinged SSM service.
	LastPingDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Connection status of the SSM agent.
	PingStatus *string `type:"string" enum:"PingStatus"`

	// The name of the operating system platform running on your instance.
	PlatformName *string `type:"string"`

	// The operating system platform type.
	PlatformType *string `type:"string" enum:"PlatformType"`

	// The version of the OS platform running on your instance.
	PlatformVersion *string `type:"string"`
}

// String returns the string representation
func (s InstanceInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInformation) GoString() string {
	return s.String()
}

// Describes a filter for a specific list of instances.
type InstanceInformationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Key *string `locationName:"key" type:"string" required:"true" enum:"InstanceInformationFilterKey"`

	// The filter values.
	ValueSet []*string `locationName:"valueSet" locationNameList:"InstanceInformationFilterValue" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceInformationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInformationFilter) GoString() string {
	return s.String()
}

type ListAssociationsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	AssociationFilterList []*AssociationFilter `locationNameList:"AssociationFilter" min:"1" type:"list" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsInput) GoString() string {
	return s.String()
}

type ListAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The associations.
	Associations []*Association `locationNameList:"Association" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsOutput) GoString() string {
	return s.String()
}

type ListCommandInvocationsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The invocations for a specific command ID.
	CommandId *string `min:"36" type:"string"`

	// (Optional) If set this returns the response of the command executions and
	// any command output. By default this is set to False.
	Details *bool `type:"boolean"`

	// (Optional) One or more filters. Use a filter to return a more specific list
	// of results.
	Filters []*CommandFilter `min:"1" type:"list"`

	// (Optional) The command execution details for a specific instance ID.
	InstanceId *string `type:"string"`

	// (Optional) The maximum number of items to return for this call. The call
	// also returns a token that you can specify in a subsequent call to get the
	// next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandInvocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandInvocationsInput) GoString() string {
	return s.String()
}

type ListCommandInvocationsOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) A list of all invocations.
	CommandInvocations []*CommandInvocation `type:"list"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandInvocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandInvocationsOutput) GoString() string {
	return s.String()
}

type ListCommandsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) If provided, lists only the specified command.
	CommandId *string `min:"36" type:"string"`

	// (Optional) One or more filters. Use a filter to return a more specific list
	// of results.
	Filters []*CommandFilter `min:"1" type:"list"`

	// (Optional) Lists commands issued against this instance ID.
	InstanceId *string `type:"string"`

	// (Optional) The maximum number of items to return for this call. The call
	// also returns a token that you can specify in a subsequent call to get the
	// next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandsInput) GoString() string {
	return s.String()
}

type ListCommandsOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) The list of commands requested by the user.
	Commands []*Command `type:"list"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandsOutput) GoString() string {
	return s.String()
}

type ListDocumentsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	DocumentFilterList []*DocumentFilter `locationNameList:"DocumentFilter" min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentsInput) GoString() string {
	return s.String()
}

type ListDocumentsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the SSM documents.
	DocumentIdentifiers []*DocumentIdentifier `locationNameList:"DocumentIdentifier" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentsOutput) GoString() string {
	return s.String()
}

type SendCommandInput struct {
	_ struct{} `type:"structure"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// Required. The name of the SSM document to execute. This can be an SSM public
	// document or a custom document.
	DocumentName *string `type:"string" required:"true"`

	// Required. The instance IDs where the command should execute.
	InstanceIds []*string `min:"1" type:"list" required:"true"`

	// The name of the S3 bucket where command execution responses should be stored.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The directory structure within the S3 bucket where the responses should be
	// stored.
	OutputS3KeyPrefix *string `type:"string"`

	// The required and optional parameters specified in the SSM document being
	// executed.
	Parameters map[string][]*string `type:"map"`

	// If this time is reached and the command has not already started executing,
	// it will not execute.
	TimeoutSeconds *int64 `min:"30" type:"integer"`
}

// String returns the string representation
func (s SendCommandInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendCommandInput) GoString() string {
	return s.String()
}

type SendCommandOutput struct {
	_ struct{} `type:"structure"`

	// The request as it was received by SSM. Also provides the command ID which
	// can be used future references to this request.
	Command *Command `type:"structure"`
}

// String returns the string representation
func (s SendCommandOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendCommandOutput) GoString() string {
	return s.String()
}

type UpdateAssociationStatusInput struct {
	_ struct{} `type:"structure"`

	// The association status.
	AssociationStatus *AssociationStatus `type:"structure" required:"true"`

	// The ID of the instance.
	InstanceId *string `type:"string" required:"true"`

	// The name of the SSM document.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAssociationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssociationStatusInput) GoString() string {
	return s.String()
}

type UpdateAssociationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateAssociationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssociationStatusOutput) GoString() string {
	return s.String()
}

const (
	// @enum AssociationFilterKey
	AssociationFilterKeyInstanceId = "InstanceId"
	// @enum AssociationFilterKey
	AssociationFilterKeyName = "Name"
)

const (
	// @enum AssociationStatusName
	AssociationStatusNamePending = "Pending"
	// @enum AssociationStatusName
	AssociationStatusNameSuccess = "Success"
	// @enum AssociationStatusName
	AssociationStatusNameFailed = "Failed"
)

const (
	// @enum CommandFilterKey
	CommandFilterKeyInvokedAfter = "InvokedAfter"
	// @enum CommandFilterKey
	CommandFilterKeyInvokedBefore = "InvokedBefore"
	// @enum CommandFilterKey
	CommandFilterKeyStatus = "Status"
)

const (
	// @enum CommandInvocationStatus
	CommandInvocationStatusPending = "Pending"
	// @enum CommandInvocationStatus
	CommandInvocationStatusInProgress = "InProgress"
	// @enum CommandInvocationStatus
	CommandInvocationStatusCancelling = "Cancelling"
	// @enum CommandInvocationStatus
	CommandInvocationStatusSuccess = "Success"
	// @enum CommandInvocationStatus
	CommandInvocationStatusTimedOut = "TimedOut"
	// @enum CommandInvocationStatus
	CommandInvocationStatusCancelled = "Cancelled"
	// @enum CommandInvocationStatus
	CommandInvocationStatusFailed = "Failed"
)

const (
	// @enum CommandPluginStatus
	CommandPluginStatusPending = "Pending"
	// @enum CommandPluginStatus
	CommandPluginStatusInProgress = "InProgress"
	// @enum CommandPluginStatus
	CommandPluginStatusSuccess = "Success"
	// @enum CommandPluginStatus
	CommandPluginStatusTimedOut = "TimedOut"
	// @enum CommandPluginStatus
	CommandPluginStatusCancelled = "Cancelled"
	// @enum CommandPluginStatus
	CommandPluginStatusFailed = "Failed"
)

const (
	// @enum CommandStatus
	CommandStatusPending = "Pending"
	// @enum CommandStatus
	CommandStatusInProgress = "InProgress"
	// @enum CommandStatus
	CommandStatusCancelling = "Cancelling"
	// @enum CommandStatus
	CommandStatusSuccess = "Success"
	// @enum CommandStatus
	CommandStatusTimedOut = "TimedOut"
	// @enum CommandStatus
	CommandStatusCancelled = "Cancelled"
	// @enum CommandStatus
	CommandStatusFailed = "Failed"
)

const (
	// @enum DocumentFilterKey
	DocumentFilterKeyName = "Name"
	// @enum DocumentFilterKey
	DocumentFilterKeyOwner = "Owner"
	// @enum DocumentFilterKey
	DocumentFilterKeyPlatformTypes = "PlatformTypes"
)

const (
	// @enum DocumentParameterType
	DocumentParameterTypeString = "String"
	// @enum DocumentParameterType
	DocumentParameterTypeStringList = "StringList"
)

const (
	// @enum DocumentStatus
	DocumentStatusCreating = "Creating"
	// @enum DocumentStatus
	DocumentStatusActive = "Active"
	// @enum DocumentStatus
	DocumentStatusDeleting = "Deleting"
)

const (
	// @enum Fault
	FaultClient = "Client"
	// @enum Fault
	FaultServer = "Server"
	// @enum Fault
	FaultUnknown = "Unknown"
)

const (
	// @enum InstanceInformationFilterKey
	InstanceInformationFilterKeyInstanceIds = "InstanceIds"
	// @enum InstanceInformationFilterKey
	InstanceInformationFilterKeyAgentVersion = "AgentVersion"
	// @enum InstanceInformationFilterKey
	InstanceInformationFilterKeyPingStatus = "PingStatus"
	// @enum InstanceInformationFilterKey
	InstanceInformationFilterKeyPlatformTypes = "PlatformTypes"
)

const (
	// @enum PingStatus
	PingStatusOnline = "Online"
	// @enum PingStatus
	PingStatusConnectionLost = "ConnectionLost"
	// @enum PingStatus
	PingStatusInactive = "Inactive"
)

const (
	// @enum PlatformType
	PlatformTypeWindows = "Windows"
	// @enum PlatformType
	PlatformTypeLinux = "Linux"
)
