#! /usr/bin/env python
# based on Cristian L. Vlasceanu' example
 
import gnome.ui
import gtk
from gtk import glade
import os
from APTonCD.core import gui
 
title_text = "Installation Disc Creator Wizzard"
intro_text = "Welcome to the Installation Disc Creator (APTonCD) Wizzard\n\n\
This wizzard will guide you trough the steps necessaries to\n\
create your additional installation disc suitable for Debian\n\
based system"
 
final_text = "You are now ready to burn the CD.\n\
Click the Apply button to proceed."
 
 
class PageEvents(object):
	"""
	Helper class, handles common signal events from druid pages
	""" 
	def __init__(self, druidPage):
		druidPage.connect("cancel", self.__on_cancel)
		icon_theme = gtk.icon_theme_get_default()
		logo = icon_theme.load_icon('aptoncd', 64, 0)
		druidPage.set_logo(logo)

	def __on_cancel(self, page, druid):
		druid.quit()
 
 
class Wizard(gnome.ui.Druid):
	"""
	A design refinement: move the quit confirmation dialog
	here, so that we can invoke it when the user clicks the
	X button on the toplevel window decoration
	"""
	def __init__(self, app):
		gnome.ui.Druid.__init__(self)
		self.__app = app
 
	def quit(self):
		dlg = gtk.MessageDialog(None,	#parent
								0,		#flags
								gtk.MESSAGE_QUESTION, 
								gtk.BUTTONS_YES_NO,
								"Do you really want to cancel?")
		dlg.connect("response", self.__on_response)
		dlg.set_transient_for(self.get_toplevel())
		dlg.set_icon_name('aptoncd')
		dlg.run()
	
	def __on_response(self, dialog, response):
		dialog.hide()
		if response == gtk.RESPONSE_YES:
			gtk.main_quit()
 
class FileEntry(gtk.Frame):
	"""
	A custom widget for entering a file name
	"""
	def __init__(self, label = None):
		gtk.Frame.__init__(self, label)
		hbox = gtk.HBox()
		hbox.set_border_width(5)
		self.add(hbox)
		self.__entry = gtk.Entry()
		hbox.pack_start(self.__entry)
		btn = gtk.Button("Button")
		hbox.pack_end(btn, False)
 
class FirstPage(gnome.ui.DruidPageEdge):
	"""
	First druid page, displays an introductory message
	outlining the purpose of this application
	"""
	def __init__(self):
		"""
		Constructor, initialize the page as a start page
		"""
		gnome.ui.DruidPageEdge.__init__(self, gnome.ui.EDGE_START)
		self.__events = PageEvents(self)
		self.set_title(title_text)
		self.set_text(intro_text)
 
 		icon_theme = gtk.icon_theme_get_default()
		logo = icon_theme.load_icon('gtk-cdrom', 64, 0)
		self.set_watermark(logo)
		self.show_all() 
 
class FinalPage(gnome.ui.DruidPageEdge):
	def __init__(self):
		gnome.ui.DruidPageEdge.__init__(self, gnome.ui.EDGE_FINISH)
		self.__events = PageEvents(self)
		self.set_text(final_text)
		self.set_title("Congratulations")
		self.connect("finish", self.__on_apply)
		icon_theme = gtk.icon_theme_get_default()
		logo = icon_theme.load_icon('gtk-cdrom', 64, 0)
		self.set_watermark(logo)
		self.show_all()
 
	def __on_apply(self, page, druid):
		druid.set_show_finish(False)
		print "Closing..."
		gtk.main_quit()
		
		
class whatPage(gnome.ui.DruidPageStandard):
	def __init__(self):
		gnome.ui.DruidPageStandard.__init__(self)
		self.__events = PageEvents(self)
		self.set_title("What do you want to do?")
 
class VolumeOptionsPage(gnome.ui.DruidPageStandard):
	def __init__(self):
		gnome.ui.DruidPageStandard.__init__(self)
		self.__events = PageEvents(self)
		self.set_title("Page 2")
 
class WizardApp(gtk.Window):
	"""
	The main window of our application
	"""
	def __init__(self):
		gtk.Window.__init__(self, "toplevel")
		self.set_position(gtk.WIN_POS_CENTER)
		self.set_title("APTonCD Wizzard")
		self.set_icon_name('aptoncd')
		self.set_size_request(550,400)
		self.connect("delete_event", self.__on_delete)
		self.__firstPage = FirstPage()
		self.__finalPage = FinalPage()
		self.__optionsPage = VolumeOptionsPage()
		self.__pagewhat = whatPage()
		self.__druid = Wizard(self)
		self.__druid.append_page(self.__firstPage)
		self.__druid.append_page(self.__pagewhat)		
		self.__druid.append_page(self.__optionsPage)
		self.__druid.append_page(self.__finalPage)
		self.add(self.__druid)
 
	def __on_delete(self, app, event):
		self.__druid.quit()
		return True
 
if __name__ == "__main__":
	app = WizardApp()
	app.show_all()
	gtk.main()
