# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################
import gtk
import re
import os
import datetime
import gobject

from APTonCD.core import *
from APTonCD.core import gui 
from APTonCD.core import constants
import APTonCD.core.utils
from APTonCD.core.utils import get_icon
from APTonCD.widgets import *

WINDOW_NAME = 'dlgRestoreFrom'

class RestoreFrom(controller.IController):
	"""
		This class will handle cd properties for APTonCD media creation.
	"""
	def __init__(self, controller = None, drive_list = []):
		"""
			Constructor
		"""
		self.controller = controller
		self.drivers = drive_list
		self.glade = gui.get_glade(constants.RESTORE_GUI, WINDOW_NAME)
	
		#Main widget
		self.window = gui.get_widget(self.glade, WINDOW_NAME)
		self.window.set_icon_name(constants.APP_ICON_NAME)
		
		self.cmbLocation = gui.get_widget(self.glade, 'cboMountedDevices')
		self.optMedia = gui.get_widget(self.glade, 'optMedia')
		self.optIso = gui.get_widget(self.glade, 'optIso')
		self.filechooserIsoImage = gui.get_widget(self.glade, 'filechooserIsoImage')
		
		#set filter to allow iso file only
		filter = gtk.FileFilter()
		#TODO: make a constant string for this file title 
		filter.set_name(constants.MESSAGE_0068) 
		filter.add_mime_type('application/x-cd-image')
		filter.add_pattern("*.iso")
		self.filechooserIsoImage.add_filter(filter)
		self.filechooserIsoImage.set_action(gtk.FILE_CHOOSER_ACTION_OPEN)
  		
		
		if self.controller:
			self.window.set_transient_for(self.controller.get_main_window())
			self.window.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
				# connect signals
		self.load_media()
		
		self.connect_signals()
		self.optMedia.set_active(True)
		if len(self.cmbLocation.get_model()) <= 0:
			self.optMedia.set_sensitive(False)
			self.optIso.set_active(True)
		else:	
			self.filechooserIsoImage.set_sensitive(False)
			self.cmbLocation.set_active_iter(self.cmbLocation.get_model().get_iter_first())
	
		self.window.set_modal(True)

	def run(self):
		result = self.window.run()
		if result == gtk.RESPONSE_OK:
			if self.optMedia.get_active():
				model = self.cmbLocation.get_model()
				return True, constants.RESTORE_TYPE.RESTORE_FROM_MEDIA, model[self.cmbLocation.get_active_iter()][1]
			else:
				if len(self.filechooserIsoImage.get_filenames()) > 0:
					return True, constants.RESTORE_TYPE.RESTORE_FROM_ISO, self.filechooserIsoImage.get_filenames()[0]
				else:
					return True, constants.RESTORE_TYPE.RESTORE_FROM_NONE, None
		else:
			return False, constants.RESTORE_TYPE.RESTORE_FROM_NONE, None

	def destroy(self):
		self.window.destroy()

	def get_main_window(self):
		"""
			implements IController interface method.
			for access the class windows object.
		"""
		if self.controller:
			return self.controller.get_main_window()
		else:
			return self.window

	def get_parent_widget(self):
		"""
			implements IController interface method.
			for container widget
		"""
		if self.controller:
			self.controller.get_parent_widget()
		else:
			return self.window.get_children()[0]

	def connect_signals(self):
		"""
			This procedure will connect widgets to its signal handler.
		"""
		#gui.connect(self.cmbLocation, 'selection_changed', self.on_cmbLocation_change)
		gui.connect(self.optIso, 'toggled', self.on_option_toggle)
		gui.connect(self.optMedia, 'toggled', self.on_option_toggle)
		
	def on_option_toggle(self, widget):
		if widget == self.optMedia:
			self.cmbLocation.set_sensitive(True)
			self.filechooserIsoImage.set_sensitive(False)
		else:
			self.cmbLocation.set_sensitive(False)
			self.filechooserIsoImage.set_sensitive(True)
			
	def load_media(self):
		self.cmbLocation.set_model(gtk.ListStore(*[gobject.TYPE_STRING] * 3))
		model = self.cmbLocation.get_model()
		cell = gtk.CellRendererText()
		self.cmbLocation.pack_start(cell, True)
		self.cmbLocation.add_attribute(cell, 'text', 0)
		
		for n in self.drivers:
			model.append(n)
