#!/usr/bin/env python
# -*- coding: utf-8 -*-
# msg.py
#  
#  Author: Laudeci Oliveira <laudeci@gmail.com>
#          Rafael Proença   <cypherbios@ubuntu.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

import gettext
import config
import locale
import gtk
import gtk.glade

#config.init(config.CONFIG_FILE)

locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain(config.I18N_APP, config.I18N_DIR)
gettext.textdomain(config.I18N_APP)

_ = gettext.gettext

gtk.glade.bindtextdomain(config.I18N_APP, config.I18N_DIR)
gtk.glade.textdomain(config.I18N_APP)
gettext.install(config.I18N_APP, config.I18N_DIR, unicode=1)

# CreateAptOncd.py
MESSAGE_0001 =    _("Selecting Packages")
MESSAGE_0002 =    _("Building list of packages")
MESSAGE_0003 =    _("Reading all packages from your cache, this could take\na long time, depending on number and size of packages.")

MESSAGE_0004 =    _('Package')
MESSAGE_0005 =    _("The package %s already is in the list.")
MESSAGE_0006 =    _("Select Package")
MESSAGE_0007 =    _("Debian Packages")
MESSAGE_0009 =    _("Check All")
MESSAGE_0010 =    _("Uncheck All")
MESSAGE_0011 =    _("Remove from list")
MESSAGE_0012 =    _("Invert Selections")
MESSAGE_0013 =    _("Creating APTonCD...")
MESSAGE_0014 =    _("Copying packages. This operation may take a long\ntime, depending on number and size of packages.")
MESSAGE_0015 =    _("The destination directory is not writable.\nPlease, select another destination directory and try again.")

MESSAGE_0016 =    _("Process canceled")
MESSAGE_0017 =    _("Processing file %s")
MESSAGE_0018 =    _("<b><i>The metapackage could not be created.</i></b>")
MESSAGE_0019 =    _("Scanning and cataloguing packages...")
MESSAGE_0020 =    _("Making the iso image...")
MESSAGE_0021 =    _("Cleaning session...")
MESSAGE_0022 =    _("The image was successfully created, and it can be found in %s.\n%s")
MESSAGE_0023 =    _("The image was successfully created, and it can be found in \n%s \n\nDo you want burn it now?")
MESSAGE_0024 =    _("The name '%s' is not supported as the .iso filename because it contains invalid characters.\nPlease use a different name with letters, numbers, or '+','-','_', '.' characters.")

# aptoncd.py
MESSAGE_0025 =    _("Insert an APTonCD media into the CD/DVD drive and click OK button when the media already mounted, or click on cancel button to abort.")

MESSAGE_0026 =    _("The CD/DVD has no data.\nInsert an APTonCD into the drive.")
MESSAGE_0027 =    _("Insert an APTonCD media into the CD/DVD drive and click OK button when ready, or click on cancel button to abort.")

MESSAGE_0028 =    _("The CD/DVD is empty or it isn't a valid APTonCD medium. \nInsert an APTonCD medium into the drive.")
MESSAGE_0029 =    _("Select an APTonCD .iso image")
MESSAGE_0030 =    _("Iso Image")
MESSAGE_0031 =    _("The selected file isn't a valid ISO file or doesn't exist.")
MESSAGE_0032 =    _("APTonCD couldn't read %s packages.\n"
	               	"The medium is probably corrupted.\n"
                	"These packages will be listed but not marked to copy.\n"
                	"You can try to copy these packages manually later.")

MESSAGE_0033 =    _("APTonCD couldn't read %s package.\n"
			"This package will be listed but not marked to copy.\n"
			"You can try to copy this package manually later.\n")

MESSAGE_0034 =    _("Reading Packages...")
MESSAGE_0035 =    _("Reading all packages from your medium, this could take\na long time, depending on number and size of packages.")

MESSAGE_0036 =    _("Check All")
MESSAGE_0037 =    _("Uncheck All")
MESSAGE_0038 =    _("Remove Package")
MESSAGE_0039 =    _("Invert check")
MESSAGE_0040 =    _("You have not permission to write in the apt cache directory.\nPlease run APTonCD with sudo or root privileges.")

MESSAGE_0041 =    _("Restoring APTonCD...")
MESSAGE_0042 =    _("Some files couldn't be sucessfully restored")
MESSAGE_0043 =    _("The files were sucessfully restored to your cache.\n Now future APTonCD media will contain these packages too.")

MESSAGE_0044 =    _("Copying file ")
MESSAGE_0045 =    _("Checking packages' versions")

#metaPackage.py
MESSAGE_0046 =    _('Version: %s')
MESSAGE_0047 =    _('File Size: %s')
MESSAGE_0048 =    _("Package:   ")
MESSAGE_0049 =    _("Summary: ")
MESSAGE_0050 =    _("Error loading package info")
MESSAGE_0051 =    _("READ ERROR")

#ProgressWindow.py
MESSAGE_0052 =    _("Processing...")
MESSAGE_0053 =    _('This process could take a long time.')
MESSAGE_0054 =    _('Please wait...')
MESSAGE_0055 =    _("remaining %i of %i")

MESSAGE_0056 =    _("Scanning %s repository")
MESSAGE_0057 =    _("Wait while APTonCD gets the package list")
MESSAGE_0058 =    _("This operation may take a long time depending \non your internet connection speed.")
MESSAGE_0059 =    _("Fetching list of packages...")

# RepDownload.py
MESSAGE_0060 =    _("Package")
MESSAGE_0061 =    _("Size")
MESSAGE_0062 =    _("Progress")
MESSAGE_0063 =    _("Downloading the Packages.gz for %s section...")
MESSAGE_0064 =    _("Building Repository")
MESSAGE_0065 =    _("The removable repository is being created, this operation may take a long time depending on the size of the repository(ies).")
MESSAGE_0066 =    _("the packages are being split up to fit the media")

MESSAGE_0067 =	  _("Download aborted.")

MESSAGE_0068 =	  _('The removable repository has been created sucessfully.\nNow you can burn these media with a program of your choice, you can find them at:\n\n<b>%s</b>\n\nAfter they are burnt, you can add these media as sources (repositories) for apt-get, aptitude and synaptic by choosing "Add CD/DVD" on the Restore menu.\n\nCheck the box below to remove the temporary files (downloaded packages).\n')

MESSAGE_0069 =	  _('You must select at least one package')