/* main.c
 * Copyright (C) 2002-2004 Pascal Eberhard <pascal.ebo@netcourrier.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "common.h"
#include "launcher.h"
#include <string.h>
#include <stdio.h>

int main(int argc, char **argv)
{
  launcher_t *launcher;
  apwalapp_t *apwal;

  gtk_init(&argc, &argv);

  if (!xmlrc_resource_file_exist())
  {
    xmlrc_resource_file_create();
    apwal = apwalapp_new();
  } else if (strstr(argv[0], "apwal-editor") != NULL)
  {
    apwal = apwalapp_new();
  }
  else if ((argc >= 2) && (strstr(argv[1], "--edit") != NULL ))
  {
    apwal = apwalapp_new();
  }
  else if (argc >= 2)
  {
    fprintf(stderr, "usage: %s [--edit]\n", argv[0]);
    exit(1);
  }
  else
  {
    launcher = launcher_new();
  }
  gtk_main();
  return 0;
}

