/***************************************************************************
 $RCSfile: mkpinlist.cpp,v $
                             -------------------
    cvs         : $Id: mkpinlist.cpp,v 1.2 2003/06/13 22:41:20 aquamaniac Exp $
    begin       : Thu Feb 20 2003
    copyright   : (C) 2003 by Fabian Kaiser
    email       : openhbci@derzach.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



/*
 */

#include "mkpinlist.h"


HBCI::Error mkPinList(HBCI::Pointer<AQMAPI> hbciif,
		      HBCI::SimpleConfig &opt){
  HBCI::Pointer<HBCI::OutboxJob> job;
  HBCI::Tree<HBCI::ConfigNode>::iterator var;
  HBCI::Error err;
  list<HBCI::Pointer<HBCI::User> >::const_iterator uit;
  list<HBCI::Pointer<HBCI::Bank > >::const_iterator bit;

  fprintf(stdout, "PINLIST\n");

  for (bit=hbciif.ref().banks().begin();
       bit!=hbciif.ref().banks().end();
       bit++) {
    for (uit=(*bit).ref().users().begin();
	 uit!=(*bit).ref().users().end();
	 uit++) {
      HBCI::Pointer<HBCI::Medium> m;

      m=(*uit).ref().medium();
      if (m.isValid()) {
	if ((*bit).ref().name().empty()) {
	  fprintf(stdout,"# Pin for user \"%s\" at \"%s\"\n",
		  (*uit).ref().userId().c_str(),
		  (*bit).ref().bankCode().c_str());
	}
	else {
	  fprintf(stdout,"# Pin for user \"%s\" at \"%s\"\n",
		  (*uit).ref().userId().c_str(),
		  (*bit).ref().name().c_str());
	}
	fprintf(stdout,"%s=\n",
		m.ref().mediumName().c_str());
      }
    } /* for users */
  } /* for banks */

  fprintf(stdout, "\n");

  return HBCI::Error();
}


