/***************************************************************************
 $RCSfile: setproperty.cpp,v $
                             -------------------
    cvs         : $Id: setproperty.cpp,v 1.1 2003/06/24 16:12:22 aquamaniac Exp $
    begin       : Sun Mar 30 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#include "setproperty.h"


HBCI::Error setProperty(HBCI::Pointer<AQMAPI> hbciif,
			HBCI::SimpleConfig &opt){
  int country;
  string instid;
  string custid;
  string pname;
  string pvalue;
  HBCI::Error err;
  list<HBCI::Pointer<HBCI::Customer> > custs;
  list<HBCI::Pointer<HBCI::Customer> >::iterator it;

  country=opt.getIntVariable("country",280,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  custid=opt.getVariable("customer","*",opt.root());
  pname=opt.getVariable("pname","",opt.root());
  pvalue=opt.getVariable("pvalue","",opt.root());

  if (pname.empty()) {
    return HBCI::Error("setProperty",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "no property name given");
  }

  try {
    custs=hbciif.ref().getCustomers(country,
				    instid,
				    custid);
    if (custs.empty())
      return HBCI::Error("setProperty",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "customer(s) not found");

    // create job for all matching customers
    for (it=custs.begin();
	 it!=custs.end();
	 it++) {
      HBCI::Pointer<HBCI::User> user;
      HBCI::Pointer<HBCI::Bank> bank;
      HBCI::Pointer<HBCI::Medium> medium;
      string n;

      user=(*it).ref().user();
      bank=user.ref().bank();
      n=bank.ref().name();
      if (n.empty())
	n=bank.ref().bankCode();
      medium=user.ref().medium();

      if (!medium.isValid()) {
	fprintf(stderr,
		"Bank: %s  Benutzer: %s\n"
		"  Benutzer hat kein Medium, ignoriere ihn\n",
		n.c_str(),
		user.ref().userId().c_str());
      }
      else {
	fprintf(stdout,
		"Bank: %s  Benutzer: %s\n"
		" Setze \"%s\" auf \"%s\"\n",
		n.c_str(),
		user.ref().userId().c_str(),
		pname.c_str(),
		pvalue.c_str());
	err=medium.ref().setProperty(pname, pvalue);
	if (!err.isOk()) {
	  return Error("setProperty", err);
	}
      }
    } // for
  }
  catch (HBCI::Error lerr) {
    err=lerr;
  }
  return err;
}





