(* AST *)
(* $Id: ast.ml,v 1.2 2003/06/10 21:24:38 berke Exp $ *)

type ident = string


type 'a boolean =
| And of 'a boolean * 'a boolean
| Or of 'a boolean * 'a boolean
| Not of 'a boolean
| True
| False
| Atom of 'a

type regexp_option =
| Case_insensitive
| Word_boundary

let string_of_regexp_option = function
| Case_insensitive -> "Case_insensitive"
| Word_boundary -> "Word_boundary"

type quantified =
| Matches of field * pattern
and pattern =
| Exact of string
| Lexicographic_le of string
| Lexicographic_ge of string
| Regular of string * regexp_option list
and field = Some_field of pattern | This_field of string

let rec dump_quantified f = function
| Matches(fd,pat) ->
    Format.fprintf f "Matches(@[";
    dump_field f fd;
    Format.fprintf f ",@,";
    dump_pattern f pat;
    Format.fprintf f "@])"
and dump_quantified_boolean f = function
| And(qb1,qb2) -> 
    Format.fprintf f "And(@[";
    dump_quantified_boolean f qb1;
    Format.fprintf f ",@,";
    dump_quantified_boolean f qb2;
    Format.fprintf f "@])"
| Or(qb1,qb2) -> 
    Format.fprintf f "Or(@[";
    dump_quantified_boolean f qb1;
    Format.fprintf f ",@,";
    dump_quantified_boolean f qb2;
    Format.fprintf f "@])"
| Not(qb) -> 
    Format.fprintf f "Not(@[";
    dump_quantified_boolean f qb;
    Format.fprintf f "@])"
| Atom(q) ->
    Format.fprintf f "Atom(@[";
    dump_quantified f q;
    Format.fprintf f "@])"
| True -> Format.fprintf f "True"
| False -> Format.fprintf f "False"
and dump_field f = function
| Some_field(pat) -> Format.fprintf f "Some_field(@["; dump_pattern f pat; Format.fprintf f "@])"
| This_field(x) -> Format.fprintf f "Some_field(%S)" x
and dump_pattern f = function
| Exact(x) -> Format.fprintf f "Exact(%S)" x
| Lexicographic_le(x) -> Format.fprintf f "Lexicographic_le(%S)" x
| Lexicographic_ge(x) -> Format.fprintf f "Lexicographic_ge(%S)" x
| Regular(x,y) -> Format.fprintf f "Regular(%S,[%s])" x
    (String.concat ";" (List.map string_of_regexp_option y))

let dump = dump_quantified_boolean
