(* Dpkg *)
(* $Id: dpkg.ml,v 1.3 2003/08/13 21:55:43 berke Exp $ *)
(* Thanks to Jeremy Shaw for sending a patch fixing the empty-line problem *)

module SM = Map.Make(String)
module IM = Map.Make(struct type t = int let compare = compare end)
module IS = Set.Make(struct type t = int let compare = compare end)

type db = {
  m : int;
  db : string SM.t array;
  index : int SM.t;
  universe : IS.t
}

exception Malformed_line of string

let decompose_line l =
  try
    let i = String.index l ':' in
    let tag = String.sub l 0 i
    and value =
      if i + 1 = String.length l then
        ""
      else
        String.sub l (i + 2) (String.length l - i - 2)
    in
      (tag,value)
  with
  Not_found -> raise (Malformed_line l)

let read_tags ic =
  let b = Buffer.create 16 in
  let f sm = function
    | None -> sm
    | Some(x') ->
       let sm' = SM.add x' (Buffer.contents b) sm in
       Buffer.clear b;
       sm'
  in
  let rec loop sm x =
   match try Some(input_line ic) with End_of_file -> None
   with
   | None -> sm
   | Some(l) ->
       if String.length l = 0 then
         f sm x
       else
         match l.[0] with
         | (' '|'\t') ->
             if l = " ." then
               Buffer.add_string b " "
             else
               Buffer.add_string b l;
             loop sm x
         | _ ->
             let sm = f sm x in
             let (x,y) = decompose_line l in
             Buffer.add_string b y;
             loop sm (Some x)
   in
   loop SM.empty None

let load fn =
  let ic = open_in fn in
  let rec loop db m =
    let sm = read_tags ic in
    if SM.empty = sm then
      begin
        close_in ic;
        let universe = 
          let rec loop i u =
            if i = m then
              u
            else
              loop (i + 1) (IS.add i u)
          in
          loop 0 IS.empty
        in
        let rec index i idx = function
        | [] -> idx
        | x::y ->
            let idx' =
              try
                SM.add (SM.find "Package" x) i idx
              with
              Not_found -> idx
            in
            index (i + 1) idx' y
        in
        let idx = index 0 SM.empty db in
        { m = m;
          db = Array.of_list db;
          index = idx;
          universe = universe }
      end
    else
      loop (sm::db) (m + 1)
  in
  loop [] 0
