(* Opt *)
(* $Id: opt.ml,v 1.8 2003/06/10 21:24:38 berke Exp $ *)

type style = Bourbaki | List | Raw | Table
and fields = All | These of (string * int option) list

let dbfn = ref "/var/lib/dpkg/available"
let ast = ref false
let interactive = ref false
let terse = ref false
let borders = ref false
let style = ref Bourbaki
let fields = ref (These["Package",Some 20;"Version",Some 10;"Description",Some 50])
let queries : (style * fields * string) list ref = ref []
let specs = [
  (*** Examples *)
  "-examples",Arg.Unit(fun () ->
    print_string
"This is ara, a utility to search the Debian (a Linux distribution)
package database using boolean combinations of regular expressions
operating on fields of the description.

ara is written in Ocaml, the finest computer programming language
on the surface of the earth. See http://caml.inria.fr/ for details.

See the manual page for details.

EXAMPLES
        
ara -list 'Section=utils'
     List the name of every package in section utils.

ara -list 'Section=utils & !Depends=~/gnome\\|kde\\|gtk/'
     ... except those whose dependency field matches the regexp
     gnome\\|kde\\|gtk.

ara -set 'Section=utils & !Depends=~/gtk\\|gnome\\|kde/ &
Priority=optional'
     ... list multiple names per line, and show only optional
     packages.

ara -set 'Section=utils & !Depends=~/gtk\\|gnome\\|kde/ &
Priority=optional & Size<100000'
     ... exclude packages greater than 99999 bytes.

ara -set 'Section=utils & (!Depends=~/gtk\\|gnome\\|kde/ |
Size<100000) & Priority=optional'
   ... well, exclude gtk,gnome or kde stuff only if 100000 bytes
   or greater.
   
ara -fields Package,Size,Maintainer:20 -table 'Section=utils &
(!Depends=~/gtk\\|gnome\\|kde/ | Size<100000) & Priority=optional'
   ... show Package, Size and Maintainer fields from the above
   results as a nice ascii table, limiting the maintainer field
   to 20 characters.

ara -fields Package:8,Size,Description:100 -table 'Section=games &
!(Depends=~/gtk\\|sdl\\|kde\\|opengl\\|gnome/ |
Description=~/shoot\\|kill\\|destroy\\|blast\\|race\\|bomb/iw |
Description=~/multi\\(-\\|\\)player\\|strategy\\|conquest\\|3\\(-\\|\\)d/iw) &
Depends=~/xlibs\\|vga/ & !Size>1000000'
   Assuming a 125-column display, display the first eight characters
   of the package name, the size in bytes, and the first hundred characters of
   the description of all packages in the games section not exceeding one
   million bytes, not depending on fancy stuff like gtk,SDL,KDE,OpenGL
   or Gnome, not mentioning some forms of violence (to shoot, to kill,
   etc.) in its description, not described as multi-player,
   strategy, conquest or three-dimensional games, yet depending
   on either xlibs or svga to exclude console-based games.

SPEED

ara reads the whole database into memory and then processes
queries. Since the database is usually big, this takes some
time. However, queries then run quite fast. So : specify
multiple queries or use the -interactive option to amortize
the cost of reading the database.

REMARKS
   
The database lives, by default, as a text file under the path
/var/lib/dpkg/available on your Debian installation. It lists
all packages, installed or not, that are known to your Debian
package management system.

Searching this file using grep usually gives bad results. This
utility has been written out of the frustration of not being able
to do satisfactory searches using standard text processing tools.\n";
    exit 0),
  ": Display some documentation including examples and exit.";
  (* Examples ***)

  "-version",Arg.Unit(fun () ->
    print_string "ara version 0.3 released 2003-05-01 under the GNU GPL by Berke Durak.\n"; exit 0),
  ": Print version and exit.";

  "-db",Arg.String((:=) dbfn),
  "<path> : Set package database file (default /var/lib/dpkg/available).";

  "-set",Arg.String(fun x -> queries := (Bourbaki,!fields,x)::!queries),
  "<query> : Display names of packages satisfying query between a pair of
curly braces.";

  "-list",Arg.String(fun x -> queries := (List,!fields,x)::!queries),
  "<query> : Same, but display one package name per line, and no curly braces (default).";

  "-raw",Arg.String(fun x -> queries := (Raw,!fields,x)::!queries),
  "<query> : For each package satisfying the query, display all selected fields.";

  "-table",Arg.String(fun x -> queries := (Table,!fields,x)::!queries),
  "<query> : Display results as a table.";

  "-fields",Arg.String(fun x ->
    fields :=
      if x = "*" then
        All
      else
        These(List.map
          (fun w ->
            try
              let i = String.index w ':' in
              if i + 1 = String.length w then
                raise (Arg.Bad "width specifier invalid")
              else
                let n =
                  try
                    int_of_string
                      (String.sub w (i + 1)
                        (String.length w - i - 1))
                  with
                  _ -> raise (Arg.Bad "width specifier invalid")
                in
                (String.sub w 0 i,Some n)
            with
            Not_found -> (w,None)) (Utils.split_at ',' x))),
  "<field_1[:width_1],...,field_n[:width_n]> <query> : Limit output
to specified fields for the -table and -raw options.  The optional
width specifiers are used with the -table option, ignored otherwise.
Use * to display all fields (but remember to escape the star character
from your shell).";

  "-borders",Arg.Set(borders),
  ": Draw ASCII borders for tabular output.";

  "-ast",Arg.Set(ast),
  ": Dump the abstract syntax tree of parsed queries to stderr.";

  "-interactive",Arg.Set(interactive),
  ": Interactive mode ; prompt for a query, display it ; best used with a line
editor such as ledit."
]
