/*
	OpenGL dynamic loader

	(C) 2006 Patrice Mandin

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include "SDL_compat.h"
#include "SDL_opengl_wrapper.h"

#include "dyngl.h"

#ifdef __cplusplus
extern "C" {
#endif

/*--- Global variables ---*/

dyngl_funcs gl;

/*--- Functions ---*/

int dyngl_load(char *filename)
{
	int lib_loaded = 0;
	
#ifndef OS_darwin
	if (strlen(filename)>1) {
		if (SDL_GL_LoadLibrary(filename)<0) {
			fprintf(stderr, "Can not load OpenGL library from <%s>\n", filename);
		} else {
			lib_loaded = 1;
		}
	}
#else
	/* Just to make the compiler not complain about an unused filename parameter. */
	filename = filename;
#endif

	if (!lib_loaded) {
		/* Try to load default */
		if (SDL_GL_LoadLibrary(NULL)<0) {
			fprintf(stderr, "Can not load default OpenGL library\n");
			return 0;
		}
		fprintf(stderr, "Loaded default OpenGL library\n");
	}

#define GL_PROC(type, gl, name, export, upper, params, first, ret) gl.name = SDL_GL_GetProcAddress(#gl #name);
#define GLU_PROC(type, gl, name, export, upper, params, first, ret)
#include "../../atari/nfosmesa/glfuncs.h"

	return 1;
}

#ifdef __cplusplus
}
#endif
