# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::MainWindow::Archive;

use Glib qw(TRUE FALSE);
use Gtk2;

use base qw(ArchWay::MainWindow::Base ArchWay::MainWindow::RevisionBase);

use ArchWay::Widget::Abrowse;

sub init ($) {
	my $self = shift;

	$self->SUPER::init;
	$self->add_revision_actions;

	# menus (name, stock id, label)
	my @menus = (
		[ "RevisionMenu", undef, "_Revision" ],
	);

	# menu/toolbar layout
	my $layout = <<_EOF_;
<ui>
	<menubar name="MenuBar">
		<placeholder name="ApplicationMenus">
			<menu action="RevisionMenu">
				<menuitem action="GetTree" />
				<menuitem action="GetCSet" />
				<menuitem action="ViewCSet" />
				<menuitem action="ViewLog" />
			</menu>
		</placeholder>
	</menubar>

	<toolbar name="ToolBar">
		<toolitem action="GetTree" />
		<toolitem action="GetCSet" />
		<toolitem action="ViewCSet" />
		<toolitem action="ViewLog" />
	</toolbar>
</ui>
_EOF_

	# add menu/toolbar to ui
	my $actions = Gtk2::ActionGroup->new('ArchiveActions');
	$actions->add_actions(\@menus, undef);

	$self->ui->insert_action_group($actions, 0);
	$self->ui->add_ui_from_string($layout);

	# init ui
	$self->set_default_size(600, 500);
	$self->tree_view->show($self->limit);
}

sub main_widget ($) {
	my $self = shift;

	if (! exists $self->{main_widget}) {
		my $scwin_tv = Gtk2::ScrolledWindow->new();
		$scwin_tv->set_policy('automatic', 'automatic');
		$scwin_tv->add($self->tree_view());

		my $scwin_fv = Gtk2::ScrolledWindow->new();
		$scwin_fv->set_policy('automatic', 'automatic');
		$scwin_fv->add($self->revisions_view());

		my $vpaned = Gtk2::VPaned->new();
		$vpaned->pack1($scwin_tv, TRUE, TRUE);
		$vpaned->pack2($scwin_fv, TRUE, TRUE);

		$self->{main_widget} = $vpaned;
	}

	return $self->{main_widget};
}

sub tree_view {
	my $self = shift;

	if (! exists $self->{tree_view}) {
		my $tv = ArchWay::Widget::Abrowse->new;

		$tv->get_selection->signal_connect(
			changed => sub { $self->update_content_view }
		);

		$self->{tree_view} = $tv;
	}

	return $self->{tree_view};
}

sub limit ($) {
	my $self = shift;

	return $self->{limit};
}

sub update_content_view ($) {
	my $self = shift;

	my $session = $self->arch;
	$session->working_name($self->tree_view->get_selected_path || '');

	$self->revisions_view->clear;

	if (defined (($session->working_names)[3])) {
		my $revisions = $session->revision_details;
		$self->revisions_view->add_revisions(
			$revisions,
			version => $session->working_name
		);

	} else {
		my $tv = $self->tree_view;
		
		my $iter = $tv->get_selection->get_selected;
		if (defined $iter) {
			$tv->expand_row($tv->get_model->get_path($iter), FALSE);
			$self->set_status('Browsing: ' . $session->working_name);
		} else {
			$self->set_status('');
		}
	}
}

sub set_archive ($$) {
	my $self = shift;
	my $archive = shift;
	$self->set_status("Browsing: $archive");
	$self->tree_view->show($archive);
}

1;

__END__
