# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::MainWindow::Graph;

use base 'ArchWay::MainWindow::Base';

use Glib qw(TRUE FALSE);
use Gtk2;

use ArchWay::Widget::PartnerVersions;

sub init ($) {
	my $self = shift;

	$self->SUPER::init;

	# init ui
	$self->set_default_size(600, 500);
	$self->main_widget->set_position(250);
}

sub main_widget ($) {
	my $self = shift;

	if (! exists $self->{main_widget}) {
		my $scwin = Gtk2::ScrolledWindow->new;
		$scwin->set_policy('automatic', 'automatic');
		$scwin->add($self->partners_view());

		my $lbl = Gtk2::Label->new;
		$lbl->set_markup('<b>*** not implemented yet ***</b>');

		my $vpaned = Gtk2::VPaned->new();
		$vpaned->pack1($scwin, TRUE, TRUE);
		$vpaned->pack2($lbl, TRUE, TRUE);
		
		$self->{main_widget} = $vpaned;
	}

	return $self->{main_widget};
}

sub partners_view ($) {
	my $self = shift;

	if (! exists $self->{partners_view}) {
		my $partners_view = ArchWay::Widget::PartnerVersions->new(
			$self->tree, $self
		);

		$self->{partners_view} = $partners_view;
	}

	return $self->{partners_view};
}

sub tree ($) {
	my $self = shift;

	return $self->{tree};
}

1;

__END__
