# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::MainWindow::Personal;

use base 'ArchWay::MainWindow::Base';

use Glib qw(TRUE FALSE);
use Gtk2;

use Arch::Util qw(run_cmd);

sub init ($) {
	my $self = shift;

	$self->SUPER::init;

	# init ui
	$self->id_widget->set_text($self->arch->my_id);
	$self->set_default_size(600, 100);
}

sub id_widget ($) {
	my $self = shift;

	if (! exists $self->{id_widget}) {
		my $widget = Gtk2::Entry->new;
		$widget->set_editable(FALSE);

		$self->{id_widget} = $widget;
	}

	return $self->{id_widget};
}

sub archv_widget ($) {
	my $self = shift;

	if (! exists $self->{archv_widget}) {
		my $widget = Gtk2::Entry->new;
		$widget->set_editable(FALSE);

		$widget->set_sensitive(FALSE);
		$widget->set_text('*** not implemented yet ***');

		$self->{archv_widget} = $widget;
	}

	return $self->{archv_widget};
}

sub main_widget ($) {
	my $self = shift;

	if (! exists $self->{main_widget}) {
		my $table = Gtk2::Table->new(2, 3);
		$table->set_row_spacings(3);
		$table->set_col_spacings(5);
		$table->set_border_width(5);

		my @rows = (
			[
				'Identity',
				$self->id_widget,
				sub { $self->change_id }
			],
			[
				'Default Archive',
				$self->archv_widget,
				sub { $self->change_archv }
			]
		);

		for (my $i = 0; $i < @rows; ++$i) {
			my $label = Gtk2::Label->new;
			$label->set_markup("<b>$rows[$i]->[0]:</b>");
			$label->set_alignment(0.0, 0.0);

			$table->attach(
				$label,
				0, 1, $i, $i+1,
				[qw(fill)], [], 0, 0
			);

			$table->attach(
				$rows[$i]->[1],
				1, 2, $i, $i+1,
				[qw(expand fill)], [], 0, 0
			);

			my $button = Gtk2::Button->new_with_label('Change ...');
			if ($rows[$i]->[2]) {
				$button->signal_connect(clicked => $rows[$i]->[2]);
			} else {
				$button->set_sensitive(FALSE);
			}
		
			$table->attach(
				$button,
				2, 3, $i, $i+1,
				[], [], 0, 0
			);
		}
		
		$self->{main_widget} = $table;
	}

	return $self->{main_widget};
}

sub change_id ($) {
	my $self = shift;

	my $id = $self->prompt_string(
		'Identity',
		title   => 'Enter New Identity',
		default => $self->id_widget->get_text,
	);

	if (defined $id) {
		$self->arch->my_id($id) || $self->alert('my-id failed');
		$self->id_widget->set_text($self->arch->my_id);
	}
}

sub change_archv ($) {
	my $self = shift;

	$self->session->activate_gui("regst", "--choose", "--quiet");
}

1;

__END__
